/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.GLException;
import io.agora.rtc.mediaio.IVideoFrameConsumer;
import java.nio.ByteBuffer;

public class VideoFrameConsumerImpl
implements IVideoFrameConsumer {
    private long mCaptureHandle;

    public VideoFrameConsumerImpl(long nativeHandle) {
        this.mCaptureHandle = nativeHandle;
    }

    @Override
    public void consumeByteBufferFrame(ByteBuffer buffer, int format, int width, int height, int rotation, long ts) {
        this.provideByteBufferFrame(this.mCaptureHandle, buffer, format, width, height, rotation, ts);
    }

    @Override
    public void consumeByteArrayFrame(byte[] data, int format, int width, int height, int rotation, long ts) {
        this.provideByteArrayFrame(this.mCaptureHandle, data, format, width, height, rotation, ts);
    }

    @Override
    public void consumeTextureFrame(int texId, int format, int width, int height, int rotation, long ts, float[] matrix) {
        EGLContext sharedContext = EGL14.eglGetCurrentContext();
        int eglError = EGL14.eglGetError();
        if (eglError != 12288) {
            String errorMsg = "eglError: " + eglError;
            throw new GLException(eglError, errorMsg);
        }
        this.provideTextureFrame(this.mCaptureHandle, sharedContext, texId, format, width, height, rotation, ts, matrix);
    }

    public native void provideByteArrayFrame(long var1, byte[] var3, int var4, int var5, int var6, int var7, long var8);

    public native void provideTextureFrame(long var1, Object var3, int var4, int var5, int var6, int var7, int var8, long var9, float[] var11);

    public native void provideByteBufferFrame(long var1, ByteBuffer var3, int var4, int var5, int var6, int var7, long var8);
}

