/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.graphics.SurfaceTexture;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.mediaio.IVideoFrameConsumer;
import io.agora.rtc.mediaio.IVideoSource;
import io.agora.rtc.mediaio.SurfaceTextureHelper;
import java.lang.ref.WeakReference;

public abstract class TextureSource
implements IVideoSource,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    protected WeakReference<IVideoFrameConsumer> mConsumer;
    protected SurfaceTextureHelper mSurfaceTextureHelper;
    protected int mWidth;
    protected int mHeight;
    protected int mPixelFormat;

    public TextureSource(EglBase.Context sharedContext, int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mPixelFormat = 11;
        this.mSurfaceTextureHelper = SurfaceTextureHelper.create("TexCamThread", sharedContext);
        this.mSurfaceTextureHelper.getSurfaceTexture().setDefaultBufferSize(width, height);
        this.mSurfaceTextureHelper.startListening(this);
    }

    @Override
    public boolean onInitialize(IVideoFrameConsumer observer) {
        this.mConsumer = new WeakReference<IVideoFrameConsumer>(observer);
        return this.onCapturerOpened();
    }

    @Override
    public boolean onStart() {
        return this.onCapturerStarted();
    }

    @Override
    public void onStop() {
        this.onCapturerStopped();
    }

    @Override
    public void onDispose() {
        this.mConsumer = null;
        this.onCapturerClosed();
    }

    @Override
    public int getBufferType() {
        return 3;
    }

    @Override
    public void onTextureFrameAvailable(int oesTextureId, float[] transformMatrix, long timestampNs) {
        this.mSurfaceTextureHelper.returnTextureFrame();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTextureHelper.getSurfaceTexture();
    }

    public EglBase.Context getEglContext() {
        return this.mSurfaceTextureHelper.getEglContext();
    }

    public void release() {
        this.mSurfaceTextureHelper.stopListening();
        this.mSurfaceTextureHelper.dispose();
        this.mSurfaceTextureHelper = null;
    }

    protected abstract boolean onCapturerOpened();

    protected abstract boolean onCapturerStarted();

    protected abstract void onCapturerStopped();

    protected abstract void onCapturerClosed();
}

