/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.EglRenderer;
import io.agora.rtc.gl.GlRectDrawer;
import io.agora.rtc.gl.JavaI420Buffer;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.RgbaBuffer;
import io.agora.rtc.gl.TextureBufferImpl;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.utils.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;

public class BaseVideoRenderer
implements SurfaceHolder.Callback,
TextureView.SurfaceTextureListener {
    private static final String TAG = BaseVideoRenderer.class.getSimpleName();
    private static final String ERROR_EGL = "Only one egl surface allowed";
    private final EglRenderer eglRenderer;
    private int mBufferType = -1;
    private int mPixelFormat = -1;
    private SurfaceView mSurfaceView;
    private TextureView mTextureView;
    private Surface mSurface;
    private SurfaceTexture mSurfaceTexture;
    private SurfaceHolder.Callback mSurfaceViewListener;
    private TextureView.SurfaceTextureListener mSurfaceTextureListener;
    private boolean mHasEglSurface = false;
    private boolean mStarted = false;

    public BaseVideoRenderer(String name) {
        this.eglRenderer = new EglRenderer(name);
    }

    public EglRenderer getEglRender() {
        return this.eglRenderer;
    }

    public long getEGLContextHandle() {
        return this.eglRenderer.getEglContext().getNativeEglContext();
    }

    public void init(EglBase.Context sharedContext) {
        this.init(sharedContext, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    public void init(EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        this.eglRenderer.init(sharedContext, configAttributes, drawer);
    }

    public void setRenderView(SurfaceView view, SurfaceHolder.Callback listener) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mSurfaceView = view;
        this.mSurfaceViewListener = listener;
        this.mSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void setRenderView(TextureView view, TextureView.SurfaceTextureListener listener) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mTextureView = view;
        this.mSurfaceTextureListener = listener;
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    public void setRenderSurface(Surface surface) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mSurface = surface;
        this.eglRenderer.createEglSurface(surface);
        this.mHasEglSurface = true;
    }

    public void setRenderSurface(SurfaceTexture st) {
        ThreadUtils.checkIsOnMainThread();
        if (this.mHasEglSurface) {
            throw new IllegalStateException(ERROR_EGL);
        }
        this.mSurfaceTexture = st;
        this.eglRenderer.createEglSurface(st);
        this.mHasEglSurface = true;
    }

    public void setBufferType(MediaIO.BufferType type) {
        this.mBufferType = type.intValue();
    }

    public void setPixelFormat(MediaIO.PixelFormat fmt) {
        this.mPixelFormat = fmt.intValue();
    }

    public void release() {
        this.eglRenderer.release();
    }

    public boolean start() {
        this.mStarted = true;
        return true;
    }

    public void stop() {
        this.mStarted = false;
    }

    public void consume(int texId, int format, int width, int height, int rotation, long ts, float[] matrix) {
        VideoFrame.TextureBuffer.Type type;
        if (!this.mStarted) {
            return;
        }
        if (format == 11) {
            type = VideoFrame.TextureBuffer.Type.OES;
        } else if (format == 10) {
            type = VideoFrame.TextureBuffer.Type.RGB;
        } else {
            return;
        }
        this.rendTextureFrame(texId, type, width, height, rotation, ts, matrix);
    }

    public void consume(ByteBuffer buffer, int format, int width, int height, int rotation, long ts) {
        if (!this.mStarted) {
            return;
        }
        if (format == 1) {
            this.rendI420Frame(buffer, format, width, height, rotation, ts);
        } else if (format == 4) {
            this.rendRGBAFrame(buffer, format, width, height, rotation, ts);
        }
    }

    public void consume(byte[] data, int format, int width, int height, int rotation, long ts) {
        if (!this.mStarted) {
            return;
        }
        if (format == 1) {
            this.rendI420Frame(data, format, width, height, rotation, ts);
        } else if (format == 4) {
            this.rendRGBAFrame(data, format, width, height, rotation, ts);
        }
    }

    public int getBufferType() {
        if (this.mBufferType == -1) {
            throw new IllegalArgumentException("Buffer type is not set");
        }
        return this.mBufferType;
    }

    public int getPixelFormat() {
        if (this.mPixelFormat == -1) {
            throw new IllegalArgumentException("Pixel format is not set");
        }
        return this.mPixelFormat;
    }

    private void rendTextureFrame(int texId, VideoFrame.TextureBuffer.Type type, int width, int height, int rotation, long ts, float[] matrix) {
        Matrix m = RendererCommon.convertMatrixToAndroidGraphicsMatrix(matrix);
        TextureBufferImpl buffer = new TextureBufferImpl(width, height, type, texId, m, null, new Runnable(){

            @Override
            public void run() {
            }
        });
        VideoFrame frame = new VideoFrame(buffer, rotation, ts);
        this.eglRenderer.renderFrame(frame);
        frame.release();
    }

    private void rendI420Frame(ByteBuffer data, int format, int width, int height, int rotation, long ts) {
        if (data == null) {
            return;
        }
        byte[] tmp = new byte[data.remaining()];
        data.get(tmp, 0, tmp.length);
        JavaI420Buffer buffer = JavaI420Buffer.createYUV(tmp, width, height);
        if (buffer == null) {
            return;
        }
        VideoFrame frame = new VideoFrame(buffer, rotation, ts);
        this.eglRenderer.renderFrame(frame);
        frame.release();
    }

    private void rendI420Frame(byte[] data, int format, int width, int height, int rotation, long ts) {
        if (data == null || data.length == 0) {
            return;
        }
        JavaI420Buffer buffer = JavaI420Buffer.createYUV(data, width, height);
        if (buffer == null) {
            return;
        }
        VideoFrame frame = new VideoFrame(buffer, rotation, ts);
        this.eglRenderer.renderFrame(frame);
        frame.release();
    }

    private void rendRGBAFrame(final ByteBuffer data, int format, int width, int height, int rotation, long ts) {
        if (data == null) {
            return;
        }
        RgbaBuffer buffer = new RgbaBuffer(data, width, height, new Runnable(){

            @Override
            public void run() {
                BaseVideoRenderer.this.releaseBuffer(data);
            }
        });
        VideoFrame frame = new VideoFrame(buffer, rotation, ts);
        this.eglRenderer.renderFrame(frame);
        frame.release();
    }

    private void rendRGBAFrame(byte[] data, int format, int width, int height, int rotation, long ts) {
        if (data == null || data.length == 0) {
            return;
        }
        final ByteBuffer buffer = ByteBuffer.wrap(data);
        RgbaBuffer rgbaBuffer = new RgbaBuffer(buffer, width, height, new Runnable(){

            @Override
            public void run() {
                BaseVideoRenderer.this.releaseBuffer(buffer);
            }
        });
        VideoFrame frame = new VideoFrame(rgbaBuffer, rotation, ts);
        this.eglRenderer.renderFrame(frame);
        frame.release();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(holder.getSurface());
        this.mHasEglSurface = true;
        if (this.mSurfaceViewListener != null) {
            this.mSurfaceViewListener.surfaceCreated(holder);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        ThreadUtils.checkIsOnMainThread();
        Log.e((String)TAG, (String)("surfaceChanged: format: " + format + " size: " + width + "x" + height));
        if (this.mSurfaceViewListener != null) {
            this.mSurfaceViewListener.surfaceChanged(holder, format, width, height);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch completionLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                completionLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(completionLatch);
        if (this.mSurfaceViewListener != null) {
            this.mSurfaceViewListener.surfaceDestroyed(holder);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(surface);
        this.mHasEglSurface = true;
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        Log.e((String)TAG, (String)("onSurfaceTextureSizeChanged: width- " + width + ", height: " + height));
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureSizeChanged(surface, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        ThreadUtils.checkIsOnMainThread();
        final CountDownLatch completionLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(new Runnable(){

            @Override
            public void run() {
                completionLatch.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(completionLatch);
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureDestroyed(surface);
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this.mSurfaceTextureListener != null) {
            this.mSurfaceTextureListener.onSurfaceTextureUpdated(surface);
        }
    }

    private void releaseBuffer(ByteBuffer buffer) {
        buffer = null;
    }
}

