/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import android.view.WindowManager;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.mediaio.IVideoFrameConsumer;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.mediaio.TextureSource;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;

public class AgoraTextureCamera
extends TextureSource {
    private static final String TAG = AgoraTextureCamera.class.getSimpleName();
    private Context mContext;
    private Camera camera;
    private Camera.CameraInfo info;

    public AgoraTextureCamera(Context context, int width, int height) {
        super(null, width, height);
        this.mContext = context;
    }

    @Override
    public void onTextureFrameAvailable(int oesTextureId, float[] transformMatrix, long timestampNs) {
        IVideoFrameConsumer consumer;
        WeakReference consumerWeakRef;
        super.onTextureFrameAvailable(oesTextureId, transformMatrix, timestampNs);
        int rotation = this.getFrameOrientation();
        if (this.info.facing == 1) {
            transformMatrix = RendererCommon.multiplyMatrices(transformMatrix, RendererCommon.horizontalFlipMatrix());
        }
        if ((consumerWeakRef = this.mConsumer) != null && (consumer = (IVideoFrameConsumer)consumerWeakRef.get()) != null) {
            consumer.consumeTextureFrame(oesTextureId, MediaIO.PixelFormat.TEXTURE_OES.intValue(), this.mWidth, this.mHeight, rotation, System.currentTimeMillis(), transformMatrix);
        }
    }

    @Override
    protected boolean onCapturerOpened() {
        try {
            this.openCamera();
            this.camera.setPreviewTexture(this.getSurfaceTexture());
            this.camera.startPreview();
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"initialize: failed to initalize camera device");
            return false;
        }
        return true;
    }

    @Override
    protected boolean onCapturerStarted() {
        this.camera.startPreview();
        return true;
    }

    @Override
    protected void onCapturerStopped() {
        this.camera.stopPreview();
    }

    @Override
    protected void onCapturerClosed() {
        this.releaseCamera();
    }

    private void openCamera() {
        if (this.camera != null) {
            throw new RuntimeException("camera already initialized");
        }
        this.info = new Camera.CameraInfo();
        int numCameras = Camera.getNumberOfCameras();
        for (int i = 0; i < numCameras; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)this.info);
            if (this.info.facing != 1) continue;
            this.camera = Camera.open((int)i);
            break;
        }
        if (this.camera == null) {
            Log.d((String)TAG, (String)"No front-facing camera found; opening default");
            this.camera = Camera.open();
        }
        if (this.camera == null) {
            throw new RuntimeException("Unable to open camera");
        }
        Camera.Parameters parms = this.camera.getParameters();
        List frameRates = parms.getSupportedPreviewFpsRange();
        int minFps = ((int[])frameRates.get(frameRates.size() - 1))[0];
        int maxFps = ((int[])frameRates.get(frameRates.size() - 1))[1];
        parms.setPreviewFpsRange(minFps, maxFps);
        parms.setPreviewSize(this.mWidth, this.mHeight);
        parms.setRecordingHint(true);
        this.camera.setParameters(parms);
        Camera.Size cameraPreviewSize = parms.getPreviewSize();
        String previewFacts = cameraPreviewSize.width + "x" + cameraPreviewSize.height;
        Log.i((String)TAG, (String)("Camera config: " + previewFacts));
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    private int getFrameOrientation() {
        int rotation = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            rotation = 360 - rotation;
        }
        return (this.info.orientation + rotation) % 360;
    }

    private void releaseCamera() {
        if (this.camera != null) {
            this.camera.stopPreview();
            try {
                this.camera.setPreviewTexture(null);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"failed to set Preview Texture");
            }
            this.camera.release();
            this.camera = null;
            Log.d((String)TAG, (String)"releaseCamera -- done");
        }
    }
}

