/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.mediaio.BaseVideoRenderer;
import io.agora.rtc.mediaio.IVideoSink;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.utils.ThreadUtils;
import java.nio.ByteBuffer;

public class AgoraSurfaceView
extends SurfaceView
implements IVideoSink,
SurfaceHolder.Callback {
    private static final String TAG = AgoraSurfaceView.class.getSimpleName();
    private BaseVideoRenderer mRender = new BaseVideoRenderer(TAG);
    private EglBase.Context mEglContext;
    private int[] mConfigAttributes;
    private RendererCommon.GlDrawer mDrawer;

    public AgoraSurfaceView(Context context) {
        super(context);
        this.mRender.setRenderView(this, this);
    }

    public AgoraSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mRender.setRenderView(this, this);
    }

    public void init(EglBase.Context sharedContext) {
        this.mEglContext = sharedContext;
    }

    public void init(EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        this.mEglContext = sharedContext;
        this.mConfigAttributes = configAttributes;
        this.mDrawer = drawer;
    }

    @Override
    public long getEGLContextHandle() {
        return this.mRender.getEGLContextHandle();
    }

    public void setBufferType(MediaIO.BufferType type) {
        this.mRender.setBufferType(type);
    }

    public void setPixelFormat(MediaIO.PixelFormat pixelFormat) {
        this.mRender.setPixelFormat(pixelFormat);
    }

    public void setMirror(boolean mirror) {
        this.mRender.getEglRender().setMirror(mirror);
    }

    @Override
    public boolean onInitialize() {
        if (this.mConfigAttributes != null && this.mDrawer != null) {
            this.mRender.init(this.mEglContext, this.mConfigAttributes, this.mDrawer);
        } else {
            this.mRender.init(this.mEglContext);
        }
        return true;
    }

    @Override
    public boolean onStart() {
        return this.mRender.start();
    }

    @Override
    public void onStop() {
        this.mRender.stop();
    }

    @Override
    public void onDispose() {
        this.mRender.release();
    }

    @Override
    public void consumeByteBufferFrame(ByteBuffer buffer, int format, int width, int height, int rotation, long ts) {
        this.mRender.consume(buffer, format, width, height, rotation, ts);
    }

    @Override
    public void consumeByteArrayFrame(byte[] data, int pixelFormat, int width, int height, int rotation, long ts) {
        this.mRender.consume(data, pixelFormat, width, height, rotation, ts);
    }

    @Override
    public void consumeTextureFrame(int texId, int pixelFormat, int width, int height, int rotation, long ts, float[] matrix) {
        this.mRender.consume(texId, pixelFormat, width, height, rotation, ts, matrix);
    }

    @Override
    public int getBufferType() {
        int type = this.mRender.getBufferType();
        if (type == -1) {
            throw new IllegalArgumentException("Buffer type is not set");
        }
        return type;
    }

    @Override
    public int getPixelFormat() {
        int format = this.mRender.getPixelFormat();
        if (format == -1) {
            throw new IllegalArgumentException("Pixel format is not set");
        }
        return format;
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.i((String)TAG, (String)("surfaceChanged: format: " + format + " size: " + width + "x" + height));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ThreadUtils.checkIsOnMainThread();
        this.mRender.getEglRender().setLayoutAspectRatio((float)(right - left) / (float)(bottom - top));
    }
}

