/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ImageFormat;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.WindowManager;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.mediaio.CameraSource;
import io.agora.rtc.mediaio.CaptureParameters;
import io.agora.rtc.mediaio.IVideoFrameConsumer;
import io.agora.rtc.mediaio.MediaIO;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

@TargetApi(value=21)
public class AgoraBufferedCamera2
extends CameraSource {
    private static final String TAG = AgoraBufferedCamera2.class.getSimpleName();
    private Context mContext;
    private String mCameraId;
    private int cameraOrientation;
    private boolean isCameraFrontFacing;
    private CameraCaptureSession mCaptureSession;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private CaptureRequest mPreviewRequest;
    private CameraDevice mCameraDevice;
    private CameraCharacteristics mCharacteristics;
    private boolean mFlashSupported;
    private int mState = 0;
    private static final int STATE_PREVIEW = 0;
    private static final int STATE_WAITING_LOCK = 1;
    private static final int STATE_WAITING_PRECAPTURE = 2;
    private static final int STATE_WAITING_NON_PRECAPTURE = 3;
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private ImageReader mImageReader;
    private byte[] mBufferArrayData;
    private ByteBuffer mByteBufferData;
    private CaptureParameters mParameters;
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onImageAvailable(ImageReader reader) {
            try (Image image = null;){
                image = reader.acquireLatestImage();
                if (image == null) {
                    return;
                }
                if (image.getFormat() != 35 || image.getPlanes().length != 3) {
                    Logging.e(TAG, "Unexpected image format: " + image.getFormat() + "or #planes:" + image.getPlanes().length);
                    return;
                }
                if (reader.getWidth() != image.getWidth() || reader.getHeight() != image.getHeight()) {
                    throw new IllegalStateException("ImageReader size " + reader.getWidth() + "x" + reader.getHeight() + " did not match Image size: " + image.getWidth() + "x" + image.getHeight());
                }
                AgoraBufferedCamera2.readImageIntoBuffer(image, AgoraBufferedCamera2.this.mBufferArrayData);
                int orientation = AgoraBufferedCamera2.this.getFrameOrientation();
                if (AgoraBufferedCamera2.this.consumer != null && ((AgoraBufferedCamera2)AgoraBufferedCamera2.this).mParameters.bufferType == MediaIO.BufferType.BYTE_ARRAY.intValue()) {
                    AgoraBufferedCamera2.this.consumer.consumeByteArrayFrame(AgoraBufferedCamera2.this.mBufferArrayData, ((AgoraBufferedCamera2)AgoraBufferedCamera2.this).mParameters.pixelFormat, image.getWidth(), image.getHeight(), orientation, System.currentTimeMillis());
                } else if (AgoraBufferedCamera2.this.consumer != null && ((AgoraBufferedCamera2)AgoraBufferedCamera2.this).mParameters.bufferType == MediaIO.BufferType.BYTE_BUFFER.intValue()) {
                    AgoraBufferedCamera2.this.mByteBufferData.rewind();
                    AgoraBufferedCamera2.this.mByteBufferData.put(AgoraBufferedCamera2.this.mBufferArrayData, 0, AgoraBufferedCamera2.this.mBufferArrayData.length);
                    AgoraBufferedCamera2.this.consumer.consumeByteBufferFrame(AgoraBufferedCamera2.this.mByteBufferData, ((AgoraBufferedCamera2)AgoraBufferedCamera2.this).mParameters.pixelFormat, image.getWidth(), image.getHeight(), orientation, System.currentTimeMillis());
                }
            }
        }
    };
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            AgoraBufferedCamera2.this.mCameraOpenCloseLock.release();
            AgoraBufferedCamera2.this.mCameraDevice = cameraDevice;
            AgoraBufferedCamera2.this.createCameraPreviewSession();
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            AgoraBufferedCamera2.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            AgoraBufferedCamera2.this.mCameraDevice = null;
        }

        public void onError(CameraDevice cameraDevice, int error) {
            AgoraBufferedCamera2.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            AgoraBufferedCamera2.this.mCameraDevice = null;
        }
    };
    private CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void process(CaptureResult result) {
            switch (AgoraBufferedCamera2.this.mState) {
                case 0: {
                    return;
                }
                case 1: {
                    Integer aeState;
                    Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                    if (afState != null && (4 == afState || 5 == afState) && (aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE)) != null && aeState != 2) return;
                }
                case 2: {
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState != null && aeState != 5 && aeState != 4) return;
                    AgoraBufferedCamera2.this.mState = 3;
                    return;
                }
                case 3: {
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState == null || aeState == 5) return;
                    return;
                }
            }
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };

    public AgoraBufferedCamera2(Context context) {
        this.mContext = context;
        this.mParameters = new CaptureParameters();
        this.mParameters.width = 640;
        this.mParameters.height = 480;
        this.mParameters.fps = 15;
        this.mParameters.pixelFormat = MediaIO.PixelFormat.I420.intValue();
        this.mParameters.bufferType = MediaIO.BufferType.BYTE_BUFFER.intValue();
    }

    public AgoraBufferedCamera2(Context context, CaptureParameters parameters) {
        this.mContext = context;
        if (parameters != null) {
            this.mParameters = new CaptureParameters();
            this.mParameters.width = parameters.width;
            this.mParameters.height = parameters.height;
            this.mParameters.fps = parameters.fps;
            this.mParameters.pixelFormat = parameters.pixelFormat;
            this.mParameters.bufferType = parameters.bufferType;
        }
    }

    public void useFrontCamera(boolean front) {
        this.isCameraFrontFacing = front;
    }

    @Override
    public boolean onInitialize(IVideoFrameConsumer consumer) {
        this.consumer = consumer;
        this.allocateBuffer(this.mParameters.pixelFormat);
        return true;
    }

    @Override
    public boolean onStart() {
        this.startBackgroundThread();
        this.openCamera(this.mParameters.width, this.mParameters.height);
        return true;
    }

    @Override
    public void onStop() {
        this.doStop();
    }

    @Override
    public void onDispose() {
        this.doStop();
        this.mBufferArrayData = null;
        this.mByteBufferData = null;
    }

    @Override
    public int getBufferType() {
        return this.mParameters.bufferType;
    }

    private void allocateBuffer(int pixelFormat) {
        int bufSize = 0;
        if (pixelFormat == MediaIO.PixelFormat.I420.intValue()) {
            bufSize = this.mParameters.width * this.mParameters.height * ImageFormat.getBitsPerPixel((int)35) / 8;
        }
        if (this.mParameters.bufferType == MediaIO.BufferType.BYTE_ARRAY.intValue()) {
            this.mBufferArrayData = new byte[bufSize];
        } else if (this.mParameters.bufferType == MediaIO.BufferType.BYTE_BUFFER.intValue()) {
            this.mBufferArrayData = new byte[bufSize];
            this.mByteBufferData = ByteBuffer.allocateDirect(bufSize);
        }
    }

    private void openCamera(int width, int height) {
        this.setUpCameraOutputs(width, height);
        CameraManager manager = (CameraManager)this.mContext.getSystemService("camera");
        try {
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            manager.openCamera(this.mCameraId, this.mStateCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)e.toString());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", e);
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)e.toString());
        }
    }

    private void doStop() {
        this.closeCamera();
        this.stopBackgroundThread();
    }

    private void createCameraPreviewSession() {
        try {
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
            if (this.mFlashSupported) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
            }
            this.mPreviewRequestBuilder.addTarget(this.mImageReader.getSurface());
            List<Surface> surfaces = Arrays.asList(this.mImageReader.getSurface());
            this.mCameraDevice.createCaptureSession(surfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    if (null == AgoraBufferedCamera2.this.mCameraDevice) {
                        return;
                    }
                    AgoraBufferedCamera2.this.mCaptureSession = cameraCaptureSession;
                    try {
                        AgoraBufferedCamera2.this.mPreviewRequest = AgoraBufferedCamera2.this.mPreviewRequestBuilder.build();
                        AgoraBufferedCamera2.this.mCaptureSession.setRepeatingRequest(AgoraBufferedCamera2.this.mPreviewRequest, AgoraBufferedCamera2.this.mCaptureCallback, AgoraBufferedCamera2.this.mBackgroundHandler);
                    }
                    catch (CameraAccessException | IllegalStateException e) {
                        e.printStackTrace();
                    }
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                    Log.e((String)TAG, (String)"Configure camera failed");
                }
            }, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void setUpCameraOutputs(int width, int height) {
        CameraManager manager = (CameraManager)this.mContext.getSystemService("camera");
        try {
            String[] cameraName = manager.getCameraIdList();
            for (int i = 0; i < cameraName.length; ++i) {
                String cameraId;
                this.mCameraId = cameraId = cameraName[i];
                this.mCharacteristics = manager.getCameraCharacteristics(cameraId);
                this.cameraOrientation = (Integer)this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                Boolean available = (Boolean)this.mCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                boolean bl = this.mFlashSupported = available == null ? false : available;
                if (!this.isCameraFrontFacing || (Integer)this.mCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0) break;
            }
            this.mImageReader = ImageReader.newInstance((int)this.mParameters.width, (int)this.mParameters.height, (int)this.getAndroidImageFormat(this.mParameters.pixelFormat), (int)2);
            this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private int getAndroidImageFormat(int mediaioFormat) {
        int format = mediaioFormat == MediaIO.PixelFormat.I420.intValue() ? 35 : 0;
        return format;
    }

    private static Size chooseOptimalSize(Size[] choices, int textureViewWidth, int textureViewHeight, int maxWidth, int maxHeight, Size aspectRatio) {
        ArrayList<Size> bigEnough = new ArrayList<Size>();
        ArrayList<Size> notBigEnough = new ArrayList<Size>();
        int w = aspectRatio.getWidth();
        int h = aspectRatio.getHeight();
        for (Size option : choices) {
            if (option.getWidth() > maxWidth || option.getHeight() > maxHeight || option.getHeight() != option.getWidth() * h / w) continue;
            if (option.getWidth() >= textureViewWidth && option.getHeight() >= textureViewHeight) {
                bigEnough.add(option);
                continue;
            }
            notBigEnough.add(option);
        }
        if (bigEnough.size() > 0) {
            return Collections.min(bigEnough, new CompareSizesByArea());
        }
        if (notBigEnough.size() > 0) {
            return Collections.max(notBigEnough, new CompareSizesByArea());
        }
        Log.e((String)TAG, (String)"Couldn't find any suitable preview size");
        return choices[0];
    }

    private void closeCamera() {
        try {
            this.mCameraOpenCloseLock.acquire();
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != this.mCameraDevice) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
            if (null != this.mImageReader) {
                this.mImageReader.close();
                this.mImageReader = null;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    private void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        if (this.mBackgroundThread == null) {
            return;
        }
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void readImageIntoBuffer(Image image, byte[] data) {
        int width = image.getWidth();
        int height = image.getHeight();
        Image.Plane[] planes = image.getPlanes();
        int offset = 0;
        for (int plane = 0; plane < planes.length; ++plane) {
            int planeHeight;
            ByteBuffer buffer = planes[plane].getBuffer();
            int rowStride = planes[plane].getRowStride();
            int pixelStride = planes[plane].getPixelStride();
            int planeWidth = plane == 0 ? width : width / 2;
            int n = planeHeight = plane == 0 ? height : height / 2;
            if (pixelStride == 1 && rowStride == planeWidth) {
                buffer.get(data, offset, planeWidth * planeHeight);
                offset += planeWidth * planeHeight;
                continue;
            }
            byte[] rowData = new byte[rowStride];
            for (int row = 0; row < planeHeight - 1; ++row) {
                buffer.get(rowData, 0, rowStride);
                for (int col = 0; col < planeWidth; ++col) {
                    data[offset++] = rowData[col * pixelStride];
                }
            }
            buffer.get(rowData, 0, Math.min(rowStride, buffer.remaining()));
            for (int col = 0; col < planeWidth; ++col) {
                data[offset++] = rowData[col * pixelStride];
            }
        }
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    private int getFrameOrientation() {
        int rotation = this.getDeviceOrientation();
        if (!this.isCameraFrontFacing) {
            rotation = 360 - rotation;
        }
        return (this.cameraOrientation + rotation) % 360;
    }

    static class CompareSizesByArea
    implements Comparator<Size> {
        CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }
}

