/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.text.TextUtils;
import io.agora.rtc.IRtcEngineEventHandler;
import io.agora.rtc.internal.Marshallable;
import io.agora.rtc.live.LiveInjectStreamConfig;
import io.agora.rtc.live.LiveTranscoding;
import io.agora.rtc.video.AgoraImage;
import io.agora.rtc.video.ChannelMediaInfo;
import io.agora.rtc.video.ChannelMediaRelayConfiguration;
import java.util.ArrayList;

public class RtcEngineMessage {
    public static short AGORA_UI_SERVER = 0;

    public static class PUserAccountInfo
    extends Marshallable {
        public int uid;
        public String userAccount;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushBytes(this.userAccount.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.userAccount = this.popString16UTF8();
        }
    }

    public static class PNetworkTypeChanged
    extends Marshallable {
        public int type;

        @Override
        public byte[] marshall() {
            this.pushInt(this.type);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.type = this.popInt();
        }
    }

    public static class PConnectionState
    extends Marshallable {
        public int state;
        public int reason;

        @Override
        public byte[] marshall() {
            this.pushInt(this.state);
            this.pushInt(this.reason);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popInt();
            this.reason = this.popInt();
        }
    }

    public static class PLocalAudioEnabled
    extends Marshallable {
        boolean enabled;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.enabled = this.popBool();
        }
    }

    public static class PLocalFallbackStatus
    extends Marshallable {
        boolean state;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popBool();
        }
    }

    public static class PUserTransportStat
    extends Marshallable {
        public boolean isAudio;
        public int peer_uid;
        public int delay;
        public int lost;
        public int rxKBitRate;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.isAudio = this.popBool();
            this.peer_uid = this.popInt();
            this.delay = this.popShort();
            this.lost = this.popShort();
            this.rxKBitRate = this.popShort();
        }
    }

    public static class PCrossChannelEvent
    extends Marshallable {
        public int code;

        @Override
        public byte[] marshall() {
            this.pushInt(this.code);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.code = this.popInt();
        }
    }

    public static class PCrossChannelState
    extends Marshallable {
        public int state;
        public int code;

        @Override
        public byte[] marshall() {
            this.pushInt(this.state);
            this.pushInt(this.code);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popInt();
            this.code = this.popInt();
        }
    }

    public static class PAndroidContextInfo
    extends Marshallable {
        public String device;
        public String deviceInfo;
        public String systemInfo;
        public String configDir;
        public String dataDir;
        public String pluginDir;
        public String imei;
        public String macAddress;
        public String androidID;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.device.getBytes());
            this.pushBytes(this.deviceInfo.getBytes());
            this.pushBytes(this.systemInfo.getBytes());
            this.pushBytes(this.configDir.getBytes());
            this.pushBytes(this.dataDir.getBytes());
            this.pushBytes(this.pluginDir.getBytes());
            this.pushBytes(this.imei.getBytes());
            this.pushBytes(this.macAddress.getBytes());
            this.pushBytes(this.androidID.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.device = this.popString16UTF8();
            this.deviceInfo = this.popString16UTF8();
            this.systemInfo = this.popString16UTF8();
            this.configDir = this.popString16UTF8();
            this.dataDir = this.popString16UTF8();
            this.pluginDir = this.popString16UTF8();
            this.imei = this.popString16UTF8();
            this.macAddress = this.popString16UTF8();
            this.androidID = this.popString16UTF8();
        }
    }

    static class PAudioRoutingChanged
    extends Marshallable {
        int routing;

        PAudioRoutingChanged() {
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.routing = this.popInt();
        }
    }

    public static class PRemoteVideoStateExt
    extends Marshallable {
        public int uid;
        public int state;
        public int reason;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.state);
            this.pushInt(this.reason);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.state = this.popByte();
            this.reason = this.popByte();
            this.elapsed = this.popInt();
        }
    }

    public static class PRemoteAudioState
    extends Marshallable {
        public int uid;
        public int state;
        public int reason;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.state);
            this.pushInt(this.reason);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.state = this.popInt();
            this.reason = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PPrivilegeWillExpire
    extends Marshallable {
        public String token;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.token.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.token = this.popString16UTF8();
        }
    }

    public static class PStreamInjectedStatus
    extends Marshallable {
        public String url;
        public int uid;
        public int status;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.url.getBytes());
            this.pushInt(this.uid);
            this.pushInt(this.status);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.url = this.popString16UTF8();
            this.uid = this.popInt();
            this.status = this.popInt();
        }
    }

    public static class PHostInStopped
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
        }
    }

    public static class PHostInRequest
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
        }
    }

    public static class PHostInResponse
    extends Marshallable {
        public int ownerUid;
        public boolean accepted;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.ownerUid = this.popInt();
            this.accepted = this.popBool();
            this.error = this.popInt();
        }
    }

    public static class PInjectStreamConfig
    extends Marshallable {
        private static final short SERVER_TYPE = 0;
        private static final short URI = 25;

        private void marshall(Marshallable m, LiveInjectStreamConfig config) {
            m.pushShort((short)0);
            m.pushShort((short)25);
            m.pushInt(config.width);
            m.pushInt(config.height);
            m.pushInt(config.videoGop);
            m.pushInt(config.videoFramerate);
            m.pushInt(config.videoBitrate);
            m.pushInt(LiveInjectStreamConfig.AudioSampleRateType.getValue(config.audioSampleRate));
            m.pushInt(config.audioBitrate);
            m.pushInt(config.audioChannels);
        }

        public byte[] marshall(LiveInjectStreamConfig config) {
            this.marshall(this, config);
            return super.marshall();
        }
    }

    public static class PChannelMediaRelayConfiguration
    extends Marshallable {
        private void marshallChannelInfo(Marshallable m, ChannelMediaInfo channelMediaInfo) {
            m.pushString16(channelMediaInfo.channelName);
            m.pushString16(channelMediaInfo.token);
            m.pushInt(channelMediaInfo.uid);
        }

        private void marshall(Marshallable m, ChannelMediaRelayConfiguration configuration) {
            this.marshallChannelInfo(m, configuration.getSrcChannelMediaInfo());
            int count = configuration.getDestChannelMediaInfos().size();
            this.pushShort((short)count);
            for (String channelName : configuration.getDestChannelMediaInfos().keySet()) {
                ChannelMediaInfo destInfo = configuration.getDestChannelMediaInfos().get(channelName);
                this.marshallChannelInfo(m, destInfo);
            }
        }

        public byte[] marshall(ChannelMediaRelayConfiguration configuration) {
            this.marshall(this, configuration);
            return super.marshall();
        }
    }

    public static class PLiveTranscoding
    extends Marshallable {
        private static final short SERVER_TYPE = 0;
        private static final short URI = 23;

        private void marshallUserConfig(Marshallable m, LiveTranscoding.TranscodingUser user) {
            m.pushInt(user.uid);
            m.pushInt(user.x);
            m.pushInt(user.y);
            m.pushInt(user.width);
            m.pushInt(user.height);
            m.pushInt(user.zOrder);
            m.pushDouble(user.alpha);
            m.pushInt(user.audioChannel);
        }

        private void marshallImage(Marshallable m, AgoraImage image) {
            m.pushString16(image.url);
            m.pushInt(image.x);
            m.pushInt(image.y);
            m.pushInt(image.width);
            m.pushInt(image.height);
        }

        private void marshall(Marshallable m, LiveTranscoding transcoding) {
            m.pushShort((short)0);
            m.pushShort((short)23);
            m.pushInt(transcoding.width);
            m.pushInt(transcoding.height);
            m.pushInt(transcoding.videoGop);
            m.pushInt(transcoding.videoFramerate);
            m.pushInt(LiveTranscoding.VideoCodecProfileType.getValue(transcoding.videoCodecProfile));
            m.pushInt(transcoding.videoBitrate);
            if (transcoding.watermark == null) {
                transcoding.watermark = new AgoraImage();
            }
            this.marshallImage(m, transcoding.watermark);
            if (transcoding.backgroundImage == null) {
                transcoding.backgroundImage = new AgoraImage();
            }
            this.marshallImage(m, transcoding.backgroundImage);
            m.pushBool(transcoding.lowLatency);
            m.pushInt(LiveTranscoding.AudioSampleRateType.getValue(transcoding.audioSampleRate));
            m.pushInt(transcoding.audioBitrate);
            m.pushInt(transcoding.audioChannels);
            m.pushInt(LiveTranscoding.AudioCodecProfileType.getValue(transcoding.audioCodecProfile));
            m.pushInt(transcoding.backgroundColor & 0xFFFFFF);
            if (TextUtils.isEmpty((CharSequence)transcoding.userConfigExtraInfo)) {
                transcoding.userConfigExtraInfo = "";
            }
            m.pushString16(transcoding.userConfigExtraInfo);
            if (TextUtils.isEmpty((CharSequence)transcoding.metadata)) {
                transcoding.metadata = "";
            }
            m.pushString16(transcoding.metadata);
            int count = 0;
            if (transcoding.getUsers() != null && transcoding.getUsers().size() > 0) {
                count = transcoding.getUserCount();
                this.pushShort((short)count);
                for (LiveTranscoding.TranscodingUser user : transcoding.getUsers()) {
                    this.marshallUserConfig(m, user);
                }
            } else {
                this.pushShort((short)count);
            }
        }

        public byte[] marshall(LiveTranscoding transcoding) {
            this.marshall(this, transcoding);
            return super.marshall();
        }
    }

    public static class PStreamUnPublished
    extends Marshallable {
        public String url;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.url = this.popString16UTF8();
        }
    }

    public static class PStreamPublished
    extends Marshallable {
        public String url;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.url = this.popString16UTF8();
            this.error = this.popInt();
        }
    }

    public static class PRtmpStreamingState
    extends Marshallable {
        public String url;
        public int state;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.url = this.popString16UTF8();
            this.state = this.popInt();
            this.error = this.popInt();
        }
    }

    public static class PClientRoleChanged
    extends Marshallable {
        int oldRole;
        int newRole;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.oldRole = this.popInt();
            this.newRole = this.popInt();
        }
    }

    public static class PActiveSpeaker
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
        }
    }

    public static class PFirstLocalAudioFrame
    extends Marshallable {
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstRemoteAudioFrame
    extends Marshallable {
        public int uid;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PStreamMessageError
    extends Marshallable {
        int uid;
        int streamId;
        int error;
        int missed;
        int cached;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.streamId = this.popInt();
            this.error = this.popInt();
            this.missed = this.popInt();
            this.cached = this.popInt();
        }
    }

    public static class PStreamMessage
    extends Marshallable {
        int uid;
        int streamId;
        byte[] payload;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.streamId = this.popInt();
            this.payload = this.popBytes();
        }
    }

    public static class PApiCallExecuted
    extends Marshallable {
        public int error;
        public String api;
        public String result;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.error = this.popInt();
            this.api = this.popString16UTF8();
            this.result = this.popString16UTF8();
        }
    }

    public static class PError
    extends Marshallable {
        public int err;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.err = this.popInt();
        }
    }

    public static class PMediaEngineEvent
    extends Marshallable {
        int code;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.code = this.popInt();
        }
    }

    public static class PVideoSizeChanged
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int rotation;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.rotation);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.rotation = this.popInt();
        }
    }

    public static class PCameraExposureAreaChanged
    extends Marshallable {
        public int x;
        public int y;
        public int width;
        public int height;

        @Override
        public byte[] marshall() {
            this.pushInt(this.x);
            this.pushInt(this.y);
            this.pushInt(this.width);
            this.pushInt(this.height);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.x = this.popInt();
            this.y = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
        }
    }

    public static class PCameraFocusAreaChanged
    extends Marshallable {
        public int x;
        public int y;
        public int width;
        public int height;

        @Override
        public byte[] marshall() {
            this.pushInt(this.x);
            this.pushInt(this.y);
            this.pushInt(this.width);
            this.pushInt(this.height);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.x = this.popInt();
            this.y = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
        }
    }

    public static class PFirstRemoteVideoDecoded
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstLocalVideoFrame
    extends Marshallable {
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.width = this.popInt();
            this.height = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstRemoteVideoFrame
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PLocalVideoStat
    extends Marshallable {
        public IRtcEngineEventHandler.LocalVideoStats stats = new IRtcEngineEventHandler.LocalVideoStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.sentBitrate);
            this.pushInt(this.stats.sentFrameRate);
            this.pushInt(this.stats.encoderOutputFrameRate);
            this.pushInt(this.stats.rendererOutputFrameRate);
            this.pushInt(this.stats.targetBitrate);
            this.pushInt(this.stats.targetFrameRate);
            this.pushInt(this.stats.qualityAdaptIndication);
            this.pushInt(this.stats.encodedBitrate);
            this.pushInt(this.stats.encodedFrameWidth);
            this.pushInt(this.stats.encodedFrameHeight);
            this.pushInt(this.stats.encodedFrameCount);
            this.pushInt(this.stats.codecType);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.stats.sentBitrate = this.popInt();
            this.stats.sentFrameRate = this.popInt();
            this.stats.encoderOutputFrameRate = this.popInt();
            this.stats.rendererOutputFrameRate = this.popInt();
            this.stats.targetBitrate = this.popInt();
            this.stats.targetFrameRate = this.popInt();
            this.stats.qualityAdaptIndication = this.popInt();
            this.stats.encodedBitrate = this.popInt();
            this.stats.encodedFrameWidth = this.popInt();
            this.stats.encodedFrameHeight = this.popInt();
            this.stats.encodedFrameCount = this.popInt();
            this.stats.codecType = this.popByte();
        }
    }

    public static class PLocalAudioStat
    extends Marshallable {
        public IRtcEngineEventHandler.LocalAudioStats stats = new IRtcEngineEventHandler.LocalAudioStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.numChannels);
            this.pushInt(this.stats.sentSampleRate);
            this.pushInt(this.stats.sentBitrate);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.stats.numChannels = this.popInt();
            this.stats.sentSampleRate = this.popInt();
            this.stats.sentBitrate = this.popInt();
        }
    }

    public static class PRemoteAudioStat
    extends Marshallable {
        public IRtcEngineEventHandler.RemoteAudioStats stats = new IRtcEngineEventHandler.RemoteAudioStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.uid);
            this.pushInt(this.stats.quality);
            this.pushInt(this.stats.networkTransportDelay);
            this.pushInt(this.stats.jitterBufferDelay);
            this.pushInt(this.stats.audioLossRate);
            this.pushInt(this.stats.numChannels);
            this.pushInt(this.stats.receivedSampleRate);
            this.pushInt(this.stats.receivedBitrate);
            this.pushInt(this.stats.totalFrozenTime);
            this.pushInt(this.stats.frozenRate);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.stats.uid = this.popInt();
            this.stats.quality = this.popInt();
            this.stats.networkTransportDelay = this.popInt();
            this.stats.jitterBufferDelay = this.popInt();
            this.stats.audioLossRate = this.popInt();
            this.stats.numChannels = this.popInt();
            this.stats.receivedSampleRate = this.popInt();
            this.stats.receivedBitrate = this.popInt();
            this.stats.totalFrozenTime = this.popInt();
            this.stats.frozenRate = this.popInt();
        }
    }

    public static class PRemoteVideoStat
    extends Marshallable {
        public IRtcEngineEventHandler.RemoteVideoStats stats = new IRtcEngineEventHandler.RemoteVideoStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.uid);
            this.pushInt(this.stats.delay);
            this.pushInt(this.stats.width);
            this.pushInt(this.stats.height);
            this.pushInt(this.stats.receivedBitrate);
            this.pushInt(this.stats.decoderOutputFrameRate);
            this.pushInt(this.stats.rendererOutputFrameRate);
            this.pushInt(this.stats.packetLossRate);
            this.pushInt(this.stats.rxStreamType);
            this.pushInt(this.stats.totalFrozenTime);
            this.pushInt(this.stats.frozenRate);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.stats.uid = this.popInt();
            this.stats.delay = this.popInt();
            this.stats.width = this.popInt();
            this.stats.height = this.popInt();
            this.stats.receivedBitrate = this.popInt();
            this.stats.decoderOutputFrameRate = this.popInt();
            this.stats.rendererOutputFrameRate = this.popInt();
            this.stats.packetLossRate = this.popInt();
            this.stats.rxStreamType = this.popInt();
            this.stats.totalFrozenTime = this.popInt();
            this.stats.frozenRate = this.popInt();
        }
    }

    public static class PVideoNetOptions
    extends Marshallable {
        short width;
        short height;
        short frameRate;
        short bitrate;

        public void marshall(Marshallable m) {
            m.pushShort(this.width);
            m.pushShort(this.height);
            m.pushShort(this.frameRate);
            m.pushShort(this.bitrate);
        }

        @Override
        public byte[] marshall() {
            this.marshall(this);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.width = this.popShort();
            this.height = this.popShort();
            this.frameRate = this.popShort();
            this.bitrate = this.popShort();
        }
    }

    public static class MediaNetworkInfo
    extends Marshallable {
        String localIp4 = "";
        String gatewayIp4 = "";
        String localIp6 = "";
        String gatewayIp6 = "";
        int networkType;
        int networkSubtype;
        int signalLevel;
        int rssi;
        int asu;
        String ssid = "";
        String bssid = "";
        ArrayList<String> dnsList = null;

        public void marshall(Marshallable m) {
            m.pushBytes(this.localIp4.getBytes());
            m.pushBytes(this.gatewayIp4.getBytes());
            m.pushBytes(this.localIp6.getBytes());
            m.pushBytes(this.gatewayIp6.getBytes());
            m.pushInt(this.networkType);
            m.pushInt(this.networkSubtype);
            m.pushInt(this.signalLevel);
            m.pushInt(this.rssi);
            m.pushInt(this.asu);
            if (this.ssid != null && this.ssid instanceof String) {
                m.pushBytes(this.ssid.getBytes());
            } else {
                m.pushBytes("".getBytes());
            }
            if (this.bssid != null) {
                m.pushBytes(this.bssid.getBytes());
            } else {
                m.pushBytes("".getBytes());
            }
            if (this.dnsList != null) {
                m.pushStringArray(this.dnsList);
            } else {
                m.pushStringArray(new ArrayList<String>());
            }
        }

        @Override
        public byte[] marshall() {
            this.marshall(this);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
        }
    }

    public static class MediaAppContext
    extends Marshallable {
        MediaNetworkInfo networkInfo;

        @Override
        public byte[] marshall() {
            if (this.networkInfo != null) {
                this.networkInfo.marshall(this);
            }
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
        }
    }

    public static class PMediaResSpeakersReport
    extends Marshallable {
        int mixVolume;
        Speaker[] speakers;

        @Override
        public byte[] marshall() {
            this.pushInt(this.mixVolume);
            int len = this.speakers.length;
            this.pushShort((short)len);
            for (int i = 0; i < len; ++i) {
                this.pushInt(this.speakers[i].uid);
                this.pushInt(this.speakers[i].volume);
            }
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.mixVolume = this.popInt();
            int len = this.popShort();
            if (len > 0) {
                this.speakers = new Speaker[len];
                for (int i = 0; i < len; ++i) {
                    this.speakers[i] = new Speaker();
                    this.speakers[i].uid = this.popInt();
                    this.speakers[i].volume = this.popInt();
                    this.speakers[i].vad = this.popInt();
                }
            }
        }

        public static class Speaker {
            public int uid;
            public int volume;
            public int vad;
        }
    }

    public static class MediaResSetupTime
    extends Marshallable {
        int elapsed;
        boolean firstSuccess;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.elapsed = this.popInt();
            this.firstSuccess = this.popBool();
        }
    }

    public static class PMediaResFirstRemoteAudioDecoded
    extends Marshallable {
        public int uid;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PMediaResLocalAudioStateChanged
    extends Marshallable {
        int state;
        int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popInt();
            this.error = this.popInt();
        }
    }

    public static class PMediaResLocalVideoStateChanged
    extends Marshallable {
        int localVideoState;
        int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.localVideoState = this.popInt();
            this.error = this.popInt();
        }
    }

    public static class PMediaResAudioEffectFinished
    extends Marshallable {
        int soundId;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.soundId = this.popInt();
        }
    }

    public static class PMediaResLastmileProbeResult
    extends Marshallable {
        short state;
        int rtt;
        LastmileProbeOneWayResult uplinkReport;
        LastmileProbeOneWayResult downlinkReport;

        @Override
        public byte[] marshall() {
            this.pushShort(this.state);
            this.pushInt(this.uplinkReport.packetLossRate);
            this.pushInt(this.uplinkReport.jitter);
            this.pushInt(this.uplinkReport.availableBandwidth);
            this.pushInt(this.downlinkReport.packetLossRate);
            this.pushInt(this.downlinkReport.jitter);
            this.pushInt(this.downlinkReport.availableBandwidth);
            this.pushInt(this.rtt);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.state = this.popShort();
            this.uplinkReport = new LastmileProbeOneWayResult();
            this.downlinkReport = new LastmileProbeOneWayResult();
            this.uplinkReport.packetLossRate = this.popInt();
            this.uplinkReport.jitter = this.popInt();
            this.uplinkReport.availableBandwidth = this.popInt();
            this.downlinkReport.packetLossRate = this.popInt();
            this.downlinkReport.jitter = this.popInt();
            this.downlinkReport.availableBandwidth = this.popInt();
            this.rtt = this.popInt();
        }

        public static class LastmileProbeOneWayResult {
            public int packetLossRate;
            public int jitter;
            public int availableBandwidth;
        }
    }

    public static class PMediaResLastmileQuality
    extends Marshallable {
        int quality;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.quality = this.popInt();
        }
    }

    public static class PMediaResNetworkQuality
    extends Marshallable {
        int uid;
        int txQuality;
        int rxQuality;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.txQuality = this.popInt();
            this.rxQuality = this.popInt();
        }
    }

    public static class PMediaResUserState
    extends Marshallable {
        int uid;
        boolean state;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.state = this.popBool();
        }
    }

    public static class PMediaResUserOfflineEvent
    extends Marshallable {
        int uid;
        int reason;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.reason = this.popInt();
        }
    }

    public static class PMediaResUserJoinedEvent
    extends Marshallable {
        int uid;
        int elapsed;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.uid = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PMediaResJoinMedia
    extends Marshallable {
        public String channel;
        public int uid;
        public int elapsed;
        public boolean firstSuccess;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.channel = this.popString16UTF8();
            this.uid = this.popInt();
            this.elapsed = this.popInt();
            this.firstSuccess = this.popBool();
        }
    }

    public static class PMediaResRtcStats
    extends Marshallable {
        int totalDuration;
        int totalTxBytes;
        int totalRxBytes;
        int txAudioBytes;
        int txVideoBytes;
        int rxAudioBytes;
        int rxVideoBytes;
        int txKBitRate;
        int rxKBitRate;
        int txAudioKBitRate;
        int rxAudioKBitRate;
        int txVideoKBitRate;
        int rxVideoKBitRate;
        int lastmileDelay;
        int txPacketLossRate;
        int rxPacketLossRate;
        int cpuTotalUsage;
        int cpuAppUsage;
        int users;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.totalDuration = this.popInt();
            this.totalTxBytes = this.popInt();
            this.totalRxBytes = this.popInt();
            this.txAudioBytes = this.popInt();
            this.txVideoBytes = this.popInt();
            this.rxAudioBytes = this.popInt();
            this.rxVideoBytes = this.popInt();
            this.txKBitRate = this.popShort();
            this.rxKBitRate = this.popShort();
            this.txAudioKBitRate = this.popShort();
            this.rxAudioKBitRate = this.popShort();
            this.txVideoKBitRate = this.popShort();
            this.rxVideoKBitRate = this.popShort();
            this.lastmileDelay = this.popShort();
            this.txPacketLossRate = this.popShort();
            this.rxPacketLossRate = this.popShort();
            this.cpuTotalUsage = this.popInt();
            this.cpuAppUsage = this.popInt();
            this.users = this.popInt();
        }
    }

    public static class PMediaResTransportQuality
    extends Marshallable {
        public boolean isAudio;
        public int peer_uid;
        public int bitrate;
        public short delay;
        public short lost;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.isAudio = this.popBool();
            this.peer_uid = this.popInt();
            this.bitrate = this.popInt();
            this.delay = this.popShort();
            this.lost = this.popShort();
        }
    }

    public static class PMediaResAudioQuality
    extends Marshallable {
        int peer_uid;
        int quality;
        short delay;
        short lost;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
            super.unmarshall(buf);
            this.peer_uid = this.popInt();
            this.quality = this.popInt();
            this.delay = this.popShort();
            this.lost = this.popShort();
        }
    }

    public static class PMediaReqConnectMedia2
    extends Marshallable {
        public static final int uri = 0x3F60000 | AGORA_UI_SERVER;
        String connInfo;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.connInfo.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
        }
    }

    public static class PMediaReqLeaveChannel
    extends Marshallable {
        public static final int uri = 0x60000 | AGORA_UI_SERVER;
        int sid;

        @Override
        public byte[] marshall() {
            this.pushInt(this.sid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
        }
    }

    public static class PMediaReqUserData
    extends Marshallable {
        public static final int uri = 0x50000 | AGORA_UI_SERVER;
        String key;
        String username;
        String mobileinfo;
        int uid;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.key.getBytes());
            this.pushBytes(this.username.getBytes());
            this.pushBytes(this.mobileinfo.getBytes());
            this.pushInt(this.uid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
        }
    }

    public static class PMediaReqLeaveLinkd
    extends Marshallable {
        public static final int uri = 0x40000 | AGORA_UI_SERVER;
        int sid;

        @Override
        public byte[] marshall() {
            this.pushInt(this.sid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
        }
    }

    public static class PMediaReqJoinMeida
    extends Marshallable {
        public static final int uri = 0x30000 | AGORA_UI_SERVER;
        int sid;

        @Override
        public byte[] marshall() {
            this.pushInt(this.sid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
        }
    }

    public static class PMediaReqCreateChannel
    extends Marshallable {
        public static final int uri = 0x20000 | AGORA_UI_SERVER;
        String key;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.key.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] buf) {
        }
    }
}

