/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import android.media.AudioManager;
import android.net.wifi.WifiManager;
import android.opengl.EGLContext;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.OrientationEventListener;
import android.view.SurfaceView;
import io.agora.rtc.IAudioEffectManager;
import io.agora.rtc.IAudioFrameObserver;
import io.agora.rtc.IMetadataObserver;
import io.agora.rtc.IRtcEngineEventHandler;
import io.agora.rtc.IRtcEngineEventHandlerEx;
import io.agora.rtc.RtcEngineEx;
import io.agora.rtc.internal.Connectivity;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.LastmileProbeConfig;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.internal.RtcEngineMessage;
import io.agora.rtc.live.LiveInjectStreamConfig;
import io.agora.rtc.live.LiveTranscoding;
import io.agora.rtc.mediaio.AgoraDefaultRender;
import io.agora.rtc.mediaio.AgoraDefaultSource;
import io.agora.rtc.mediaio.IVideoSink;
import io.agora.rtc.mediaio.IVideoSource;
import io.agora.rtc.models.UserInfo;
import io.agora.rtc.video.AgoraImage;
import io.agora.rtc.video.AgoraVideoFrame;
import io.agora.rtc.video.BeautyOptions;
import io.agora.rtc.video.CameraCapturerConfiguration;
import io.agora.rtc.video.ChannelMediaInfo;
import io.agora.rtc.video.ChannelMediaRelayConfiguration;
import io.agora.rtc.video.VideoCanvas;
import io.agora.rtc.video.VideoEncoderConfiguration;
import io.agora.rtc.video.WatermarkOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RtcEngineImpl
extends RtcEngineEx
implements IAudioEffectManager {
    private static final String TAG = "RtcEngine";
    private static final int VIDEO_SOURCE_TYPE_NULL = 0;
    private static final int VIDEO_SOURCE_TYPE_DEFAULT = 1;
    private static final int VIDEO_SOURCE_TYPE_CUSTOMIZED = 2;
    private static final int VIDEO_SOURCE_TYPE_EXTERNAL_DEPRECATED = 3;
    private int mVideoSourceType = 1;
    private boolean mLocalVideoEnabled = false;
    private boolean mUseLocalView = false;
    private int mExAudioSampleRate = 0;
    private int mExAudioChannels = 0;
    private OrientationEventListener mOrientationListener;
    private long lastOrientationTs = 0L;
    private int mTotalRotation = 1000;
    private long mNativeHandle = 0L;
    private static boolean sLibLoaded = false;
    private final ConcurrentHashMap<IRtcEngineEventHandler, Integer> mRtcHandlers = new ConcurrentHashMap();
    private IRtcEngineEventHandler.RtcStats mRtcStats = null;
    private WifiManager.WifiLock mWifiLock = null;
    private int mChannelProfile = 0;
    private int mClientRole = 2;
    private WeakReference<Context> mContext;
    private int mOrientation = -1;
    private static final int ORIENTATION_HYSTERESIS = 0;
    static float[] sMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    private void checkVoipPermissions(Context context, String perm) throws SecurityException {
        if (context == null || context.checkCallingOrSelfPermission(perm) != 0) {
            throw new SecurityException(perm + " is not granted");
        }
    }

    private void checkVoipPermissions(Context context) throws SecurityException {
        this.checkVoipPermissions(context, "android.permission.INTERNET");
        this.checkVoipPermissions(context, "android.permission.RECORD_AUDIO");
        this.checkVoipPermissions(context, "android.permission.MODIFY_AUDIO_SETTINGS");
        if (this.mVideoSourceType == 1 && this.mLocalVideoEnabled) {
            this.checkVoipPermissions(context, "android.permission.CAMERA");
        }
    }

    private int checkVoipPermissions(Context context, int clientRole) {
        switch (clientRole) {
            case 1: {
                try {
                    this.checkVoipPermissions(context);
                    break;
                }
                catch (SecurityException e) {
                    Logging.e(TAG, "Do not have enough permission! ", e);
                    return -9;
                }
            }
            case 2: {
                try {
                    this.checkVoipPermissions(context, "android.permission.INTERNET");
                    break;
                }
                catch (SecurityException e) {
                    Logging.e(TAG, "Do not have Internet permission!");
                    return -9;
                }
            }
            default: {
                return -2;
            }
        }
        return 0;
    }

    public static synchronized void loadNativeLibrary() {
        System.loadLibrary("agora-rtc-sdk-jni");
    }

    public static synchronized boolean initializeNativeLibs() {
        if (!sLibLoaded) {
            RtcEngineImpl.loadNativeLibrary();
            sLibLoaded = RtcEngineImpl.nativeClassInit() == 0;
        }
        return sLibLoaded;
    }

    public static boolean checkIfInUIThread(String name) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            Logging.i(TAG, name + " in UI Thread");
            return true;
        }
        Logging.i(TAG, name + " not in UI Thread");
        return false;
    }

    public RtcEngineImpl(Context context, String appId, IRtcEngineEventHandler handler) throws Exception {
        this.mContext = new WeakReference<Context>(context);
        this.addHandler(handler);
        this.mNativeHandle = this.nativeObjectInit(context, appId, "", "", "", "", "", "");
    }

    public Context getContext() {
        return (Context)this.mContext.get();
    }

    public void doDestroy() {
        this.setExternalVideoSource(false, false, true);
        this.doStopMonitorSystemEvent();
        this.nativeDestroy(this.mNativeHandle);
        this.mNativeHandle = 0L;
    }

    public void reinitialize(Context context, String appId, IRtcEngineEventHandler handler) {
        this.addHandler(handler);
    }

    @Override
    public void addHandler(IRtcEngineEventHandler handler) {
        this.mRtcHandlers.put(handler, 0);
    }

    @Override
    public void removeHandler(IRtcEngineEventHandler handler) {
        if (this.mRtcHandlers.containsKey(handler)) {
            this.mRtcHandlers.remove(handler);
        }
    }

    private void setDeviceOrientation(int orientation) {
        long now = System.currentTimeMillis();
        if (now - this.lastOrientationTs < 100L) {
            return;
        }
        int newori = (int)(Math.round((double)orientation / 90.0) * 90L) % 360;
        int update = 0;
        if (Math.abs(newori - orientation) < 20) {
            update = 1;
        } else if (Math.abs(newori - orientation) < 40) {
            update = 2;
        }
        if (newori == 0 && orientation > 180) {
            if (360 - orientation < 20) {
                update = 1;
            } else if (360 - orientation < 40) {
                update = 2;
            }
        }
        if (update > 0) {
            try {
                int cameraRotation;
                Camera.CameraInfo info = new Camera.CameraInfo();
                int cameraOrientation = info.orientation;
                int totalCameraRotation = 0;
                int n = cameraRotation = update == 1 ? newori : newori + 5;
                if (totalCameraRotation != this.mTotalRotation) {
                    this.setVideoRotateCapturedFrames(totalCameraRotation, cameraRotation);
                }
                this.mTotalRotation = totalCameraRotation;
            }
            catch (Exception e) {
                Logging.e(TAG, "Unable to get camera info, ", e);
            }
        }
        this.lastOrientationTs = now;
    }

    private int setVideoRotateCapturedFrames(int degree, int rotation) {
        return this.setParameterObject("che.video.local.rotate_video", RtcEngineImpl.formatString("{\"degree\":%d,\"rotation\":%d}", degree, rotation));
    }

    @Override
    public int setupRemoteVideo(VideoCanvas remote) {
        RtcEngineImpl.checkIfInUIThread("setupRemoteVideo");
        if (remote != null) {
            return this.nativeSetupVideoRemote(this.mNativeHandle, remote.view, remote.renderMode, remote.uid);
        }
        return -1;
    }

    @Override
    public int setupLocalVideo(VideoCanvas local) {
        RtcEngineImpl.checkIfInUIThread("setupLocalVideo");
        if (this.mVideoSourceType == 3) {
            return -1;
        }
        if (local != null) {
            this.mUseLocalView = true;
            this.nativeSetupVideoLocal(this.mNativeHandle, local.view, local.renderMode);
        } else {
            this.mUseLocalView = false;
            this.nativeSetupVideoLocal(this.mNativeHandle, null, 1);
        }
        return 0;
    }

    @Override
    public int setLocalRenderMode(int mode) {
        return this.setRemoteRenderMode(0, mode);
    }

    @Override
    public int setRemoteRenderMode(int uid, int mode) {
        return this.setParameterObject("che.video.render_mode", RtcEngineImpl.formatString("{\"uid\":%d,\"mode\":%d}", (long)uid & 0xFFFFFFFFL, mode));
    }

    @Override
    public int setLocalVideoMirrorMode(int mode) {
        String modeStr;
        switch (mode) {
            case 0: {
                modeStr = "default";
                break;
            }
            case 1: {
                modeStr = "forceMirror";
                break;
            }
            case 2: {
                modeStr = "disableMirror";
                break;
            }
            default: {
                return -2;
            }
        }
        return this.setParameter("che.video.localViewMirrorSetting", modeStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssetsCacheFile(Context context, String filePath) {
        try {
            String fileName = "wm_" + filePath.replace(File.separator, "_");
            File cacheFile = new File(context.getCacheDir(), fileName);
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
            try (InputStream inputStream = context.getAssets().open(filePath);
                 FileOutputStream outputStream = new FileOutputStream(cacheFile);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
            }
            return cacheFile.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int addVideoWatermark(AgoraImage watermark) {
        WatermarkOptions options = null;
        String watermarkUrl = null;
        if (watermark != null) {
            watermarkUrl = watermark.url;
            options = new WatermarkOptions();
            options.visibleInPreview = false;
            options.positionInPortraitMode = options.positionInLandscapeMode = new WatermarkOptions.Rectangle(watermark.x, watermark.y, watermark.width, watermark.height);
        }
        return this.addVideoWatermark(watermarkUrl, options);
    }

    @Override
    public int addVideoWatermark(String watermarkUrl, WatermarkOptions options) {
        if (watermarkUrl == null || TextUtils.isEmpty((CharSequence)watermarkUrl) || options == null) {
            return -2;
        }
        if (watermarkUrl.startsWith("/assets/")) {
            String assetsPath = watermarkUrl.replaceFirst("/assets/", "");
            assetsPath = this.getAssetsCacheFile((Context)this.mContext.get(), assetsPath);
            if (assetsPath == null) {
                return -2;
            }
            watermarkUrl = assetsPath;
            Logging.i(TAG, "assets watermark, url: " + watermarkUrl);
        }
        int lx = 0;
        int ly = 0;
        int lw = 0;
        int lh = 0;
        int px = 0;
        int py = 0;
        int pw = 0;
        int ph = 0;
        if (options.positionInLandscapeMode != null) {
            lx = options.positionInLandscapeMode.x;
            ly = options.positionInLandscapeMode.y;
            lw = options.positionInLandscapeMode.width;
            lh = options.positionInLandscapeMode.height;
        }
        if (options.positionInPortraitMode != null) {
            px = options.positionInPortraitMode.x;
            py = options.positionInPortraitMode.y;
            pw = options.positionInPortraitMode.width;
            ph = options.positionInPortraitMode.height;
        }
        return this.nativeAddVideoWatermark(this.mNativeHandle, watermarkUrl, options.visibleInPreview, lx, ly, lw, lh, px, py, pw, ph);
    }

    @Override
    public int clearVideoWatermarks() {
        return this.nativeClearVideoWatermarks(this.mNativeHandle);
    }

    @Override
    public int enableDualStreamMode(boolean enabled) {
        return this.setParameters(String.format("{\"rtc.dual_stream_mode\":%b,\"che.video.enableLowBitRateStream\":%d}", enabled, enabled ? 1 : 0));
    }

    @Override
    @Deprecated
    public void monitorHeadsetEvent(boolean monitor) {
        Logging.i(TAG, "enter monitorHeadsetEvent:" + monitor);
    }

    @Override
    @Deprecated
    @TargetApi(value=11)
    public void monitorBluetoothHeadsetEvent(boolean monitor) {
        Logging.i(TAG, "enter monitorBluetoothHeadsetEvent:" + monitor);
    }

    @Override
    public boolean enableHighPerfWifiMode(boolean enable) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return false;
        }
        if (enable) {
            int wakeLock = context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK");
            if (wakeLock != 0) {
                this.mWifiLock = null;
                return false;
            }
            if (this.mWifiLock == null) {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                this.mWifiLock = wifiManager.createWifiLock(3, "agora.voip.lock");
            }
        } else {
            this.mWifiLock = null;
        }
        return true;
    }

    public IRtcEngineEventHandler.RtcStats getRtcStats() {
        if (this.mRtcStats == null) {
            this.mRtcStats = new IRtcEngineEventHandler.RtcStats();
        }
        return this.mRtcStats;
    }

    public synchronized void updateRtcStats(RtcEngineMessage.PMediaResRtcStats stats) {
        IRtcEngineEventHandler.RtcStats rtcStats = this.getRtcStats();
        if (rtcStats == null) {
            return;
        }
        rtcStats.totalDuration = stats.totalDuration;
        rtcStats.txBytes = stats.totalTxBytes;
        rtcStats.rxBytes = stats.totalRxBytes;
        rtcStats.txAudioBytes = stats.txAudioBytes;
        rtcStats.txVideoBytes = stats.txVideoBytes;
        rtcStats.rxAudioBytes = stats.rxAudioBytes;
        rtcStats.rxVideoBytes = stats.rxVideoBytes;
        rtcStats.txKBitRate = stats.txKBitRate;
        rtcStats.rxKBitRate = stats.rxKBitRate;
        rtcStats.txAudioKBitRate = stats.txAudioKBitRate;
        rtcStats.rxAudioKBitRate = stats.rxAudioKBitRate;
        rtcStats.txVideoKBitRate = stats.txVideoKBitRate;
        rtcStats.rxVideoKBitRate = stats.rxVideoKBitRate;
        rtcStats.lastmileDelay = stats.lastmileDelay;
        rtcStats.txPacketLossRate = stats.txPacketLossRate;
        rtcStats.rxPacketLossRate = stats.rxPacketLossRate;
        rtcStats.users = stats.users;
        rtcStats.cpuTotalUsage = (double)stats.cpuTotalUsage / 100.0;
        rtcStats.cpuAppUsage = (double)stats.cpuAppUsage / 100.0;
    }

    private void doMonitorSystemEvent(Context context) {
        if (context == null) {
            return;
        }
        int accessNetworkState = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
        if (accessNetworkState != 0) {
            return;
        }
        if (Connectivity.getNetworkType(context) != 2) {
            return;
        }
        int accessWifiState = context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE");
        if (accessWifiState != 0) {
            return;
        }
        if (this.mWifiLock != null) {
            this.mWifiLock.acquire();
            Logging.i(TAG, "hp connection mode detected");
        }
    }

    private int doCheckPermission(Context context) {
        int role = 1;
        if (this.mChannelProfile == 1) {
            role = this.mClientRole;
        }
        if (this.checkVoipPermissions(context, role) != 0) {
            Logging.e(TAG, "can't join channel because no permission");
            return -9;
        }
        return 0;
    }

    @Override
    public int joinChannel(String key, String channelName, String optionalInfo, int optionalUid) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        this.doMonitorSystemEvent(context);
        int r = this.doCheckPermission(context);
        if (!this.mUseLocalView) {
            try {
                if (this.mOrientationListener == null) {
                    this.mOrientationListener = new OrientationEventListener(context, 2){

                        public void onOrientationChanged(int orientation) {
                            if (RtcEngineImpl.this.mUseLocalView) {
                                return;
                            }
                            if (orientation == -1) {
                                return;
                            }
                            RtcEngineImpl.this.updateViewOrientation(orientation);
                        }
                    };
                }
                this.mOrientationListener.enable();
            }
            catch (Exception e) {
                Logging.e(TAG, "Unable to create OrientationEventListener, ", e);
            }
        }
        return this.nativeJoinChannel(this.mNativeHandle, null, key, channelName, optionalInfo, optionalUid);
    }

    @Override
    public int switchChannel(String key, String channelName) {
        return this.nativeSwitchChannel(this.mNativeHandle, key, channelName);
    }

    private void updateViewOrientation(int orientation) {
        int roundedOrientation = RtcEngineImpl.roundOrientation(orientation, this.mOrientation);
        if (this.mOrientation != roundedOrientation) {
            this.mOrientation = roundedOrientation;
            int ori = this.mOrientation;
            if (ori / 90 % 2 != 0) {
                ori = (ori + 180) % 360;
            }
            int displayRotation = ori / 90;
            this.setParameterObject("che.video.view_orientation", RtcEngineImpl.formatString("{\"uid\":%d,\"orientation\":%d}", 0, displayRotation));
        }
    }

    private static int roundOrientation(int orientation, int orientationHistory) {
        boolean changeOrientation = false;
        if (orientationHistory == -1) {
            changeOrientation = true;
        } else {
            int dist = Math.abs(orientation - orientationHistory);
            boolean bl = changeOrientation = (dist = Math.min(dist, 360 - dist)) >= 45;
        }
        if (changeOrientation) {
            return (orientation + 45) / 90 * 90 % 360;
        }
        return orientationHistory;
    }

    private void doStopMonitorSystemEvent() {
        if (this.mOrientationListener != null) {
            this.mOrientationListener.disable();
            this.mOrientationListener = null;
        }
        if (this.mWifiLock != null && this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
            Logging.i(TAG, "hp connection mode ended");
        }
    }

    @Override
    public int leaveChannel() {
        this.doStopMonitorSystemEvent();
        return this.nativeLeaveChannel(this.mNativeHandle);
    }

    @Override
    public int startEchoTest() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        this.doMonitorSystemEvent(context);
        return this.nativeStartEchoTest(this.mNativeHandle, null);
    }

    @Override
    public int startEchoTest(int intervalInSeconds) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        this.doMonitorSystemEvent(context);
        return this.nativeStartEchoTestWithInterval(this.mNativeHandle, null, intervalInSeconds);
    }

    @Override
    public int stopEchoTest() {
        return this.nativeStopEchoTest(this.mNativeHandle);
    }

    @Override
    public int enableLastmileTest() {
        return this.setParameter("rtc.lastmile_test", true);
    }

    @Override
    public int disableLastmileTest() {
        return this.setParameter("rtc.lastmile_test", false);
    }

    @Override
    public int startLastmileProbeTest(LastmileProbeConfig config) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        this.doMonitorSystemEvent(context);
        return this.nativeStartLastmileProbeTest(this.mNativeHandle, null, config.probeUplink, config.probeDownlink, config.expectedUplinkBitrate, config.expectedDownlinkBitrate);
    }

    @Override
    public int stopLastmileProbeTest() {
        return this.nativeStopLastmileProbeTest(this.mNativeHandle);
    }

    @Override
    public int enableVideo() {
        this.mLocalVideoEnabled = true;
        return this.nativeEnableVideo(this.mNativeHandle);
    }

    @Override
    public int disableVideo() {
        this.mLocalVideoEnabled = false;
        return this.nativeDisableVideo(this.mNativeHandle);
    }

    @Override
    public int enableLocalVideo(boolean enabled) {
        this.mLocalVideoEnabled = enabled;
        return this.setParameters(String.format("{\"rtc.video.capture\":%b,\"che.video.local.capture\":%b,\"che.video.local.render\":%b,\"che.video.local.send\":%b}", enabled, enabled, enabled, enabled));
    }

    @Override
    public int startPreview() {
        if (this.mVideoSourceType == 3) {
            return -4;
        }
        return this.nativeStartPreview(this.mNativeHandle);
    }

    @Override
    public int stopPreview() {
        return this.setParameter("rtc.video.preview", false);
    }

    @Override
    public int enableAudio() {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.audio.enabled\":%b, \"che.audio.enable.recording.device\":%b}", true, true));
    }

    @Override
    public int enableLocalAudio(boolean enabled) {
        return this.nativeEnableLocalAudio(this.mNativeHandle, enabled);
    }

    @Override
    public int disableAudio() {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.audio.enabled\":%b, \"che.audio.enable.recording.device\":%b}", false, false));
    }

    @Override
    public int pauseAudio() {
        return this.setParameter("rtc.audio.paused", true);
    }

    @Override
    public int resumeAudio() {
        return this.setParameter("rtc.audio.paused", false);
    }

    @Override
    public int muteLocalAudioStream(boolean muted) {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.audio.mute_me\":%b, \"che.audio.mute_me\":%b}", muted, muted));
    }

    @Override
    public int muteLocalVideoStream(boolean muted) {
        return this.nativeMuteLocalVideoStream(this.mNativeHandle, muted);
    }

    @Override
    public int muteAllRemoteAudioStreams(boolean muted) {
        return this.setParameter("rtc.audio.mute_peers", muted);
    }

    @Override
    public int setDefaultMuteAllRemoteAudioStreams(boolean muted) {
        return this.setParameter("rtc.audio.set_default_mute_peers", muted);
    }

    @Override
    public int muteAllRemoteVideoStreams(boolean muted) {
        return this.nativeMuteAllRemoteVideoStreams(this.mNativeHandle, muted);
    }

    @Override
    public int setDefaultMuteAllRemoteVideoStreams(boolean muted) {
        return this.setParameter("rtc.video.set_default_mute_peers", muted);
    }

    @Override
    public int setBeautyEffectOptions(boolean enabled, BeautyOptions options) {
        if (options == null) {
            if (enabled) {
                return -2;
            }
            options = new BeautyOptions();
        }
        return this.nativeSetBeautyEffectOptions(this.mNativeHandle, enabled, options.lighteningContrastLevel, options.lighteningLevel, options.smoothnessLevel, options.rednessLevel);
    }

    @Override
    public int muteRemoteAudioStream(int uid, boolean muted) {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.audio.mute_peer\":{\"uid\":%d,\"mute\":%b}}", (long)uid & 0xFFFFFFFFL, muted));
    }

    @Override
    public int muteRemoteVideoStream(int uid, boolean muted) {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.video.mute_peer\":{\"uid\":%d,\"mute\":%b}}", (long)uid & 0xFFFFFFFFL, muted));
    }

    @Override
    public int renewToken(String token) {
        if (token == null) {
            return -2;
        }
        return this.setParameter("rtc.renew_token", token);
    }

    @Override
    public int registerLocalUserAccount(String appId, String userAccount) {
        if (appId == null || userAccount == null) {
            return -2;
        }
        return this.nativeRegisterLocalUserAccount(this.mNativeHandle, appId, userAccount);
    }

    @Override
    public int joinChannelWithUserAccount(String token, String channelId, String userAccount) {
        return this.nativeJoinChannelWithUserAccount(this.mNativeHandle, token, channelId, userAccount);
    }

    @Override
    public int getUserInfoByUserAccount(String userAccount, UserInfo userInfo) {
        return this.nativeGetUserInfoByUserAccount(this.mNativeHandle, userAccount, userInfo);
    }

    @Override
    public int getUserInfoByUid(int uid, UserInfo userInfo) {
        return this.nativeGetUserInfoByUid(this.mNativeHandle, uid, userInfo);
    }

    @Override
    public int setDefaultAudioRoutetoSpeakerphone(boolean defaultToSpeaker) {
        Logging.i(String.format("API call to setDefaultAudioRoutetoSpeakerphone :%b", defaultToSpeaker));
        return this.nativeSetDefaultAudioRoutetoSpeakerphone(this.mNativeHandle, defaultToSpeaker);
    }

    @Override
    public int setEnableSpeakerphone(boolean speakerOn) {
        Logging.i(String.format("API call to setEnableSpeakerphone to %b", speakerOn));
        return this.nativeSetEnableSpeakerphone(this.mNativeHandle, speakerOn);
    }

    @Override
    public boolean isSpeakerphoneEnabled() {
        return this.nativeIsSpeakerphoneEnabled(this.mNativeHandle);
    }

    @Override
    public int adjustRecordingSignalVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        } else if (volume > 400) {
            volume = 400;
        }
        return this.setParameter("che.audio.record.signal.volume", volume);
    }

    @Override
    public int adjustPlaybackSignalVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        } else if (volume > 400) {
            volume = 400;
        }
        return this.setParameter("che.audio.playout.signal.volume", volume);
    }

    @Override
    public int setRecordingAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        return this.setParameterObject("che.audio.set_capture_raw_audio_format", RtcEngineImpl.formatString("{\"sampleRate\":%d,\"channelCnt\":%d,\"mode\":%d,\"samplesPerCall\":%d}", sampleRate, channel, mode, samplesPerCall));
    }

    @Override
    public int setPlaybackAudioFrameParameters(int sampleRate, int channel, int mode, int samplesPerCall) {
        return this.setParameterObject("che.audio.set_render_raw_audio_format", RtcEngineImpl.formatString("{\"sampleRate\":%d,\"channelCnt\":%d,\"mode\":%d,\"samplesPerCall\":%d}", sampleRate, channel, mode, samplesPerCall));
    }

    @Override
    public int setMixedAudioFrameParameters(int sampleRate, int samplesPerCall) {
        return this.setParameterObject("che.audio.set_mixed_raw_audio_format", RtcEngineImpl.formatString("{\"sampleRate\":%d,\"samplesPerCall\":%d}", sampleRate, samplesPerCall));
    }

    @Override
    public int setHighQualityAudioParameters(boolean fullband, boolean stereo, boolean fullBitrate) {
        return this.setParameterObject("che.audio.codec.hq", RtcEngineImpl.formatString("{\"fullband\":%b,\"stereo\":%b,\"fullBitrate\":%b}", fullband, stereo, fullBitrate));
    }

    @Override
    public int enableInEarMonitoring(boolean enabled) {
        return this.setParameter("che.audio.headset.monitoring", enabled);
    }

    @Override
    public int enableWebSdkInteroperability(boolean enabled) {
        return this.setParameters(String.format("{\"rtc.video.web_h264_interop_enable\":%b,\"che.video.web_h264_interop_enable\":%b}", enabled, enabled));
    }

    @Override
    public int setVideoQualityParameters(boolean preferFrameRateOverImageQuality) {
        return this.setParameters(String.format("{\"rtc.video.prefer_frame_rate\":%b,\"che.video.prefer_frame_rate\":%b}", preferFrameRateOverImageQuality, preferFrameRateOverImageQuality));
    }

    @Override
    @Deprecated
    public void setPreferHeadset(boolean enabled) {
    }

    @Override
    public int enableAudioVolumeIndication(int interval, int smooth, boolean report_vad) {
        if (interval < 0) {
            interval = 0;
        }
        if (report_vad) {
            return this.setParameterObject("che.audio.volume_indication", RtcEngineImpl.formatString("{\"interval\":%d,\"smooth\":%d,\"vad\":%d}", interval, smooth, 1));
        }
        return this.setParameterObject("che.audio.volume_indication", RtcEngineImpl.formatString("{\"interval\":%d,\"smooth\":%d,\"vad\":%d}", interval, smooth, 0));
    }

    @Override
    @Deprecated
    public int enableAudioQualityIndication(boolean enabled) {
        return this.setParameter("rtc.audio_quality_indication", enabled);
    }

    @Override
    public int enableTransportQualityIndication(boolean enabled) {
        return this.setParameter("rtc.transport_quality_indication", enabled);
    }

    @Override
    public int playRecap() {
        return this.setParameter("che.audio.recap.start_play", true);
    }

    @Override
    public int enableRecap(int interval) {
        if (interval < 0) {
            interval = 0;
        }
        return this.setParameter("che.audio.recap.interval", interval);
    }

    @Override
    public int setVideoProfile(int profile, boolean swapWidthAndHeight) {
        if (profile < 0) {
            return -2;
        }
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.video.profile\":[%d,%b]}", profile, swapWidthAndHeight));
    }

    @Override
    public int setVideoProfile(int width, int height, int frameRate, int bitrate) {
        return this.nativeSetVideoProfileEx(this.mNativeHandle, width, height, frameRate, bitrate);
    }

    @Override
    public int setVideoEncoderConfiguration(VideoEncoderConfiguration config) {
        return this.nativeSetVideoEncoderConfiguration(this.mNativeHandle, config.dimensions.width, config.dimensions.height, config.frameRate, config.minFrameRate, config.bitrate, config.minBitrate, config.orientationMode.getValue(), config.degradationPrefer.getValue());
    }

    @Override
    public int setAudioProfile(int profile, int scenario) {
        return this.nativeSetAudioProfile(this.mNativeHandle, profile, scenario);
    }

    @Override
    public int monitorAudioRouteChange(boolean isMonitoring) {
        Logging.i("API call monitorAudioRouteChange:" + isMonitoring);
        return 0;
    }

    @Override
    public int switchCamera() {
        if (this.mVideoSourceType != 1) {
            return -1;
        }
        return this.nativeSwitchCamera(this.mNativeHandle);
    }

    private int switchCamera(CameraCapturerConfiguration.CAMERA_DIRECTION direction) {
        if (this.mVideoSourceType != 1) {
            return -1;
        }
        return this.nativeSwitchCameraByDirection(this.mNativeHandle, direction.getValue());
    }

    @Override
    public boolean isCameraZoomSupported() {
        String value = this.nativeGetParameter(this.mNativeHandle, "che.video.camera.zoom_supported", null);
        return Boolean.valueOf(value);
    }

    @Override
    public boolean isCameraTorchSupported() {
        String value = this.nativeGetParameter(this.mNativeHandle, "che.video.camera.torch_supported", null);
        return Boolean.valueOf(value);
    }

    @Override
    public boolean isCameraFocusSupported() {
        String value = this.nativeGetParameter(this.mNativeHandle, "che.video.camera.focus_supported", null);
        return Boolean.valueOf(value);
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        String value = this.nativeGetParameter(this.mNativeHandle, "che.video.camera.exposure_supported", null);
        return Boolean.valueOf(value);
    }

    @Override
    public boolean isCameraAutoFocusFaceModeSupported() {
        String value = this.nativeGetParameter(this.mNativeHandle, "che.video.camera.face_focus_supported", null);
        return Boolean.valueOf(value);
    }

    @Override
    public int setCameraZoomFactor(float factor) {
        return this.setParameter("che.video.camera.zoom", factor);
    }

    @Override
    public float getCameraMaxZoomFactor() {
        String value = this.nativeGetParameter(this.mNativeHandle, "che.video.camera.get_max_zoom", null);
        if (value == null) {
            return 1.0f;
        }
        float retValue = Double.valueOf(value).floatValue();
        return retValue;
    }

    @Override
    public int setCameraFocusPositionInPreview(float positionX, float positionY) {
        return this.setParameterObject("che.video.camera.focus", RtcEngineImpl.formatString("{\"x\":%f,\"y\":%f,\"preview\":%b}", Float.valueOf(positionX), Float.valueOf(positionY), true));
    }

    @Override
    public int setCameraExposurePosition(float positionXinView, float positionYinView) {
        return this.setParameterObject("che.video.camera.exposure", RtcEngineImpl.formatString("{\"x\":%f,\"y\":%f,\"preview\":%b}", Float.valueOf(positionXinView), Float.valueOf(positionYinView), true));
    }

    @Override
    public int setCameraTorchOn(boolean isOn) {
        return this.setParameter("che.video.camera.flash", isOn);
    }

    @Override
    public int setCameraAutoFocusFaceModeEnabled(boolean enabled) {
        return this.setParameter("che.video.camera.face_detection", enabled);
    }

    public int enableRemoteVideo(boolean enabled, int uid) {
        return this.setParameterObject("che.video.peer.receive", RtcEngineImpl.formatString("{\"enable\":%b, \"uid\":%d}", enabled, (long)uid & 0xFFFFFFFFL));
    }

    public int stopRemoteVideo(int uid) {
        return this.setParameter("che.video.peer.stop_video", (long)uid & 0xFFFFFFFFL);
    }

    private static String formatString(String format, Object ... args) {
        return String.format(Locale.US, format, args);
    }

    public int stopAllRemoteVideo() {
        return this.setParameter("che.video.peer.stop_all_renders", true);
    }

    @Override
    public int startAudioRecording(String filePath, int quality) {
        return this.startAudioRecording(filePath, 32000, quality);
    }

    @Override
    public int startAudioRecording(String filePath, int sampeRate, int quality) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return -2;
        }
        return this.setParameterObject("che.audio.start_recording", RtcEngineImpl.formatString("{\"filePath\":\"%s\", \"sampleRate\":%d, \"quality\":%d}", filePath, sampeRate, quality));
    }

    @Override
    public int stopAudioRecording() {
        return this.setParameter("che.audio.stop_recording", true);
    }

    @Override
    public int startAudioMixing(String filePath, boolean loopback, boolean replace, int cycle) {
        return this.setParameterObject("che.audio.start_file_as_playout", RtcEngineImpl.formatString("{\"filePath\":\"%s\", \"loopback\":%b, \"replace\":%b, \"cycle\":%d}", filePath, loopback, replace, cycle));
    }

    @Override
    public int stopAudioMixing() {
        return this.setParameter("che.audio.stop_file_as_playout", true);
    }

    @Override
    public int pauseAudioMixing() {
        return this.setParameter("che.audio.pause_file_as_playout", true);
    }

    @Override
    public int resumeAudioMixing() {
        return this.setParameter("che.audio.pause_file_as_playout", false);
    }

    @Override
    public int adjustAudioMixingVolume(int volume) {
        int ret = this.adjustAudioMixingPlayoutVolume(volume);
        if (ret == 0) {
            this.adjustAudioMixingPublishVolume(volume);
        }
        return ret;
    }

    @Override
    public int adjustAudioMixingPlayoutVolume(int volume) {
        return this.setParameter("che.audio.set_file_as_playout_volume", volume);
    }

    @Override
    public int adjustAudioMixingPublishVolume(int volume) {
        return this.setParameter("che.audio.set_file_as_playout_publish_volume", volume);
    }

    @Override
    public int getAudioMixingPlayoutVolume() {
        return this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_file_as_playout_volume", null);
    }

    @Override
    public int getAudioMixingPublishVolume() {
        return this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_file_as_playout_publish_volume", null);
    }

    @Override
    public int getAudioMixingDuration() {
        return this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_mixing_file_length_ms", null);
    }

    @Override
    public int getAudioMixingCurrentPosition() {
        return this.nativeGetIntParameter(this.mNativeHandle, "che.audio.get_mixing_file_played_ms", null);
    }

    @Override
    public int setAudioMixingPosition(int pos) {
        return this.setParameter("che.audio.mixing.file.position", pos);
    }

    @Override
    public int useExternalAudioDevice() {
        return this.setParameters("{\"che.audio.audioSampleRate\":32000, \"che.audio.external_device\":true}");
    }

    @Override
    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        boolean useExternalAudioSource = observer != null;
        return this.nativeRegisterAudioFrameObserver(this.mNativeHandle, observer);
    }

    @Override
    public int setExternalAudioSink(boolean enabled, int sampleRate, int channels) {
        if (enabled) {
            return this.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_render\":%b,\"che.audio.external_render.pull\":%b,\"che.audio.set_render_raw_audio_format\":{\"sampleRate\":%d,\"channelCnt\":%d,\"mode\":%d}}", enabled, enabled, sampleRate, channels, 0));
        }
        return this.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_render\":%b,\"che.audio.external_render\":%b,\"che.audio.external_render.pull\":%b}", enabled, enabled, enabled));
    }

    @Override
    public int pullPlaybackAudioFrame(byte[] data, int lengthInBytes) {
        return this.nativePullAudioFrame(this.mNativeHandle, data, lengthInBytes);
    }

    @Override
    public int setExternalAudioSource(boolean enabled, int sampleRate, int channels) {
        this.mExAudioSampleRate = sampleRate;
        this.mExAudioChannels = channels;
        if (enabled) {
            return this.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_capture\":%b,\"che.audio.external_capture.push\":%b,\"che.audio.set_capture_raw_audio_format\":{\"sampleRate\":%d,\"channelCnt\":%d,\"mode\":%d}}", enabled, enabled, sampleRate, channels, 2));
        }
        return this.setParameters(RtcEngineImpl.formatString("{\"che.audio.external_capture\":%b,\"che.audio.external_capture\":%b,\"che.audio.external_capture.push\":%b}", enabled, enabled, enabled));
    }

    @Override
    public int pushExternalAudioFrame(byte[] data, long timestamp) {
        return this.nativePushExternalAudioFrameRawData(this.mNativeHandle, data, timestamp, this.mExAudioSampleRate, this.mExAudioChannels);
    }

    @Override
    public int setLogFile(String filePath) {
        return this.setParameter("rtc.log_file", filePath);
    }

    @Override
    public int setLogFilter(int filter) {
        return this.setParameter("rtc.log_filter", filter & 0x80F);
    }

    @Override
    public int setLogFileSize(int fileSizeInKBytes) {
        return this.setParameter("rtc.log_size", fileSizeInKBytes);
    }

    @Override
    public int setProfile(String profile, boolean merge) {
        return this.nativeSetProfile(this.mNativeHandle, profile, merge);
    }

    public String getProfile() {
        return this.nativeGetProfile(this.mNativeHandle);
    }

    @Override
    public int setAppType(int appType) {
        return this.nativeSetAppType(this.mNativeHandle, appType);
    }

    @Override
    public int setParameters(String parameters) {
        return this.nativeSetParameters(this.mNativeHandle, parameters);
    }

    @Override
    public String getParameters(String parameters) {
        return this.nativeGetParameters(this.mNativeHandle, parameters);
    }

    @Override
    public String getParameter(String parameter, String args) {
        return this.nativeGetParameter(this.mNativeHandle, parameter, args);
    }

    @Override
    public String makeQualityReportUrl(String channelName, int listenerUid, int speakerUid, int format) {
        return this.nativeMakeQualityReportUrl(this.mNativeHandle, channelName, listenerUid, speakerUid, format);
    }

    @Override
    public String getCallId() {
        return this.nativeGetCallId(this.mNativeHandle);
    }

    @Override
    public int rate(String callId, int rating, String description) {
        return this.nativeRate(this.mNativeHandle, callId, rating, description);
    }

    @Override
    public int complain(String callId, String description) {
        return this.nativeComplain(this.mNativeHandle, callId, description);
    }

    @Override
    public int setChannelProfile(int profile) {
        return this.nativeSetChannelProfile(this.mNativeHandle, profile);
    }

    @Override
    public int setClientRole(int role) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -7;
        }
        if (this.checkVoipPermissions(context, role) == 0) {
            switch (role) {
                case 1: 
                case 2: {
                    this.mClientRole = role;
                    break;
                }
                default: {
                    return -2;
                }
            }
            return this.setParameter("rtc.client_role", role);
        }
        return -9;
    }

    @Override
    public int setCameraCapturerConfiguration(CameraCapturerConfiguration config) {
        int ret = this.setParameter("che.video.camera_capture_mode", config.preference.getValue());
        if (0 == ret) {
            return this.switchCamera(config.cameraDirection);
        }
        return ret;
    }

    @Override
    public int setRemoteVideoStreamType(int uid, int streamType) {
        return this.setParameters(RtcEngineImpl.formatString("{\"rtc.video.set_remote_video_stream\":{\"uid\":%d,\"stream\":%d},\"che.video.setstream\":{\"uid\":%d,\"stream\":%d}}", (long)uid & 0xFFFFFFFFL, streamType, (long)uid & 0xFFFFFFFFL, streamType));
    }

    @Override
    public int setRemoteUserPriority(int uid, int userPriority) {
        return this.nativeSetRemoteUserPriority(this.mNativeHandle, uid, userPriority);
    }

    @Override
    public int setRemoteDefaultVideoStreamType(int streamType) {
        return this.setParameter("rtc.video.set_remote_default_video_stream_type", streamType);
    }

    @Override
    public int setLocalPublishFallbackOption(int option) {
        return this.setParameter("rtc.local_publish_fallback_option", option);
    }

    @Override
    public int setRemoteSubscribeFallbackOption(int option) {
        return this.setParameter("rtc.remote_subscribe_fallback_option", option);
    }

    @Override
    public int setEncryptionMode(String encryptionMode) {
        return this.setParameter("rtc.encryption.mode", encryptionMode);
    }

    @Override
    public int setEncryptionSecret(String secret) {
        return this.nativeSetEncryptionSecret(this.mNativeHandle, secret);
    }

    private void onLogEvent(int level, String message) {
    }

    protected void onEvent(int eventId, byte[] evt) {
        try {
            Iterator it = this.mRtcHandlers.keySet().iterator();
            while (it.hasNext()) {
                IRtcEngineEventHandler h = (IRtcEngineEventHandler)it.next();
                if (h == null) {
                    it.remove();
                    continue;
                }
                this.handleEvent(eventId, evt, h);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("onEvent: " + ex.toString()));
        }
    }

    protected void handleEvent(int eventId, byte[] evt, IRtcEngineEventHandler handler) {
        if (handler == null) {
            return;
        }
        block0 : switch (eventId) {
            case 100: {
                this.sendLogEvent(evt);
                break;
            }
            case 101: {
                RtcEngineMessage.PError pe = new RtcEngineMessage.PError();
                pe.unmarshall(evt);
                if (pe.err >= 1151 && pe.err <= 1164 || pe.err >= 1001 && pe.err < 1033 && this.getParameters("che.audio.adm.active").equals("2")) {
                    Logging.e(TAG, "ADM Error code " + pe.err + " restart ADM");
                    this.setParameter("che.audio.opensl", false);
                    this.setParameters("che.audio.restart");
                }
                handler.onError(pe.err);
                break;
            }
            case 102: {
                RtcEngineMessage.PError pe = new RtcEngineMessage.PError();
                pe.unmarshall(evt);
                if ((pe.err == 1019 || pe.err == 1052) && this.getParameters("che.audio.adm.active").equals("2")) {
                    Logging.e(TAG, "ADM Error code " + pe.err + " restart ADM");
                    this.setParameter("che.audio.opensl", false);
                    this.setParameters("che.audio.restart");
                }
                handler.onWarning(pe.err);
                break;
            }
            case 1006: {
                handler.onMediaEngineStartCallSuccess();
                break;
            }
            case 10001: {
                RtcEngineMessage.MediaResSetupTime mrst0 = new RtcEngineMessage.MediaResSetupTime();
                mrst0.unmarshall(evt);
                break;
            }
            case 13001: {
                RtcEngineMessage.PMediaResJoinMedia pmjm = new RtcEngineMessage.PMediaResJoinMedia();
                pmjm.unmarshall(evt);
                if (pmjm.firstSuccess) {
                    handler.onJoinChannelSuccess(pmjm.channel, pmjm.uid, pmjm.elapsed);
                    break;
                }
                handler.onRejoinChannelSuccess(pmjm.channel, pmjm.uid, pmjm.elapsed);
                break;
            }
            case 1005: {
                handler.onCameraReady();
                break;
            }
            case 1108: {
                handler.onRequestToken();
                break;
            }
            case 1109: {
                RtcEngineMessage.PClientRoleChanged pcrc = new RtcEngineMessage.PClientRoleChanged();
                pcrc.unmarshall(evt);
                handler.onClientRoleChanged(pcrc.oldRole, pcrc.newRole);
                break;
            }
            case 1119: {
                RtcEngineMessage.PRtmpStreamingState prss = new RtcEngineMessage.PRtmpStreamingState();
                prss.unmarshall(evt);
                handler.onRtmpStreamingStateChanged(prss.url, prss.state, prss.error);
                break;
            }
            case 1110: {
                RtcEngineMessage.PStreamPublished psp = new RtcEngineMessage.PStreamPublished();
                psp.unmarshall(evt);
                handler.onStreamPublished(psp.url, psp.error);
                break;
            }
            case 1111: {
                RtcEngineMessage.PStreamUnPublished psup = new RtcEngineMessage.PStreamUnPublished();
                psup.unmarshall(evt);
                handler.onStreamUnpublished(psup.url);
                break;
            }
            case 1112: {
                handler.onTranscodingUpdated();
                break;
            }
            case 1116: {
                RtcEngineMessage.PStreamInjectedStatus sis = new RtcEngineMessage.PStreamInjectedStatus();
                sis.unmarshall(evt);
                handler.onStreamInjectedStatus(sis.url, sis.uid, sis.status);
                break;
            }
            case 1117: {
                RtcEngineMessage.PPrivilegeWillExpire ppwe = new RtcEngineMessage.PPrivilegeWillExpire();
                ppwe.unmarshall(evt);
                handler.onTokenPrivilegeWillExpire(ppwe.token);
            }
            case 1002: {
                handler.onMediaEngineLoadSuccess();
                break;
            }
            case 1104: {
                RtcEngineMessage.PMediaEngineEvent pmee = new RtcEngineMessage.PMediaEngineEvent();
                pmee.unmarshall(evt);
                switch (pmee.code) {
                    case 10: {
                        handler.onAudioMixingFinished();
                        break block0;
                    }
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: {
                        break block0;
                    }
                    case 14: {
                        handler.onMicrophoneEnabled(true);
                        break block0;
                    }
                    case 15: {
                        handler.onMicrophoneEnabled(false);
                        break block0;
                    }
                }
                if (pmee.code < 701 || pmee.code > 713) break;
                if (pmee.code >= 701 && pmee.code <= 703) {
                    handler.onAudioMixingStateChanged(714, pmee.code);
                    break;
                }
                if (pmee.code != 712) {
                    handler.onAudioMixingStateChanged(pmee.code, 0);
                    break;
                }
                Logging.d(TAG, "AudioMixing restart");
                break;
            }
            case 1007: {
                handler.onVideoStopped();
                break;
            }
            case 1101: {
                RtcEngineMessage.PMediaResTransportQuality tq = new RtcEngineMessage.PMediaResTransportQuality();
                tq.unmarshall(evt);
                if (tq.isAudio) {
                    ((IRtcEngineEventHandlerEx)handler).onAudioTransportQuality(tq.peer_uid, tq.bitrate, tq.delay, tq.lost);
                    break;
                }
                ((IRtcEngineEventHandlerEx)handler).onVideoTransportQuality(tq.peer_uid, tq.bitrate, tq.delay, tq.lost);
                break;
            }
            case 1102: {
                RtcEngineMessage.PMediaResAudioQuality aq = new RtcEngineMessage.PMediaResAudioQuality();
                aq.unmarshall(evt);
                handler.onAudioQuality(aq.peer_uid, aq.quality, aq.delay, aq.lost);
                break;
            }
            case 1106: {
                this.onApiCallExecuted(evt, handler);
                break;
            }
            case 13010: {
                RtcEngineMessage.PMediaResRtcStats rtcStats = new RtcEngineMessage.PMediaResRtcStats();
                rtcStats.unmarshall(evt);
                this.updateRtcStats(rtcStats);
                handler.onRtcStats(this.getRtcStats());
                break;
            }
            case 13006: {
                Context cc = (Context)this.mContext.get();
                if (cc != null) {
                    this.getAudioManager(cc).setMode(0);
                }
                RtcEngineMessage.PMediaResRtcStats rtcStats2 = new RtcEngineMessage.PMediaResRtcStats();
                rtcStats2.unmarshall(evt);
                this.updateRtcStats(rtcStats2);
                handler.onLeaveChannel(this.getRtcStats());
                break;
            }
            case 13007: {
                RtcEngineMessage.PMediaResNetworkQuality nq = new RtcEngineMessage.PMediaResNetworkQuality();
                nq.unmarshall(evt);
                handler.onNetworkQuality(nq.uid, nq.txQuality, nq.rxQuality);
                break;
            }
            case 13017: {
                RtcEngineMessage.PMediaResLastmileQuality lq = new RtcEngineMessage.PMediaResLastmileQuality();
                lq.unmarshall(evt);
                handler.onLastmileQuality(lq.quality);
                break;
            }
            case 13020: {
                RtcEngineMessage.PMediaResLastmileProbeResult result = new RtcEngineMessage.PMediaResLastmileProbeResult();
                result.unmarshall(evt);
                IRtcEngineEventHandler.LastmileProbeResult r = new IRtcEngineEventHandler.LastmileProbeResult();
                r.state = result.state;
                r.rtt = result.rtt;
                r.uplinkReport.packetLossRate = result.uplinkReport.packetLossRate;
                r.uplinkReport.jitter = result.uplinkReport.jitter;
                r.uplinkReport.availableBandwidth = result.uplinkReport.availableBandwidth;
                r.downlinkReport.packetLossRate = result.downlinkReport.packetLossRate;
                r.downlinkReport.jitter = result.downlinkReport.jitter;
                r.downlinkReport.availableBandwidth = result.downlinkReport.availableBandwidth;
                handler.onLastmileProbeResult(r);
                break;
            }
            case 13013: {
                RtcEngineMessage.PMediaResUserJoinedEvent euj = new RtcEngineMessage.PMediaResUserJoinedEvent();
                euj.unmarshall(evt);
                handler.onUserJoined(euj.uid, euj.elapsed);
                break;
            }
            case 13008: {
                RtcEngineMessage.PMediaResUserOfflineEvent euo = new RtcEngineMessage.PMediaResUserOfflineEvent();
                euo.unmarshall(evt);
                handler.onUserOffline(euo.uid, euo.reason);
                break;
            }
            case 13014: {
                RtcEngineMessage.PMediaResUserState euma = new RtcEngineMessage.PMediaResUserState();
                euma.unmarshall(evt);
                handler.onUserMuteAudio(euma.uid, euma.state);
                break;
            }
            case 13015: {
                RtcEngineMessage.PMediaResUserState eumv = new RtcEngineMessage.PMediaResUserState();
                eumv.unmarshall(evt);
                handler.onUserMuteVideo(eumv.uid, eumv.state);
                break;
            }
            case 13016: {
                RtcEngineMessage.PMediaResUserState euev = new RtcEngineMessage.PMediaResUserState();
                euev.unmarshall(evt);
                handler.onUserEnableVideo(euev.uid, euev.state);
                break;
            }
            case 13019: {
                RtcEngineMessage.PMediaResUserState euelv = new RtcEngineMessage.PMediaResUserState();
                euelv.unmarshall(evt);
                handler.onUserEnableLocalVideo(euelv.uid, euelv.state);
                break;
            }
            case 14000: {
                ((IRtcEngineEventHandlerEx)handler).onRecap(evt);
                break;
            }
            case 14019: {
                handler.onConnectionBanned();
                break;
            }
            case 14001: {
                this.onSpeakersReport(evt, handler);
                break;
            }
            case 14016: {
                RtcEngineMessage.PActiveSpeaker eas = new RtcEngineMessage.PActiveSpeaker();
                eas.unmarshall(evt);
                handler.onActiveSpeaker(eas.uid);
                break;
            }
            case 14014: {
                this.onFirstLocalAudioFrame(evt, handler);
                break;
            }
            case 14015: {
                this.onFirstRemoteAudioFrame(evt, handler);
                break;
            }
            case 14005: {
                this.onFirstLocalVideoFrame(evt, handler);
                break;
            }
            case 14002: {
                this.onFirstRemoteVideoFrame(evt, handler);
                break;
            }
            case 14007: {
                this.onFirstRemoteVideoDecoded(evt, handler);
                break;
            }
            case 14020: {
                this.onCameraFocusAreaChanged(evt, handler);
                break;
            }
            case 14029: {
                this.onCameraExposureAreaChanged(evt, handler);
                break;
            }
            case 14013: {
                this.onVideoSizeChanged(evt, handler);
                break;
            }
            case 14040: {
                this.onRemoteAudioStateChanged(evt, handler);
                break;
            }
            case 14036: {
                this.onRemoteVideoStateChangedExt(evt, handler);
                break;
            }
            case 14003: {
                this.onLocalVideoStat(evt, handler);
                break;
            }
            case 14004: {
                this.onRemoteVideoStat(evt, handler);
                break;
            }
            case 14041: {
                this.onLocalAudioStat(evt, handler);
                break;
            }
            case 14030: {
                this.onRemoteAudioStat(evt, handler);
                break;
            }
            case 14008: {
                handler.onConnectionLost();
                break;
            }
            case 14010: {
                handler.onConnectionInterrupted();
                break;
            }
            case 14028: {
                RtcEngineMessage.PConnectionState cs = new RtcEngineMessage.PConnectionState();
                cs.unmarshall(evt);
                handler.onConnectionStateChanged(cs.state, cs.reason);
                break;
            }
            case 14009: {
                this.onStreamMessage(evt, handler);
                break;
            }
            case 14012: {
                this.onStreamMessageError(evt, handler);
                break;
            }
            case 14022: {
                RtcEngineMessage.PLocalFallbackStatus lfs = new RtcEngineMessage.PLocalFallbackStatus();
                lfs.unmarshall(evt);
                handler.onLocalPublishFallbackToAudioOnly(lfs.state);
                break;
            }
            case 14023: {
                RtcEngineMessage.PMediaResUserState erfsc = new RtcEngineMessage.PMediaResUserState();
                erfsc.unmarshall(evt);
                handler.onRemoteSubscribeFallbackToAudioOnly(erfsc.uid, erfsc.state);
                break;
            }
            case 14011: {
                break;
            }
            case 13018: {
                RtcEngineMessage.PMediaResAudioEffectFinished aef = new RtcEngineMessage.PMediaResAudioEffectFinished();
                aef.unmarshall(evt);
                handler.onAudioEffectFinished(aef.soundId);
                break;
            }
            case 14037: {
                this.onChannelMediaRelayStateChanged(evt, handler);
                break;
            }
            case 14038: {
                this.onChannelMediaRelayEvent(evt, handler);
                break;
            }
            case 1118: {
                RtcEngineMessage.PMediaResLocalVideoStateChanged lvsc = new RtcEngineMessage.PMediaResLocalVideoStateChanged();
                lvsc.unmarshall(evt);
                handler.onLocalVideoStateChanged(lvsc.localVideoState, lvsc.error);
                break;
            }
            case 14042: {
                RtcEngineMessage.PMediaResLocalAudioStateChanged lasc = new RtcEngineMessage.PMediaResLocalAudioStateChanged();
                lasc.unmarshall(evt);
                handler.onLocalAudioStateChanged(lasc.state, lasc.error);
                break;
            }
            case 14033: {
                RtcEngineMessage.PMediaResFirstRemoteAudioDecoded frad = new RtcEngineMessage.PMediaResFirstRemoteAudioDecoded();
                frad.unmarshall(evt);
                handler.onFirstRemoteAudioDecoded(frad.uid, frad.elapsed);
                break;
            }
            case 14032: {
                RtcEngineMessage.PAudioRoutingChanged arc = new RtcEngineMessage.PAudioRoutingChanged();
                arc.unmarshall(evt);
                handler.onAudioRouteChanged(arc.routing);
                break;
            }
            case 14024: {
                RtcEngineMessage.PUserTransportStat ts = new RtcEngineMessage.PUserTransportStat();
                ts.unmarshall(evt);
                if (ts.isAudio) {
                    handler.onRemoteAudioTransportStats(ts.peer_uid, ts.delay, ts.lost, ts.rxKBitRate);
                    break;
                }
                handler.onRemoteVideoTransportStats(ts.peer_uid, ts.delay, ts.lost, ts.rxKBitRate);
                break;
            }
            case 14031: {
                RtcEngineMessage.PNetworkTypeChanged ntc = new RtcEngineMessage.PNetworkTypeChanged();
                ntc.unmarshall(evt);
                handler.onNetworkTypeChanged(ntc.type);
                break;
            }
            case 14034: {
                RtcEngineMessage.PUserAccountInfo uai = new RtcEngineMessage.PUserAccountInfo();
                uai.unmarshall(evt);
                handler.onLocalUserRegistered(uai.uid, uai.userAccount);
                break;
            }
            case 14035: {
                RtcEngineMessage.PUserAccountInfo uiu = new RtcEngineMessage.PUserAccountInfo();
                uiu.unmarshall(evt);
                UserInfo ui = new UserInfo();
                ui.uid = uiu.uid;
                ui.userAccount = uiu.userAccount;
                handler.onUserInfoUpdated(uiu.uid, ui);
                break;
            }
        }
    }

    private void onApiCallExecuted(byte[] evt, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PApiCallExecuted r = new RtcEngineMessage.PApiCallExecuted();
        r.unmarshall(evt);
        handler.onApiCallExecuted(r.error, r.api, r.result);
    }

    private void onFirstRemoteVideoDecoded(byte[] evt, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PFirstRemoteVideoDecoded v = new RtcEngineMessage.PFirstRemoteVideoDecoded();
        v.unmarshall(evt);
        handler.onFirstRemoteVideoDecoded(v.uid, v.width, v.height, v.elapsed);
    }

    private void onCameraFocusAreaChanged(byte[] evt, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PCameraFocusAreaChanged v = new RtcEngineMessage.PCameraFocusAreaChanged();
        v.unmarshall(evt);
        handler.onCameraFocusAreaChanged(new Rect(v.x, v.y, v.x + v.width, v.y + v.height));
    }

    private void onCameraExposureAreaChanged(byte[] evt, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PCameraExposureAreaChanged v = new RtcEngineMessage.PCameraExposureAreaChanged();
        v.unmarshall(evt);
        handler.onCameraExposureAreaChanged(new Rect(v.x, v.y, v.x + v.width, v.y + v.height));
    }

    private void onVideoSizeChanged(byte[] evt, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PVideoSizeChanged v = new RtcEngineMessage.PVideoSizeChanged();
        v.unmarshall(evt);
        handler.onVideoSizeChanged(v.uid, v.width, v.height, v.rotation);
    }

    private void onRemoteAudioStateChanged(byte[] evt, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PRemoteAudioState m = new RtcEngineMessage.PRemoteAudioState();
        m.unmarshall(evt);
        handler.onRemoteAudioStateChanged(m.uid, m.state, m.reason, m.elapsed);
    }

    private void onRemoteVideoStateChangedExt(byte[] evt, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PRemoteVideoStateExt m = new RtcEngineMessage.PRemoteVideoStateExt();
        m.unmarshall(evt);
        handler.onRemoteVideoStateChanged(m.uid, m.state, m.reason, m.elapsed);
    }

    private void onStreamMessage(byte[] evt, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PStreamMessage v = new RtcEngineMessage.PStreamMessage();
        v.unmarshall(evt);
        handler.onStreamMessage(v.uid, v.streamId, v.payload);
    }

    private void onStreamMessageError(byte[] evt, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PStreamMessageError v = new RtcEngineMessage.PStreamMessageError();
        v.unmarshall(evt);
        handler.onStreamMessageError(v.uid, v.streamId, v.error, v.missed, v.cached);
    }

    private void onFirstLocalVideoFrame(byte[] evt, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PFirstLocalVideoFrame v = new RtcEngineMessage.PFirstLocalVideoFrame();
        v.unmarshall(evt);
        handler.onFirstLocalVideoFrame(v.width, v.height, v.elapsed);
    }

    private void onRemoteVideoStat(byte[] data, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PRemoteVideoStat v = new RtcEngineMessage.PRemoteVideoStat();
        v.unmarshall(data);
        if (v.stats.uid == 0) {
            return;
        }
        handler.onRemoteVideoStats(v.stats);
    }

    private void onRemoteAudioStat(byte[] data, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PRemoteAudioStat v = new RtcEngineMessage.PRemoteAudioStat();
        v.unmarshall(data);
        if (v.stats.uid == 0) {
            return;
        }
        handler.onRemoteAudioStats(v.stats);
    }

    private void onLocalAudioStat(byte[] data, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PLocalAudioStat v = new RtcEngineMessage.PLocalAudioStat();
        v.unmarshall(data);
        handler.onLocalAudioStats(v.stats);
    }

    private void onLocalVideoStat(byte[] data, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PLocalVideoStat v = new RtcEngineMessage.PLocalVideoStat();
        v.unmarshall(data);
        handler.onLocalVideoStats(v.stats);
    }

    private void onFirstRemoteVideoFrame(byte[] data, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PFirstRemoteVideoFrame v = new RtcEngineMessage.PFirstRemoteVideoFrame();
        v.unmarshall(data);
        handler.onFirstRemoteVideoFrame(v.uid, v.width, v.height, v.elapsed);
    }

    private void onFirstLocalAudioFrame(byte[] data, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PFirstLocalAudioFrame v = new RtcEngineMessage.PFirstLocalAudioFrame();
        v.unmarshall(data);
        handler.onFirstLocalAudioFrame(v.elapsed);
    }

    private void onFirstRemoteAudioFrame(byte[] data, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PFirstRemoteAudioFrame v = new RtcEngineMessage.PFirstRemoteAudioFrame();
        v.unmarshall(data);
        handler.onFirstRemoteAudioFrame(v.uid, v.elapsed);
    }

    private void onChannelMediaRelayStateChanged(byte[] data, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PCrossChannelState c = new RtcEngineMessage.PCrossChannelState();
        c.unmarshall(data);
        handler.onChannelMediaRelayStateChanged(c.state, c.code);
    }

    private void onChannelMediaRelayEvent(byte[] data, IRtcEngineEventHandler handler) {
        RtcEngineMessage.PCrossChannelEvent c = new RtcEngineMessage.PCrossChannelEvent();
        c.unmarshall(data);
        handler.onChannelMediaRelayEvent(c.code);
    }

    private void onSpeakersReport(byte[] evt, IRtcEngineEventHandler handler) {
        if (evt == null) {
            return;
        }
        RtcEngineMessage.PMediaResSpeakersReport report = new RtcEngineMessage.PMediaResSpeakersReport();
        report.unmarshall(evt);
        if (report.speakers != null && report.speakers.length >= 0) {
            IRtcEngineEventHandler.AudioVolumeInfo[] speakers = new IRtcEngineEventHandler.AudioVolumeInfo[report.speakers.length];
            for (int i = 0; i < report.speakers.length; ++i) {
                speakers[i] = new IRtcEngineEventHandler.AudioVolumeInfo();
                speakers[i].uid = report.speakers[i].uid;
                speakers[i].volume = report.speakers[i].volume;
                speakers[i].vad = report.speakers[i].vad;
            }
            handler.onAudioVolumeIndication(speakers, report.mixVolume);
        } else {
            handler.onAudioVolumeIndication(new IRtcEngineEventHandler.AudioVolumeInfo[0], 0);
        }
    }

    private void sendLogEvent(byte[] evt) {
        try {
            String msg = new String(evt, "ISO-8859-1");
            this.onLogEvent(0, msg);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected AudioManager getAudioManager(Context context) {
        if (context == null) {
            return null;
        }
        AudioManager audioMgr = (AudioManager)context.getSystemService("audio");
        return audioMgr;
    }

    protected ActivityManager getActivityManager(Context context) {
        if (context == null) {
            return null;
        }
        ActivityManager mgr = (ActivityManager)context.getSystemService("activity");
        return mgr;
    }

    private RtcEngineMessage.PVideoNetOptions getOptionsByVideoProfile(int profile) {
        try {
            byte[] data = RtcEngineImpl.nativeGetOptionsByVideoProfile(this.mNativeHandle, profile);
            if (data != null) {
                RtcEngineMessage.PVideoNetOptions options = new RtcEngineMessage.PVideoNetOptions();
                options.unmarshall(data);
                return options;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int createDataStream(boolean reliable, boolean ordered) {
        return this.nativeCreateDataStream(this.mNativeHandle, reliable, ordered);
    }

    @Override
    public int sendStreamMessage(int streamId, byte[] message) {
        return this.nativeSendStreamMessage(this.mNativeHandle, streamId, message);
    }

    @Override
    public int updateSharedContext(javax.microedition.khronos.egl.EGLContext sharedContext) {
        return this.nativeSetEGL10Context(this.mNativeHandle, sharedContext);
    }

    @Override
    public int updateSharedContext(EGLContext sharedContext) {
        return this.nativeSetEGL14Context(this.mNativeHandle, sharedContext);
    }

    @Override
    public int setTextureId(int id, javax.microedition.khronos.egl.EGLContext sharedContext, int width, int height, long ts) {
        return this.nativeSetEGL10TextureId(this.mNativeHandle, id, sharedContext, 10, width, height, ts, sMatrix);
    }

    @Override
    public int setTextureId(int id, EGLContext sharedContext, int width, int height, long ts) {
        return this.nativeSetEGL14TextureId(this.mNativeHandle, id, sharedContext, 11, width, height, ts, sMatrix);
    }

    public int setTextureIdWithMatrix(int id, javax.microedition.khronos.egl.EGLContext sharedContext, int format, int width, int height, long ts, float[] matrix) {
        if (matrix == null) {
            return this.nativeSetEGL10TextureId(this.mNativeHandle, id, sharedContext, format, width, height, ts, sMatrix);
        }
        if (matrix.length < 16) {
            return -2;
        }
        return this.nativeSetEGL10TextureId(this.mNativeHandle, id, sharedContext, format, width, height, ts, matrix);
    }

    public int setTextureIdWithMatrix(int id, EGLContext sharedContext, int format, int width, int height, long ts, float[] matrix) {
        if (matrix == null) {
            return this.nativeSetEGL14TextureId(this.mNativeHandle, id, sharedContext, format, width, height, ts, sMatrix);
        }
        if (matrix.length < 16) {
            return -2;
        }
        return this.nativeSetEGL14TextureId(this.mNativeHandle, id, sharedContext, format, width, height, ts, matrix);
    }

    @Override
    public boolean isTextureEncodeSupported() {
        boolean support = DeviceUtils.getRecommendedEncoderType() == 0;
        return support;
    }

    @Override
    public void setExternalVideoSource(boolean enable, boolean useTexture, boolean pushMode) {
        this.mVideoSourceType = enable ? 3 : 1;
        if (useTexture) {
            if (enable) {
                this.setParameter("che.video.enable_external_texture_input", true);
            } else {
                this.setParameter("che.video.enable_external_texture_input", false);
                Logging.w("setExternalVideoSource: on Android, texture mode cannot be disabled once enabled.");
            }
        }
        this.setExtVideoSource(this.mNativeHandle, enable ? 1 : 0, pushMode ? 1 : 0);
    }

    @Override
    public boolean pushExternalVideoFrame(AgoraVideoFrame frame) {
        if (frame == null || frame.format == 12) {
            Logging.e("pushExternalVideoFrame failed!! invalid video frame.");
            return false;
        }
        if (this.mVideoSourceType != 3) {
            Logging.e("pushExternalVideoFrame failed!! Call setExternalVideoSource to enable enable external video source!!");
            return false;
        }
        if (frame.format == 10 || frame.format == 11) {
            if (frame.eglContext14 != null) {
                if (this.updateSharedContext(frame.eglContext14) == 0) {
                    return this.setTextureIdWithMatrix(frame.textureID, frame.eglContext14, frame.format, frame.stride, frame.height, frame.timeStamp, frame.transform) == 0;
                }
            } else if (frame.eglContext11 != null && this.updateSharedContext(frame.eglContext11) == 0) {
                return this.setTextureIdWithMatrix(frame.textureID, frame.eglContext11, frame.format, frame.stride, frame.height, frame.timeStamp, frame.transform) == 0;
            }
        } else if (frame.format > 0 && frame.format <= 8) {
            return this.deliverFrame(this.mNativeHandle, frame.buf, frame.stride, frame.height, frame.cropLeft, frame.cropTop, frame.cropRight, frame.cropBottom, frame.rotation, frame.timeStamp, frame.format) == 0;
        }
        return false;
    }

    @Override
    public int addPublishStreamUrl(String url, boolean transcodingEnabled) {
        return this.nativeAddPublishStreamUrl(this.mNativeHandle, url, transcodingEnabled);
    }

    @Override
    public int removePublishStreamUrl(String url) {
        return this.nativeRemovePublishStreamUrl(this.mNativeHandle, url);
    }

    @Override
    public int setLiveTranscoding(LiveTranscoding transcoding) {
        if (transcoding == null) {
            return -2;
        }
        if (transcoding.getUsers() != null) {
            for (LiveTranscoding.TranscodingUser user : transcoding.getUsers()) {
                if (user.width > 0 && user.height > 0) continue;
                throw new IllegalArgumentException("transcoding user's width and height must be >0");
            }
        }
        RtcEngineMessage.PLiveTranscoding pt = new RtcEngineMessage.PLiveTranscoding();
        byte[] data = pt.marshall(transcoding);
        return this.nativeSetLiveTranscoding(this.mNativeHandle, data);
    }

    @Override
    public int addInjectStreamUrl(String url, LiveInjectStreamConfig config) {
        if (url == null || config == null) {
            return -2;
        }
        RtcEngineMessage.PInjectStreamConfig pi = new RtcEngineMessage.PInjectStreamConfig();
        byte[] data = pi.marshall(config);
        return this.nativeAddInjectStreamUrl(this.mNativeHandle, url, data);
    }

    @Override
    public int removeInjectStreamUrl(String url) {
        if (url == null) {
            return -2;
        }
        return this.nativeRemoveInjectStreamUrl(this.mNativeHandle, url);
    }

    @Override
    public int startChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (channelMediaRelayConfiguration == null || channelMediaRelayConfiguration.getDestChannelMediaInfos().size() == 0 || channelMediaRelayConfiguration.getSrcChannelMediaInfo() == null || channelMediaRelayConfiguration.getDestChannelMediaInfos().size() > 4) {
            return -2;
        }
        for (Map.Entry<String, ChannelMediaInfo> entry : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
            if (entry.getValue().channelName != null && entry.getValue().channelName.length() != 0) continue;
            return -2;
        }
        RtcEngineMessage.PChannelMediaRelayConfiguration pt = new RtcEngineMessage.PChannelMediaRelayConfiguration();
        byte[] data = pt.marshall(channelMediaRelayConfiguration);
        return this.nativeStartChannelMediaRelay(this.mNativeHandle, data);
    }

    @Override
    public int stopChannelMediaRelay() {
        return this.nativeStopChannelMediaRelay(this.mNativeHandle);
    }

    @Override
    public int updateChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (channelMediaRelayConfiguration == null || channelMediaRelayConfiguration.getDestChannelMediaInfos().size() == 0 || channelMediaRelayConfiguration.getSrcChannelMediaInfo() == null || channelMediaRelayConfiguration.getDestChannelMediaInfos().size() > 4) {
            return -2;
        }
        for (Map.Entry<String, ChannelMediaInfo> entry : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
            if (entry.getValue().channelName != null && entry.getValue().channelName.length() != 0) continue;
            return -2;
        }
        RtcEngineMessage.PChannelMediaRelayConfiguration pt = new RtcEngineMessage.PChannelMediaRelayConfiguration();
        byte[] data = pt.marshall(channelMediaRelayConfiguration);
        return this.nativeUpdateChannelMediaRelay(this.mNativeHandle, data);
    }

    @Override
    public int startDumpVideoReceiveTrack(int uid) {
        return this.nativeStartDumpVideoReceiveTrack(this.mNativeHandle, uid);
    }

    @Override
    public int stopDumpVideoReceiveTrack() {
        return this.nativeStopDumpVideoReceiveTrack(this.mNativeHandle);
    }

    @Override
    public long getNativeHandle() {
        return this.nativeGetHandle(this.mNativeHandle);
    }

    private static String inetAddressToIpAddress(InetAddress address) {
        if (!address.isLoopbackAddress()) {
            if (address instanceof Inet4Address) {
                Inet4Address address4 = (Inet4Address)address;
                return address4.getHostAddress();
            }
            if (address instanceof Inet6Address) {
                // empty if block
            }
        }
        return null;
    }

    protected static String getLocalHost() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                if (intf.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String ip = RtcEngineImpl.inetAddressToIpAddress(addr);
                    if (ip == null || ip.isEmpty()) continue;
                    return ip;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int setVideoSource(IVideoSource videoSource) {
        this.mVideoSourceType = videoSource == null ? 0 : (videoSource instanceof AgoraDefaultSource ? 1 : 2);
        return this.nativeAddVideoCapturer(this.mNativeHandle, videoSource, this.mVideoSourceType);
    }

    @Override
    public int setLocalVideoRenderer(IVideoSink render) {
        int type = render == null ? 0 : (render instanceof AgoraDefaultRender ? 1 : 2);
        return this.nativeAddLocalVideoRender(this.mNativeHandle, render, type);
    }

    @Override
    public int setRemoteVideoRenderer(int uid, IVideoSink render) {
        int type = render == null ? 0 : (render instanceof AgoraDefaultRender ? 1 : 2);
        return this.nativeAddRemoteVideoRender(this.mNativeHandle, uid, render, type);
    }

    public int removeRemoteVideoTrack(int uid) {
        return this.nativeRemoveVideoReceiveTrack(this.mNativeHandle, uid);
    }

    @Override
    public IAudioEffectManager getAudioEffectManager() {
        return this;
    }

    @Override
    public int enableSoundPositionIndication(boolean enabled) {
        return this.setParameter("che.audio.enable_sound_position", enabled);
    }

    @Override
    public int setRemoteVoicePosition(int uid, double pan, double gain) {
        return this.setParameterObject("che.audio.game_place_sound_position", RtcEngineImpl.formatString("{\"uid\":%d,\"pan\":%f,\"gain\":%f}", (long)uid & 0xFFFFFFFFL, pan, gain));
    }

    @Override
    public int setLocalVoicePitch(double pitch) {
        return this.setParameter("che.audio.morph.pitch_shift", (int)(pitch * 100.0));
    }

    @Override
    public int setLocalVoiceEqualization(int bandFrequency, int bandGain) {
        return this.setParameterObject("che.audio.morph.equalization", RtcEngineImpl.formatString("{\"index\":%d,\"gain\":%d}", bandFrequency, bandGain));
    }

    @Override
    public int setLocalVoiceReverb(int reverbKey, int value) {
        return this.setParameterObject("che.audio.morph.reverb", RtcEngineImpl.formatString("{\"key\":%d,\"value\":%d}", reverbKey, value));
    }

    @Override
    public int setLocalVoiceChanger(int voiceChanger) {
        return this.setParameter("che.audio.morph.voice_changer", voiceChanger);
    }

    @Override
    public int setLocalVoiceReverbPreset(int preset) {
        return this.setParameter("che.audio.morph.reverb_preset", preset);
    }

    @Override
    public int setInEarMonitoringVolume(int volume) {
        return this.setParameter("che.audio.headset.monitoring.parameter", volume);
    }

    @Override
    public double getEffectsVolume() {
        double r = this.nativeGetIntParameter(this.mNativeHandle, "che.audio.game_get_effects_volume", null);
        if (r < 0.0) {
            r = 0.0;
        }
        return r;
    }

    @Override
    public int setEffectsVolume(double volume) {
        return this.setParameter("che.audio.game_set_effects_volume", volume);
    }

    @Override
    public int setVolumeOfEffect(int soundId, double volume) {
        return this.setParameterObject("che.audio.game_adjust_effect_volume", RtcEngineImpl.formatString("{\"soundId\":%d,\"gain\":%f}", soundId, volume));
    }

    @Override
    @Deprecated
    public int playEffect(int soundId, String filePath, int loopCount, double pitch, double pan, double gain) {
        return this.playEffect(soundId, filePath, loopCount, pitch, pan, gain, false);
    }

    @Override
    public int playEffect(int soundId, String filePath, int loopCount, double pitch, double pan, double gain, boolean publish) {
        return this.setParameterObject("che.audio.game_play_effect", RtcEngineImpl.formatString("{\"soundId\":%d,\"filePath\":\"%s\",\"loopCount\":%d, \"pitch\":%f,\"pan\":%f,\"gain\":%f, \"send2far\":%d}", soundId, filePath, loopCount, pitch, pan, gain, publish ? 1 : 0));
    }

    @Override
    public int stopEffect(int soundId) {
        return this.setParameter("che.audio.game_stop_effect", soundId);
    }

    @Override
    public int stopAllEffects() {
        return this.setParameter("che.audio.game_stop_all_effects", true);
    }

    @Override
    public int preloadEffect(int soundId, String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return -2;
        }
        return this.setParameterObject("che.audio.game_preload_effect", RtcEngineImpl.formatString("{\"soundId\":%d,\"filePath\":\"%s\"}", soundId, filePath));
    }

    @Override
    public int unloadEffect(int soundId) {
        return this.setParameter("che.audio.game_unload_effect", soundId);
    }

    @Override
    public int pauseEffect(int soundId) {
        return this.setParameter("che.audio.game_pause_effect", soundId);
    }

    @Override
    public int pauseAllEffects() {
        return this.setParameter("che.audio.game_pause_all_effects", true);
    }

    @Override
    public int resumeEffect(int soundId) {
        return this.setParameter("che.audio.game_resume_effect", soundId);
    }

    @Override
    public int resumeAllEffects() {
        return this.setParameter("che.audio.game_resume_all_effects", true);
    }

    @Override
    public int setApiCallMode(int syncCallTimeout) {
        return this.nativeSetApiCallMode(this.mNativeHandle, syncCallTimeout);
    }

    @Override
    public int getConnectionState() {
        return this.nativeGetConncetionState(this.mNativeHandle);
    }

    public void finalize() {
        if (this.mNativeHandle != 0L) {
            this.nativeDestroy(this.mNativeHandle);
        }
    }

    @Override
    public int registerMediaMetadataObserver(IMetadataObserver observer, int type) {
        return this.nativeRegisterMediaMetadataObserver(this.mNativeHandle, observer, type);
    }

    private int setParameter(String key, boolean value) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%b}", key, value));
    }

    private int setParameter(String key, int value) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%d}", key, value));
    }

    private int setParameter(String key, long value) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%d}", key, value));
    }

    private int setParameter(String key, double value) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%f}", key, value));
    }

    private int setParameter(String key, String value) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":\"%s\"}", key, value));
    }

    private int setParameterObject(String key, String value) {
        return this.setParameters(RtcEngineImpl.formatString("{\"%s\":%s}", key, value));
    }

    private synchronized boolean checkStatus() {
        if (this.mNativeHandle == 0L) {
            throw new IllegalStateException("RtcEngine does not initialize or it may be destroyed");
        }
        return true;
    }

    private static native int nativeClassInit();

    private native long nativeObjectInit(Object var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8);

    private native int nativeDestroy(long var1);

    private native int nativeSetProfile(long var1, String var3, boolean var4);

    private native int nativeSetEncryptionSecret(long var1, String var3);

    private native int nativeSetAppType(long var1, int var3);

    private native String nativeGetProfile(long var1);

    private native int nativeSetParameters(long var1, String var3);

    private native String nativeGetParameters(long var1, String var3);

    private native String nativeGetParameter(long var1, String var3, String var4);

    private native int nativeGetIntParameter(long var1, String var3, String var4);

    private native int nativeJoinChannel(long var1, byte[] var3, String var4, String var5, String var6, int var7);

    private native int nativeSwitchChannel(long var1, String var3, String var4);

    private native int nativeLeaveChannel(long var1);

    private native int nativeRegisterLocalUserAccount(long var1, String var3, String var4);

    private native int nativeJoinChannelWithUserAccount(long var1, String var3, String var4, String var5);

    private native int nativeGetUserInfoByUserAccount(long var1, String var3, Object var4);

    private native int nativeGetUserInfoByUid(long var1, int var3, Object var4);

    private native int nativeStartEchoTest(long var1, byte[] var3);

    private native int nativeStartEchoTestWithInterval(long var1, byte[] var3, int var4);

    private native int nativeStopEchoTest(long var1);

    private native int nativeSwitchCamera(long var1);

    private native int nativeSwitchCameraByDirection(long var1, int var3);

    private native int nativeStartPreview(long var1);

    private native int nativeStartLastmileProbeTest(long var1, byte[] var3, boolean var4, boolean var5, int var6, int var7);

    private native int nativeStopLastmileProbeTest(long var1);

    private native int nativeCreateDataStream(long var1, boolean var3, boolean var4);

    private native int nativeSendStreamMessage(long var1, int var3, byte[] var4);

    private native int nativeAddPublishStreamUrl(long var1, String var3, boolean var4);

    private native int nativeRemovePublishStreamUrl(long var1, String var3);

    private native int nativeSetLiveTranscoding(long var1, byte[] var3);

    private native int nativeAddInjectStreamUrl(long var1, String var3, byte[] var4);

    private native int nativeRemoveInjectStreamUrl(long var1, String var3);

    private native int nativeRenewChannelKey(long var1, String var3);

    private native int nativeRenewToken(long var1, String var3);

    static native int nativeLog(int var0, String var1);

    private native int nativeSetupVideoRemote(long var1, SurfaceView var3, int var4, int var5);

    private native int nativeSetupVideoLocal(long var1, SurfaceView var3, int var4);

    private native int nativeSetEGL10Context(long var1, javax.microedition.khronos.egl.EGLContext var3);

    private native int nativeSetEGL14Context(long var1, EGLContext var3);

    private native int nativeSetEGL10TextureId(long var1, int var3, javax.microedition.khronos.egl.EGLContext var4, int var5, int var6, int var7, long var8, float[] var10);

    private native int nativeSetEGL14TextureId(long var1, int var3, EGLContext var4, int var5, int var6, int var7, long var8, float[] var10);

    private native int nativeSetVideoProfileEx(long var1, int var3, int var4, int var5, int var6);

    private native int nativeSetAudioProfile(long var1, int var3, int var4);

    private native int nativeSetVideoEncoderConfiguration(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private native int nativeAddVideoWatermark(long var1, String var3, boolean var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private native int nativeClearVideoWatermarks(long var1);

    private native int nativeSetBeautyEffectOptions(long var1, boolean var3, int var4, float var5, float var6, float var7);

    private native int nativeSetRemoteUserPriority(long var1, int var3, int var4);

    private native int nativeStartChannelMediaRelay(long var1, byte[] var3);

    private native int nativeStopChannelMediaRelay(long var1);

    private native int nativeUpdateChannelMediaRelay(long var1, byte[] var3);

    private native int nativeStartDumpVideoReceiveTrack(long var1, int var3);

    private native int nativeStopDumpVideoReceiveTrack(long var1);

    private native String nativeMakeQualityReportUrl(long var1, String var3, int var4, int var5, int var6);

    private native String nativeGetCallId(long var1);

    private native int nativeRate(long var1, String var3, int var4, String var5);

    private native int nativeComplain(long var1, String var3, String var4);

    private native int nativeRegisterAudioFrameObserver(long var1, Object var3);

    private native int nativePullAudioFrame(long var1, byte[] var3, int var4);

    private native int nativePushExternalAudioFrameRawData(long var1, byte[] var3, long var4, int var6, int var7);

    private native int nativeSetApiCallMode(long var1, int var3);

    public static native String nativeGetSdkVersion();

    public static native String nativeGetChatEngineVersion();

    public static native String nativeGetErrorDescription(int var0);

    private static native byte[] nativeGetOptionsByVideoProfile(long var0, int var2);

    private native long nativeGetHandle(long var1);

    private native int setExtVideoSource(long var1, int var3, int var4);

    private native int deliverFrame(long var1, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, int var13);

    private native int nativeAddVideoCapturer(long var1, IVideoSource var3, int var4);

    private native int nativeAddLocalVideoRender(long var1, IVideoSink var3, int var4);

    private native int nativeAddRemoteVideoRender(long var1, int var3, IVideoSink var4, int var5);

    private native int nativeRemoveVideoReceiveTrack(long var1, int var3);

    private native int nativeGetConncetionState(long var1);

    private native int nativeRegisterMediaMetadataObserver(long var1, Object var3, int var4);

    private native int nativeEnableVideo(long var1);

    private native int nativeDisableVideo(long var1);

    private native int nativeMuteLocalVideoStream(long var1, boolean var3);

    private native int nativeMuteAllRemoteVideoStreams(long var1, boolean var3);

    private native int nativeSetDefaultAudioRoutetoSpeakerphone(long var1, boolean var3);

    private native int nativeEnableLocalAudio(long var1, boolean var3);

    private native int nativeSetEnableSpeakerphone(long var1, boolean var3);

    private native boolean nativeIsSpeakerphoneEnabled(long var1);

    private native int nativeSetChannelProfile(long var1, int var3);
}

