/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import io.agora.rtc.internal.CommonUtility;
import io.agora.rtc.internal.Logging;
import java.lang.ref.WeakReference;

public class PowerConnectionReceiver
extends BroadcastReceiver {
    private WeakReference<CommonUtility> mCommonUtility;

    public PowerConnectionReceiver(CommonUtility cu) {
        this.mCommonUtility = new WeakReference<CommonUtility>(cu);
    }

    public void onReceive(Context context, Intent intent) {
        CommonUtility cu = (CommonUtility)this.mCommonUtility.get();
        if (cu == null) {
            Logging.w("rtc engine is not ready");
            return;
        }
        if (intent != null) {
            int level = intent.getIntExtra("level", -1);
            int scale = intent.getIntExtra("scale", -1);
            if (scale != 0) {
                float batteryPct = (float)level / (float)scale;
                cu.onPowerChange((int)(batteryPct * 100.0f));
            }
        }
    }
}

