/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import io.agora.rtc.internal.Logging;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceUtils {
    public static final int DEVICE_INFO_UNKNOWN = -1;
    private static final String TAG = "DeviceUtils";
    private static final String[] H264_HW_BLACKLIST = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060"};
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (Character.isDigit(path.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static String getDeviceId() {
        String deviceId = Build.MANUFACTURER + "/" + Build.MODEL + "/" + Build.PRODUCT + "/" + Build.DEVICE + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        if (deviceId != null) {
            deviceId = deviceId.toLowerCase();
        }
        String bid = Build.ID;
        Pattern pattern = Pattern.compile(".*[A-Z][A-M][0-9]$");
        Matcher matcher = pattern.matcher(bid);
        if (Build.BRAND.toLowerCase().equals("samsung") && Build.DEVICE.toLowerCase().startsWith("cs02") && !matcher.find() && Build.VERSION.SDK_INT == 19) {
            deviceId = "yeshen/simulator/" + Build.MODEL + "/" + Build.PRODUCT + "/" + Build.DEVICE + "/" + Build.VERSION.SDK_INT + "/" + System.getProperty("os.version");
        }
        return deviceId;
    }

    public static String getDeviceInfo() {
        String deviceInfo = Build.MANUFACTURER + "/" + Build.MODEL;
        if (deviceInfo != null) {
            deviceInfo = deviceInfo.toLowerCase();
        }
        return deviceInfo;
    }

    public static String getSystemInfo() {
        String systemInfo = "Android/" + Build.VERSION.RELEASE;
        return systemInfo;
    }

    public static int selectFrontCamera() {
        int index = 0;
        try {
            index = Camera.getNumberOfCameras() > 1 ? 1 : 0;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
        }
        return index;
    }

    public static int getNumberOfCameras() {
        try {
            return Camera.getNumberOfCameras();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
            return 0;
        }
    }

    public static int getRecommendedEncoderType() {
        List<String> exceptionModels = Arrays.asList(H264_HW_BLACKLIST);
        if (exceptionModels.contains(Build.MODEL)) {
            Logging.w(TAG, "Model: " + Build.MODEL + " has black listed H.264 encoder.");
            return 1;
        }
        if (Build.VERSION.SDK_INT <= 18) {
            return 1;
        }
        return 0;
    }

    public static int getNumberOfCPUCores() {
        int cores;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = DeviceUtils.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (cores == -1) {
                cores = DeviceUtils.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (cores == -1) {
                cores = DeviceUtils.getCoresFromCPUFileList();
            }
        }
        catch (SecurityException e) {
            cores = -1;
        }
        catch (NullPointerException e) {
            cores = -1;
        }
        return cores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCpuName() {
        FileReader fr = null;
        try {
            fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            String[] array = text.split(":\\s+", 2);
            for (int i = 0; i < array.length; ++i) {
            }
            if (fr != null) {
                fr.close();
            }
            String string = array[1];
            return string;
        }
        catch (FileNotFoundException e) {
            Logging.e(TAG, "getCpuName failed, no /proc/cpuinfo found in system", e);
        }
        catch (IOException e) {
            Logging.e(TAG, "getCpuName failed,", e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    Logging.e(TAG, "failed to close proc file", e);
                }
            }
        }
        return null;
    }

    public static String getCpuABI() {
        return Build.CPU_ABI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String fileLocation) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileLocation);
            BufferedReader buf = new BufferedReader(new InputStreamReader(is));
            String fileContents = buf.readLine();
            if (is != null) {
                ((InputStream)is).close();
            }
            int n = DeviceUtils.getCoresFromFileString(fileContents);
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    Logging.e(TAG, "close file stream", e);
                }
            }
        }
    }

    private static int getCoresFromFileString(String str) {
        if (str == null || !str.matches("0-[\\d]+$")) {
            return -1;
        }
        int cores = Integer.valueOf(str.substring(2)) + 1;
        return cores;
    }

    private static int getCoresFromCPUFileList() {
        return new File("/sys/devices/system/cpu").listFiles(CPU_FILTER).length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCPUMaxFreqKHz() {
        int maxFreq;
        block15: {
            maxFreq = -1;
            try {
                for (int i = 0; i < DeviceUtils.getNumberOfCPUCores(); ++i) {
                    String filename = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
                    File cpuInfoMaxFreqFile = new File(filename);
                    if (!cpuInfoMaxFreqFile.exists()) continue;
                    byte[] buffer = new byte[128];
                    try (FileInputStream stream = new FileInputStream(cpuInfoMaxFreqFile);){
                        int endIndex;
                        stream.read(buffer);
                        for (endIndex = 0; Character.isDigit(buffer[endIndex]) && endIndex < buffer.length; ++endIndex) {
                        }
                        String str = new String(buffer, 0, endIndex);
                        Integer freqBound = Integer.parseInt(str);
                        if (freqBound <= maxFreq) continue;
                        maxFreq = freqBound;
                        continue;
                    }
                }
                if (maxFreq != -1) break block15;
                try (FileInputStream stream = new FileInputStream("/proc/cpuinfo");){
                    int freqBound = DeviceUtils.parseFileForValue("cpu MHz", stream);
                    if ((freqBound *= 1000) > maxFreq) {
                        maxFreq = freqBound;
                    }
                }
            }
            catch (IOException e) {
                maxFreq = -1;
            }
        }
        return maxFreq;
    }

    private static int parseFileForValue(String textToMatch, FileInputStream stream) {
        byte[] buffer = new byte[1024];
        try {
            int length = stream.read(buffer);
            for (int i = 0; i < length; ++i) {
                int textIndex;
                if (buffer[i] != 10 && i != 0) continue;
                if (buffer[i] == 10) {
                    // empty if block
                }
                for (int j = ++i; j < length && buffer[j] == textToMatch.charAt(textIndex = j - i); ++j) {
                    if (textIndex != textToMatch.length() - 1) continue;
                    return DeviceUtils.extractValue(buffer, j);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static int extractValue(byte[] buffer, int index) {
        while (index < buffer.length && buffer[index] != 10) {
            if (Character.isDigit(buffer[index])) {
                int start = index++;
                while (index < buffer.length && Character.isDigit(buffer[index])) {
                    ++index;
                }
                String str = new String(buffer, 0, start, index - start);
                return Integer.parseInt(str);
            }
            ++index;
        }
        return -1;
    }
}

