/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import io.agora.rtc.internal.ConnectionChangeBroadcastReceiver;
import io.agora.rtc.internal.Connectivity;
import io.agora.rtc.internal.DeviceUtils;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.internal.PowerConnectionReceiver;
import io.agora.rtc.internal.RtcEngineMessage;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;

class CommonUtility {
    private static final String TAG = CommonUtility.class.getSimpleName();
    private WeakReference<Context> mContext;
    private static WeakReference<Application> mApplication;
    private AgoraPhoneStateListener mPhoneStateListener = null;
    private ConnectionChangeBroadcastReceiver mConnectionBroadcastReceiver = null;
    private BroadcastReceiver mOrientationObserver = null;
    private PowerConnectionReceiver mPowerConnectionReceiver = null;
    private long mBridgeHandle = 0L;
    private int mMobileType = -1;
    private int batteryPercentage = 255;

    public CommonUtility(Context context, long bridge) {
        this.mContext = new WeakReference<Context>(context);
        this.mBridgeHandle = bridge;
        try {
            this.mPhoneStateListener = new AgoraPhoneStateListener();
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            telephonyManager.listen((PhoneStateListener)this.mPhoneStateListener, 288);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create PhoneStateListener, ", e);
        }
        this.monitorConnectionEvent(true);
        this.monitorPowerChange(true);
    }

    public void destroy() {
        Context context = (Context)this.mContext.get();
        if (this.mPhoneStateListener != null && context != null) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            telephonyManager.listen((PhoneStateListener)this.mPhoneStateListener, 0);
            this.mPhoneStateListener = null;
        }
        this.monitorConnectionEvent(false);
        this.monitorPowerChange(false);
    }

    public int getNetworkType() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return -1;
        }
        if (CommonUtility.checkAccessNetworkState(context)) {
            return Connectivity.getNetworkType(context);
        }
        return -1;
    }

    public byte[] getNetworkInfo() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return null;
        }
        RtcEngineMessage.MediaNetworkInfo ni = this.doGetNetworkInfo(context);
        if (ni != null) {
            return ni.marshall();
        }
        return null;
    }

    public int getBatteryLifePercent() {
        Context context = (Context)this.mContext.get();
        if (context != null) {
            return this.batteryPercentage;
        }
        return 255;
    }

    public void onPhoneStateChanged(boolean enableAudio, int event, int arg) {
        if (this.mBridgeHandle == 0L) {
            return;
        }
        this.nativeAudioRoutingPhoneChanged(this.mBridgeHandle, enableAudio, event, arg);
    }

    public void monitorConnectionEvent(boolean monitor) {
        if (monitor) {
            if (this.mConnectionBroadcastReceiver == null) {
                try {
                    this.mConnectionBroadcastReceiver = new ConnectionChangeBroadcastReceiver(this);
                    Context context = (Context)this.mContext.get();
                    if (context != null && this.mConnectionBroadcastReceiver != null) {
                        context.registerReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                    }
                }
                catch (Exception e) {
                    Logging.e(TAG, "Unable to create ConnectionChangeBroadcastReceiver, ", e);
                }
            }
        } else {
            try {
                Context context = (Context)this.mContext.get();
                if (context != null && this.mConnectionBroadcastReceiver != null) {
                    context.unregisterReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mConnectionBroadcastReceiver = null;
        }
    }

    public void monitorPowerChange(boolean monitor) {
        if (monitor) {
            if (this.mPowerConnectionReceiver == null) {
                try {
                    this.mPowerConnectionReceiver = new PowerConnectionReceiver(this);
                    Context context = (Context)this.mContext.get();
                    if (context != null && this.mPowerConnectionReceiver != null) {
                        IntentFilter iFilter = new IntentFilter();
                        iFilter.addAction("android.intent.action.BATTERY_CHANGED");
                        context.registerReceiver((BroadcastReceiver)this.mPowerConnectionReceiver, iFilter);
                    }
                }
                catch (Exception e) {
                    Logging.e(TAG, "Unable to create PowerConnectionReceiver, ", e);
                }
            }
        } else {
            try {
                Context context = (Context)this.mContext.get();
                if (context != null && this.mPowerConnectionReceiver != null) {
                    context.unregisterReceiver((BroadcastReceiver)this.mPowerConnectionReceiver);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mPowerConnectionReceiver = null;
        }
    }

    public void notifyNetworkChange() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        this.nativeNotifyNetworkChange(this.mBridgeHandle, this.getNetworkInfo());
    }

    public void onPowerChange(int batteryPct) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        this.batteryPercentage = batteryPct;
    }

    public int getFrontCameraIndex() {
        return DeviceUtils.selectFrontCamera();
    }

    public int getNumberOfCameras() {
        return DeviceUtils.getNumberOfCameras();
    }

    public int isSimulator() {
        int suspectCount = 0;
        String cpuinfo = "";
        String serial = "";
        String manufacturer = "";
        try {
            if (Build.VERSION.SDK_INT < 26) {
                serial = Build.SERIAL;
            } else if (Build.VERSION.SDK_INT <= 28) {
                serial = Build.getSerial();
            }
            if (serial.toLowerCase().equals("unknown")) {
                Logging.i(TAG, "serial = " + serial + ", suspectCount = " + ++suspectCount);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "get serial info fail.");
        }
        try {
            manufacturer = Build.MANUFACTURER;
            if (manufacturer.toLowerCase().contains("netease")) {
                ++suspectCount;
            }
            Logging.i(TAG, "manufacturer = " + manufacturer);
        }
        catch (Exception e) {
            Logging.e(TAG, "get manufacturer info fail.");
        }
        if (this.isSimulatorProperty()) {
            ++suspectCount;
        }
        if (Build.VERSION.SDK_INT > 28) {
            if ("nokia".equalsIgnoreCase(manufacturer) && ("Nokia_N1".equalsIgnoreCase(Build.DEVICE) || "N1".equalsIgnoreCase(Build.MODEL))) {
                return 0;
            }
            if (suspectCount > 0 && !manufacturer.toLowerCase().contains("welldo")) {
                return 1;
            }
        } else if ((serial.toLowerCase().equals("unknown") || suspectCount > 0) && !manufacturer.toLowerCase().contains("welldo")) {
            return 1;
        }
        return 0;
    }

    public int getAndroidVersion() {
        return Build.VERSION.SDK_INT;
    }

    public int isSpeakerphoneEnabled(Context context) {
        if (context == null) {
            return 0;
        }
        AudioManager audioManager = this.getAudioManager(context);
        return audioManager.isSpeakerphoneOn() ? 1 : 0;
    }

    public static boolean canGetDefaultContext() {
        boolean r = false;
        if (Looper.myLooper() == Looper.getMainLooper() || Build.VERSION.SDK_INT >= 18) {
            r = true;
        }
        return r;
    }

    public static byte[] getContextInfo(Context context) {
        if (context == null) {
            return null;
        }
        RtcEngineMessage.PAndroidContextInfo info = new RtcEngineMessage.PAndroidContextInfo();
        info.device = DeviceUtils.getDeviceId();
        info.deviceInfo = DeviceUtils.getDeviceInfo();
        info.systemInfo = DeviceUtils.getSystemInfo();
        info.configDir = CommonUtility.getAppStorageDir(context);
        info.dataDir = context.getCacheDir().getAbsolutePath();
        info.pluginDir = context.getApplicationInfo().nativeLibraryDir;
        info.imei = CommonUtility.getImei(context);
        info.macAddress = CommonUtility.getWiFiMac(context);
        info.androidID = CommonUtility.getAndroidID(context);
        if (TextUtils.isEmpty((CharSequence)info.device)) {
            info.device = "";
        }
        if (TextUtils.isEmpty((CharSequence)info.deviceInfo)) {
            info.deviceInfo = "";
        }
        if (TextUtils.isEmpty((CharSequence)info.systemInfo)) {
            info.systemInfo = "";
        }
        if (TextUtils.isEmpty((CharSequence)info.configDir)) {
            info.configDir = "";
        }
        if (TextUtils.isEmpty((CharSequence)info.dataDir)) {
            info.dataDir = "";
        }
        if (TextUtils.isEmpty((CharSequence)info.pluginDir)) {
            info.pluginDir = "";
        }
        if (TextUtils.isEmpty((CharSequence)info.imei)) {
            info.imei = "";
        }
        if (TextUtils.isEmpty((CharSequence)info.macAddress)) {
            info.macAddress = "";
        }
        if (TextUtils.isEmpty((CharSequence)info.androidID)) {
            info.androidID = "";
        }
        return info.marshall();
    }

    private static Boolean checkImei(String imei) {
        try {
            Integer LEN = imei.length();
            if (LEN > 10 && LEN < 20 && !CommonUtility.checkImeiSame(imei.trim()).booleanValue()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static Boolean checkImeiSame(String imei) {
        try {
            char firstChar = '0';
            if (imei.length() > 0) {
                firstChar = imei.charAt(0);
            }
            Boolean isSame = true;
            for (int i = 0; i < imei.length(); ++i) {
                char ch = imei.charAt(i);
                if (firstChar == ch) continue;
                isSame = false;
                break;
            }
            return isSame;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static String getImei(Context context) {
        String strImei;
        block8: {
            strImei = null;
            try {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                if (Build.VERSION.SDK_INT >= 22) {
                    strImei = tm.getDeviceId();
                    break block8;
                }
                String tempImei = tm.getDeviceId();
                if (CommonUtility.checkImei(tempImei.trim()).booleanValue()) {
                    strImei = tempImei.trim();
                    break block8;
                }
                try {
                    TelephonyManager telephonyManager1 = (TelephonyManager)context.getSystemService("phone1");
                    String imeiphone1 = telephonyManager1.getDeviceId();
                    if (imeiphone1 != null && CommonUtility.checkImei(imeiphone1).booleanValue()) {
                        strImei = imeiphone1;
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (strImei == null) {
            return "";
        }
        return strImei;
    }

    private static String getWiFiMac(Context context) {
        String INVALID_MAC = "00:00:00:00:00:00";
        Pattern MAC_PATTERN = Pattern.compile("^([0-9A-F]{2}:){5}([0-9A-F]{2})$");
        String mac = null;
        try {
            WifiInfo info;
            WifiManager wifiManager;
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
                    if (all == null || all.size() <= 0) {
                        return "";
                    }
                    for (NetworkInterface nif : all) {
                        if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                        byte[] macBytes = nif.getHardwareAddress();
                        if (macBytes == null) {
                            return "";
                        }
                        StringBuilder res1 = new StringBuilder();
                        for (byte b : macBytes) {
                            res1.append(String.format("%02X:", b));
                        }
                        if (res1.length() > 0) {
                            res1.deleteCharAt(res1.length() - 1);
                        }
                        mac = res1.toString().toUpperCase().trim();
                    }
                }
                catch (Throwable all) {
                    // empty catch block
                }
                return mac != null && !"".equals(mac.trim()) ? mac : "";
            }
            if (context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE") == 0 && (wifiManager = (WifiManager)context.getSystemService("wifi")).isWifiEnabled() && (info = wifiManager.getConnectionInfo()) != null && (mac = info.getMacAddress()) != null && (INVALID_MAC.equals(mac = mac.toUpperCase().trim()) || !MAC_PATTERN.matcher(mac).matches())) {
                mac = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (mac == null) {
            return "";
        }
        return mac;
    }

    private static String getAndroidID(Context context) {
        String strAndroidID = null;
        try {
            strAndroidID = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (strAndroidID == null) {
            return "";
        }
        return strAndroidID;
    }

    public static String[] getLocalHostList() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            ArrayList<String> ips = new ArrayList<String>();
            for (NetworkInterface intf : interfaces) {
                if (intf.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String ip = CommonUtility.inetAddressToIpAddress(addr);
                    if (ip == null) continue;
                    ips.add(ip);
                }
            }
            if (!ips.isEmpty()) {
                String[] addresses = new String[ips.size()];
                int i = 0;
                Iterator iterator = ips.iterator();
                while (iterator.hasNext()) {
                    String ip;
                    addresses[i] = ip = (String)iterator.next();
                    ++i;
                }
                return addresses;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getLocalHost() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                if (intf.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String ip = CommonUtility.inetAddressToIpAddress(addr);
                    if (ip == null || ip.isEmpty()) continue;
                    return ip;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    private boolean isSimulatorProperty() {
        int suspectCount = 0;
        String hardware = "";
        String arch = "";
        String baseBandVersion = "";
        String buildFlavor = "";
        String productBoard = "";
        String boardPlatform = "";
        try {
            hardware = CommonUtility.getSystemProperty("ro.hardware");
            if (null == hardware || hardware.toLowerCase().equals("intel")) {
                ++suspectCount;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "get property hardware fail.");
        }
        Logging.i(TAG, "hardware = " + hardware + ", suspectCount = " + suspectCount);
        try {
            arch = System.getProperty("os.arch");
            if (null == arch || arch.toLowerCase().equals("i686")) {
                Logging.i(TAG, "arch = " + arch + ", suspectCount = " + ++suspectCount);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "get property arch fail.");
        }
        if (Build.VERSION.SDK_INT > 28) {
            if (hardware.toLowerCase().contains("ttvm")) {
                suspectCount += 10;
            } else if (hardware.toLowerCase().contains("nox")) {
                suspectCount += 10;
            }
            try {
                buildFlavor = CommonUtility.getSystemProperty("ro.build.flavor");
                if (null == buildFlavor || buildFlavor.contains("vbox") || buildFlavor.contains("sdk_gphone")) {
                    Logging.i(TAG, "buildFlavor = " + buildFlavor + ", suspectCount = " + ++suspectCount);
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "get property buildFlavor fail.");
            }
            try {
                productBoard = CommonUtility.getSystemProperty("ro.product.board");
                if (null == productBoard || productBoard.contains("android") | productBoard.contains("goldfish")) {
                    Logging.i(TAG, "productBoard = " + productBoard + ", suspectCount = " + ++suspectCount);
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "get property productBoard fail.");
            }
            try {
                boardPlatform = CommonUtility.getSystemProperty("ro.board.platform");
                if (null == boardPlatform || boardPlatform.contains("android")) {
                    Logging.i(TAG, "boardPlatform = " + boardPlatform + ", suspectCount = " + ++suspectCount);
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "get property boardPlatform fail.");
            }
        }
        return suspectCount > 0;
    }

    private void regiseterBroadcaster(Context context) {
        if (context == null) {
            return;
        }
        this.mOrientationObserver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.intent.action.CONFIGURATION_CHANGED")) {
                    Display display = ((WindowManager)((Context)CommonUtility.this.mContext.get()).getSystemService("window")).getDefaultDisplay();
                    int orientation = display.getRotation();
                    switch (orientation) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                }
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        context.registerReceiver(this.mOrientationObserver, intentFilter);
    }

    private void unregisterBroadcaster(Context context) {
        if (context == null || this.mOrientationObserver == null) {
            return;
        }
        context.unregisterReceiver(this.mOrientationObserver);
    }

    private AudioManager getAudioManager(Context context) {
        if (context == null) {
            return null;
        }
        AudioManager audioMgr = (AudioManager)context.getSystemService("audio");
        return audioMgr;
    }

    private static String getSystemProperty(String name) throws Exception {
        Class<?> systemPropertyClazz = Class.forName("android.os.SystemProperties");
        return (String)systemPropertyClazz.getMethod("get", String.class).invoke(systemPropertyClazz, name);
    }

    private static boolean checkAccessNetworkState(Context context) {
        if (context == null) {
            return false;
        }
        int res = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
        return res == 0;
    }

    private RtcEngineMessage.MediaNetworkInfo doGetNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        RtcEngineMessage.MediaNetworkInfo ni = new RtcEngineMessage.MediaNetworkInfo();
        if (!CommonUtility.checkAccessNetworkState(context)) {
            ni.ssid = "";
            ni.bssid = "";
            ni.rssi = 0;
            ni.signalLevel = 0;
            return ni;
        }
        String lh = CommonUtility.getLocalHost();
        if (lh != null) {
            ni.localIp4 = lh;
        }
        NetworkInfo networkInfo = Connectivity.getNetworkInfo(context);
        ni.networkType = Connectivity.getNetworkType(networkInfo);
        if (networkInfo != null) {
            ni.networkSubtype = networkInfo.getSubtype();
        }
        ni.dnsList = Connectivity.getDnsList();
        if (ni.networkType == 2) {
            WifiInfo wifiInfo;
            InetAddress addr;
            if (!CommonUtility.checkAccessWifiState(context)) {
                ni.ssid = "";
                ni.bssid = "";
                ni.rssi = 0;
                ni.signalLevel = 0;
                return ni;
            }
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            DhcpInfo dhcp = wifiManager.getDhcpInfo();
            if (dhcp != null && (addr = CommonUtility.intToInetAddress(dhcp.gateway)) != null) {
                ni.gatewayIp4 = addr.getHostAddress();
            }
            if ((wifiInfo = wifiManager.getConnectionInfo()) != null) {
                String bssid = wifiInfo.getBSSID();
                ni.ssid = wifiInfo.getSSID().replace("\"", "");
                ni.bssid = bssid == null ? "" : bssid.replace("\"", "");
                ni.rssi = wifiInfo.getRssi();
                ni.signalLevel = WifiManager.calculateSignalLevel((int)ni.rssi, (int)5);
                if (Build.VERSION.SDK_INT >= 21) {
                    int freq = wifiInfo.getFrequency();
                    if (freq >= 5000) {
                        ni.networkSubtype = 101;
                    } else if (freq >= 2400) {
                        ni.networkSubtype = 100;
                    }
                }
            }
        } else if (this.mPhoneStateListener != null) {
            ni.rssi = this.mPhoneStateListener.getRssi();
            ni.signalLevel = this.mPhoneStateListener.getLevel();
            ni.asu = this.mPhoneStateListener.getAsuLevel();
        } else if (context.checkCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0) {
            this.getSignalStrength(context, ni);
        }
        return ni;
    }

    private static String inetAddressToIpAddress(InetAddress address) {
        if (!address.isLoopbackAddress()) {
            if (address instanceof Inet4Address) {
                Inet4Address address4 = (Inet4Address)address;
                return address4.getHostAddress();
            }
            if (address instanceof Inet6Address) {
                // empty if block
            }
        }
        return null;
    }

    private static boolean checkAccessWifiState(Context context) {
        if (context == null) {
            return false;
        }
        int res = context.checkCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE");
        return res == 0;
    }

    private static InetAddress intToInetAddress(int hostAddress) {
        byte[] addressBytes = new byte[]{(byte)(0xFF & hostAddress), (byte)(0xFF & hostAddress >> 8), (byte)(0xFF & hostAddress >> 16), (byte)(0xFF & hostAddress >> 24)};
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @TargetApi(value=17)
    private boolean getSignalStrength(Context context, RtcEngineMessage.MediaNetworkInfo ni) {
        CellSignalStrengthGsm cellSignalStrength;
        if (context == null || Build.VERSION.SDK_INT < 17) {
            this.mMobileType = -1;
            return false;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        List cellInfoList = telephonyManager.getAllCellInfo();
        if (cellInfoList == null || cellInfoList.isEmpty()) {
            return false;
        }
        CellInfo cellInfo = (CellInfo)cellInfoList.get(0);
        if (cellInfo == null) {
            return false;
        }
        try {
            if ((this.mMobileType == -1 || this.mMobileType == 0) && (cellSignalStrength = ((CellInfoGsm)cellInfo).getCellSignalStrength()) != null) {
                this.mMobileType = 0;
                ni.rssi = cellSignalStrength.getDbm();
                ni.signalLevel = cellSignalStrength.getLevel();
                ni.asu = cellSignalStrength.getAsuLevel();
                return true;
            }
        }
        catch (Exception e) {
            this.mMobileType = -1;
        }
        try {
            if ((this.mMobileType == -1 || this.mMobileType == 1) && (cellSignalStrength = ((CellInfoCdma)cellInfo).getCellSignalStrength()) != null) {
                this.mMobileType = 1;
                ni.rssi = cellSignalStrength.getDbm();
                ni.signalLevel = cellSignalStrength.getLevel();
                ni.asu = cellSignalStrength.getAsuLevel();
                return true;
            }
        }
        catch (Exception e) {
            this.mMobileType = -1;
        }
        try {
            if (this.mMobileType == -1 || this.mMobileType == 2) {
                if (Build.VERSION.SDK_INT < 18) {
                    return false;
                }
                cellSignalStrength = ((CellInfoWcdma)cellInfo).getCellSignalStrength();
                if (cellSignalStrength != null) {
                    this.mMobileType = 2;
                    ni.rssi = cellSignalStrength.getDbm();
                    ni.signalLevel = cellSignalStrength.getLevel();
                    ni.asu = cellSignalStrength.getAsuLevel();
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.mMobileType = -1;
        }
        try {
            if ((this.mMobileType == -1 || this.mMobileType == 3) && (cellSignalStrength = ((CellInfoLte)cellInfo).getCellSignalStrength()) != null) {
                this.mMobileType = 3;
                ni.rssi = cellSignalStrength.getDbm();
                ni.signalLevel = cellSignalStrength.getLevel();
                ni.asu = cellSignalStrength.getAsuLevel();
                return true;
            }
        }
        catch (Exception e) {
            this.mMobileType = -1;
        }
        return false;
    }

    private static String getAppStorageDir(Context context) {
        if (context != null) {
            int res = context.checkCallingOrSelfPermission("android.permission.READ_EXTERNAL_STORAGE");
            if (res == 0) {
                return "/sdcard/" + context.getApplicationInfo().packageName;
            }
            Logging.w(TAG, "read external storage is not granted");
        }
        return null;
    }

    private native void nativeAudioRoutingPhoneChanged(long var1, boolean var3, int var4, int var5);

    private native int nativeNotifyNetworkChange(long var1, byte[] var3);

    private class AgoraPhoneStateListener
    extends PhoneStateListener {
        private SignalStrength mSignalStrenth;
        private boolean phoneStatusNeedResume = false;

        public int getRssi() {
            int rssi = 0;
            if (Build.VERSION.SDK_INT <= 28) {
                rssi = this.invokeMethod("getDbm");
            }
            return rssi;
        }

        public int getLevel() {
            return this.invokeMethod("getLevel");
        }

        public int getAsuLevel() {
            int asuLevel = 0;
            if (Build.VERSION.SDK_INT <= 28) {
                asuLevel = this.invokeMethod("getAsuLevel");
            }
            return asuLevel;
        }

        private int invokeMethod(String methodName) {
            try {
                Method method;
                if (this.mSignalStrenth != null && (method = this.mSignalStrenth.getClass().getDeclaredMethod(methodName, new Class[0])) != null) {
                    return (Integer)method.invoke((Object)this.mSignalStrenth, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            this.mSignalStrenth = signalStrength;
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            super.onCallStateChanged(state, incomingNumber);
            switch (state) {
                case 0: {
                    if (!this.phoneStatusNeedResume) break;
                    this.phoneStatusNeedResume = false;
                    Logging.i(TAG, "system phone call end delay 1000ms");
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                CommonUtility.this.nativeAudioRoutingPhoneChanged(CommonUtility.this.mBridgeHandle, true, 22, 0);
                            }
                            catch (Exception e) {
                                Logging.e(TAG, "fail to resume ", e);
                            }
                        }
                    }, 1000L);
                    break;
                }
                case 1: {
                    Logging.i(TAG, "system phone call ring");
                    this.phoneStatusNeedResume = true;
                    CommonUtility.this.nativeAudioRoutingPhoneChanged(CommonUtility.this.mBridgeHandle, false, 22, 1);
                    break;
                }
                case 2: {
                    Logging.i(TAG, "system phone call start");
                    this.phoneStatusNeedResume = true;
                    CommonUtility.this.nativeAudioRoutingPhoneChanged(CommonUtility.this.mBridgeHandle, false, 22, 2);
                    break;
                }
            }
        }
    }

    public static class MobileType {
        public static final int Unknown = -1;
        public static final int Gsm = 0;
        public static final int Cdma = 1;
        public static final int Wcdma = 2;
        public static final int Lte = 3;
    }
}

