/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import io.agora.rtc.internal.AudioRoutingListener;
import io.agora.rtc.internal.Logging;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class AudioRoutingController {
    private static final String TAG = "AudioRoute";
    private static final int UNINIT = 0;
    private static final int START = 1;
    private static final int STOP = 2;
    private static final int ERROR = 4;
    public static final int UNSET = -1;
    public static final int OFF = 0;
    public static final int ON = 1;
    private WeakReference<Context> mContext;
    private EventHandler mEventHandler;
    private WeakReference<AudioRoutingListener> mListener;
    private ControllerState mState;
    private boolean mIsWiredHeadsetPlugged = false;
    private int mHeadsetType = -1;
    private boolean mIsBTHeadsetPlugged = false;
    private int mForceSpeakerphone = -1;
    private int mCurrentRouting = -1;
    private int mDefaultRouting = -1;
    private int mChannelProfile = 1;
    private boolean mVideoDisabled = true;
    private boolean mMuteLocal = false;
    private boolean mMuteRemotes = false;
    private int mEngineRole = -1;
    private boolean mPhoneInCall = false;
    private int mSpeakerCommVolume = -1;
    private boolean mBTHeadSetProperlySeted = false;
    private static final int BT_SCO_STATE_CONNECTING = 0;
    private static final int BT_SCO_STATE_CONNECTED = 1;
    private static final int BT_SCO_STATE_DISCONNECTING = 2;
    private static final int BT_SCO_STATE_DISCONNECTED = 3;
    private int mBtScoState = 3;
    private boolean mIsBTScoStarted = false;
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 4000;
    private static final int MAX_SCO_CONNECT_ATTEMPS = 5;
    private int dynamic_timeout = 4000;
    private int mScoConnectionAttemps;
    private ControllerStopState mStopState = null;
    private ControllerStartState mStartState = null;
    private ControllerErrorState mErrorState = null;
    private boolean mUsingCommParameters = false;
    private final Runnable bluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            AudioRoutingController.this.bluetoothTimeout();
        }
    };
    private HeadsetBroadcastReceiver mHeadsetReceiver;
    private BTHeadsetBroadcastReceiver mBTHeadsetReceiver;
    private BluetoothAdapter mBTAdapter;
    private BluetoothHeadset mBTHeadset;
    private BluetoothProfile.ServiceListener mBTHeadsetListener;
    private static final int EVT_HEADSET = 1;
    private static final int EVT_BT_HEADSET = 2;
    private static final int EVT_BT_SCO = 3;
    public static final int CMD_SET_DEFAULT_ROUTING = 10;
    public static final int CMD_FORCE_TO_SPEAKER = 11;
    public static final int CMD_MUTE_VIDEO_LOCAL = 12;
    public static final int CMD_MUTE_VIDEO_REMOTES = 13;
    public static final int CMD_MUTE_VIDEO_ALL = 14;
    public static final int CMD_START_BT_SCO = 15;
    public static final int CMD_FORCE_BT_SCO_OFF = 16;
    public static final int EVT_CHANNEL_PROFILE = 20;
    public static final int EVT_ENGINE_ROLE_CHANGED = 21;
    public static final int EVT_PHONE_STATE_CHANGED = 22;
    public static final int EVT_USING_COMM_PARAMETERS = 112;
    public static final int EVT_USING_NORM_PARAMETERS = 113;

    private void startTimer() {
        this.dynamic_timeout += 4000 * this.mScoConnectionAttemps;
        Logging.d(TAG, "start bluetooth timer " + this.dynamic_timeout);
        this.mEventHandler.postDelayed(this.bluetoothTimeoutRunnable, 4000L);
    }

    private void cancelTimer() {
        Logging.d(TAG, "cancel bluetooth timer");
        this.mEventHandler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    private ControllerState changeState(int state) {
        if (state == 2) {
            if (this.mStopState == null) {
                this.mStopState = new ControllerStopState();
            }
            if (this.mStopState != null) {
                this.mStopState.reset();
            }
            return this.mStopState;
        }
        if (state == 1) {
            if (this.mStartState == null) {
                this.mStartState = new ControllerStartState();
            }
            if (this.mStartState != null) {
                this.mStartState.reset();
            }
            return this.mStartState;
        }
        if (this.mErrorState == null) {
            this.mErrorState = new ControllerErrorState();
        }
        if (this.mErrorState != null) {
            this.mErrorState.reset();
        }
        return this.mErrorState;
    }

    public AudioRoutingController(Context context, AudioRoutingListener listener) {
        this.mContext = new WeakReference<Context>(context);
        this.mListener = new WeakReference<AudioRoutingListener>(listener);
    }

    public int initialize() {
        Logging.i(TAG, "initialize +");
        Context context = (Context)this.mContext.get();
        if (context == null) {
            Logging.e(TAG, "context has been GCed");
            return -1;
        }
        AudioManager am = this.getAudioManager();
        if (am == null) {
            Logging.e(TAG, "invalid context: can't get AudioManager");
            return -1;
        }
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(looper) : null);
        if (this.mHeadsetReceiver == null) {
            this.mHeadsetReceiver = new HeadsetBroadcastReceiver();
        }
        this.mIsWiredHeadsetPlugged = am.isWiredHeadsetOn();
        this.mState = this.changeState(2);
        Logging.i(TAG, "Headset setup: Plugged = " + this.mIsWiredHeadsetPlugged);
        if (!this.mHeadsetReceiver.getRegistered()) {
            context.registerReceiver((BroadcastReceiver)this.mHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
            this.mHeadsetReceiver.setRegistered(true);
        }
        if (Build.VERSION.SDK_INT < 11 && 0 != context.checkCallingOrSelfPermission("android.permission.BLUETOOTH")) {
            Logging.w(TAG, "do not support BT monitoring on this device");
            return 0;
        }
        if (this.mBTHeadsetListener != null) {
            Logging.w(TAG, "Bluetooth service Listener already been initialized");
        } else {
            try {
                this.mBTHeadsetListener = new BluetoothProfile.ServiceListener(){

                    public void onServiceConnected(int profile, BluetoothProfile proxy) {
                        Logging.i(AudioRoutingController.TAG, "onServiceConnected " + profile + " =? headset(" + 1 + ")");
                        if (profile == 1) {
                            Logging.i(AudioRoutingController.TAG, "on BT service connected: " + profile + " " + proxy);
                            AudioRoutingController.this.mBTHeadset = (BluetoothHeadset)proxy;
                        }
                    }

                    public void onServiceDisconnected(int profile) {
                        Logging.i(AudioRoutingController.TAG, "onServiceDisconnected " + profile + " =? headset(" + 1 + ")");
                        if (profile == 1) {
                            Logging.i(AudioRoutingController.TAG, "on BT service disconnected: " + profile);
                            AudioRoutingController.this.cancelTimer();
                            AudioRoutingController.this.mBTHeadset = null;
                        }
                    }
                };
            }
            catch (Exception e) {
                Logging.e(TAG, "initialize failed: unable to create BluetoothProfile.ServiceListener, err=" + e.getMessage());
            }
        }
        if (!this.hasPermission(context, "android.permission.BLUETOOTH")) {
            Logging.w(TAG, "lacks BLUETOOTH permission");
            return 0;
        }
        try {
            if (this.mBTHeadsetReceiver == null) {
                this.mBTHeadsetReceiver = new BTHeadsetBroadcastReceiver();
            }
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
            if (this.mBTAdapter == null || this.mBTHeadsetListener == null) {
                Logging.e(TAG, "initialize: failed to get bluetooth adapter!!");
                return 0;
            }
            this.mBTAdapter.getProfileProxy(context, this.mBTHeadsetListener, 1);
            if (2 == this.mBTAdapter.getProfileConnectionState(1)) {
                this.mIsBTHeadsetPlugged = true;
            }
            Logging.i(TAG, "BT headset setup: BTHeadsetPlugged = " + this.mIsBTHeadsetPlugged + " " + this.mBTHeadset);
            IntentFilter bt = new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            bt.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
            bt.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            bt.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            if (!this.mBTHeadsetReceiver.getRegistered()) {
                Intent intent = context.registerReceiver((BroadcastReceiver)this.mBTHeadsetReceiver, bt);
                this.mBTHeadsetReceiver.setRegistered(true);
                if (intent != null && TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                    int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                    switch (state) {
                        case 1: {
                            Logging.i(TAG, "initial Bluetooth SCO device connected");
                            this.mBtScoState = 1;
                            break;
                        }
                        default: {
                            Logging.i(TAG, "initial Bluetooth SCO device unconnected");
                            this.mBtScoState = 3;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "unable to create BluetoothHeadsetBroadcastReceiver, err:" + e.getMessage());
        }
        Logging.i(TAG, "initialize -");
        return 0;
    }

    private void clearBTResource() {
        if (this.mBTAdapter != null) {
            this.mBTAdapter.closeProfileProxy(1, (BluetoothProfile)this.mBTHeadset);
            this.mBTAdapter = null;
        }
        if (this.mBTHeadsetListener != null) {
            this.mBTHeadsetListener = null;
        }
    }

    public void uninitialize() {
        Logging.d(TAG, "uninitialize");
        try {
            this.clearBTResource();
            Context context = (Context)this.mContext.get();
            if (context != null) {
                if (this.mHeadsetReceiver != null && this.mHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mHeadsetReceiver);
                    this.mHeadsetReceiver.setRegistered(false);
                }
                if (this.mBTHeadsetReceiver != null && this.mBTHeadsetReceiver.getRegistered()) {
                    context.unregisterReceiver((BroadcastReceiver)this.mBTHeadsetReceiver);
                    this.mBTHeadsetReceiver.setRegistered(false);
                }
            }
            this.mHeadsetReceiver = null;
            this.mBTHeadsetReceiver = null;
        }
        catch (Exception e) {
            Logging.e(TAG, "AudioRoutingController uninitialize fail: ", e);
        }
    }

    public void startMonitoring() {
        this.mState.setState(1);
    }

    public void stopMonitoring() {
        this.mState.setState(2);
    }

    public void sendEvent(int event, int arg) {
        Logging.d(TAG, "sendEvent: [" + event + "], extra arg: " + arg + "... " + (Object)((Object)this.mEventHandler));
        if (this.mEventHandler != null) {
            Message m = this.mEventHandler.obtainMessage(event, arg, 0);
            this.mEventHandler.sendMessage(m);
        }
    }

    public void clearListenerNativeHandle() {
        Logging.d(TAG, "clearListenerNativeHandle");
        AudioRoutingListener l = (AudioRoutingListener)this.mListener.get();
        if (l != null) {
            l.onAudioRoutingDestroyed();
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private boolean isAudioOnly() {
        return this.mVideoDisabled || this.mMuteLocal && this.mMuteRemotes;
    }

    private AudioManager getAudioManager() {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return null;
        }
        return (AudioManager)context.getSystemService("audio");
    }

    private void notifyAudioRoutingChanged(int routing) {
        AudioRoutingListener l = (AudioRoutingListener)this.mListener.get();
        if (l != null) {
            l.onAudioRoutingChanged(routing);
        } else {
            Logging.w(TAG, "failed to get audio routing listener");
        }
    }

    private int doSetAudioOutputRouting(int routing) {
        Logging.i(TAG, "set audio output routing from " + this.getAudioRouteDesc(this.mCurrentRouting) + " to " + this.getAudioRouteDesc(routing));
        try {
            AudioManager am = this.getAudioManager();
            if (routing != 5) {
                am.setSpeakerphoneOn(false);
                am.setSpeakerphoneOn(routing == 3);
            }
            if (this.queryCurrentAudioRouting() != routing) {
                int current = this.queryCurrentAudioRouting();
                Logging.i(TAG, "different audio routing from target " + routing + ", actual routing: " + current + "[" + this.getAudioRouteDesc(current) + "]");
            }
            this.updateBluetoothSco(routing);
            this.mCurrentRouting = routing;
            this.notifyAudioRoutingChanged(routing);
            Logging.i(TAG, "audio routing changed to " + this.getAudioRouteDesc(this.mCurrentRouting));
        }
        catch (Exception e) {
            Logging.e(TAG, "set audio output routing failed:", e);
        }
        return 0;
    }

    private int updateBluetoothSco(int targetRouting) {
        Logging.d(TAG, "updateBluetoothSco sco started: " + this.mIsBTScoStarted + ", audio route target: " + targetRouting + "[" + this.getAudioRouteDesc(targetRouting) + "] current: " + this.mCurrentRouting + "[" + this.getAudioRouteDesc(this.mCurrentRouting) + "], engine role: " + this.mEngineRole + "mUsing  " + this.mUsingCommParameters + " mBTHeadSetProperlySeted " + this.mBTHeadSetProperlySeted);
        this.mBTHeadSetProperlySeted = targetRouting != 5;
        this.notifyAudioRoutingChanged(targetRouting);
        return 0;
    }

    private void startBtSco() {
        AudioManager am = this.getAudioManager();
        int mode = am.getMode();
        Logging.i(TAG, "try to opening bt sco " + this.mScoConnectionAttemps + " " + mode + "[" + this.modeAsString(mode) + "] " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "] sco on: " + am.isBluetoothScoOn());
        Logging.d(TAG, "Off call sco support = " + am.isBluetoothScoAvailableOffCall());
        this.mBtScoState = 0;
        ++this.mScoConnectionAttemps;
        this.doStartBTSco(am);
    }

    private String modeAsString(int mode) {
        String modeAsString;
        switch (mode) {
            case 0: {
                modeAsString = "MODE_NORMAL";
                break;
            }
            case 1: {
                modeAsString = "MODE_RINGTONE";
                break;
            }
            case 2: {
                modeAsString = "MODE_IN_CALL";
                break;
            }
            case 3: {
                modeAsString = "MODE_IN_COMMUNICATION";
                break;
            }
            default: {
                modeAsString = "Unknown " + mode;
            }
        }
        return modeAsString;
    }

    private String btStateAsString(int state) {
        String btStateAsString;
        switch (state) {
            case 0: {
                btStateAsString = "SCO_CONNECTING";
                break;
            }
            case 1: {
                btStateAsString = "SCO_CONNECTED";
                break;
            }
            case 2: {
                btStateAsString = "SCO_DISCONNECTING";
                break;
            }
            case 3: {
                btStateAsString = "SCO_DISCONNECTED";
                break;
            }
            default: {
                btStateAsString = "Unknown " + state;
            }
        }
        return btStateAsString;
    }

    private void doStartBTSco(AudioManager am) {
        try {
            int mode = am.getMode();
            Logging.i(TAG, "doStartBTSco " + Build.VERSION.SDK_INT + " sco on: " + am.isBluetoothScoOn() + " " + mode + "[" + this.modeAsString(mode) + "]");
            if (Build.VERSION.SDK_INT < 22) {
                am.setStreamMute(0, true);
            }
            am.setSpeakerphoneOn(false);
            am.setBluetoothScoOn(true);
            am.startBluetoothSco();
            if (this.mBTHeadset != null) {
                Method connectAudio = null;
                Object retVal = null;
                try {
                    connectAudio = this.mBTHeadset.getClass().getMethod("connectAudio", new Class[0]);
                    retVal = connectAudio.invoke((Object)this.mBTHeadset, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "doStartBTSco fail ", e);
        }
        Logging.d(TAG, "doStartBTSco done sco on: " + am.isBluetoothScoOn() + " " + am.getMode() + "[" + this.modeAsString(am.getMode()) + "]");
    }

    private void doStopBTSco(AudioManager am) {
        Logging.i(TAG, "doStopBTSco " + Build.VERSION.SDK_INT + " sco on: " + am.isBluetoothScoOn());
        am.setBluetoothScoOn(false);
        am.stopBluetoothSco();
        if (this.mBTHeadset != null) {
            Method disconnectAudio = null;
            Object retVal = null;
            try {
                disconnectAudio = this.mBTHeadset.getClass().getMethod("disconnectAudio", new Class[0]);
                retVal = disconnectAudio.invoke((Object)this.mBTHeadset, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (Build.VERSION.SDK_INT < 22) {
            // empty if block
        }
    }

    private void stopBtSco() {
        AudioManager am = this.getAudioManager();
        int mode = am.getMode();
        Logging.i(TAG, "try to stopping bt sco " + mode + "[" + this.modeAsString(mode) + "] " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "] sco on: " + am.isBluetoothScoOn());
        this.mBtScoState = !am.isBluetoothScoOn() ? 3 : 2;
        this.doStopBTSco(am);
    }

    private void checkBtScoState(boolean isBtScoOn) {
        this.mScoConnectionAttemps = 0;
    }

    private void bluetoothTimeout() {
        AudioManager am = this.getAudioManager();
        boolean scoConnected = false;
        if (this.mBTHeadset == null) {
            Logging.w(TAG, "no bluetooth profile connected");
            return;
        }
        List devices = this.mBTHeadset.getConnectedDevices();
        if (devices.size() > 0) {
            BluetoothDevice bluetoothDevice = (BluetoothDevice)devices.get(0);
            Method isAudioOn = null;
            Object retVal = null;
            if (Build.VERSION.SDK_INT <= 26) {
                try {
                    isAudioOn = this.mBTHeadset.getClass().getMethod("isAudioOn", new Class[0]);
                    retVal = isAudioOn.invoke((Object)this.mBTHeadset, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if (this.mBTHeadset.isAudioConnected(bluetoothDevice) || retVal != null && ((Boolean)retVal).booleanValue()) {
                Logging.d(TAG, "SCO connected with " + bluetoothDevice.getName());
                scoConnected = true;
            } else {
                Logging.d(TAG, "SCO is not connected with " + bluetoothDevice.getName());
            }
        } else {
            Logging.w(TAG, "no bluetooth device connected.");
        }
        if (this.mScoConnectionAttemps < 5) {
            Logging.d(TAG, "attemps trying, bt sco started: " + this.mIsBTScoStarted + " sco connected: " + scoConnected + " " + this.mScoConnectionAttemps + " times " + this.mBtScoState + "[" + this.btStateAsString(this.mBtScoState) + "]");
            if (this.mIsBTScoStarted && !scoConnected) {
                this.startTimer();
                ++this.mScoConnectionAttemps;
                this.stopBtSco();
                am.stopBluetoothSco();
                this.doStartBTSco(am);
            }
        } else {
            Logging.e(TAG, "start bluetooth sco timeout, actual routing: " + this.queryCurrentAudioRouting());
            this.mScoConnectionAttemps = 0;
            if (this.mListener.get() != null) {
                ((AudioRoutingListener)this.mListener.get()).onAudioRoutingError(1030);
            }
            this.resetAudioRouting();
        }
    }

    private void resetAudioRouting() {
        Logging.e(TAG, "default routing: " + this.getAudioRouteDesc(this.mDefaultRouting) + " bluetooth " + this.mIsBTHeadsetPlugged + ", current routing: " + this.getAudioRouteDesc(this.mCurrentRouting) + ", actual system routing: " + this.getAudioRouteDesc(this.queryCurrentAudioRouting()));
        if (this.mForceSpeakerphone == 1) {
            int targetRouting = 3;
            Logging.i(TAG, "reset(force) audio routing, default routing: " + this.getAudioRouteDesc(this.mDefaultRouting) + ", current routing: " + this.getAudioRouteDesc(this.mCurrentRouting) + ", target routing: " + this.getAudioRouteDesc(targetRouting) + ", actual system routing:" + this.getAudioRouteDesc(this.queryCurrentAudioRouting()));
            if (this.mCurrentRouting != 3 || this.queryCurrentAudioRouting() != 3) {
                this.doSetAudioOutputRouting(targetRouting);
            }
        } else {
            int route = this.queryCurrentAudioRouting();
            if (route == 0 || route == 2) {
                this.mIsWiredHeadsetPlugged = true;
            }
            int targetRouting = this.mIsBTHeadsetPlugged ? 5 : (this.mIsWiredHeadsetPlugged ? this.mHeadsetType : (this.mForceSpeakerphone == 0 ? 1 : this.mDefaultRouting));
            Logging.i(TAG, "reset audio routing, default routing: " + this.getAudioRouteDesc(this.mDefaultRouting) + ", current routing: " + this.getAudioRouteDesc(this.mCurrentRouting) + ", target routing: " + this.getAudioRouteDesc(targetRouting) + ", actual system routing: " + this.getAudioRouteDesc(this.queryCurrentAudioRouting()));
            if (this.mCurrentRouting != targetRouting || this.queryCurrentAudioRouting() != this.mCurrentRouting) {
                this.doSetAudioOutputRouting(targetRouting);
            }
        }
    }

    private String getAudioRouteDesc(int route) {
        switch (route) {
            case 1: {
                return "Earpiece";
            }
            case 3: {
                return "Speakerphone";
            }
            case 4: {
                return "Loudspeaker";
            }
            case 0: {
                return "Headset";
            }
            case 2: {
                return "HeadsetOnly";
            }
            case 5: {
                return "HeadsetBluetooth";
            }
            case -1: {
                return "Default";
            }
        }
        return "Unknown";
    }

    private int queryCurrentAudioRouting() {
        AudioManager am = this.getAudioManager();
        if (this.mBTAdapter == null) {
            this.mBTAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        try {
            if (am.isSpeakerphoneOn()) {
                return 3;
            }
            if ((am.isBluetoothScoOn() || am.isBluetoothA2dpOn()) && this.mBTAdapter.isEnabled()) {
                return 5;
            }
            if (am.isWiredHeadsetOn()) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            Logging.e(TAG, "fatal error @queryCurrentAudioRouting", e);
            return -1;
        }
    }

    protected boolean hasPermission(Context context, String permission2) {
        return context.checkCallingOrSelfPermission(permission2) == 0;
    }

    private class ControllerErrorState
    extends ControllerBaseState {
        private ControllerErrorState() {
        }

        @Override
        public int getState() {
            return 4;
        }
    }

    private class ControllerStartState
    extends ControllerBaseState {
        public ControllerStartState() {
            if (AudioRoutingController.this.mDefaultRouting == -1) {
                if (AudioRoutingController.this.mChannelProfile == 0 && AudioRoutingController.this.isAudioOnly()) {
                    AudioRoutingController.this.mDefaultRouting = 1;
                } else {
                    AudioRoutingController.this.mDefaultRouting = 3;
                }
            }
            AudioRoutingController.this.resetAudioRouting();
            Logging.i(AudioRoutingController.TAG, "Monitor start: default routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting) + ", current routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mCurrentRouting));
        }

        @Override
        public void reset() {
            if (AudioRoutingController.this.mDefaultRouting == -1) {
                if (AudioRoutingController.this.mChannelProfile == 0 && AudioRoutingController.this.isAudioOnly()) {
                    AudioRoutingController.this.mDefaultRouting = 1;
                } else {
                    AudioRoutingController.this.mDefaultRouting = 3;
                }
            }
            AudioRoutingController.this.resetAudioRouting();
            Logging.i(AudioRoutingController.TAG, "Monitor reset: default routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting) + ", current routing: " + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mCurrentRouting));
        }

        @Override
        public int getState() {
            return 1;
        }

        @Override
        public void onEvent(int event, int info) {
            Logging.d(AudioRoutingController.TAG, "StartState: onEvent: " + event + ", info: " + info);
            AudioManager am = AudioRoutingController.this.getAudioManager();
            switch (event) {
                case 1: {
                    AudioRoutingController.this.mHeadsetType = info;
                    AudioRoutingController.this.mIsWiredHeadsetPlugged = info >= 0;
                    if (AudioRoutingController.this.mPhoneInCall || AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        return;
                    }
                    if (AudioRoutingController.this.mIsWiredHeadsetPlugged && AudioRoutingController.this.mCurrentRouting != info) {
                        AudioRoutingController.this.doSetAudioOutputRouting(info);
                        break;
                    }
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 11: {
                    if (AudioRoutingController.this.mChannelProfile == 1 && AudioRoutingController.this.mIsBTHeadsetPlugged) break;
                    AudioRoutingController.this.mForceSpeakerphone = info;
                    if (AudioRoutingController.this.mPhoneInCall) break;
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 16: {
                    AudioManager amg = AudioRoutingController.this.getAudioManager();
                    if (info == 0) {
                        if (!amg.isBluetoothScoOn()) break;
                        AudioRoutingController.this.doStopBTSco(amg);
                        break;
                    }
                    if (!amg.isBluetoothA2dpOn()) break;
                    AudioRoutingController.this.doStartBTSco(amg);
                    break;
                }
                case 21: {
                    AudioRoutingController.this.mEngineRole = info;
                    if (AudioRoutingController.this.mPhoneInCall) break;
                    AudioRoutingController.this.updateBluetoothSco(AudioRoutingController.this.mCurrentRouting);
                    break;
                }
                case 2: {
                    if (info != 0 || !AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        // empty if block
                    }
                    AudioRoutingController.this.mBTHeadSetProperlySeted = false;
                    AudioRoutingController.this.mIsBTHeadsetPlugged = info == 1;
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    Logging.d(AudioRoutingController.TAG, "BT HEADSET EVENT  " + info + " mIsBTHeadsetPlugged " + AudioRoutingController.this.mIsBTHeadsetPlugged);
                    if (AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        AudioRoutingController.this.doSetAudioOutputRouting(5);
                        break;
                    }
                    if (AudioRoutingController.this.mForceSpeakerphone == 1) {
                        AudioRoutingController.this.doSetAudioOutputRouting(3);
                        break;
                    }
                    if (AudioRoutingController.this.mForceSpeakerphone == 0) {
                        if (AudioRoutingController.this.mIsWiredHeadsetPlugged) {
                            AudioRoutingController.this.doSetAudioOutputRouting(0);
                            break;
                        }
                        AudioRoutingController.this.doSetAudioOutputRouting(1);
                        break;
                    }
                    if (AudioRoutingController.this.mIsWiredHeadsetPlugged) {
                        AudioRoutingController.this.doSetAudioOutputRouting(0);
                        break;
                    }
                    AudioRoutingController.this.doSetAudioOutputRouting(AudioRoutingController.this.mDefaultRouting);
                    break;
                }
                case 3: {
                    AudioRoutingController.this.mBtScoState = info == 1 ? 1 : 2;
                    if (AudioRoutingController.this.mPhoneInCall) {
                        return;
                    }
                    AudioRoutingController.this.checkBtScoState(info == 1);
                    if (info != 0) break;
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 22: {
                    Logging.i(AudioRoutingController.TAG, "phone state changed: " + info);
                    AudioRoutingController.this.mPhoneInCall = info > 0;
                    if (info == 0) {
                        AudioRoutingController.this.resetAudioRouting();
                        break;
                    }
                    AudioRoutingController.this.mCurrentRouting = -1;
                    break;
                }
                case 112: {
                    if (AudioRoutingController.this.mUsingCommParameters && AudioRoutingController.this.mBTHeadSetProperlySeted) break;
                    AudioRoutingController.this.mUsingCommParameters = true;
                    Logging.d(AudioRoutingController.TAG, "BT HEADSET EVENT  " + info + " mIsBTHeadsetPlugged " + AudioRoutingController.this.mIsBTHeadsetPlugged);
                    AudioRoutingController.this.mBTHeadSetProperlySeted = true;
                    if (AudioRoutingController.this.mIsBTHeadsetPlugged) {
                        AudioRoutingController.this.startTimer();
                        AudioRoutingController.this.mIsBTScoStarted = true;
                        AudioRoutingController.this.doStartBTSco(am);
                        break;
                    }
                    AudioRoutingController.this.mIsBTScoStarted = false;
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                case 113: {
                    if (AudioRoutingController.this.mUsingCommParameters || AudioRoutingController.this.mBTHeadSetProperlySeted) {
                        // empty if block
                    }
                    AudioRoutingController.this.mBTHeadSetProperlySeted = true;
                    AudioRoutingController.this.mUsingCommParameters = false;
                    if (am.isBluetoothScoOn()) {
                        AudioRoutingController.this.cancelTimer();
                        AudioRoutingController.this.doStopBTSco(am);
                        break;
                    }
                    AudioRoutingController.this.resetAudioRouting();
                    break;
                }
                default: {
                    super.onEvent(event, info);
                }
            }
        }
    }

    private class ControllerStopState
    extends ControllerBaseState {
        public ControllerStopState() {
            AudioRoutingController.this.cancelTimer();
            if (AudioRoutingController.this.mIsBTScoStarted) {
                AudioRoutingController.this.mIsBTScoStarted = false;
                AudioRoutingController.this.stopBtSco();
            }
            AudioRoutingController.this.mForceSpeakerphone = -1;
            AudioRoutingController.this.mCurrentRouting = -1;
            AudioRoutingController.this.mDefaultRouting = -1;
            AudioRoutingController.this.mScoConnectionAttemps = 0;
            Logging.i(AudioRoutingController.TAG, "Monitor stopped");
        }

        @Override
        public int getState() {
            return 2;
        }

        @Override
        public void reset() {
            Logging.i(AudioRoutingController.TAG, "Monitor stop state, reset");
            AudioRoutingController.this.mBTHeadSetProperlySeted = false;
            AudioRoutingController.this.cancelTimer();
            if (AudioRoutingController.this.mIsBTScoStarted || AudioRoutingController.this.getAudioManager().isBluetoothScoOn()) {
                AudioRoutingController.this.mIsBTScoStarted = false;
                AudioRoutingController.this.stopBtSco();
            }
            AudioRoutingController.this.mForceSpeakerphone = -1;
            AudioRoutingController.this.mCurrentRouting = -1;
            AudioRoutingController.this.mDefaultRouting = -1;
            AudioRoutingController.this.mScoConnectionAttemps = 0;
            Logging.i(AudioRoutingController.TAG, "Monitor stopped");
        }

        @Override
        public void onEvent(int evt, int info) {
            Logging.d(AudioRoutingController.TAG, "StopState: onEvent: " + evt + ", info: " + info);
            try {
                AudioManager am = AudioRoutingController.this.getAudioManager();
                switch (evt) {
                    case 11: {
                        am.setSpeakerphoneOn(info == 1);
                        AudioRoutingController.this.mCurrentRouting = info == 1 ? 3 : -1;
                        AudioRoutingController.this.mForceSpeakerphone = info;
                        AudioRoutingController.this.notifyAudioRoutingChanged(AudioRoutingController.this.queryCurrentAudioRouting());
                        break;
                    }
                    default: {
                        super.onEvent(evt, info);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Logging.e(AudioRoutingController.TAG, "onEvent: Exception ", e);
            }
        }
    }

    private abstract class ControllerBaseState
    implements ControllerState {
        private ControllerBaseState() {
        }

        @Override
        public void setState(int state) {
            if (state == this.getState()) {
                Logging.i(AudioRoutingController.TAG, "setState: state not changed!");
                return;
            }
            AudioRoutingController.this.mState = AudioRoutingController.this.changeState(state);
        }

        @Override
        public void reset() {
            AudioRoutingController.this.resetAudioRouting();
        }

        @Override
        public int getState() {
            return 0;
        }

        @Override
        public void onEvent(int event, int info) {
            switch (event) {
                case 1: {
                    AudioRoutingController.this.mHeadsetType = info;
                    AudioRoutingController.this.mIsWiredHeadsetPlugged = info >= 0;
                    break;
                }
                case 20: {
                    AudioRoutingController.this.mChannelProfile = info;
                    break;
                }
                case 2: {
                    AudioRoutingController.this.mIsBTHeadsetPlugged = info == 1;
                    break;
                }
                case 14: {
                    AudioRoutingController.this.mVideoDisabled = info > 0;
                    break;
                }
                case 12: {
                    AudioRoutingController.this.mMuteLocal = info > 0;
                    break;
                }
                case 13: {
                    AudioRoutingController.this.mMuteRemotes = info > 0;
                    break;
                }
                case 21: {
                    AudioRoutingController.this.mEngineRole = info;
                    break;
                }
                case 10: {
                    AudioRoutingController.this.mDefaultRouting = info;
                    Logging.i(AudioRoutingController.TAG, "User set default routing to:" + AudioRoutingController.this.getAudioRouteDesc(AudioRoutingController.this.mDefaultRouting));
                    break;
                }
                case 22: {
                    AudioRoutingController.this.mPhoneInCall = info > 0;
                    break;
                }
                case 112: {
                    AudioRoutingController.this.mUsingCommParameters = true;
                }
                case 113: {
                    AudioRoutingController.this.mUsingCommParameters = false;
                }
            }
        }
    }

    private static interface ControllerState {
        public void setState(int var1);

        public int getState();

        public void onEvent(int var1, int var2);

        public void reset();
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            AudioRoutingController.this.mState.onEvent(msg.what, msg.arg1);
        }
    }

    private class BTHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private BTHeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean isReg) {
            this.isRegistered = isReg;
        }

        public void onReceive(Context context, Intent intent) {
            block29: {
                String action = intent.getAction();
                try {
                    if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                        int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                        int previousState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                        Logging.d(AudioRoutingController.TAG, "BT ACTION_CONNECTION_STATE_CHANGED prev " + previousState + ", " + state);
                        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                        switch (state) {
                            case 2: {
                                if (device != null && (device.getBluetoothClass().hasService(0x200000) || device.getBluetoothClass().hasService(0x400000))) {
                                    Logging.i(AudioRoutingController.TAG, "Bluetooth device " + device + " connected");
                                    AudioRoutingController.this.mScoConnectionAttemps = 0;
                                    AudioRoutingController.this.sendEvent(2, 1);
                                    break;
                                }
                                break block29;
                            }
                            case 1: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + device + " connecting");
                                break;
                            }
                            case 3: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + device + " disconnecting");
                                AudioRoutingController.this.mIsBTHeadsetPlugged = false;
                                break;
                            }
                            case 0: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + device + " disconnected");
                                AudioRoutingController.this.sendEvent(2, 0);
                                break;
                            }
                            default: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth device " + device + " unknown event, state=" + state);
                                break;
                            }
                        }
                        break block29;
                    }
                    if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                        int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                        int previousState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                        Logging.d(AudioRoutingController.TAG, "BT ACTION_AUDIO_STATE_CHANGED prev " + previousState + ", " + state);
                        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                        switch (state) {
                            case 12: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + device + " connected");
                                break;
                            }
                            case 11: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + device + " connecting");
                                break;
                            }
                            case 10: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + device + " disconnected");
                                break;
                            }
                            default: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth audio device " + device + " event, state=" + state);
                                break;
                            }
                        }
                        break block29;
                    }
                    if (action.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                        int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -99);
                        int previousState = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -99);
                        Logging.d(AudioRoutingController.TAG, "BT ACTION_SCO_AUDIO_STATE_UPDATED prev " + previousState + ", " + state);
                        switch (state) {
                            case 1: {
                                if (AudioRoutingController.this.mBTAdapter.getProfileConnectionState(1) == 2) {
                                    Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device connected");
                                    AudioRoutingController.this.cancelTimer();
                                    AudioRoutingController.this.sendEvent(3, 1);
                                    break;
                                }
                                break block29;
                            }
                            case 2: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device connecting");
                                break;
                            }
                            case -1: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device error");
                                break;
                            }
                            case 0: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device disconnected");
                                AudioRoutingController.this.sendEvent(3, 0);
                                break;
                            }
                            default: {
                                Logging.i(AudioRoutingController.TAG, "Bluetooth SCO device unknown event, state=" + state);
                                break;
                            }
                        }
                        break block29;
                    }
                    if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                        int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -99);
                        int previousState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -99);
                        Logging.d(AudioRoutingController.TAG, "BluetoothAdapter.ACTION_STATE_CHANGED prev " + previousState + ", " + state);
                        switch (state) {
                            case 10: {
                                AudioRoutingController.this.sendEvent(2, 0);
                                break;
                            }
                            case 12: {
                                if (AudioRoutingController.this.mBTAdapter.getProfileConnectionState(2) != 2 && AudioRoutingController.this.mBTAdapter.getProfileConnectionState(1) != 2) break;
                                AudioRoutingController.this.sendEvent(2, 1);
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Logging.e(AudioRoutingController.TAG, "BT broadcast receiver onReceive fail ", e);
                }
            }
        }
    }

    private class HeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private HeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean isReg) {
            this.isRegistered = isReg;
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("android.intent.action.HEADSET_PLUG") && intent.hasExtra("state")) {
                int plugged = intent.getIntExtra("state", -1);
                if (plugged == 1) {
                    int microphone = intent.getIntExtra("microphone", -1);
                    if (microphone == 1) {
                        Logging.i(AudioRoutingController.TAG, "Headset w/ mic connected");
                        AudioRoutingController.this.sendEvent(1, 0);
                    } else {
                        Logging.i(AudioRoutingController.TAG, "Headset w/o mic connected");
                        AudioRoutingController.this.sendEvent(1, 2);
                    }
                } else if (plugged == 0) {
                    Logging.i(AudioRoutingController.TAG, "Headset disconnected");
                    AudioRoutingController.this.sendEvent(1, -1);
                } else {
                    Logging.i(AudioRoutingController.TAG, "Headset unknown event detected, state=" + plugged);
                }
            }
        }
    }
}

