/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import io.agora.rtc.internal.Logging;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;

public class MediaCodecAudioEncoder {
    private MediaCodec mMediaCodec = null;
    private MediaFormat mTrackFormat = null;
    private String mCodecString = null;
    private File outputFile = null;
    private BufferedOutputStream outputStream = null;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private MediaCodec mAACEncoder = null;
    private MediaFormat mAACFormat = null;
    private ByteBuffer[] mAACInputBuffers;
    private ByteBuffer[] mAACOutputBuffers;
    private ByteBuffer mAACEncodedBuffer = ByteBuffer.allocateDirect(1024);
    private String TAG = "MediaCodec Audio Encoder";

    public boolean createStreaming(String filename, int sampleRate, int channels, int quality) {
        try {
            Logging.i(this.TAG, "Recording aac with fs = " + sampleRate + ", ch = " + channels + ", quality = " + quality);
            String ext = filename.substring(filename.length() - 3);
            if (ext.equalsIgnoreCase("3gp") || ext.equalsIgnoreCase("amr")) {
                if (sampleRate == 8000) {
                    this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/3gpp");
                    this.mTrackFormat = MediaFormat.createAudioFormat((String)"audio/3gpp", (int)sampleRate, (int)channels);
                    this.mTrackFormat.setInteger("bitrate", 12200);
                    this.mCodecString = "audio/3gpp";
                } else if (sampleRate == 16000) {
                    this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/amr-wb");
                    this.mTrackFormat = MediaFormat.createAudioFormat((String)"audio/amr-wb", (int)sampleRate, (int)channels);
                    this.mTrackFormat.setInteger("bitrate", 23850);
                    this.mCodecString = "audio/amr-wb";
                }
            } else if (ext.equalsIgnoreCase("aac")) {
                int bitrate = 50000;
                switch (quality) {
                    case 0: {
                        bitrate = 16000;
                        break;
                    }
                    case 1: {
                        bitrate = 25000;
                        break;
                    }
                    default: {
                        bitrate = 50000;
                    }
                }
                this.mMediaCodec = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
                this.mTrackFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channels);
                int[] kAACProfiles = new int[]{2, 5, 39};
                this.mTrackFormat.setInteger("aac-profile", 2);
                this.mTrackFormat.setInteger("sample-rate", sampleRate);
                this.mTrackFormat.setInteger("channel-count", channels);
                this.mTrackFormat.setInteger("bitrate", bitrate);
                this.mCodecString = "audio/mp4a-latm";
            } else {
                return false;
            }
            this.mMediaCodec.configure(this.mTrackFormat, null, null, 1);
            if (this.mMediaCodec != null) {
                this.mMediaCodec.start();
            }
            this.outputFile = new File(filename);
            this.touch(this.outputFile);
            try {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.outputFile));
                Logging.i(this.TAG, "outputStream initialized");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mCodecString == "audio/3gpp") {
                byte[] header = new byte[]{35, 33, 65, 77, 82, 10};
                this.outputStream.write(header);
            } else if (this.mCodecString == "audio/amr-wb") {
                byte[] header = new byte[]{35, 33, 65, 77, 82, 45, 87, 66, 10};
                this.outputStream.write(header);
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when creating aac file encoder");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void setChannelCount(int channels) {
        try {
            this.mTrackFormat.setInteger("channel-count", channels);
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when setting aac file encoder channel count");
            e.printStackTrace();
        }
    }

    public void setSampleRate(int sample_rate) {
        try {
            this.mTrackFormat.setInteger("sample-rate", sample_rate);
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when setting aac file encoder sample rate");
            e.printStackTrace();
        }
    }

    public void releaseStreaming() {
        try {
            if (this.mMediaCodec != null) {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when releasing aac file encoder");
            e.printStackTrace();
        }
    }

    public void encodeFrame(byte[] data) {
        try {
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(2000L);
            if (inputBufferIndex != -1) {
                ByteBuffer inputBuffer;
                if (Build.VERSION.SDK_INT >= 21) {
                    inputBuffer = this.mMediaCodec.getInputBuffer(inputBufferIndex);
                } else {
                    this.mInputBuffers = this.mMediaCodec.getInputBuffers();
                    inputBuffer = this.mInputBuffers[inputBufferIndex];
                }
                inputBuffer.clear();
                inputBuffer.put(data);
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, data.length, 0L, 0);
            }
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int outputBufferIndex = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            while (outputBufferIndex >= 0) {
                byte[] outData;
                ByteBuffer outputBuffer;
                int outBitsSize = bufferInfo.size;
                if (Build.VERSION.SDK_INT >= 21) {
                    outputBuffer = this.mMediaCodec.getOutputBuffer(outputBufferIndex);
                } else {
                    this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                    outputBuffer = this.mOutputBuffers[outputBufferIndex];
                }
                outputBuffer.position(bufferInfo.offset);
                outputBuffer.limit(bufferInfo.offset + outBitsSize);
                if (this.mCodecString == "audio/mp4a-latm") {
                    int outPacketSize = outBitsSize + 7;
                    outData = new byte[outPacketSize];
                    this.addADTStoPacket(outData, outPacketSize);
                    outputBuffer.get(outData, 7, outBitsSize);
                    outputBuffer.position(bufferInfo.offset);
                    this.outputStream.write(outData, 0, outData.length);
                } else if (this.mCodecString == "audio/3gpp" || this.mCodecString == "audio/amr-wb") {
                    outData = new byte[outBitsSize];
                    outputBuffer.get(outData, 0, outBitsSize);
                    outputBuffer.position(bufferInfo.offset);
                    this.outputStream.write(outData, 0, outData.length);
                }
                this.mMediaCodec.releaseOutputBuffer(outputBufferIndex, false);
                outputBufferIndex = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when encoding aac file");
            e.printStackTrace();
        }
    }

    private void addADTStoPacket(byte[] packet, int packetLen) {
        int profile = 2;
        int freqIdx = 5;
        int chanCfg = 1;
        packet[0] = -1;
        packet[1] = -7;
        packet[2] = (byte)((profile - 1 << 6) + (freqIdx << 2) + (chanCfg >> 2));
        packet[3] = (byte)(((chanCfg & 3) << 6) + (packetLen >> 11));
        packet[4] = (byte)((packetLen & 0x7FF) >> 3);
        packet[5] = (byte)(((packetLen & 7) << 5) + 31);
        packet[6] = -4;
    }

    private void touch(File f) {
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean createAACStreaming(int sampleRate, int channels, int encodeRate) {
        try {
            Logging.i(this.TAG, "Encoding aac with fs = " + sampleRate + ", bitrate = " + encodeRate);
            this.mAACEncoder = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
            this.mAACFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channels);
            int[] kAACProfiles = new int[]{2, 5, 39};
            this.mAACFormat.setInteger("aac-profile", 2);
            this.mAACFormat.setInteger("sample-rate", sampleRate);
            this.mAACFormat.setInteger("channel-count", channels);
            this.mAACFormat.setInteger("bitrate", encodeRate);
            this.mAACEncoder.configure(this.mAACFormat, null, null, 1);
            if (this.mAACEncoder != null) {
                this.mAACEncoder.start();
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when creating aac encode stream");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean setAACEncodeBitrate(int bitrate) {
        Logging.w(this.TAG, "Set hw aac bitrate = " + bitrate);
        try {
            if (this.mAACEncoder != null) {
                this.mAACEncoder.stop();
                this.mAACFormat.setInteger("bitrate", bitrate);
                this.mAACEncoder.configure(this.mAACFormat, null, null, 1);
                this.mAACEncoder.start();
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when setting aac encode bitrate");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void releaseAACStreaming() {
        try {
            if (this.mAACEncoder != null) {
                this.mAACEncoder.stop();
                this.mAACEncoder.release();
                this.mAACEncoder = null;
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when releasing aac encode stream");
            e.printStackTrace();
        }
    }

    public int encodeAACFrame(byte[] data) {
        int encoded_size = 0;
        try {
            MediaCodec.BufferInfo bufferInfo;
            int outputBufferIndex;
            int inputBufferIndex = this.mAACEncoder.dequeueInputBuffer(2000L);
            if (inputBufferIndex != -1) {
                ByteBuffer inputBuffer;
                if (Build.VERSION.SDK_INT >= 21) {
                    inputBuffer = this.mAACEncoder.getInputBuffer(inputBufferIndex);
                } else {
                    this.mAACInputBuffers = this.mAACEncoder.getInputBuffers();
                    inputBuffer = this.mAACInputBuffers[inputBufferIndex];
                }
                inputBuffer.clear();
                inputBuffer.put(data);
                this.mAACEncoder.queueInputBuffer(inputBufferIndex, 0, data.length, 0L, 0);
            }
            if ((outputBufferIndex = this.mAACEncoder.dequeueOutputBuffer(bufferInfo = new MediaCodec.BufferInfo(), 0L)) >= 0) {
                ByteBuffer outputBuffer;
                int outBitsSize = bufferInfo.size;
                if (Build.VERSION.SDK_INT >= 21) {
                    outputBuffer = this.mAACEncoder.getOutputBuffer(outputBufferIndex);
                } else {
                    this.mAACOutputBuffers = this.mAACEncoder.getOutputBuffers();
                    outputBuffer = this.mAACOutputBuffers[outputBufferIndex];
                }
                encoded_size = (bufferInfo.flags & 2) == 2 ? 0 : bufferInfo.size;
                outputBuffer.position(bufferInfo.offset);
                outputBuffer.limit(bufferInfo.offset + outBitsSize);
                this.mAACEncodedBuffer.position(0);
                this.mAACEncodedBuffer.put(outputBuffer);
                this.mAACEncoder.releaseOutputBuffer(outputBufferIndex, false);
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when encoding aac stream");
            e.printStackTrace();
        }
        return encoded_size;
    }
}

