/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import io.agora.rtc.internal.Logging;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;

public class MediaCodecAudioDecoder {
    private Context mContext = null;
    private MediaCodec mMediaCodec = null;
    private MediaExtractor mExtractor = null;
    private MediaFormat mTrackFormat = null;
    private boolean mDecodedDataReady = false;
    private boolean eoInputStream = false;
    private boolean eoOutputStream = false;
    private int mSampleRate = 44100;
    private int mChannels = 2;
    private long mFileLength;
    private int mRetryCount = 0;
    private static int MAX_DECODER_RETRY_COUNT = 300;
    private static int HTTP_REQUEST_TIMEOUT = 3000;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private ByteBuffer mDecodedRAWBuffer;
    private MediaCodec mAACDecoder = null;
    private ByteBuffer mAACOutputBuffer = ByteBuffer.allocateDirect(4096);
    private String TAG = "MediaCodec Audio Decoder";

    public boolean createStreaming(String filename) {
        try {
            int i;
            Logging.i(this.TAG, "Try to decode audio file : " + filename);
            this.mRetryCount = 0;
            String assets_prefix = "/assets/";
            boolean isAssets = filename.startsWith(assets_prefix);
            boolean isHttp = filename.toLowerCase().startsWith("http");
            this.mExtractor = new MediaExtractor();
            if (isAssets) {
                if (this.mContext == null) {
                    return false;
                }
                AssetFileDescriptor afd = this.mContext.getAssets().openFd(filename.substring(assets_prefix.length()));
                this.mExtractor.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            } else if (isHttp) {
                try {
                    HttpURLConnection.setFollowRedirects(false);
                    HttpURLConnection con = (HttpURLConnection)new URL(filename).openConnection();
                    con.setConnectTimeout(HTTP_REQUEST_TIMEOUT);
                    con.setReadTimeout(HTTP_REQUEST_TIMEOUT);
                    con.connect();
                    if (con.getResponseCode() != 200) {
                        return false;
                    }
                    this.mExtractor.setDataSource(filename);
                }
                catch (SocketTimeoutException e) {
                    Logging.e(this.TAG, "Connect timeout on URL : " + filename);
                    return false;
                }
                catch (IOException e) {
                    Logging.e(this.TAG, "Connect IOException on URL : " + filename);
                    return false;
                }
            } else {
                this.mExtractor.setDataSource(filename);
            }
            int nTracks = this.mExtractor.getTrackCount();
            for (i = 0; i < nTracks; ++i) {
                this.mExtractor.unselectTrack(i);
            }
            for (i = 0; i < nTracks; ++i) {
                this.mTrackFormat = this.mExtractor.getTrackFormat(i);
                String mimeType = this.mTrackFormat.getString("mime");
                if (!mimeType.contains("audio/")) continue;
                this.mExtractor.selectTrack(i);
                this.mMediaCodec = MediaCodec.createDecoderByType((String)mimeType);
                this.mMediaCodec.configure(this.mTrackFormat, null, null, 0);
                break;
            }
            if (this.mMediaCodec != null) {
                this.mMediaCodec.start();
            }
            this.mChannels = this.mTrackFormat.getInteger("channel-count");
            this.mSampleRate = this.mTrackFormat.getInteger("sample-rate");
            this.mFileLength = this.mTrackFormat.getLong("durationUs");
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when creating aac audio file decoder");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int getChannelCount() {
        return this.mChannels;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public long getFileLength() {
        return this.mFileLength;
    }

    public long getCurrentFilePosition() {
        return this.mExtractor.getSampleTime();
    }

    public void setCurrentFilePosition(long position) {
        this.mExtractor.seekTo(position, 2);
    }

    public boolean getDecodeDataReadyFlag() {
        return this.mDecodedDataReady;
    }

    public void releaseStreaming() {
        try {
            if (this.mMediaCodec != null) {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            if (this.mExtractor != null) {
                this.mExtractor.release();
                this.mExtractor = null;
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when releasing audio file stream");
            e.printStackTrace();
        }
        this.eoOutputStream = false;
        this.eoInputStream = false;
    }

    public void rewindStreaming() {
        try {
            this.mExtractor.seekTo(0L, 1);
            this.mMediaCodec.flush();
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when rewinding audio file stream");
            e.printStackTrace();
        }
        this.eoInputStream = false;
        this.eoOutputStream = false;
        this.mDecodedDataReady = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeFrame() {
        try {
            int index;
            if (!this.eoInputStream && (index = this.mMediaCodec.dequeueInputBuffer(0L)) >= 0) {
                ByteBuffer buf;
                if (Build.VERSION.SDK_INT >= 21) {
                    buf = this.mMediaCodec.getInputBuffer(index);
                } else {
                    this.mInputBuffers = this.mMediaCodec.getInputBuffers();
                    buf = this.mInputBuffers[index];
                }
                int sampleSize = this.mExtractor.readSampleData(buf, 0);
                if (sampleSize <= 0) {
                    sampleSize = 0;
                    this.eoInputStream = true;
                }
                long presentationTimeUs = this.mExtractor.getSampleTime();
                int flags = this.mExtractor.getSampleFlags();
                if (this.eoInputStream) {
                    flags |= 4;
                }
                this.mMediaCodec.queueInputBuffer(index, 0, sampleSize, presentationTimeUs, flags);
                this.mExtractor.advance();
            }
            if (this.eoOutputStream) return this.eoOutputStream;
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int index2 = this.mMediaCodec.dequeueOutputBuffer(info, 0L);
            this.mDecodedDataReady = false;
            switch (index2) {
                case -3: {
                    return this.eoOutputStream;
                }
                case -2: {
                    return this.eoOutputStream;
                }
                case -1: {
                    ++this.mRetryCount;
                    if (this.mRetryCount < MAX_DECODER_RETRY_COUNT || !Build.BRAND.toLowerCase().contains("meizu") && !Build.MANUFACTURER.toLowerCase().contains("meizu") && !Build.BRAND.toLowerCase().contains("vivo") && !Build.MANUFACTURER.toLowerCase().contains("vivo")) return this.eoOutputStream;
                    Logging.e(this.TAG, "EAGAIN count=" + this.mRetryCount + " presentationTimeUs=" + info.presentationTimeUs + " totalUs=" + this.mFileLength + " Force EOS");
                    this.eoOutputStream = true;
                    return this.eoOutputStream;
                }
                default: {
                    this.mRetryCount = 0;
                    if (index2 < 0) return this.eoOutputStream;
                    if ((info.flags & 4) == 4) {
                        this.eoOutputStream = true;
                    }
                    if (Build.VERSION.SDK_INT >= 21) {
                        ByteBuffer buf = this.mMediaCodec.getOutputBuffer(index2);
                        this.cloneByteBuffer(buf);
                    } else {
                        this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                        ByteBuffer buf = this.mOutputBuffers[index2];
                        this.cloneByteBufferByLength(buf, info.size);
                    }
                    this.mMediaCodec.releaseOutputBuffer(index2, false);
                    this.mDecodedDataReady = true;
                }
            }
            return this.eoOutputStream;
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when decoding audio file stream");
            e.printStackTrace();
        }
        return this.eoOutputStream;
    }

    private boolean checkInfoChange() {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        try {
            MediaFormat curr_format = this.mMediaCodec.getOutputFormat();
            int curr_rate = curr_format.getInteger("sample-rate");
            int curr_channels = curr_format.getInteger("channel-count");
            boolean change = this.mSampleRate != curr_rate || this.mChannels != curr_channels;
            this.mSampleRate = curr_rate;
            this.mChannels = curr_channels;
            return change;
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when checking file's new format");
            e.printStackTrace();
            return false;
        }
    }

    private void cloneByteBuffer(ByteBuffer original) {
        try {
            if (this.mDecodedRAWBuffer == null || this.mDecodedRAWBuffer.limit() != original.limit()) {
                if (this.mDecodedRAWBuffer != null) {
                    this.mDecodedRAWBuffer.clear();
                    this.mDecodedRAWBuffer = null;
                }
                this.mDecodedRAWBuffer = ByteBuffer.allocateDirect(original.limit());
            }
            this.mDecodedRAWBuffer.position(0);
            this.mDecodedRAWBuffer.put(original);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cloneByteBufferByLength(ByteBuffer original, int length) {
        try {
            if (this.mDecodedRAWBuffer == null || this.mDecodedRAWBuffer.capacity() < length) {
                if (this.mDecodedRAWBuffer != null) {
                    this.mDecodedRAWBuffer.clear();
                    this.mDecodedRAWBuffer = null;
                }
                this.mDecodedRAWBuffer = ByteBuffer.allocateDirect(length);
            }
            this.mDecodedRAWBuffer.position(0);
            original.limit(length);
            this.mDecodedRAWBuffer.put(original);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean checkAACSupported() {
        boolean supported;
        block5: {
            supported = true;
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    MediaCodecInfo[] codecInfos;
                    MediaCodecList codecList = new MediaCodecList(1);
                    for (MediaCodecInfo codecInfo : codecInfos = codecList.getCodecInfos()) {
                        String name;
                        if (codecInfo.isEncoder() || !(name = codecInfo.getName().toLowerCase()).contains("nvidia")) continue;
                        supported = false;
                        break block5;
                    }
                    break block5;
                }
                int numCodecs = MediaCodecList.getCodecCount();
                for (int i = 0; i < numCodecs; ++i) {
                    String name;
                    MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
                    if (codecInfo.isEncoder() || !(name = codecInfo.getName().toLowerCase()).contains("nvidia")) continue;
                    supported = false;
                    break;
                }
            }
            catch (Exception e) {
                Logging.e(this.TAG, "Error when checking aac codec availability");
                e.printStackTrace();
                return false;
            }
        }
        return supported;
    }

    public boolean createAACStreaming(int sample_rate) {
        try {
            this.mAACDecoder = MediaCodec.createDecoderByType((String)"audio/mp4a-latm");
            MediaFormat aacFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sample_rate, (int)1);
            aacFormat.setInteger("sample-rate", sample_rate);
            aacFormat.setInteger("channel-count", 1);
            byte[] csd = new byte[]{18, -120};
            ByteBuffer csdBuf = ByteBuffer.wrap(csd);
            aacFormat.setByteBuffer("csd-0", csdBuf);
            this.mAACDecoder.configure(aacFormat, null, null, 0);
            if (this.mAACDecoder != null) {
                this.mAACDecoder.start();
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when creating aac decode stream");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void releaseAACStreaming() {
        try {
            if (this.mAACDecoder != null) {
                this.mAACDecoder.stop();
                this.mAACDecoder.release();
                this.mAACDecoder = null;
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when releasing aac decode stream");
            e.printStackTrace();
        }
    }

    public int decodeAACFrame(byte[] encoded_data) {
        int bytes = 0;
        try {
            int index = this.mAACDecoder.dequeueInputBuffer(200L);
            if (index >= 0) {
                ByteBuffer buf;
                if (Build.VERSION.SDK_INT >= 21) {
                    buf = this.mAACDecoder.getInputBuffer(index);
                } else {
                    ByteBuffer[] bufs = this.mAACDecoder.getInputBuffers();
                    buf = bufs[index];
                }
                buf.clear();
                buf.put(encoded_data);
                this.mAACDecoder.queueInputBuffer(index, 0, encoded_data.length, 0L, 0);
            }
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            index = this.mAACDecoder.dequeueOutputBuffer(info, 0L);
            switch (index) {
                case -3: {
                    break;
                }
                case -2: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (index >= 0) {
                        ByteBuffer buf;
                        if (Build.VERSION.SDK_INT >= 21) {
                            buf = this.mAACDecoder.getOutputBuffer(index);
                        } else {
                            ByteBuffer[] bufs = this.mAACDecoder.getOutputBuffers();
                            buf = bufs[index];
                        }
                        bytes = info.size;
                        this.mAACOutputBuffer.position(0);
                        buf.limit(bytes);
                        this.mAACOutputBuffer.put(buf);
                        this.mAACDecoder.releaseOutputBuffer(index, false);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Logging.e(this.TAG, "Error when decoding aac stream");
            e.printStackTrace();
        }
        return bytes;
    }
}

