/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;

class AudioManagerAndroid {
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAMES_PER_BUFFER = 256;
    private int mNativeOutputSampleRate;
    private boolean mAudioLowLatencySupported;
    private int mAudioLowLatencyOutputFrameSize;
    private AudioManager audioManager;

    private AudioManagerAndroid(Context context) {
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.mNativeOutputSampleRate = 44100;
        this.mAudioLowLatencyOutputFrameSize = 256;
        if (Build.VERSION.SDK_INT >= 17) {
            String framesPerBuffer;
            String sampleRateString = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            if (sampleRateString != null) {
                this.mNativeOutputSampleRate = Integer.parseInt(sampleRateString);
            }
            if ((framesPerBuffer = this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) != null) {
                this.mAudioLowLatencyOutputFrameSize = Integer.parseInt(framesPerBuffer);
            }
        }
        this.mAudioLowLatencySupported = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private int getNativeOutputSampleRate() {
        return this.mNativeOutputSampleRate;
    }

    private boolean isAudioLowLatencySupported() {
        return this.mAudioLowLatencySupported;
    }

    private int getAudioLowLatencyOutputFrameSize() {
        return this.mAudioLowLatencyOutputFrameSize;
    }

    private int QuerySpeakerStatus() {
        if (this.audioManager.isBluetoothScoOn()) {
            return 5;
        }
        if (this.audioManager.isWiredHeadsetOn()) {
            return 0;
        }
        if (this.audioManager.isSpeakerphoneOn()) {
            return 3;
        }
        return 1;
    }

    private int SetPlayoutSpeaker(boolean loudspeakerOn) {
        this.audioManager.setSpeakerphoneOn(loudspeakerOn);
        return 0;
    }

    private int SetAudioMode(int mode) {
        switch (mode) {
            case 0: {
                this.audioManager.setMode(0);
                break;
            }
            case 1: {
                this.audioManager.setMode(1);
                break;
            }
            case 2: {
                this.audioManager.setMode(2);
                break;
            }
            case 3: {
                this.audioManager.setMode(3);
                break;
            }
            default: {
                this.audioManager.setMode(0);
            }
        }
        return 0;
    }

    private int GetAudioMode(int mode) {
        return this.audioManager.getMode();
    }
}

