/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRecordingConfiguration;
import android.media.AudioTimestamp;
import android.media.AudioTrack;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.os.Build;
import android.os.Process;
import io.agora.rtc.internal.Logging;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

class AudioDevice {
    final String TAG = "AudioDevice Java";
    private final int _MaxRecPlay10msBlocks = 4;
    private AudioTrack _audioTrack = null;
    private AudioRecord _audioRecord = null;
    private Context _context;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private ByteBuffer _recBuffer;
    private byte[] _tempBufPlay;
    private byte[] _tempBufRec;
    private final ReentrantLock _playLock = new ReentrantLock();
    private final ReentrantLock _recLock = new ReentrantLock();
    private boolean _doPlayInit = true;
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private boolean _isPlaying = false;
    private int _bufferedRecSamples = 0;
    private int _bufferedPlaySamples = 0;
    private int _playPosition = 0;
    private int _playbackSampleRate = 0;
    private int _playBufSize = 0;
    private int _playbackRestartCount = 0;
    private int _recordSampleRate = 0;
    private int _recordChannel = 0;
    private int _playChannel = 0;
    private int _recordBufSize = 0;
    private int _recordSource = 0;
    private int _recordRestartCount = 0;
    private boolean _renderStart = false;
    private long _firstRenderTS = 0L;
    private int _playPreviousUnderrun = 0;
    private long _recDelay = 10L;
    private long _lastRecDelay = 0L;
    private long _recStartTS = 0L;
    private int _recStartDelay = 0;
    private AcousticEchoCanceler aec = null;
    private boolean useBuiltInAEC = false;
    private int _streamType = 0;
    private int playWriten = 0;
    private int maxDelay = 0;
    private int totalDelay = 0;

    AudioDevice() {
        try {
            this._playBuffer = ByteBuffer.allocateDirect(7680);
            this._recBuffer = ByteBuffer.allocateDirect(7680);
        }
        catch (Exception e) {
            Logging.e("AudioDevice Java", "failed to allocate bytebuffer", e);
        }
        this._tempBufPlay = new byte[7680];
        this._tempBufRec = new byte[7680];
    }

    private boolean BuiltInAECIsAvailable() {
        try {
            if (Build.VERSION.SDK_INT >= 17) {
                return AcousticEchoCanceler.isAvailable();
            }
        }
        catch (ExceptionInInitializerError eii) {
            Logging.e("AudioDevice Java", "Unable to create AEC object ", eii);
        }
        catch (Exception e) {
            Logging.e("AudioDevice Java", "Unable to query Audio Effect: Acoustic Echo Cancellation");
        }
        return false;
    }

    private int GetPreferedSampleRate() {
        int SR = 0;
        try {
            if (this._audioManager == null && this._context != null) {
                this._audioManager = (AudioManager)this._context.getSystemService("audio");
            }
            String nativeSampleRate = this._audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            SR = Integer.parseInt(nativeSampleRate);
        }
        catch (Exception e) {
            Logging.e("AudioDevice Java", "GetPreferedSampleRate error", e);
        }
        if (SR == 0) {
            SR = 16000;
        }
        return SR;
    }

    private boolean EnableBuiltInAEC(boolean enable) {
        if (Build.VERSION.SDK_INT <= 18) {
            return false;
        }
        this.useBuiltInAEC = enable;
        if (this.aec != null) {
            int ret = this.aec.setEnabled(enable);
            if (ret != 0) {
                Logging.e("AudioDevice Java", "AcousticEchoCanceler.setEnabled failed");
                return false;
            }
            Logging.e("AudioDevice Java", "AcousticEchoCanceler.getEnabled: " + this.aec.getEnabled());
        }
        return true;
    }

    private boolean BuiltInAECIsEnabled() {
        return this.useBuiltInAEC;
    }

    private int InitRecording(int audioSource, int sampleRate, int recChannel) {
        int minRecBufSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)(recChannel == 2 ? 12 : 16), (int)2);
        Logging.d("AudioDevice Java", "Java minimum recording buffer size is " + minRecBufSize);
        int recBufSize = minRecBufSize * 2;
        this._bufferedRecSamples = 5 * sampleRate / 200;
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        try {
            this._audioRecord = new AudioRecord(audioSource, sampleRate, recChannel == 2 ? 12 : 16, 2, recBufSize);
        }
        catch (Exception e) {
            Logging.e("AudioDevice Java", "Unable to new AudioRecord: ", e);
            return -1;
        }
        if (this._audioRecord.getState() != 1) {
            Logging.e("AudioDevice Java", "Java recording not initialized " + sampleRate);
            return -2;
        }
        this._recordSampleRate = sampleRate;
        this._recordChannel = recChannel;
        this._recordSource = audioSource;
        this._recordBufSize = recBufSize;
        this._recordRestartCount = 0;
        Logging.d("AudioDevice Java", "Java recording sample rate set to " + sampleRate);
        Logging.d("AudioDevice Java", "AcousticEchoCanceler.isAvailable: " + this.BuiltInAECIsAvailable());
        if (!this.BuiltInAECIsAvailable()) {
            return this._bufferedRecSamples;
        }
        this.aec = AcousticEchoCanceler.create((int)this._audioRecord.getAudioSessionId());
        if (this.aec == null) {
            Logging.e("AudioDevice Java", "AcousticEchoCanceler.create failed");
        } else {
            AudioEffect.Descriptor descriptor = this.aec.getDescriptor();
            Logging.d("AudioDevice Java", "AcousticEchoCanceler name: " + descriptor.name + ", implementor: " + descriptor.implementor + ", uuid: " + descriptor.uuid);
            this.EnableBuiltInAEC(this.useBuiltInAEC);
        }
        return this._bufferedRecSamples;
    }

    private int StartRecording() {
        try {
            if (this._audioRecord == null) {
                return -2;
            }
            this._audioRecord.startRecording();
            Logging.e("AudioDevice Java", "Recording start time " + System.nanoTime());
            this._recStartTS = System.nanoTime();
            this._recStartDelay = 0;
            this._recDelay = 10L;
        }
        catch (IllegalStateException e) {
            Logging.e("AudioDevice Java", "failed to startRecording", e);
            return -1;
        }
        catch (Exception e) {
            Logging.e("AudioDevice Java", "failed to startRecording Exception", e);
            return -2;
        }
        this._isRecording = true;
        return 0;
    }

    private int CheckAudioStatus(int isPlayOut) {
        int ret = 0;
        if (Build.VERSION.SDK_INT >= 24) {
            if (this._audioManager == null) {
                if (this._context != null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                } else {
                    Logging.e("AudioDevice Java", "CheckAudioStatus error");
                    return -1;
                }
            }
            if (isPlayOut == 0) {
                if (this._audioManager != null) {
                    int myID = -1;
                    if (this._audioRecord != null) {
                        myID = this._audioRecord.getAudioSessionId();
                    }
                    List configs = this._audioManager.getActiveRecordingConfigurations();
                    for (AudioRecordingConfiguration cfg : configs) {
                        if (cfg.getClientAudioSessionId() == myID) continue;
                        ret = 1033;
                    }
                } else {
                    Logging.e("AudioDevice Java", "CheckAudioStatus unkonwn error");
                    return -1;
                }
            }
        }
        return ret;
    }

    private int InitPlayback(int sampleRate, int playChannel, int streamType, int profiledMiniOutBufferMs) {
        this._streamType = streamType;
        int profiledMiniOutBufferSize = profiledMiniOutBufferMs * sampleRate * playChannel * 2 / 1000;
        int minPlayBufSize = AudioTrack.getMinBufferSize((int)sampleRate, (int)(playChannel == 2 ? 12 : 4), (int)2);
        Logging.d("AudioDevice Java", "Java minimum playback buffer size is " + minPlayBufSize + ", profiledMiniOutBufferSize is " + profiledMiniOutBufferSize + " stream type " + this._streamType);
        int playBufSize = minPlayBufSize * 2;
        if (playBufSize < profiledMiniOutBufferSize) {
            playBufSize = profiledMiniOutBufferSize;
        }
        this._bufferedPlaySamples = 0;
        Logging.d("AudioDevice Java", "Java playback buffer size is " + playBufSize + ", duration is " + playBufSize * 1000 / (sampleRate * playChannel * 2) + " ms");
        if (this._audioTrack != null) {
            this._audioTrack.release();
            this._audioTrack = null;
        }
        try {
            this._audioTrack = new AudioTrack(this._streamType, sampleRate, playChannel == 2 ? 12 : 4, 2, playBufSize, 1);
        }
        catch (Exception e) {
            Logging.e("AudioDevice Java", "Unable to new AudioTrack: ", e);
            return -1;
        }
        this._playbackSampleRate = sampleRate;
        this._playChannel = playChannel;
        this._playBufSize = playBufSize;
        this._playbackRestartCount = 0;
        if (this._audioTrack.getState() != 1) {
            Logging.e("AudioDevice Java", "Java playback not initialized " + sampleRate);
            return -1;
        }
        Logging.d("AudioDevice Java", "Java play sample rate is set to " + sampleRate);
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            return 0;
        }
        return this._audioManager.getStreamMaxVolume(this._streamType);
    }

    private int StartPlayback() {
        this._firstRenderTS = 0L;
        this._renderStart = false;
        try {
            this.playWriten = 0;
            this._audioTrack.play();
            this.maxDelay = 0;
            this.totalDelay = 0;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return -1;
        }
        catch (Exception e) {
            Logging.e("AudioDevice Java", "startplayback fail", e);
            return -1;
        }
        this._isPlaying = true;
        return 0;
    }

    private int StopRecording() {
        this._recLock.lock();
        try {
            if (this._audioRecord.getRecordingState() == 3) {
                this._audioRecord.stop();
            }
            if (this.aec != null) {
                this.aec.release();
                this.aec = null;
            }
            this._audioRecord.release();
            this._audioRecord = null;
        }
        catch (Exception e) {
            Logging.e("AudioDevice Java", "error in StopRecording ", e);
        }
        finally {
            if (this._audioRecord != null) {
                this._audioRecord.release();
                this._audioRecord = null;
            }
            this._doRecInit = true;
            this._recLock.unlock();
        }
        this._isRecording = false;
        return 0;
    }

    private int StopPlayback() {
        this._firstRenderTS = 0L;
        this._playLock.lock();
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                this._audioTrack.setVolume(0.0f);
            } else {
                this._audioTrack.setStereoVolume(0.0f, 0.0f);
            }
            if (this._audioTrack.getPlayState() == 3) {
                this._audioTrack.stop();
                this._audioTrack.flush();
            }
            this._audioTrack.release();
            this._audioTrack = null;
        }
        catch (IllegalStateException e) {
            Logging.e("AudioDevice Java", "Unable to stop playback: ", e);
            int n = -1;
            return n;
        }
        catch (Exception e) {
            Logging.e("AudioDevice Java", "Stop playback fail", e);
        }
        finally {
            if (this._audioTrack != null) {
                this._audioTrack.flush();
                this._audioTrack.release();
                this._audioTrack = null;
            }
            this._doPlayInit = true;
            this._playLock.unlock();
        }
        this._isPlaying = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int PlayAudio(int lengthInBytes) {
        int bufferedSamples;
        block19: {
            bufferedSamples = 0;
            this._playLock.lock();
            try {
                if (this._audioTrack == null) {
                    int n = -2;
                    return n;
                }
                if (this._doPlayInit) {
                    try {
                        Process.setThreadPriority((int)-19);
                    }
                    catch (Exception e) {
                        Logging.e("AudioDevice Java", "Set play thread priority failed: ", e);
                    }
                    this._doPlayInit = false;
                }
                int written = 0;
                this._playBuffer.get(this._tempBufPlay);
                written = this._audioTrack.write(this._tempBufPlay, 0, lengthInBytes);
                this._playBuffer.rewind();
                this._bufferedPlaySamples += written >> 1;
                this.playWriten += written;
                int pos = this._audioTrack.getPlaybackHeadPosition() * this._playChannel;
                int n = this.maxDelay = (this.playWriten / 2 - pos) / 2 / 48 > this.maxDelay ? (this.playWriten / 2 - pos) / 2 / 48 : this.maxDelay;
                if (this._firstRenderTS == 0L) {
                    this._firstRenderTS = System.currentTimeMillis();
                }
                if (pos > 0 && !this._renderStart) {
                    this._firstRenderTS = System.currentTimeMillis() - this._firstRenderTS;
                    Logging.e("AudioDevice Java", "caculated the first render TS = " + this._firstRenderTS + " pos = " + pos / 2 / 48 + "ms delay " + (this._firstRenderTS + (long)this.maxDelay));
                    this._renderStart = true;
                }
                if (this._renderStart) {
                    this.totalDelay = (int)this._firstRenderTS + this.maxDelay;
                }
                if (pos < this._playPosition) {
                    this._playPosition = 0;
                }
                this._bufferedPlaySamples -= pos - this._playPosition;
                this._playPosition = pos;
                if (!this._isRecording) {
                    bufferedSamples = this._bufferedPlaySamples;
                }
                if (written == lengthInBytes) break block19;
                if (this._playbackRestartCount > 20) {
                    int n2 = written;
                    return n2;
                }
                Logging.e("AudioDevice Java", "Error writing AudioTrack! Restart AudioTrack " + this._playbackRestartCount);
                ++this._playbackRestartCount;
                this._audioTrack.stop();
                this._audioTrack.release();
                this._audioTrack = null;
                try {
                    this._audioTrack = new AudioTrack(this._streamType, this._playbackSampleRate, this._playChannel == 2 ? 12 : 4, 2, this._playBufSize, 1);
                    this._audioTrack.play();
                }
                catch (Exception e) {
                    Logging.e("AudioDevice Java", "restart audio fail", e);
                }
                int n3 = written;
                return n3;
            }
            catch (Exception e) {
                Logging.e("AudioDevice Java", "PlayAudio got fatal error ", e);
            }
            finally {
                this._playLock.unlock();
            }
        }
        return bufferedSamples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int RecordAudio(int lengthInBytes) {
        this._recLock.lock();
        int ret = this._bufferedPlaySamples;
        try {
            if (this._audioRecord == null) {
                int n = -4;
                return n;
            }
            if (this._doRecInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception e) {
                    Logging.e("AudioDevice Java", "Set rec thread priority failed: ", e);
                }
                this._doRecInit = false;
            }
            int readBytes = 0;
            this._recBuffer.rewind();
            readBytes = this._audioRecord.read(this._tempBufRec, 0, lengthInBytes);
            this._recBuffer.put(this._tempBufRec);
            if (this._recDelay == 10L) {
                if (Build.VERSION.SDK_INT >= 24) {
                    AudioTimestamp ts = new AudioTimestamp();
                    this._audioRecord.getTimestamp(ts, 0);
                    this._recDelay = (System.nanoTime() - ts.nanoTime) / 1000L / 1000L;
                    if (this._recDelay > 50L) {
                        this._recDelay = 10L;
                    }
                } else {
                    this._recDelay = 10L;
                }
                if (this._recStartDelay == 0) {
                    this._recStartDelay = (int)(System.nanoTime() - this._recStartTS) / 1000 / 1000;
                }
                this._recDelay += (long)this._recStartDelay;
            }
            if (this._lastRecDelay != this._recDelay) {
                if (Build.VERSION.SDK_INT >= 23) {
                    int frames = this._audioRecord.getBufferSizeInFrames();
                    Logging.i("AudioDevice Java", "frames  " + frames + " recDelay " + this._recDelay + " caculated frames delay " + frames / (this._audioRecord.getSampleRate() / 1000));
                } else {
                    Logging.i("AudioDevice Java", "_recDelay: " + this._recDelay);
                }
                this._lastRecDelay = this._recDelay;
            }
            if (readBytes != lengthInBytes) {
                if (this._recordRestartCount % 10 == 0) {
                    Logging.e("AudioDevice Java", "Error reading AudioRecord! AudioRecord.read returns " + readBytes);
                }
                ++this._recordRestartCount;
                this._audioRecord.stop();
                this._audioRecord.release();
                this._audioRecord = null;
                this._audioRecord = new AudioRecord(this._recordSource, this._recordSampleRate, this._recordChannel == 2 ? 12 : 16, 2, this._recordBufSize);
                this._audioRecord.startRecording();
                this._recStartTS = System.nanoTime();
                this._recStartDelay = 0;
                int n = readBytes;
                return n;
            }
        }
        catch (Exception e) {
            ret = -10;
            Logging.e("AudioDevice Java", "RecordAudio try failed: ", e);
        }
        finally {
            this._recLock.unlock();
        }
        return ret;
    }

    private int GetUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.GetUnderrunCountOnNougatOrHigher();
        }
        return this.GetUnderrunCountOnLowerThanNougat();
    }

    @TargetApi(value=24)
    private int GetUnderrunCountOnNougatOrHigher() {
        int periodUnderrun = 0;
        int currentUnderrun = 0;
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                currentUnderrun = this._audioTrack.getUnderrunCount();
            }
            catch (Exception e) {
                Logging.e("AudioDevice Java", "getUnderrun fail ", e);
            }
            periodUnderrun = currentUnderrun - this._playPreviousUnderrun;
            if (periodUnderrun < 0) {
                periodUnderrun = 0;
            }
            this._playPreviousUnderrun = currentUnderrun;
            if (periodUnderrun > 0) {
                Logging.d("AudioDevice Java", "Android AudioTrack underrun count: " + periodUnderrun);
            }
        }
        return periodUnderrun;
    }

    private int GetUnderrunCountOnLowerThanNougat() {
        return -1;
    }

    private int QuerySpeakerStatus() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            Logging.e("AudioDevice Java", "Could not get audio routing - no audio manager");
            return -1;
        }
        if (this._audioManager.isBluetoothA2dpOn()) {
            return 5;
        }
        if (this._audioManager.isSpeakerphoneOn()) {
            return 3;
        }
        if (this._audioManager.isBluetoothScoOn()) {
            return 5;
        }
        if (this._audioManager.isWiredHeadsetOn()) {
            return 0;
        }
        return 1;
    }

    private int SetPlayoutSpeaker(boolean loudspeakerOn) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
            return -1;
        }
        this._audioManager.setSpeakerphoneOn(loudspeakerOn);
        return 0;
    }

    private int SetPlayoutVolume(int level) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int retVal = -1;
        if (this._audioManager != null) {
            int maxVolume = this._audioManager.getStreamMaxVolume(this._streamType);
            level = level >= 255 ? maxVolume : level * maxVolume / 255;
            this._audioManager.setStreamVolume(this._streamType, level, 0);
            retVal = 0;
        }
        return retVal;
    }

    private int GetPlayoutVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int level = -1;
        if (this._audioManager != null) {
            level = this._audioManager.getStreamVolume(this._streamType);
        }
        return level;
    }

    private int GetPlayoutMaxVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int level = -1;
        if (this._audioManager != null) {
            level = this._audioManager.getStreamMaxVolume(this._streamType);
        }
        return level;
    }

    private int SetAudioMode(int mode) {
        try {
            if (this._audioManager == null && this._context != null) {
                this._audioManager = (AudioManager)this._context.getSystemService("audio");
            }
            if (this._audioManager == null) {
                Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
                return -1;
            }
            int mMediaMaxVolume = this._audioManager.getStreamMaxVolume(3);
            int mCurrMediaVolume = this._audioManager.getStreamVolume(3);
            int mCommMaxVolume = this._audioManager.getStreamMaxVolume(0);
            int mCurrCommVolume = this._audioManager.getStreamVolume(0);
            int factorX = mMediaMaxVolume - mCommMaxVolume;
            double delta = (double)mCommMaxVolume / (double)mMediaMaxVolume;
            if (this._audioManager.getMode() == mode) {
                return 0;
            }
            if (this._isPlaying) {
                Logging.e("AudioDevice Java", "_audioManager.getMode() = " + this._audioManager.getMode() + " target mode = " + mode + "factorX = " + factorX + "mMediaMaxVolume=" + mMediaMaxVolume + "mCommMaxVolume=" + mCommMaxVolume + "mCurrMediaVolume=" + mCurrMediaVolume + "mCurrCommVolume=" + mCurrCommVolume + "delta" + delta);
                if (mode == 3) {
                    int vol = mCurrCommVolume;
                    vol = factorX < 12 ? (mCurrMediaVolume - factorX < 1 ? 1 : mCurrMediaVolume - factorX) : (int)((double)mCurrMediaVolume * delta + 0.5);
                    vol = vol < 1 ? 1 : vol;
                    Logging.d("[Java AudioDevice] set voice call vol = " + vol);
                    this._audioManager.setStreamVolume(0, vol, 0);
                } else if (mode == 0) {
                    int vol = mCurrMediaVolume;
                    vol = factorX < 12 ? (mCurrCommVolume + factorX < mMediaMaxVolume ? mCurrCommVolume + factorX : mMediaMaxVolume) : (int)((double)mCurrCommVolume / delta + 0.5);
                    vol = vol < 1 ? 1 : vol;
                    this._audioManager.setStreamVolume(3, vol, 0);
                    Logging.d("[Java AudioDevice] set music vol = " + vol);
                }
            }
            switch (mode) {
                case 0: {
                    this._audioManager.setMode(0);
                    break;
                }
                case 1: {
                    this._audioManager.setMode(1);
                    break;
                }
                case 2: {
                    this._audioManager.setMode(2);
                    break;
                }
                case 3: {
                    this._audioManager.setMode(3);
                    break;
                }
                default: {
                    this._audioManager.setMode(0);
                    break;
                }
            }
        }
        catch (Exception e) {
            Logging.e("AudioDevice Java", "set audio mode failed! ");
        }
        return 0;
    }

    private int GetAudioMode() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
            return -1;
        }
        return this._audioManager.getMode();
    }

    private int GetNativeSampleRate() {
        String sampleRateString;
        int nativeOutputSampleRate = 44100;
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            Logging.w("AudioDevice Java", "Could not set audio mode - no audio manager");
            return nativeOutputSampleRate;
        }
        if (Build.VERSION.SDK_INT >= 17 && (sampleRateString = this._audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE")) != null) {
            nativeOutputSampleRate = Integer.parseInt(sampleRateString);
        }
        return nativeOutputSampleRate;
    }

    private int GetNativePlayDelay() {
        if (this._recDelay < 0L) {
            this._recDelay = -1L;
        }
        if (this.totalDelay < 0) {
            this.totalDelay = -1;
        }
        return this.totalDelay + (int)this._recDelay;
    }
}

