/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import android.graphics.Rect;
import io.agora.rtc.models.UserInfo;

public abstract class IRtcEngineEventHandler {
    public void onWarning(int warn) {
    }

    public void onError(int err) {
    }

    public void onJoinChannelSuccess(String channel, int uid, int elapsed) {
    }

    public void onRejoinChannelSuccess(String channel, int uid, int elapsed) {
    }

    public void onLeaveChannel(RtcStats stats) {
    }

    public void onClientRoleChanged(int oldRole, int newRole) {
    }

    public void onLocalUserRegistered(int uid, String userAccount) {
    }

    public void onUserInfoUpdated(int uid, UserInfo userInfo) {
    }

    public void onUserJoined(int uid, int elapsed) {
    }

    public void onUserOffline(int uid, int reason) {
    }

    public void onConnectionStateChanged(int state, int reason) {
    }

    @Deprecated
    public void onConnectionInterrupted() {
    }

    public void onConnectionLost() {
    }

    @Deprecated
    public void onConnectionBanned() {
    }

    public void onApiCallExecuted(int error, String api, String result) {
    }

    public void onTokenPrivilegeWillExpire(String token) {
    }

    public void onRequestToken() {
    }

    @Deprecated
    public void onMicrophoneEnabled(boolean enabled) {
    }

    public void onAudioVolumeIndication(AudioVolumeInfo[] speakers, int totalVolume) {
    }

    public void onActiveSpeaker(int uid) {
    }

    public void onFirstLocalAudioFrame(int elapsed) {
    }

    public void onFirstRemoteAudioFrame(int uid, int elapsed) {
    }

    @Deprecated
    public void onVideoStopped() {
    }

    public void onFirstLocalVideoFrame(int width, int height, int elapsed) {
    }

    @Deprecated
    public void onFirstRemoteVideoDecoded(int uid, int width, int height, int elapsed) {
    }

    public void onFirstRemoteVideoFrame(int uid, int width, int height, int elapsed) {
    }

    public void onUserMuteAudio(int uid, boolean muted) {
    }

    @Deprecated
    public void onUserMuteVideo(int uid, boolean muted) {
    }

    @Deprecated
    public void onUserEnableVideo(int uid, boolean enabled) {
    }

    @Deprecated
    public void onUserEnableLocalVideo(int uid, boolean enabled) {
    }

    public void onVideoSizeChanged(int uid, int width, int height, int rotation) {
    }

    public void onRemoteAudioStateChanged(int uid, int state, int reason, int elapsed) {
    }

    public void onRemoteVideoStateChanged(int uid, int state, int reason, int elapsed) {
    }

    public void onChannelMediaRelayStateChanged(int state, int code) {
    }

    public void onChannelMediaRelayEvent(int code) {
    }

    public void onLocalPublishFallbackToAudioOnly(boolean isFallbackOrRecover) {
    }

    public void onRemoteSubscribeFallbackToAudioOnly(int uid, boolean isFallbackOrRecover) {
    }

    public void onAudioRouteChanged(int routing) {
    }

    @Deprecated
    public void onCameraReady() {
    }

    public void onCameraFocusAreaChanged(Rect rect) {
    }

    public void onCameraExposureAreaChanged(Rect rect) {
    }

    @Deprecated
    public void onAudioQuality(int uid, int quality, short delay, short lost) {
    }

    public void onRtcStats(RtcStats stats) {
    }

    public void onLastmileQuality(int quality) {
    }

    public void onLastmileProbeResult(LastmileProbeResult result) {
    }

    public void onNetworkQuality(int uid, int txQuality, int rxQuality) {
    }

    public void onLocalVideoStats(LocalVideoStats stats) {
    }

    public void onRemoteVideoStats(RemoteVideoStats stats) {
    }

    public void onLocalAudioStats(LocalAudioStats stats) {
    }

    public void onRemoteAudioStats(RemoteAudioStats stats) {
    }

    @Deprecated
    public void onLocalVideoStat(int sentBitrate, int sentFrameRate) {
    }

    @Deprecated
    public void onRemoteVideoStat(int uid, int delay, int receivedBitrate, int receivedFrameRate) {
    }

    @Deprecated
    public void onRemoteAudioTransportStats(int uid, int delay, int lost, int rxKBitRate) {
    }

    @Deprecated
    public void onRemoteVideoTransportStats(int uid, int delay, int lost, int rxKBitRate) {
    }

    public void onAudioMixingStateChanged(int state, int errorCode) {
    }

    @Deprecated
    public void onAudioMixingFinished() {
    }

    public void onAudioEffectFinished(int soundId) {
    }

    public void onFirstRemoteAudioDecoded(int uid, int elapsed) {
    }

    public void onLocalAudioStateChanged(int state, int error) {
    }

    public void onLocalVideoStateChanged(int localVideoState, int error) {
    }

    public void onRtmpStreamingStateChanged(String url, int state, int errCode) {
    }

    public void onStreamPublished(String url, int error) {
    }

    public void onStreamUnpublished(String url) {
    }

    public void onTranscodingUpdated() {
    }

    public void onStreamInjectedStatus(String url, int uid, int status) {
    }

    public void onStreamMessage(int uid, int streamId, byte[] data) {
    }

    public void onStreamMessageError(int uid, int streamId, int error, int missed, int cached) {
    }

    public void onMediaEngineLoadSuccess() {
    }

    public void onMediaEngineStartCallSuccess() {
    }

    public void onNetworkTypeChanged(int type) {
    }

    public static class RemoteAudioStats {
        public int uid;
        public int quality;
        public int networkTransportDelay;
        public int jitterBufferDelay;
        public int audioLossRate;
        public int numChannels;
        public int receivedSampleRate;
        public int receivedBitrate;
        public int totalFrozenTime;
        public int frozenRate;
    }

    public static class LocalAudioStats {
        public int numChannels;
        public int sentSampleRate;
        public int sentBitrate;
    }

    public static class RemoteVideoStats {
        public int uid;
        @Deprecated
        public int delay;
        public int width;
        public int height;
        public int receivedBitrate;
        public int decoderOutputFrameRate;
        public int rendererOutputFrameRate;
        public int packetLossRate;
        public int rxStreamType;
        public int totalFrozenTime;
        public int frozenRate;
    }

    public static class LocalVideoStats {
        public int sentBitrate;
        public int sentFrameRate;
        public int encoderOutputFrameRate;
        public int rendererOutputFrameRate;
        public int targetBitrate;
        public int targetFrameRate;
        public int qualityAdaptIndication;
        public int encodedBitrate;
        public int encodedFrameWidth;
        public int encodedFrameHeight;
        public int encodedFrameCount;
        public int codecType;
    }

    public static class LastmileProbeResult {
        public short state;
        public int rtt;
        public LastmileProbeOneWayResult uplinkReport = new LastmileProbeOneWayResult();
        public LastmileProbeOneWayResult downlinkReport = new LastmileProbeOneWayResult();

        public static class LastmileProbeOneWayResult {
            public int packetLossRate;
            public int jitter;
            public int availableBandwidth;
        }
    }

    public static class RtcStats {
        public int totalDuration;
        public int txBytes;
        public int rxBytes;
        public int txAudioBytes;
        public int txVideoBytes;
        public int rxAudioBytes;
        public int rxVideoBytes;
        public int txKBitRate;
        public int rxKBitRate;
        public int txAudioKBitRate;
        public int rxAudioKBitRate;
        public int txVideoKBitRate;
        public int rxVideoKBitRate;
        public int users;
        public int lastmileDelay;
        public int txPacketLossRate;
        public int rxPacketLossRate;
        public double cpuTotalUsage;
        public double cpuAppUsage;
    }

    public static class AudioVolumeInfo {
        public int uid;
        public int volume;
        public int vad;
    }

    public static class UserOfflineReason {
        public static final int USER_OFFLINE_QUIT = 0;
        public static final int USER_OFFLINE_DROPPED = 1;
    }

    public static class ClientRole {
        public static final int CLIENT_ROLE_BROADCASTER = 1;
        public static final int CLIENT_ROLE_AUDIENCE = 2;
    }

    @Deprecated
    public static class VideoProfile {
        public static final int VIDEO_PROFILE_120P = 0;
        public static final int VIDEO_PROFILE_120P_3 = 2;
        public static final int VIDEO_PROFILE_180P = 10;
        public static final int VIDEO_PROFILE_180P_3 = 12;
        public static final int VIDEO_PROFILE_180P_4 = 13;
        public static final int VIDEO_PROFILE_240P = 20;
        public static final int VIDEO_PROFILE_240P_3 = 22;
        public static final int VIDEO_PROFILE_240P_4 = 23;
        public static final int VIDEO_PROFILE_360P = 30;
        public static final int VIDEO_PROFILE_360P_3 = 32;
        public static final int VIDEO_PROFILE_360P_4 = 33;
        public static final int VIDEO_PROFILE_360P_6 = 35;
        public static final int VIDEO_PROFILE_360P_7 = 36;
        public static final int VIDEO_PROFILE_360P_8 = 37;
        public static final int VIDEO_PROFILE_480P = 40;
        public static final int VIDEO_PROFILE_480P_3 = 42;
        public static final int VIDEO_PROFILE_480P_4 = 43;
        public static final int VIDEO_PROFILE_480P_6 = 45;
        public static final int VIDEO_PROFILE_480P_8 = 47;
        public static final int VIDEO_PROFILE_480P_9 = 48;
        public static final int VIDEO_PROFILE_720P = 50;
        public static final int VIDEO_PROFILE_720P_3 = 52;
        public static final int VIDEO_PROFILE_720P_5 = 54;
        public static final int VIDEO_PROFILE_720P_6 = 55;
        public static final int VIDEO_PROFILE_DEFAULT = 30;
    }

    public static class ErrorCode {
        public static final int ERR_OK = 0;
        public static final int ERR_FAILED = 1;
        public static final int ERR_INVALID_ARGUMENT = 2;
        public static final int ERR_NOT_READY = 3;
        public static final int ERR_NOT_SUPPORTED = 4;
        public static final int ERR_REFUSED = 5;
        public static final int ERR_BUFFER_TOO_SMALL = 6;
        public static final int ERR_NOT_INITIALIZED = 7;
        public static final int WARN_INVALID_VIEW = 8;
        public static final int ERR_NO_PERMISSION = 9;
        public static final int ERR_TIMEDOUT = 10;
        public static final int ERR_CANCELED = 11;
        public static final int ERR_TOO_OFTEN = 12;
        public static final int ERR_BIND_SOCKET = 13;
        public static final int ERR_NET_DOWN = 14;
        public static final int ERR_NET_NOBUFS = 15;
        public static final int WARN_INIT_VIDEO = 16;
        public static final int ERR_JOIN_CHANNEL_REJECTED = 17;
        public static final int ERR_LEAVE_CHANNEL_REJECTED = 18;
        public static final int ERR_ALREADY_IN_USE = 19;
        public static final int ERR_INVALID_APP_ID = 101;
        public static final int ERR_INVALID_CHANNEL_NAME = 102;
        @Deprecated
        public static final int ERR_TOKEN_EXPIRED = 109;
        @Deprecated
        public static final int ERR_INVALID_TOKEN = 110;
        public static final int ERR_CONNECTION_INTERRUPTED = 111;
        public static final int ERR_CONNECTION_LOST = 112;
        public static final int ERR_NOT_IN_CHANNEL = 113;
        public static final int ERR_SIZE_TOO_LARGE = 114;
        public static final int ERR_BITRATE_LIMIT = 115;
        public static final int ERR_TOO_MANY_DATA_STREAMS = 116;
        public static final int ERR_DECRYPTION_FAILED = 120;
        public static final int ERR_CLIENT_IS_BANNED_BY_SERVER = 123;
        public static final int ERR_WATERMARK_PATH = 125;
        public static final int ERR_INVALID_USER_ACCOUNT = 134;
        public static final int ERR_LOAD_MEDIA_ENGINE = 1001;
        public static final int ERR_START_CALL = 1002;
        @Deprecated
        public static final int ERR_START_CAMERA = 1003;
        public static final int ERR_START_VIDEO_RENDER = 1004;
        public static final int ERR_ADM_GENERAL_ERROR = 1005;
        public static final int ERR_ADM_JAVA_RESOURCE = 1006;
        public static final int ERR_ADM_SAMPLE_RATE = 1007;
        public static final int ERR_ADM_INIT_PLAYOUT = 1008;
        public static final int ERR_ADM_START_PLAYOUT = 1009;
        public static final int ERR_ADM_STOP_PLAYOUT = 1010;
        public static final int ERR_ADM_INIT_RECORDING = 1011;
        public static final int ERR_ADM_START_RECORDING = 1012;
        public static final int ERR_ADM_STOP_RECORDING = 1013;
        public static final int ERR_ADM_RUNTIME_PLAYOUT_ERROR = 1015;
        public static final int ERR_ADM_RUNTIME_RECORDING_ERROR = 1017;
        public static final int ERR_ADM_RECORD_AUDIO_FAILED = 1018;
        public static final int ERR_ADM_INIT_LOOPBACK = 1022;
        public static final int ERR_ADM_START_LOOPBACK = 1023;
        public static final int ERR_AUDIO_BT_SCO_FAILED = 1030;
        public static final int ERR_ADM_NO_RECORDING_DEVICE = 1359;
        public static final int ERR_VDM_CAMERA_NOT_AUTHORIZED = 1501;
        public static final int ERR_VCM_UNKNOWN_ERROR = 1600;
        public static final int ERR_VCM_ENCODER_INIT_ERROR = 1601;
        public static final int ERR_VCM_ENCODER_ENCODE_ERROR = 1602;
        @Deprecated
        public static final int ERR_VCM_ENCODER_SET_ERROR = 1603;
    }

    public static class WarnCode {
        public static final int WARN_PENDING = 20;
        public static final int WARN_INIT_VIDEO = 16;
        public static final int WARN_INVALID_VIEW = 8;
        public static final int WARN_NO_AVAILABLE_CHANNEL = 103;
        public static final int WARN_LOOKUP_CHANNEL_TIMEOUT = 104;
        @Deprecated
        public static final int WARN_LOOKUP_CHANNEL_REJECTED = 105;
        public static final int WARN_OPEN_CHANNEL_TIMEOUT = 106;
        public static final int WARN_OPEN_CHANNEL_REJECTED = 107;
        public static final int WARN_OPEN_CHANNEL_INVALID_TICKET = 121;
        public static final int WARN_OPEN_CHANNEL_TRY_NEXT_VOS = 122;
        public static final int WARN_AUDIO_MIXING_OPEN_ERROR = 701;
        public static final int WARN_ADM_RUNTIME_PLAYOUT_WARNING = 1014;
        public static final int WARN_ADM_RUNTIME_RECORDING_WARNING = 1016;
        public static final int WARN_ADM_RECORD_AUDIO_SILENCE = 1019;
        public static final int WARN_ADM_RECORD_IS_OCCUPIED = 1033;
        public static final int WARN_APM_HOWLING = 1051;
    }

    public static class Quality {
        public static final int UNKNOWN = 0;
        public static final int EXCELLENT = 1;
        public static final int GOOD = 2;
        public static final int POOR = 3;
        public static final int BAD = 4;
        public static final int VBAD = 5;
        public static final int DOWN = 6;
    }
}

