/*
 * Decompiled with CFR 0.152.
 */
package io.agora.live.impl;

import android.content.Context;
import android.text.TextUtils;
import android.view.SurfaceView;
import io.agora.live.LiveChannelConfig;
import io.agora.live.LiveEngine;
import io.agora.live.LiveEngineHandler;
import io.agora.live.LivePublisher;
import io.agora.live.LiveStats;
import io.agora.live.LiveSubscriber;
import io.agora.rtc.IRtcEngineEventHandler;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.video.VideoCanvas;
import java.util.HashMap;
import java.util.Map;

public class LiveEngineImpl
extends LiveEngine {
    private static final String TAG = "LiveEngineImpl";
    private static final String[] ENCRYPTION_MODE = new String[]{"", "aes-128-xts", "aes-256-xts", "aes-128-ecb"};
    private static final int REMOTE_AUDIO_MUTED = 1;
    private static final int REMOTE_VIDEO_MUTED = 2;
    private RtcEngine mRtcEngine;
    private LivePublisher mPublisher;
    private LiveSubscriber mSubscriber;
    private LiveChannelConfig mChannelConfig;

    public LiveEngineImpl(Context context, String appId, LiveEngineHandler handler) {
        try {
            RtcEngineHandler.get().setObjects(this).setLiveHandler(handler);
            this.mRtcEngine = RtcEngine.create(context, appId, RtcEngineHandler.get());
        }
        catch (Exception ex) {
            RtcEngineHandler.get().setObjects(null).setLiveHandler(null);
            Logging.e(TAG, "failed to create AgoraLiveEngine", ex);
        }
    }

    public void reinitialize(Context context, String appId, LiveEngineHandler handler) {
        RtcEngineHandler.get().setObjects(this).setLiveHandler(handler);
    }

    public void doDestroy() {
        RtcEngineHandler.get().setObjects(null).setLiveHandler(null);
    }

    @Override
    public RtcEngine getRtcEngine() {
        return this.mRtcEngine;
    }

    @Override
    public void setPublisher(LivePublisher publisher) {
        this.mPublisher = publisher;
    }

    @Override
    public void setSubscriber(LiveSubscriber subscriber) {
        this.mSubscriber = subscriber;
    }

    @Override
    public LiveChannelConfig getLiveChannelConfig() {
        return this.mChannelConfig;
    }

    @Override
    public int joinChannel(String channelId, String token, LiveChannelConfig channelConfig, int uid) {
        this.mRtcEngine.setChannelProfile(1);
        this.mChannelConfig = channelConfig;
        if (channelConfig.videoEnabled) {
            this.mRtcEngine.enableVideo();
            this.mRtcEngine.enableDualStreamMode(true);
        } else {
            this.mRtcEngine.disableVideo();
        }
        this.mRtcEngine.setClientRole(2);
        this.mRtcEngine.setEncryptionMode("");
        this.mRtcEngine.setEncryptionSecret(null);
        return this.mRtcEngine.joinChannel(token, channelId, null, uid);
    }

    @Override
    public int leaveChannel() {
        if (this.mPublisher != null) {
            this.mPublisher.unpublish();
        }
        return this.mRtcEngine.leaveChannel();
    }

    @Override
    public int renewToken(String token) {
        if (TextUtils.isEmpty((CharSequence)token)) {
            return 2;
        }
        return this.mRtcEngine.renewToken(token);
    }

    @Override
    public int startPreview(SurfaceView view, int renderMode) {
        VideoCanvas canvas = new VideoCanvas(view, renderMode, 0);
        this.mRtcEngine.setupLocalVideo(canvas);
        return this.mRtcEngine.startPreview();
    }

    @Override
    public int stopPreview() {
        VideoCanvas canvas = new VideoCanvas(null);
        this.mRtcEngine.setupLocalVideo(canvas);
        return this.mRtcEngine.stopPreview();
    }

    private static final class RtcEngineHandler
    extends IRtcEngineEventHandler {
        private static final RtcEngineHandler gRtcHandler = new RtcEngineHandler();
        private LiveEngineHandler mLiveHandler;
        private LiveEngineImpl mLiveEngineImpl;
        private Map<Integer, Integer> remoteStreamMediaStats = new HashMap<Integer, Integer>();

        private RtcEngineHandler() {
        }

        public static RtcEngineHandler get() {
            return gRtcHandler;
        }

        public RtcEngineHandler setObjects(LiveEngineImpl liveEngineImpl) {
            this.mLiveEngineImpl = liveEngineImpl;
            return gRtcHandler;
        }

        public void setLiveHandler(LiveEngineHandler handler) {
            this.mLiveHandler = handler;
        }

        private int getMediaTypeByStat(int stat) {
            int[] types = new int[]{3, 2, 1, 0};
            if (stat >= 0 && stat <= 3) {
                return types[stat];
            }
            return 0;
        }

        @Override
        public void onError(int err) {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onError(err);
            }
        }

        @Override
        public void onWarning(int warn) {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onWarning(warn);
            }
        }

        @Override
        public void onFirstRemoteVideoDecoded(int uid, int width, int height, int elapsed) {
            if (this.mLiveEngineImpl == null || this.mLiveEngineImpl.mSubscriber == null) {
                return;
            }
            this.mLiveEngineImpl.mSubscriber.getLiveSubscriberHandler().onFirstRemoteVideoDecoded(uid, width, height, elapsed);
        }

        @Override
        public void onVideoSizeChanged(int uid, int width, int height, int rotation) {
            if (this.mLiveEngineImpl == null || this.mLiveEngineImpl.mSubscriber == null) {
                return;
            }
            this.mLiveEngineImpl.mSubscriber.getLiveSubscriberHandler().onVideoSizeChanged(uid, width, height, rotation);
        }

        @Override
        public void onUserJoined(int uid, int elapsed) {
            if (this.mLiveEngineImpl == null || this.mLiveEngineImpl.mSubscriber == null) {
                return;
            }
            this.mLiveEngineImpl.getRtcEngine().muteRemoteAudioStream(uid, true);
            this.mLiveEngineImpl.getRtcEngine().muteRemoteVideoStream(uid, true);
            int muteStatus = 0;
            this.remoteStreamMediaStats.put(uid, muteStatus);
            int type = this.getMediaTypeByStat(muteStatus);
            this.mLiveEngineImpl.mSubscriber.getLiveSubscriberHandler().publishedByHost(uid, type);
        }

        @Override
        public void onUserOffline(int uid, int reason) {
            if (this.mLiveEngineImpl == null || this.mLiveEngineImpl.mSubscriber == null) {
                return;
            }
            this.remoteStreamMediaStats.remove(uid);
            this.mLiveEngineImpl.mSubscriber.getLiveSubscriberHandler().unpublishedByHost(uid);
        }

        @Override
        public void onUserMuteAudio(int uid, boolean muted) {
            if (this.mLiveEngineImpl == null || this.mLiveEngineImpl.mSubscriber == null) {
                return;
            }
            Integer mute = this.remoteStreamMediaStats.get(uid);
            int muteStatus = 0;
            if (mute != null) {
                muteStatus = mute;
            }
            muteStatus = muted ? (muteStatus |= 1) : (muteStatus &= 0xFFFFFFFE);
            int type = this.getMediaTypeByStat(muteStatus);
            if (mute == null) {
                this.mLiveEngineImpl.mSubscriber.getLiveSubscriberHandler().publishedByHost(uid, type);
            } else {
                this.mLiveEngineImpl.mSubscriber.getLiveSubscriberHandler().onStreamTypeChanged(type, uid);
            }
            this.remoteStreamMediaStats.put(uid, muteStatus);
        }

        @Override
        public void onUserMuteVideo(int uid, boolean muted) {
            if (this.mLiveEngineImpl == null || this.mLiveEngineImpl.mSubscriber == null) {
                return;
            }
            Integer mute = this.remoteStreamMediaStats.get(uid);
            int muteStatus = 0;
            if (mute != null) {
                muteStatus = mute;
            }
            muteStatus = muted ? (muteStatus |= 2) : (muteStatus &= 0xFFFFFFFD);
            int type = this.getMediaTypeByStat(muteStatus);
            if (mute == null) {
                this.mLiveEngineImpl.mSubscriber.getLiveSubscriberHandler().publishedByHost(uid, type);
            } else {
                this.mLiveEngineImpl.mSubscriber.getLiveSubscriberHandler().onStreamTypeChanged(type, uid);
            }
            this.remoteStreamMediaStats.put(uid, muteStatus);
        }

        @Override
        public void onJoinChannelSuccess(String channel, int uid, int elapsed) {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onJoinChannel(channel, uid, elapsed);
            }
        }

        @Override
        public void onLeaveChannel(IRtcEngineEventHandler.RtcStats stats) {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onLeaveChannel();
            }
        }

        @Override
        public void onRejoinChannelSuccess(String channel, int uid, int elapsed) {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onRejoinChannel(channel, uid, elapsed);
            }
        }

        @Override
        public void onRtcStats(IRtcEngineEventHandler.RtcStats stats) {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onReportLiveStats(new LiveStats(stats));
            }
        }

        @Override
        public void onConnectionInterrupted() {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onConnectionInterrupted();
            }
        }

        @Override
        public void onConnectionLost() {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onConnectionLost();
            }
        }

        @Override
        public void onNetworkQuality(int uid, int txQuality, int rxQuality) {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onNetworkQuality(uid, txQuality, rxQuality);
            }
        }

        @Override
        public void onStreamPublished(String url, int error) {
            if (this.mLiveEngineImpl == null || this.mLiveEngineImpl.mPublisher == null) {
                return;
            }
            if (error == 0) {
                this.mLiveEngineImpl.mPublisher.getLivePublisherHandler().onStreamUrlPublished(url);
            } else {
                this.mLiveEngineImpl.mPublisher.getLivePublisherHandler().onPublishStreamUrlFailed(url, error);
            }
        }

        @Override
        public void onStreamUnpublished(String url) {
            if (this.mLiveEngineImpl == null || this.mLiveEngineImpl.mPublisher == null) {
                return;
            }
            this.mLiveEngineImpl.mPublisher.getLivePublisherHandler().onStreamUrlUnpublished(url);
        }

        @Override
        public void onTranscodingUpdated() {
            if (this.mLiveEngineImpl == null || this.mLiveEngineImpl.mPublisher == null) {
                return;
            }
            this.mLiveEngineImpl.mPublisher.getLivePublisherHandler().onPublisherTranscodingUpdated(this.mLiveEngineImpl.mPublisher);
        }

        @Override
        public void onRequestToken() {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onRequestToken();
            }
        }

        @Override
        public void onTokenPrivilegeWillExpire(String token) {
            if (this.mLiveHandler != null) {
                this.mLiveHandler.onTokenPrivilegeWillExpire(token);
            }
        }

        @Override
        public void onStreamInjectedStatus(String url, int uid, int status) {
            if (this.mLiveEngineImpl == null || this.mLiveEngineImpl.mPublisher == null) {
                return;
            }
            this.mLiveEngineImpl.mPublisher.getLivePublisherHandler().onStreamInjectedStatus(url, uid, status);
        }
    }
}

