/*
 * Decompiled with CFR 0.152.
 */
package io.agora.live;

import android.util.Log;
import android.view.SurfaceView;
import io.agora.live.LiveEngine;
import io.agora.live.LiveSubscriberHandler;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.video.VideoCanvas;
import java.lang.ref.WeakReference;

public class LiveSubscriber {
    private static final String TAG = LiveSubscriber.class.getSimpleName();
    private WeakReference<LiveEngine> mLiveEngine;
    private final LiveSubscriberHandler mHandler;

    public LiveSubscriber(LiveEngine engine, LiveSubscriberHandler handler) {
        this.mLiveEngine = new WeakReference<LiveEngine>(engine);
        this.mHandler = handler;
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le != null) {
            le.setSubscriber(this);
        }
    }

    public LiveSubscriberHandler getLiveSubscriberHandler() {
        return this.mHandler;
    }

    public void subscribe(int uid, int mediaType, SurfaceView view, int renderMode, int videoType) {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            Log.e((String)TAG, (String)"LiveEngine is null, none subscribing...");
            return;
        }
        RtcEngine re = le.getRtcEngine();
        VideoCanvas canvas = new VideoCanvas(view, renderMode, uid);
        re.setupRemoteVideo(canvas);
        re.setRemoteVideoStreamType(uid, videoType);
        re.setRemoteRenderMode(uid, renderMode);
        boolean subscribeAudio = true;
        boolean subscribeVideo = true;
        switch (mediaType) {
            case 0: {
                subscribeAudio = false;
                subscribeVideo = false;
                break;
            }
            case 1: {
                subscribeAudio = true;
                subscribeVideo = false;
                break;
            }
            case 2: {
                subscribeAudio = false;
                subscribeVideo = true;
                break;
            }
            case 3: {
                subscribeAudio = true;
                subscribeVideo = true;
            }
        }
        re.muteRemoteAudioStream(uid, !subscribeAudio);
        re.muteRemoteVideoStream(uid, !subscribeVideo);
    }

    public void unsubscribe(int uid) {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            Log.e((String)TAG, (String)"LiveEngine is null while unsubscribing");
            return;
        }
        RtcEngine re = le.getRtcEngine();
        VideoCanvas canvas = new VideoCanvas(null, 1, uid);
        re.setupRemoteVideo(canvas);
        re.muteRemoteAudioStream(uid, true);
        re.muteRemoteVideoStream(uid, true);
    }
}

