/*
 * Decompiled with CFR 0.152.
 */
package io.agora.live;

import android.text.TextUtils;
import io.agora.live.LiveEngine;
import io.agora.live.LivePublisherHandler;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.live.LiveInjectStreamConfig;
import io.agora.rtc.live.LiveTranscoding;
import io.agora.rtc.video.AgoraImage;
import java.lang.ref.WeakReference;

public class LivePublisher {
    private WeakReference<LiveEngine> mLiveEngine;
    private final LivePublisherHandler mHandler;
    private boolean mPublishing;
    private boolean mPublishAudio;
    private boolean mPublishVideo;

    public LivePublisher(LiveEngine engine, LivePublisherHandler handler) {
        this.mLiveEngine = new WeakReference<LiveEngine>(engine);
        this.mHandler = handler;
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le != null) {
            RtcEngine rtcEngine = le.getRtcEngine();
            rtcEngine.enableDualStreamMode(true);
            le.setPublisher(this);
        }
        this.setMediaType(3);
    }

    public LivePublisherHandler getLivePublisherHandler() {
        return this.mHandler;
    }

    public int setLiveTranscoding(LiveTranscoding transcoding) {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return -3;
        }
        return le.getRtcEngine().setLiveTranscoding(transcoding);
    }

    public void setMediaType(int mediaType) {
        switch (mediaType) {
            case 0: {
                this.mPublishAudio = false;
                this.mPublishVideo = false;
                break;
            }
            case 1: {
                this.mPublishAudio = true;
                this.mPublishVideo = false;
                break;
            }
            case 2: {
                this.mPublishAudio = false;
                this.mPublishVideo = true;
                break;
            }
            case 3: {
                this.mPublishAudio = true;
                this.mPublishVideo = true;
            }
        }
        this.applyPublishingMediaType();
    }

    public int setVideoProfile(int width, int height, int frameRate, int bitrate) {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return -3;
        }
        RtcEngine re = le.getRtcEngine();
        return re.setVideoProfile(width, height, frameRate, bitrate);
    }

    public void publish() {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return;
        }
        RtcEngine re = le.getRtcEngine();
        this.mPublishing = true;
        if (le.getLiveChannelConfig().videoEnabled) {
            re.enableLocalVideo(true);
        }
        re.setClientRole(1);
        this.applyPublishingMediaType();
    }

    public int addStreamUrl(String url, boolean isTranscodingEnabled) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return 2;
        }
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return 3;
        }
        RtcEngine re = le.getRtcEngine();
        return re.addPublishStreamUrl(url, isTranscodingEnabled);
    }

    public int removeStreamUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return 2;
        }
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return 3;
        }
        RtcEngine re = le.getRtcEngine();
        return re.removePublishStreamUrl(url);
    }

    public void unpublish() {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return;
        }
        RtcEngine re = le.getRtcEngine();
        re.setClientRole(2);
    }

    public void addVideoWatermark(AgoraImage watermark) {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return;
        }
        RtcEngine re = le.getRtcEngine();
        re.addVideoWatermark(watermark);
    }

    public void clearVideoWatermarks() {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return;
        }
        RtcEngine re = le.getRtcEngine();
        re.clearVideoWatermarks();
    }

    public void switchCamera() {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return;
        }
        RtcEngine re = le.getRtcEngine();
        re.switchCamera();
    }

    public int addInjectStreamUrl(String url, LiveInjectStreamConfig config) {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return 3;
        }
        RtcEngine re = le.getRtcEngine();
        return re.addInjectStreamUrl(url, config);
    }

    public int removeInjectStreamUrl(String url) {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return 3;
        }
        RtcEngine re = le.getRtcEngine();
        return re.removeInjectStreamUrl(url);
    }

    private void applyPublishingMediaType() {
        LiveEngine le = (LiveEngine)this.mLiveEngine.get();
        if (le == null) {
            return;
        }
        RtcEngine re = le.getRtcEngine();
        if (this.mPublishing) {
            re.muteLocalAudioStream(!this.mPublishAudio);
            if (le.getLiveChannelConfig().videoEnabled) {
                re.muteLocalVideoStream(!this.mPublishVideo);
            }
        }
    }
}

