/*
 * Decompiled with CFR 0.152.
 */
package io.agora.live;

import android.content.Context;
import android.view.SurfaceView;
import io.agora.live.LiveChannelConfig;
import io.agora.live.LiveEngineHandler;
import io.agora.live.LivePublisher;
import io.agora.live.LiveSubscriber;
import io.agora.live.impl.LiveEngineImpl;
import io.agora.rtc.RtcEngine;
import io.agora.rtc.internal.RtcEngineImpl;

public abstract class LiveEngine {
    private static LiveEngineImpl gLiveEngineImpl;

    public static String getSdkVersion() {
        return RtcEngineImpl.getSdkVersion();
    }

    public static String getMediaEngineVersion() {
        return RtcEngineImpl.getMediaEngineVersion();
    }

    public static LiveEngine createLiveEngine(Context context, String appId, LiveEngineHandler handler) {
        if (context == null) {
            return null;
        }
        if (gLiveEngineImpl == null) {
            gLiveEngineImpl = new LiveEngineImpl(context, appId, handler);
        } else {
            gLiveEngineImpl.reinitialize(context, appId, handler);
        }
        return gLiveEngineImpl;
    }

    public static synchronized void destroy() {
        if (gLiveEngineImpl == null) {
            return;
        }
        gLiveEngineImpl.doDestroy();
        gLiveEngineImpl = null;
        RtcEngine.destroy();
    }

    public abstract RtcEngine getRtcEngine();

    public abstract LiveChannelConfig getLiveChannelConfig();

    public abstract void setPublisher(LivePublisher var1);

    public abstract void setSubscriber(LiveSubscriber var1);

    public abstract int joinChannel(String var1, String var2, LiveChannelConfig var3, int var4);

    public abstract int leaveChannel();

    public abstract int renewToken(String var1);

    public abstract int startPreview(SurfaceView var1, int var2);

    public abstract int stopPreview();
}

