/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils2;

import android.text.TextUtils;
import android.util.Log;
import io.agora.base.internal.CalledByNative;
import io.agora.utils2.internal.Logging;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;

public class NetUtil {
    private static final String TAG = NetUtil.class.getSimpleName();

    @CalledByNative
    public static String getEncodedUrl(String urlStr) {
        return NetUtil.checkUrlEncoded(urlStr) ? urlStr : NetUtil.encodeUrl(urlStr);
    }

    @CalledByNative
    public static String getDecodedUrl(String urlStr) {
        try {
            return URLDecoder.decode(urlStr, "UTF-8");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getDecodedUrl failed: ", (Throwable)e);
            return urlStr;
        }
    }

    public static boolean checkUrlEncoded(String urlStr) {
        try {
            String tempUrl = URLDecoder.decode(urlStr, "UTF-8");
            return !TextUtils.equals((CharSequence)urlStr, (CharSequence)tempUrl);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"checkUrlEncoded failed: ", (Throwable)e);
            return false;
        }
    }

    public static String encodeUrl(String urlStr) {
        Logging.d(TAG, "encodedUrl()");
        try {
            URL tmpUrl = new URL(urlStr);
            URI uri = new URI(tmpUrl.getProtocol(), tmpUrl.getUserInfo(), tmpUrl.getHost(), tmpUrl.getPort(), tmpUrl.getPath(), tmpUrl.getQuery(), tmpUrl.getRef());
            return uri.toASCIIString();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"encodeUrl failed: ", (Throwable)e);
            return urlStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testNetworkUrlAvailable(String encodedUrl) {
        Logging.d(TAG, "testNetworkUrlAvailable encodedUrl");
        HttpURLConnection huc = null;
        boolean available = false;
        try {
            URL url = new URL(encodedUrl);
            huc = (HttpURLConnection)url.openConnection();
            huc.setConnectTimeout(1000);
            huc.setReadTimeout(1000);
            int responseCode = huc.getResponseCode();
            available = responseCode != 404;
            InputStream inputStream = huc.getInputStream();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"testNetworkUrlAvailable failed: ", (Throwable)e);
        }
        finally {
            if (huc != null) {
                huc.disconnect();
            }
        }
        return available;
    }
}

