/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift.util;

import android.util.Base64;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.util.GZipUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GiftListUtil {
    private static final String TAG = "GiftListUtil";

    public static List<GiftInfo> parserGiftList(String compressData, int usedChannel, String urlPrefix, int liveCategoryId) {
        ArrayList<GiftInfo> propsList;
        block17: {
            propsList = new ArrayList<GiftInfo>();
            try {
                byte[] data = Base64.decode((String)compressData, (int)0);
                String propsListStr = GZipUtil.unCompressToStringZLib(data);
                if ("".equals(propsListStr)) {
                    RLog.info((Object)TAG, (String)"unCompressToStringZLib : string is empty");
                    return propsList;
                }
                RLog.debug((Object)TAG, (String)"propsListStr = %s", (Object[])new Object[]{propsListStr});
                JSONArray jsonArray = new JSONArray(propsListStr);
                JSONArray jsonPricingArray = null;
                if (jsonArray.length() <= 0) break block17;
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonDesc;
                    JSONObject jsonExpend;
                    GiftInfo info = new GiftInfo();
                    info.usedChannel = usedChannel;
                    JSONObject jsonObject = jsonArray.optJSONObject(i);
                    info.propsId = jsonObject.optInt("propsId");
                    info.name = jsonObject.optString("name");
                    info.type = jsonObject.optInt("type");
                    String strVisible = jsonObject.optString("visible");
                    info.visible = strVisible.equals("true");
                    String strUsable = jsonObject.optString("usable");
                    info.usable = strUsable.equals("true");
                    info.expand = jsonExpend = jsonObject.optJSONObject("expand");
                    info.desc = jsonDesc = jsonObject.getJSONObject("desc");
                    info.description = jsonDesc.optString("description");
                    info.staticIcon = jsonDesc.optString("staticIcon");
                    info.priority = jsonDesc.optString("priority");
                    info.urlPrefix = urlPrefix;
                    info.usetype = jsonDesc.optString("usetype", "0");
                    jsonPricingArray = jsonObject.optJSONArray("pricingList");
                    ArrayList<GiftInfo.Pricing> pricingList = new ArrayList<GiftInfo.Pricing>();
                    if (jsonPricingArray != null && jsonPricingArray.length() > 0) {
                        for (int j = 0; j < jsonPricingArray.length(); ++j) {
                            JSONObject jsonPrice = jsonPricingArray.getJSONObject(j);
                            GiftInfo.Pricing pricing = new GiftInfo.Pricing();
                            pricing.currencyAmount = jsonPrice.optLong("currencyAmount");
                            pricing.revenueAmount = jsonPrice.optLong("revenueAmount");
                            pricing.currencyType = jsonPrice.optInt("currencyType");
                            pricing.userTypeLimit = jsonPrice.optInt("userTypeLimit");
                            pricingList.add(pricing);
                        }
                    }
                    info.pricingList = pricingList;
                    info.liveCategoryId = liveCategoryId;
                    ArrayList<GiftInfo.Number> numberList = new ArrayList<GiftInfo.Number>();
                    JSONArray numberArray = null;
                    try {
                        numberArray = new JSONArray(jsonDesc.optString("numberList", ""));
                    }
                    catch (JSONException e) {
                        RLog.debug((Object)TAG, (String)("parse numberList error: propsId = " + info.propsId));
                    }
                    if (numberArray != null && numberArray.length() > 0) {
                        for (int j = 0; j < numberArray.length(); ++j) {
                            JSONObject item = numberArray.optJSONObject(j);
                            if (item == null) continue;
                            GiftInfo.Number number = new GiftInfo.Number();
                            String numberStr = item.optString("number", "0");
                            number.number = Integer.valueOf(numberStr);
                            number.priority = item.optString("priority", "");
                            number.desc = item.optString("desc", "");
                            numberList.add(number);
                        }
                    }
                    Collections.sort(numberList, (o1, o2) -> o1.number - o2.number);
                    info.numberList = numberList;
                    ArrayList<GiftInfo.Effect> effectList = new ArrayList<GiftInfo.Effect>();
                    JSONArray effectArray = null;
                    try {
                        effectArray = new JSONArray(jsonDesc.optString("effectList", ""));
                    }
                    catch (JSONException e) {
                        RLog.debug((Object)TAG, (String)("parser effectList error: propsId = " + info.propsId));
                    }
                    if (effectArray != null && effectArray.length() > 0) {
                        for (int k = 0; k < effectArray.length(); ++k) {
                            JSONObject item = effectArray.optJSONObject(k);
                            if (item == null) continue;
                            GiftInfo.Effect effect = new GiftInfo.Effect();
                            String levelStr = item.optString("level", "0");
                            effect.level = Integer.valueOf(levelStr);
                            String valueStr = item.optString("value", "0");
                            effect.value = Integer.valueOf(valueStr);
                            effect.large = item.optBoolean("large", false);
                            effect.image = item.optString("image", "");
                            effect.effectUrls = item.optString("effectUrls", "");
                            if (!"".equals(effect.effectUrls)) {
                                JSONObject timeJson = null;
                                try {
                                    timeJson = new JSONObject(effect.effectUrls);
                                    effect.displayTime = timeJson.optLong("displayTime", 0L);
                                }
                                catch (JSONException e) {
                                    RLog.debug((Object)TAG, (String)("parser effectUrls error: propsId = " + info.propsId));
                                }
                            }
                            effectList.add(effect);
                        }
                    }
                    Collections.sort(effectList, (o1, o2) -> o1.level - o2.level);
                    info.effectList = effectList;
                    propsList.add(info);
                }
            }
            catch (Exception e) {
                RLog.error((Object)TAG, (String)"parserGift error.", (Throwable)e);
            }
        }
        return propsList;
    }
}

