/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.gift.GiftCacheInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;

public class GiftCacheInfoUtil {
    private static final String TAG = "GiftCacheInfoUtil";
    private static String FileDirPathName = "/revenue";

    private static String getDataFileDirPath(Context context) {
        File esdf = context.getFilesDir();
        if (esdf == null) {
            return "";
        }
        return esdf.getAbsolutePath() + FileDirPathName;
    }

    private static String getDataFilePath(Context context, int usedChannel, int liveCategoryId) {
        File esdf = context.getFilesDir();
        if (esdf == null) {
            return "";
        }
        return esdf.getAbsolutePath() + FileDirPathName + "/giftCompress_" + usedChannel + "_" + liveCategoryId + ".txt";
    }

    public static synchronized boolean writeGiftCacheInfoData(Context context, @NonNull GiftCacheInfo cacheInfo) {
        if (context == null) {
            RLog.error((Object)TAG, (String)"writeGiftCacheInfoData: context == null!", (Object[])new Object[0]);
            return false;
        }
        String path = GiftCacheInfoUtil.getDataFileDirPath(context);
        if (path.equals("")) {
            return false;
        }
        File dirFile = new File(path);
        boolean isDirMkSuccess = false;
        if (!dirFile.exists()) {
            isDirMkSuccess = dirFile.mkdir();
        }
        RLog.info((Object)TAG, (String)("writeGiftCacheInfoData: makeDir result = " + isDirMkSuccess));
        String savePath = GiftCacheInfoUtil.getDataFilePath(context, cacheInfo.usedChannel, cacheInfo.liveCategoryId);
        if (path.equals("")) {
            return false;
        }
        File dataFile = new File(savePath);
        if (!dataFile.exists()) {
            try {
                boolean isCreateFileSuccess = dataFile.createNewFile();
                RLog.info((Object)TAG, (String)("writeGiftCacheInfoData: createFile result = " + isCreateFileSuccess));
            }
            catch (Exception e) {
                RLog.error((Object)TAG, (String)"writeGiftCacheInfoData: create dataFile error.", (Throwable)e);
                return false;
            }
        }
        try {
            PrintWriter printWriter = new PrintWriter(dataFile);
            printWriter.print("");
            printWriter.flush();
            printWriter.print(cacheInfo.toJsonStr());
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception e) {
            RLog.error((Object)TAG, (String)"writeGiftCacheInfoData: write data error.", (Throwable)e);
            return false;
        }
        return true;
    }

    @Nullable
    public static synchronized GiftCacheInfo readGiftCacheInfoData(Context context, int usedChannel, int liveCategoryId) {
        if (context == null) {
            RLog.error((Object)TAG, (String)"readGiftCacheInfoData: context == null!", (Object[])new Object[0]);
            return new GiftCacheInfo();
        }
        String path = GiftCacheInfoUtil.getDataFilePath(context, usedChannel, liveCategoryId);
        if (path.equals("")) {
            return null;
        }
        File dataFile = new File(path);
        StringBuilder jsonData = new StringBuilder();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(dataFile));
            while ((line = br.readLine()) != null) {
                jsonData.append(line);
            }
            br.close();
        }
        catch (Exception e) {
            RLog.error((Object)TAG, (String)"readGiftCacheInfoData: read data error.", (Throwable)e);
        }
        return GiftCacheInfo.parseFromJson(jsonData.toString());
    }
}

