/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift.util;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterOutputStream;

public class GZipUtil {
    public static final String GZIP_ENCODE_UTF_8 = "UTF-8";
    public static final String GZIP_ENCODE_ISO_8859_1 = "ISO-8859-1";

    public static byte[] compress(String str, String encoding) {
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes(encoding));
            gzip.close();
        }
        catch (IOException e) {
            RLog.error((Object)"gzip compress error.", (String)e.getMessage(), (Object[])new Object[0]);
        }
        return out.toByteArray();
    }

    public static String uncompressToString(byte[] bytes) {
        return GZipUtil.uncompressToString(bytes, GZIP_ENCODE_UTF_8);
    }

    public static String uncompressToString(byte[] bytes, String encoding) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            int n;
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            return out.toString(encoding);
        }
        catch (IOException e) {
            RLog.error((Object)"gzip compress error.", (String)e.getMessage(), (Object[])new Object[0]);
            return null;
        }
    }

    public static String unCompressToStringZLib(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InflaterOutputStream zos = new InflaterOutputStream(out);
        try {
            zos.write(bytes);
            zos.close();
            return out.toString(GZIP_ENCODE_UTF_8);
        }
        catch (IOException e) {
            RLog.error((Object)"ZLib compress error.", (String)e.getMessage(), (Object[])new Object[0]);
            return "";
        }
    }

    public static boolean isGzip(byte[] data) {
        int header = data[0] << 8 | data[1] & 0xFF;
        return header == 8075;
    }
}

