/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.ActivityGiftBagInfo;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class GetGiftBagResponse
implements IBaseJsonResponse {
    private String seq;
    private int result;
    private String message;
    private int cmd;
    private boolean firstCharge;
    private boolean hasBuy;
    private int purchasedNum;
    private List<ActivityGiftBagInfo> giftBags;
    private String beginTime;
    private String endTime;
    private String currentActivityConf;

    public GetGiftBagResponse(String jsonMsg) {
        this.parserResponse(jsonMsg);
    }

    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            this.seq = response.optString("seq", "");
            this.cmd = response.optInt("cmd", 0);
            this.result = response.optInt("result", 0);
            this.message = response.optString("message", "");
            this.firstCharge = response.optBoolean("firstCharge");
            this.hasBuy = response.optBoolean("hasBuy");
            this.purchasedNum = response.optInt("purchasedNum");
            this.giftBags = new ArrayList<ActivityGiftBagInfo>();
            JSONArray rankArray = response.optJSONArray("giftBags");
            if (rankArray != null && rankArray.length() > 0) {
                for (int i = 0; i < rankArray.length(); ++i) {
                    JSONObject gitfBagItem = rankArray.optJSONObject(i);
                    if (gitfBagItem == null) continue;
                    ActivityGiftBagInfo activityGiftBagInfo = new ActivityGiftBagInfo();
                    activityGiftBagInfo.name = gitfBagItem.optString("name");
                    activityGiftBagInfo.tips = gitfBagItem.optString("tips");
                    activityGiftBagInfo.url = gitfBagItem.optString("url");
                    activityGiftBagInfo.weight = gitfBagItem.optInt("weight", 0);
                    activityGiftBagInfo.propCnt = gitfBagItem.optInt("propCnt", 0);
                    activityGiftBagInfo.currencyAmount = gitfBagItem.optString("currencyAmount");
                    this.giftBags.add(activityGiftBagInfo);
                }
            }
            this.beginTime = response.optString("beginTime", "");
            this.endTime = response.optString("endTime", "");
            this.currentActivityConf = response.optString("currentActivityConf", "");
        }
        catch (Exception e) {
            RLog.error((Object)"GetGiftBagResponse", (String)"parserResponse error.", (Throwable)e);
        }
    }

    public String getSeq() {
        return this.seq;
    }

    public int getResult() {
        return this.result;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean getFirstCharge() {
        return this.firstCharge;
    }

    public boolean getHasBuy() {
        return this.hasBuy;
    }

    public int getPurchasedNum() {
        return this.purchasedNum;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getCurrentActivityConf() {
        return this.currentActivityConf;
    }

    public int getCmd() {
        return this.cmd;
    }

    public List<ActivityGiftBagInfo> getGiftBags() {
        return this.giftBags;
    }
}

