/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import org.json.JSONException;
import org.json.JSONObject;

public class GiftCacheInfo {
    public static final String KEY_USED_CHANNEL = "usedChannel";
    public static final String KEY_LIVE_CATEGORY_ID = "liveCategoryId";
    public static final String KEY_URL_PREFIX = "urlPreFix";
    public static final String KEY_MD5_HASH = "md5Hash";
    public static final String KEY_COMPRESS_DATA = "compressData";
    public int usedChannel;
    public int liveCategoryId;
    public String urlPreFix;
    public String md5Hash;
    public String compressData;

    public GiftCacheInfo() {
        this.reset();
    }

    public GiftCacheInfo(int usedChannel, int liveCategoryId, String urlPreFix, String md5Hash, String compressData) {
        this.usedChannel = usedChannel;
        this.liveCategoryId = liveCategoryId;
        this.urlPreFix = urlPreFix;
        this.md5Hash = md5Hash;
        this.compressData = compressData;
    }

    public void reset() {
        this.usedChannel = 0;
        this.liveCategoryId = 0;
        this.urlPreFix = "";
        this.md5Hash = "";
        this.compressData = "";
    }

    public String toJsonStr() {
        String jsonStr = "";
        try {
            JSONObject jb = new JSONObject();
            jb.put(KEY_USED_CHANNEL, this.usedChannel);
            jb.put(KEY_LIVE_CATEGORY_ID, this.liveCategoryId);
            jb.put(KEY_URL_PREFIX, (Object)this.urlPreFix);
            jb.put(KEY_MD5_HASH, (Object)this.md5Hash);
            jb.put(KEY_COMPRESS_DATA, (Object)this.compressData);
            jsonStr = jb.toString();
        }
        catch (JSONException e) {
            RLog.error((Object)"GiftCacheInfo", (String)"toJsonStr error.", (Throwable)e);
        }
        RLog.debug((Object)"GiftCacheInfo", (String)"toJsonStr result = %s", (Object[])new Object[]{jsonStr});
        return jsonStr;
    }

    public String toString() {
        return "GiftCacheInfo{usedChannel=" + this.usedChannel + ", liveCategoryId=" + this.liveCategoryId + ", urlPreFix='" + this.urlPreFix + '\'' + ", md5Hash='" + this.md5Hash + '\'' + ", compressData='" + this.compressData + '\'' + '}';
    }

    public static GiftCacheInfo parseFromJson(String data) {
        GiftCacheInfo cacheInfo = new GiftCacheInfo();
        try {
            JSONObject jb = new JSONObject(data);
            cacheInfo.usedChannel = jb.optInt(KEY_USED_CHANNEL, 0);
            cacheInfo.liveCategoryId = jb.optInt(KEY_LIVE_CATEGORY_ID, 0);
            cacheInfo.urlPreFix = jb.optString(KEY_URL_PREFIX, "");
            cacheInfo.md5Hash = jb.optString(KEY_MD5_HASH, "");
            cacheInfo.compressData = jb.optString(KEY_COMPRESS_DATA, "");
        }
        catch (JSONException e) {
            RLog.error((Object)"GiftCacheInfo", (String)"parseFromJson error.", (Throwable)e);
        }
        RLog.debug((Object)"GiftCacheInfo", (String)"parseFromJson result: = %s", (Object[])new Object[]{cacheInfo.toString()});
        return cacheInfo;
    }
}

