package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.RankInfo;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * 贡献榜入口返回
 */
public class RankEntranceResponse implements IBaseJsonResponse {
    private String seq;
    private int result;
    private String message;
    private int cmd;
    private List<RankInfo> rankList;

    public RankEntranceResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            seq = response.optString("seq", "");
            result = response.optInt("result", 0);
            message = response.optString("message", "");
            cmd = response.optInt("cmd", 0);
            rankList = new ArrayList<>();
            JSONArray rankArray = response.optJSONArray("ranks");
            if (rankArray != null && rankArray.length() > 0) {
                for (int i = 0; i < rankArray.length(); ++i) {
                    JSONObject rankItem = rankArray.optJSONObject(i);
                    if (rankItem != null) {
                        RankInfo rankInfo = new RankInfo();
                        rankInfo.uid = rankItem.optLong("uid", 0);
                        rankInfo.value = rankItem.optLong("value", 0);
                        rankInfo.rank = rankItem.optInt("rank", 0);
                        rankList.add(rankInfo);
                    }
                }
            }
        } catch (Exception e) {
            RLog.error("RankEntranceResponse", "parserResponse error.", e);
        }
    }

    public String getSeq() {
        return seq;
    }

    public int getResult() {
        return result;
    }

    public String getMessage() {
        return message;
    }

    public int getCmd() {
        return cmd;
    }

    public List<RankInfo> getRankList() {
        return rankList;
    }

}
