package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.ActivityGiftBagInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.RankInfo;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class GetGiftBagResponse implements IBaseJsonResponse {

//    # Response
//    {
//        "cmd":2049,
//            "firstCharge":true //true:首充用户（之前尚未充值过），false:非首充用户
//        "hasBuy":true,    //Boolean类型 true:已经购买过礼包，false:尚未购买过礼包
//            "purchasedNum",2 //已有2人购买该礼包
//        "giftBags": [{
//        "name":$name,     //礼物名称
//                "tips":$tips,    //礼物描述
//                "url":&url,      //礼物图片
//                "weight":$weight, //权重
//                "propCnt":$propCnt, //礼物个数
//                "currencyAmount":$currencyAmount //礼物金额
//    },...],
//        "beginTime":&beginTime,// 活动开始时间戳
//            "endTime":&endTime, //活动结束时间
//            "currentActivityConf":{
//        "currentGiftBagId":360001,//当前进行的礼包id
//                "activityPic":"当前礼包活动宣传图片url",
//    },
//    }

    private String seq;
    private int result; // 业务错误码
    private String message; // 业务返回码信息说明
    private int cmd;
    private boolean firstCharge;
    private boolean hasBuy;
    private int purchasedNum;
    private List<ActivityGiftBagInfo> giftBags;
    private String beginTime;
    private String endTime;
    private String currentActivityConf;

    public GetGiftBagResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            seq = response.optString("seq", "");
            cmd = response.optInt("cmd", 0);
            result = response.optInt("result", 0);
            message = response.optString("message", "");
            firstCharge = response.optBoolean("firstCharge");
            hasBuy = response.optBoolean("hasBuy");
            purchasedNum = response.optInt("purchasedNum");
            giftBags = new ArrayList<>();
            JSONArray rankArray = response.optJSONArray("giftBags");
            if (rankArray != null && rankArray.length() > 0) {
                for (int i = 0; i < rankArray.length(); ++i) {
                    JSONObject gitfBagItem = rankArray.optJSONObject(i);
                    if (gitfBagItem != null) {
                        ActivityGiftBagInfo activityGiftBagInfo = new ActivityGiftBagInfo();
                        activityGiftBagInfo.name = gitfBagItem.optString("name");
                        activityGiftBagInfo.tips = gitfBagItem.optString("tips");
                        activityGiftBagInfo.url = gitfBagItem.optString("url");
                        activityGiftBagInfo.weight = gitfBagItem.optInt("weight", 0);
                        activityGiftBagInfo.propCnt = gitfBagItem.optInt("propCnt", 0);
                        activityGiftBagInfo.currencyAmount = gitfBagItem.optString("currencyAmount");
                        giftBags.add(activityGiftBagInfo);
                    }
                }
            }

            beginTime = response.optString("beginTime", "");
            endTime = response.optString("endTime", "");
            currentActivityConf = response.optString("currentActivityConf", "");

        } catch (Exception e) {
            RLog.error("GetGiftBagResponse", "parserResponse error.", e);
        }
    }

    public String getSeq() {
        return seq;
    }

    public int getResult() {
        return result;
    }

    public String getMessage() {
        return message;
    }

    public boolean getFirstCharge() {
        return firstCharge;
    }

    public boolean getHasBuy() {
        return hasBuy;
    }

    public int getPurchasedNum() {
        return purchasedNum;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public String getCurrentActivityConf() {
        return currentActivityConf;
    }

    public int getCmd() {
        return cmd;
    }

    public List<ActivityGiftBagInfo> getGiftBags() {
        return giftBags;
    }

}

