package com.yy.mobile.framework.revenuesdk.gift;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.service.media.MediaBrowserService;
import android.support.annotation.NonNull;
import android.util.Pair;

import com.yy.mobile.framework.revenuesdk.baseapi.ErrorCode;
import com.yy.mobile.framework.revenuesdk.baseapi.ServiceFailResult;
import com.yy.mobile.framework.revenuesdk.baseapi.data.IRevenueDataReceiver;
import com.yy.mobile.framework.revenuesdk.baseapi.data.IRevenueDataSender;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageBroadcast;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageResponse;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageUnicast;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.EventAlias;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.EventType;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.HiidoReport;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.IReporter;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.trace.TraceReport;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.SeqUtil;
import com.yy.mobile.framework.revenuesdk.gift.bean.ActivityGiftBagInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBagAcquireMessage;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBagAddMessage;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBroInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftComboFinishInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.MultiGiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.PackageWalletUpdateMessage;
import com.yy.mobile.framework.revenuesdk.gift.bean.SendGiftResInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.UserProps;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.GetGiftBagInfoResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.LoadAllGiftResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.LoadPackageGiftResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.LoadReceiveGiftAmountResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.QueryCouponStoreResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.RankEntranceResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.SendGiftResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.ToInfoResult;
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolBroUri;
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolCmd;
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolUnicastUri;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetGiftBagRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetGiftBagResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetPropsByAppIdRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetPropsByAppIdResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetPropsResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserCouponStoreRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserCouponStoreResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserPropsRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserPropsResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserReceivePropsAmountRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserReceivePropsAmountResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.RankEntranceRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.RankEntranceResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.SendGiftToMultiUserRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.SendGiftToMultiUserResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.ToInfoRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.ToInfoResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.UseItemRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.UseItemResponse;
import com.yy.mobile.framework.revenuesdk.gift.reporter.DefaultGiftReporter;
import com.yy.mobile.framework.revenuesdk.gift.reporter.IGiftReporter;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.GetGiftBagParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.GetToInfoParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadAllGiftJsonParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadAllGiftParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadPackageGiftParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadReceiveGiftAmountParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.QueryCouponStoreParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.RankEntranceParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.SendGiftParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.SendGiftParamV2;
import com.yy.mobile.framework.revenuesdk.gift.util.BroadcastMsgParser;
import com.yy.mobile.framework.revenuesdk.gift.util.GiftCacheInfoUtil;
import com.yy.mobile.framework.revenuesdk.gift.util.UnicastMsgParser;

import org.json.JSONObject;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by lhf on 2018/7/10.
 * <p>
 * YY.Inc
 */
@SuppressWarnings("javadoc")
public class GiftServiceImpl implements IGiftService, IRevenueDataReceiver {

    private static final String TAG = "GiftServiceImpl";
    private static final String GIFT_CALLBACK_TYPE_KEY = "json";
    private int mAppId;
    private int mUsedChannel;
    private int currentUsedchannel; //当前直播间使用的渠道
    private Context mContext;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private Handler workHandler;
    private IRevenueDataSender iDataSender;
    private IGiftReporter iGiftReporter;
    private String mCountryCode;
    private String mDefalutServiceName;
    private String mDefalutFunctionName;
    private GiftCache mGiftCache;
    private int retryCount = 0;

    // 拉取礼物请求参数存储
    private ConcurrentHashMap<String, Pair<Integer, Integer>> loadGiftParamMap =
            new ConcurrentHashMap<>();

    // 拉取礼物请求的CallBack存储
    private ConcurrentHashMap<String, String> loadGiftCallBackMap = new ConcurrentHashMap<>();

    /**
     * 礼物通知回调
     */
    private List<IGiftEventCallback> giftCallbackList = new ArrayList<>();

    public GiftServiceImpl(int appId, int usedChannel, String country, String clientVer,
                           String serviceName, String functionName, boolean requestReuse,
                           boolean isOpenRisk, IRevenueDataSender iDataSender,
                           Context context, IReporter iReporter) {
        mAppId = appId;
        mUsedChannel = usedChannel;
        mContext = context;
        mCountryCode = country;
        mDefalutServiceName = serviceName;
        mDefalutFunctionName = functionName;
        // 初始化线程
        HandlerThread workThread = new HandlerThread("Revenue_GiftServiceImpl");
        workThread.start();
        workHandler = new Handler(workThread.getLooper());
        mGiftCache = new GiftCache(appId, mContext, workHandler, usedChannel);
        iGiftReporter = new DefaultGiftReporter(iReporter, clientVer, country);
        this.iDataSender = iDataSender;
        // 不在初始化的时候加载礼物缓存
        //mGiftCache.initGiftFromFile();
    }

    @Override
    public void loadAllGift(@NonNull LoadAllGiftParam param,
                            @NonNull IGiftRequestCallback<LoadAllGiftResult> callback,
                            boolean forceUpdate) {
        RLog.info(TAG,
                "loadAllGift: appId = %d, usedChannel = %d, uid = %d, liveCategoryId = %d, ticket = %d",
                param.appId, param.channelId, param.uid, param.liveCategoryId, param.ticket);
        int appId = param.appId;
        if (appId == 0) {
            appId = mAppId;
        }
        int channelId = param.channelId;
        if (channelId == 0) {
            channelId = mUsedChannel;
        }
        List<GiftInfo> giftInfos = mGiftCache.getGiftList(channelId, param.liveCategoryId);
        if (forceUpdate || giftInfos == null || giftInfos.isEmpty()) {
            GetPropsByAppIdRequest request = new GetPropsByAppIdRequest();
            request.seq = SeqUtil.increaseSeqId();
            request.uid = param.uid;
            request.appId = appId;
            request.usedChannel = channelId;
            request.sid = param.sid;
            request.ssid = param.ssid;
            request.recvUid = param.recvUid;
            request.filterPropsTypes = param.filterPropsTypes;
            request.countryCode = param.countryCode;
            request.liveCategoryId = param.liveCategoryId;
            request.lastMd5Hash = mGiftCache.getLastMd5Hash(channelId, param.liveCategoryId);
            if (forceUpdate) {
                request.lastMd5Hash = "";
            }
            request.clientVersion = param.clientVersion;
            request.ticket = param.ticket;
            request.version = param.version;
            loadGiftParamMap
                    .put(request.seq, new Pair<>(request.usedChannel, request.liveCategoryId));
            RLog.info(TAG, "loadGiftParamMap--put: seq = %d", request.seq);
            sendRequest(request.seq, request, param.retry, callback);
            RLog.info(TAG, "sendRequest: seq = %d", request.seq);

        } else {
            GiftCacheInfo giftCacheInfo =
                    GiftCacheInfoUtil
                            .readGiftCacheInfoData(mContext, channelId, param.liveCategoryId);
            LoadAllGiftResult result = new LoadAllGiftResult();
            result.appId = mAppId;
            result.channelId = mUsedChannel;
            result.giftList = giftInfos;
            if (giftCacheInfo != null) {
                result.compressData = giftCacheInfo.compressData;
            } else {
                result.compressData = "";
            }
            callback.onSuccess(result);
        }
    }

    @Override
    public void loadAllGiftJsonData(@NonNull LoadAllGiftJsonParam param,
                                    @NonNull IGiftRequestCallback<String> callback,
                                    boolean forceUpdate) {

        RLog.info(TAG,
                "loadAllGiftJsonData: appId = %d, usedChannel = %d, uid = %d, liveCategoryId = %d, ticket = %d",
                param.appId, param.channelId, param.uid, param.liveCategoryId, param.ticket);
        int appId = param.appId;
        if (appId == 0) {
            appId = mAppId;
        }
        int channelId = param.channelId;
        if (channelId == 0) {
            channelId = mUsedChannel;
        }
        GetPropsByAppIdRequest request = new GetPropsByAppIdRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.uid = param.uid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.recvUid = param.recvUid;
        request.filterPropsTypes = param.filterPropsTypes;
        request.countryCode = param.countryCode;
        request.liveCategoryId = param.liveCategoryId;
        request.lastMd5Hash = param.lastMd5Hash;
        if (forceUpdate) {
            request.lastMd5Hash = "";
        }
        request.clientVersion = param.clientVersion;
        request.ticket = param.ticket;
        request.version = param.version;
        loadGiftCallBackMap.put(request.seq, GIFT_CALLBACK_TYPE_KEY);
        RLog.info(TAG, "loadGiftCallBackMap--put: seq = %d", request.seq);
        sendRequest(request.seq, request, param.retry, callback);
        RLog.info(TAG, "sendRequest: seq = %d", request.seq);
    }

    @Override
    public void loadPackageGift(@NonNull LoadPackageGiftParam param,
                                @NonNull IGiftRequestCallback<LoadPackageGiftResult> callback) {
        RLog.info(TAG, "loadPackageGift: appId = %d, usedChannel = %d, uid = %d", param.appId,
                param.channelId, param.uid);
        int appId = param.appId;
        if (appId == 0) {
            appId = mAppId;
        }
        int channelId = param.channelId;
        if (channelId == 0) {
            channelId = mUsedChannel;
        }
        GetUserPropsRequest request = new GetUserPropsRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.uid = param.uid;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.ticket = param.ticket;
        sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void loadReceiveGiftAmount(@NonNull LoadReceiveGiftAmountParam param, @NonNull
            IGiftRequestCallback<LoadReceiveGiftAmountResult> callback) {
        RLog.info(TAG, "loadReceiveGiftAmount: appId = %d, usedChannel = %d, uid = %d", param.appId,
                param.channelId, param.uid);
        int appId = param.appId;
        if (appId == 0) {
            appId = mAppId;
        }
        int channelId = param.channelId;
        if (channelId == 0) {
            channelId = mUsedChannel;
        }
        GetUserReceivePropsAmountRequest request = new GetUserReceivePropsAmountRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.uid = param.uid;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.anchorUid = param.anchorUid;
        sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void sendGiftToUser(@NonNull SendGiftParam param,
                               @NonNull IGiftRequestCallback<SendGiftResult> callback) {
        RLog.info(TAG,
                "loadPackageGift: appId = %d, usedChannel = %d, senderUid = %d, reciverUid = %d",
                mAppId, mUsedChannel, param.senderuid, param.recveruid);
        sendUseItemRequest(param, callback);
    }

    @Override
    public void sendGiftToMultiUser(@NonNull SendGiftParamV2 param,
                                    @NonNull IGiftRequestCallback<SendGiftResult> callback) {
        int appId = param.appId;
        if (appId == 0) {
            appId = mAppId;
        }
        int channelId = param.channelId;
        if (channelId == 0) {
            channelId = mUsedChannel;
        }
        SendGiftToMultiUserRequest request = new SendGiftToMultiUserRequest();
        String seq = SeqUtil.increaseSeqId();
        request.seq = seq;
        request.uid = param.senderuid;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.propsId = param.propsId;
        request.count = param.count;
        request.senderUid = param.senderuid;
        request.sendernickname = param.sendernickname;
        request.expend = param.expand;
        request.isAutoBuy = param.isAutoBuy;
        request.payGateOrderId = param.payGateOrderId;
        request.payWay = param.payWay;
        request.payAdditionInfo = param.payAdditionInfo;
        request.targetUsers = param.targetUsers;
        sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void getToInfo(@NonNull GetToInfoParam param,
                          @NonNull IGiftRequestCallback<ToInfoResult> callback) {
        RLog.info(TAG, "getToInfo: appId = %d, usedChannel = %d, uid = %d", mAppId, mUsedChannel,
                param.uid);
        int appId = param.appId;
        if (appId == 0) {
            appId = mAppId;
        }
        int channelId = param.channelId;
        if (channelId == 0) {
            channelId = mUsedChannel;
        }
        ToInfoRequest request = new ToInfoRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.uid = param.uid;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.appId = appId;
        request.usedChannel = channelId;
        sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void getRankEntranceInfo(@NonNull RankEntranceParam param,
                                    @NonNull IGiftRequestCallback<RankEntranceResult> callback) {
        RLog.info(TAG, "getRankEntranceInfo: appId = %d, usedChannel = %d, uid = %d", mAppId,
                mUsedChannel, param.uid);
        int appId = param.appId;
        if (appId == 0) {
            appId = mAppId;
        }
        int channelId = param.channelId;
        if (channelId == 0) {
            channelId = mUsedChannel;
        }
        RankEntranceRequest request = new RankEntranceRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.uid = param.uid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.code = param.code;
        request.rtype = param.rtype;
        request.ctype = param.ctype;
        request.latest = param.latest;
        request.size = param.size;
        request.timeParam = param.timeParam;
        sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void getGiftBagInfo(@NonNull GetGiftBagParam param,
                               @NonNull IGiftRequestCallback<GetGiftBagInfoResult> callback) {
        RLog.info(TAG, "getGiftBagInfo: appId = %d, usedChannel = %d", mAppId,
                mUsedChannel);
        int appId = param.appId;
        if (appId == 0) {
            appId = mAppId;
        }
        int channelId = param.usedChannel;
        if (channelId == 0) {
            channelId = mUsedChannel;
        }

        GetGiftBagRequest request = new GetGiftBagRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.appId = appId;
        request.uid = param.uid;
        request.usedChannel = channelId;
        request.giftPropId = param.giftPropId;
        request.currencyType = param.currencyType;
        request.actId = param.actId;

        sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void queryUserCouponStore(@NonNull QueryCouponStoreParam param,
                                     @NonNull
                                             IGiftRequestCallback<QueryCouponStoreResult> callback) {
        RLog.info(TAG, "queryUserCouponStore: appId = %d, usedChannel = %d", mAppId,
                mUsedChannel);

        String seq = SeqUtil.increaseSeqId();
        GetUserCouponStoreRequest request = new GetUserCouponStoreRequest(param);
        param.setSeq(seq);
        sendRequest(seq, request, null, callback);
    }

    @Override
    public List<GiftInfo> getAllGift(int usedChannel) {
        return getAllGift(usedChannel, 0);
    }

    @Override
    public List<GiftInfo> getAllGift(int usedChannel, int liveCategoryId) {
        return mGiftCache.getGiftList(usedChannel, liveCategoryId);
    }

    @Override
    public List<GiftInfo> getAllChannelGift() {
        return new ArrayList<>();
    }

    @Override
    public GiftInfo findGiftById(int propsId) {
        return mGiftCache.findGiftById(propsId);
    }

    @Override
    public GiftInfo findGiftById(int propsId, int usedChannel) {
        return mGiftCache.findGiftById(propsId, usedChannel);
    }

    @Override
    public void setCurrentUsedChannel(int usedChannel) {
        currentUsedchannel = usedChannel;
    }

    @Override
    public void addGiftEventCallback(@NonNull IGiftEventCallback giftCallback) {
        if (!giftCallbackList.contains(giftCallback)) {
            giftCallbackList.add(giftCallback);
        }
    }

    @Override
    public void removeGiftEventCallback(@NonNull IGiftEventCallback giftCallback) {
        if (giftCallbackList.contains(giftCallback)) {
            giftCallbackList.remove(giftCallback);
        }
    }

    @Override
    public void registerGiftReporter(IGiftReporter iGiftReporter) {
        this.iGiftReporter = iGiftReporter;
    }

    @Override
    public void clearAllGiftCache() {
        mGiftCache.clearAllGiftCache();
    }

    @Override
    public void clearGiftCacheByChannelAndCategoryId(int usedChannel, int liveCategoryId) {
        mGiftCache.clearGiftCacheByChannelAndCategoryId(usedChannel, liveCategoryId);
    }

    @Override
    public void setCountryCode(String countryCode) {
        mCountryCode = countryCode;
    }

    private void sendRequest(String seq, BaseJsonRequest request, ArrayList<Integer> retry,
                             IGiftRequestCallback callback) {
        if (iDataSender != null) {
            Map header = new HashMap();
            header.put("traceid", TraceReport.Companion.getTraceId());
            header.put("pageid", TraceReport.Companion.getPageId());
            iDataSender.sendData(mAppId, seq, retry, header, request.marshall());
            if (callback != null) {
                CallbackMode.getInstance().registerCallback(seq, callback);
            }
        }
    }

    private void onGetPropsJsonDataByAppIdResp(final GetPropsResponse responseData,
                                               final PSCIMessageResponse psciResponseData) {
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mUid = responseData.getUid();
        loadGiftCallBackMap.remove(responseData.getSeq());
        RLog.info(TAG, "loadGiftCallBackMap--remove: seq = %d", responseData.getSeq());
        if (responseData.getResult() == ErrorCode.SUCCESS) {
            CallbackMode.getInstance()
                    .onCallbackSuccess(responseData.getSeq(), psciResponseData.jsonMsg);
            if (iGiftReporter != null) {
                reportResponse.mEventId = EventType.GiftEventID.LOAD_ALL_GIFT_SUCCESS;
                reportResponse.mEventaliae = EventAlias.GiftEventAlias.LOAD_ALL_GIFT_SUCCESS;
                reportResponse.mErrCode = responseData.getResult() + "";
                reportResponse.mErrMsg = responseData.getMessage();
                iGiftReporter.onLoadAllGiftResault(reportResponse);
            }
            RLog.info(TAG, "onGetPropsJsonDataByAppIdResp sucess:" + psciResponseData.jsonMsg);
        } else {
            CallbackMode.getInstance()
                    .onCallbackFail(responseData.getSeq(), responseData.getResult(),
                            responseData.getMessage());
            RLog.error(TAG, "onGetPropsJsonDataByAppIdResp fail reason = %s",
                    responseData.getMessage());
            if (iGiftReporter != null) {
                reportResponse.mEventId = EventType.GiftEventID.LOAD_ALL_GIFT_FAIL;
                reportResponse.mEventaliae = EventAlias.GiftEventAlias.LOAD_ALL_GIFT_FAIL;
                reportResponse.mErrCode = responseData.getResult() + "";
                reportResponse.mErrMsg = responseData.getMessage();
                iGiftReporter.onLoadAllGiftResault(reportResponse);
            }
        }
    }

    /**
     * 获取礼物列表返回
     *
     * @param responseData
     */
    private void onGetPropsByAppIdResp(final GetPropsByAppIdResponse responseData) {
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mUid = responseData.getUid();
        Pair<Integer, Integer> reqParam = loadGiftParamMap.remove(responseData.getSeq());
        RLog.info(TAG, "loadGiftParamMap--remove: seq = %d", responseData.getSeq());
        if (responseData.getResult() == ErrorCode.SUCCESS) {
            List<GiftInfo> giftInfos = mGiftCache
                    .getGiftList(responseData.getUsedChannel(),
                            responseData.getLiveCategoryId());
            if ("".equals(responseData.getCompressData())) {
                RLog.info(TAG, "onGetPropsByAppIdResp : md5Hash not change");
            } else {
                giftInfos = responseData.getPropsList();
                mGiftCache.updateGiftList(responseData.getUsedChannel(),
                        responseData.getLiveCategoryId(),
                        responseData.getPropsList(),
                        responseData.getUrlPrefix(),
                        responseData.getCompressData(),
                        giftInfos.isEmpty() ? "" : responseData.getMd5Version());
            }
            // 这里再加个保护
            if (giftInfos == null) {
                giftInfos = new ArrayList<>();
            }
            LoadAllGiftResult result = new LoadAllGiftResult();
            result.appId = mAppId;
            result.channelId = responseData.getUsedChannel();
            result.giftList = giftInfos;
            result.expand = responseData.getExpand();
            result.compressData = responseData.getCompressData();
            CallbackMode.getInstance().onCallbackSuccess(responseData.getSeq(), result);
            if (iGiftReporter != null) {
                reportResponse.mEventId = EventType.GiftEventID.LOAD_ALL_GIFT_SUCCESS;
                reportResponse.mEventaliae = EventAlias.GiftEventAlias.LOAD_ALL_GIFT_SUCCESS;
                reportResponse.mErrCode = responseData.getResult() + "";
                reportResponse.mErrMsg = responseData.getMessage();
                iGiftReporter.onLoadAllGiftResault(reportResponse);
            }
            RLog.info(TAG, "onGetPropsByAppIdResp sucess, seq:" + responseData.getSeq());
        } else {
            // 加载礼物列表失败，尝试加载缓存的礼物数据
            if (reqParam != null) {
                mGiftCache.loadGiftListFromCache(reqParam.first, reqParam.second);
            }
            CallbackMode.getInstance()
                    .onCallbackFail(responseData.getSeq(), responseData.getResult(),
                            responseData.getMessage());
            RLog.error(TAG, "GetPropsByAppIdResp fail reason = %s", responseData.getMessage());
            if (iGiftReporter != null) {
                reportResponse.mEventId = EventType.GiftEventID.LOAD_ALL_GIFT_FAIL;
                reportResponse.mEventaliae = EventAlias.GiftEventAlias.LOAD_ALL_GIFT_FAIL;
                reportResponse.mErrCode = responseData.getResult() + "";
                reportResponse.mErrMsg = responseData.getMessage();
                iGiftReporter.onLoadAllGiftResault(reportResponse);
            }
        }
    }

    /**
     * 获取账号信息返回
     *
     * @param toInfoResponse
     */
    private void onToInfoResponse(ToInfoResponse toInfoResponse) {
        if (toInfoResponse.getResult() == ErrorCode.SUCCESS) {
            ToInfoResult result = new ToInfoResult(toInfoResponse.getAccountList(),
                    toInfoResponse.getUserPropsList(),
                    toInfoResponse.getAccountPeriodList(), toInfoResponse.getMinAmountLimit());
            CallbackMode.getInstance().onCallbackSuccess(toInfoResponse.getSeq(), result);
        } else {
            RLog.error(TAG, "onToInfoResponse fail reason = %s", toInfoResponse.getMessage());
            CallbackMode.getInstance()
                    .onCallbackFail(toInfoResponse.getSeq(), toInfoResponse.getResult(),
                            toInfoResponse.getMessage());
        }
    }

    /**
     * 获取包裹列表返回
     *
     * @param res
     */
    private void onGetUserPropsResponse(GetUserPropsResponse res) {
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mUid = res.getUid();
        if (res.getResult() == ErrorCode.SUCCESS) {
            RLog.info(TAG, "onGetUserPropsResponse: uid = %d, appId = %d, usedChannel = %d",
                    res.getUid(), res.getAppId(), res.getUsedChannel());
            final List<GiftInfo> packageGiftList = new ArrayList<>();
            if (res.getUserProps().propsItemList != null) {
                for (UserProps.PropsItem propsItem : res.getUserProps().propsItemList) {
                    GiftInfo giftInfo = findGiftById(propsItem.propsId, res.getUsedChannel());
                    if (giftInfo != null) {
                        giftInfo.count = propsItem.count;
                        giftInfo.expireCount = propsItem.expireCount;
                        packageGiftList.add(giftInfo);
                    }
                }
            }
            LoadPackageGiftResult result = new LoadPackageGiftResult();
            result.appId = mAppId;
            result.channelId = mUsedChannel;
            result.packageGiftList = packageGiftList;
            CallbackMode.getInstance().onCallbackSuccess(res.getSeq(), result);
            if (iGiftReporter != null) {
                reportResponse.mEventId = EventType.GiftEventID.LOAD_PACKAGE_GIFT_SUCCESS;
                reportResponse.mEventaliae = EventAlias.GiftEventAlias.LOAD_PACKAGE_GIFT_SUCCESS;
                reportResponse.mErrCode = res.getResult() + "";
                reportResponse.mErrMsg = res.getMessage();
                iGiftReporter.onLoadPackageGiftResault(reportResponse);
            }
        } else {
            RLog.error(TAG, "onGetUserPropsResponse fail reason = %s", res.getMessage());
            CallbackMode.getInstance()
                    .onCallbackFail(res.getSeq(), res.getResult(), res.getMessage());
            if (iGiftReporter != null) {
                reportResponse.mEventId = EventType.GiftEventID.LOAD_PACKAGE_GIFT_FAIL;
                reportResponse.mEventaliae = EventAlias.GiftEventAlias.LOAD_PACKAGE_GIFT_FAIL;
                reportResponse.mErrCode = res.getResult() + "";
                reportResponse.mErrMsg = res.getMessage();
                iGiftReporter.onLoadPackageGiftResault(reportResponse);
            }
        }
    }

    /**
     * 获取贡献榜入口值返回
     *
     * @param res
     */
    private void onRankEntranceResponse(RankEntranceResponse res) {
        if (res.getResult() == ErrorCode.SUCCESS) {
            RLog.info(TAG, "onRankEntranceResponse success");
            RankEntranceResult result = new RankEntranceResult(res.getRankList());
            CallbackMode.getInstance().onCallbackSuccess(res.getSeq(), result);
        } else {
            RLog.error(TAG, "onGetUserPropsResponse fail reason = %s", res.getMessage());
            CallbackMode.getInstance()
                    .onCallbackFail(res.getSeq(), res.getResult(), res.getMessage());
        }
    }

    /**
     * 获取活动礼包信息
     *
     * @param res
     */
    private void onGetGiftBagResponse(GetGiftBagResponse res) {
        if (res.getResult() == ErrorCode.SUCCESS) {
            RLog.info(TAG, "onGetGiftBagResponse success");
            GetGiftBagInfoResult result = new GetGiftBagInfoResult();

            result.firstCharge = res.getFirstCharge();
            result.hasBuy = res.getHasBuy();
            result.purchasedNum = res.getPurchasedNum();
            result.giftBags = res.getGiftBags();
            result.beginTime = res.getBeginTime();
            result.endTime = res.getEndTime();
            result.currentActivityConf = res.getCurrentActivityConf();

            CallbackMode.getInstance().onCallbackSuccess(res.getSeq(), result);
        } else {
            RLog.error(TAG, "onGetGiftBagResponse fail reason = %s", res.getMessage());
            CallbackMode.getInstance()
                    .onCallbackFail(res.getSeq(), res.getResult(), res.getMessage());
        }
    }

    /**
     * 送礼给多人回调.
     *
     * @param response
     */
    private void onSendGiftToMultiUserResponse(SendGiftToMultiUserResponse response) {
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mUid = response.getUid();
        final String seq = response.getSeq();
        final int code = response.getResult();
        final String message = response.getMessage();
        final SendGiftResInfo sendGiftResInfo = new SendGiftResInfo();
        sendGiftResInfo.propsId = response.getPropsId();
        sendGiftResInfo.count = response.getCount();
        sendGiftResInfo.appId = response.getAppId();
        sendGiftResInfo.senderuid = response.getSenderUid();
        sendGiftResInfo.sendernickname = response.getSendernickname();
        sendGiftResInfo.expend = response.getExpend();
        sendGiftResInfo.confirmUrl = response.getConfirmUrl();
        if (code == ErrorCode.SUCCESS || code == ErrorCode.CONSUME_CONFIRM_NEED) {
            SendGiftResult result = new SendGiftResult();
            result.appId = mAppId;
            result.channelId = mUsedChannel;
            result.resInfo = sendGiftResInfo;
            CallbackMode.getInstance().onCallbackSuccess(seq, result);
            if (iGiftReporter != null) {
                reportResponse.mEventId = EventType.GiftEventID.SEND_GIFT_TO_MULTIUSER_SUCCESS;
                reportResponse.mEventaliae =
                        EventAlias.GiftEventAlias.SEND_GIFT_TO_MULTIUSER_SUCCESS;
                reportResponse.mErrCode = code + "";
                reportResponse.mErrMsg = message;
                iGiftReporter.onSendGiftToMultiUserResault(reportResponse);
                reportResponse.mEventId = EventType.GiftSummaryEventID.SUMMARY_SEND_MULTI_SUCCESS;
                reportResponse.mEventaliae =
                        EventAlias.GiftSummaryEventAlias.SUMMARY_SEND_MULTI_SUCCESS;
                iGiftReporter.onSendSingleSummaryResult(reportResponse);
            }
        } else {
            CallbackMode.getInstance().onCallbackFail(seq, code, message);
            if (iGiftReporter != null) {
                reportResponse.mEventId = EventType.GiftEventID.SEND_GIFT_TO_MULTIUSER_FAIL;
                reportResponse.mEventaliae = EventAlias.GiftEventAlias.SEND_GIFT_TO_MULTIUSER_FAIL;
                reportResponse.mErrCode = code + "";
                reportResponse.mErrMsg = message;
                iGiftReporter.onSendGiftToMultiUserResault(reportResponse);
                reportResponse.mEventId = EventType.GiftSummaryEventID.SUMMARY_SEND_MULTI_FAIL;
                reportResponse.mEventaliae =
                        EventAlias.GiftSummaryEventAlias.SUMMARY_SEND_MULTI_FAIL;
                iGiftReporter.onSendSingleSummaryResult(reportResponse);
            }
        }
    }

    private void onGetUserReceivePropsAmountResponse(GetUserReceivePropsAmountResponse res) {
        if (res.getResult() == ErrorCode.SUCCESS) {
            RLog.info(TAG,
                    "onGetUserReceivePropsAmountResponse: uid = %d, appId = %d, usedChannel = %d",
                    res.getUid(), res.getAppId(), res.getUsedChannel());
            LoadReceiveGiftAmountResult result = new LoadReceiveGiftAmountResult();
            result.appId = mAppId;
            result.channelId = mUsedChannel;
            result.giftList = res.getRecvPropsList();
            CallbackMode.getInstance().onCallbackSuccess(res.getSeq(), result);
        } else {
            RLog.error(TAG, "onGetUserReceivePropsAmountResponse fail reason = %s",
                    res.getMessage());
            CallbackMode.getInstance()
                    .onCallbackFail(res.getSeq(), res.getResult(), res.getMessage());
        }
    }

    private void onGetUserCouponStoreResponse(GetUserCouponStoreResponse rsp) {
        RLog.info(TAG,
                "onGetUserCouponStoreResponse: uid = %d, appId = %d, result = %d, message = %s",
                rsp.getUid(), rsp.getAppId(), rsp.getResult(), rsp.getMessage());
        if (rsp.isSuccess()) {
            CallbackMode.getInstance().onCallbackSuccess(rsp.getSeq(), rsp.getRspResult());
        } else {
            CallbackMode.getInstance()
                    .onCallbackFail(rsp.getSeq(), rsp.getResult(), rsp.getMessage());
        }
    }

    /**
     * 发送赠送礼物请求(默认只使用包裹礼物)
     *
     * @param param
     * @param callback
     */
    private void sendUseItemRequest(SendGiftParam param,
                                    IGiftRequestCallback<SendGiftResult> callback) {
        int appId = param.appId;
        if (appId == 0) {
            appId = mAppId;
        }
        int channelId = param.channelId;
        if (channelId == 0) {
            channelId = mUsedChannel;
        }

        retryCount = 3;

        UseItemRequest request = new UseItemRequest();
        String seq = SeqUtil.increaseSeqId();
        request.seq = seq;
        request.uid = param.senderuid;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.propsId = param.propsId;
        request.count = param.count;
        request.senderUid = param.senderuid;
        request.sendernickname = param.sendernickname;
        request.recveruid = param.recveruid;
        request.recvernickname = param.recvernickname;
        request.realRecveruid = param.realRecveruid;
        request.realRecvernickname = param.realRecvernickname;
        request.anchorUid = param.recveruid;
        request.expend = param.expand;
        request.isAutoBuy = param.isAutoBuy;
        request.payGateOrderId = param.payGateOrderId;
        request.payWay = param.payWay;
        request.payAdditionInfo = param.payAdditionInfo;
        sendRequest(request.seq, request, param.retry, callback);
    }

    /**
     * 使用包裹礼物结果返回
     *
     * @param useItemResponse
     */
    private void onUseItemResponse(UseItemResponse useItemResponse) {
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mUid = useItemResponse.getUid();
        final String seq = useItemResponse.getSeq();
        final int code = useItemResponse.getResult();
        final String message = useItemResponse.getMessage();
        final SendGiftResInfo sendGiftResInfo = new SendGiftResInfo();
        sendGiftResInfo.propsId = useItemResponse.getPropsId();
        sendGiftResInfo.count = useItemResponse.getCount();
        sendGiftResInfo.appId = useItemResponse.getAppId();
        sendGiftResInfo.senderuid = useItemResponse.getSenderUid();
        sendGiftResInfo.sendernickname = useItemResponse.getSendernickname();
        sendGiftResInfo.recveruid = useItemResponse.getRecveruid();
        sendGiftResInfo.recvernickname = useItemResponse.getRecvernickname();
        sendGiftResInfo.realRecveruid = useItemResponse.getRealRecveruid();
        sendGiftResInfo.realRecvernickname = useItemResponse.getRealRecvernickname();
        sendGiftResInfo.expend = useItemResponse.getExpend();
        sendGiftResInfo.confirmUrl = useItemResponse.getConfirmUrl();
        sendGiftResInfo.buyCount = useItemResponse.getBuyCount();
        /*
         *  cdm=1009这个接口有两个功能（可以看成两个接口），购买礼包和送礼。
         *  下面的条件都表示成功，SUCCESS对应送礼成功，CONSUME_CONFIRM_NEED表示购买礼包下单成功
         */
        if (code == ErrorCode.SUCCESS || code == ErrorCode.CONSUME_CONFIRM_NEED) {
            SendGiftResult result = new SendGiftResult();
            result.appId = mAppId;
            result.channelId = mUsedChannel;
            result.resInfo = sendGiftResInfo;
            CallbackMode.getInstance().onCallbackSuccess(seq, result);
            if (iGiftReporter != null) {
                reportResponse.mEventId = EventType.GiftEventID.SEND_GIFT_TO_USER_SUCCESS;
                reportResponse.mEventaliae = EventAlias.GiftEventAlias.SEND_GIFT_TO_USER_SUCCESS;
                reportResponse.mErrCode = code + "";
                reportResponse.mErrMsg = message;
                iGiftReporter.onSendGiftToUserResault(reportResponse);
                reportResponse.mEventId = EventType.GiftSummaryEventID.SUMMARY_SEND_SINGLE_SUCCESS;
                reportResponse.mEventaliae =
                        EventAlias.GiftSummaryEventAlias.SUMMARY_SEND_SINGLE_SUCCESS;
                iGiftReporter.onSendSingleSummaryResult(reportResponse);
            }
        }
//        else if (code == ErrorCode.SDK_TIMEOUT || code == ErrorCode.SDK_TIMEOUT_CONNECT_FAIL) {
//        }
        else {
            CallbackMode.getInstance().onCallbackFail(seq, code, message);
            if (iGiftReporter != null) {
                reportResponse.mEventId = EventType.GiftEventID.SEND_GIFT_TO_USER_FAIL;
                reportResponse.mEventaliae = EventAlias.GiftEventAlias.SEND_GIFT_TO_USER_FAIL;
                reportResponse.mErrCode = code + "";
                reportResponse.mErrMsg = message;
                iGiftReporter.onSendGiftToUserResault(reportResponse);
                reportResponse.mEventId = EventType.GiftSummaryEventID.SUMMARY_SEND_SINGLE_FAIL;
                reportResponse.mEventaliae =
                        EventAlias.GiftSummaryEventAlias.SUMMARY_SEND_SINGLE_FAIL;
                iGiftReporter.onSendSingleSummaryResult(reportResponse);
            }
        }
    }

    /**
     * 解析礼物广播数据
     *
     * @param broadcastData
     */
    private void onGiftBroadcastData(PSCIMessageBroadcast broadcastData) {
        JSONObject data = broadcastData.getData();
        int propsId = data.optInt("props_id", 0);
        int usedChannel = data.optInt("used_channel", mUsedChannel);
        // 这里使用客户端传进来的usedChannel，不然无法多端互通
        GiftInfo giftInfo = findGiftById(propsId, currentUsedchannel);
        if (giftInfo != null) {
            final GiftBroInfo giftBroInfo = BroadcastMsgParser.parseGiftBroInfo(data);
            giftBroInfo.giftInfo = giftInfo;
            mainHandler.post(() -> {
                for (IGiftEventCallback iGiftEventCallback : giftCallbackList) {
                    iGiftEventCallback
                            .onGiftBroadcastInfo(mAppId, giftBroInfo.usedChannel, giftBroInfo);
                }
            });
        } else {
            RLog.error(TAG, "onGiftBroadcastData findGiftInfo == null! propsId = %d", propsId);
        }
    }

    /**
     * 礼包发放后，单播通知客户端刷新包裹信息
     *
     * @param unicastData
     */
    private void onGiftBagAddMessage(final PSCIMessageUnicast unicastData) {
        final GiftBagAddMessage giftBagAddMessage =
                UnicastMsgParser.parseGiftBagAddMessage(unicastData.getData());
        mainHandler.post(() -> {
            for (IGiftEventCallback iGiftEventCallback : giftCallbackList) {
                iGiftEventCallback
                        .onGiftBagAddUnicast(unicastData.getAppId(), unicastData.getChannelId(),
                                giftBagAddMessage);
            }
        });
    }

    /**
     * 礼包使用后，单播通知获得的道具信息
     *
     * @param unicastData
     */
    private void onGiftBagAcquireMessage(final PSCIMessageUnicast unicastData) {
        final GiftBagAcquireMessage acquireMessage =
                UnicastMsgParser.parseGiftBagAcquireMessage(unicastData.getData());
        mainHandler.post(() -> {
            for (IGiftEventCallback iGiftEventCallback : giftCallbackList) {
                iGiftEventCallback
                        .onGiftBagAcquireUnicast(unicastData.getAppId(),
                                unicastData.getChannelId(),
                                acquireMessage);
            }
        });
    }

    /**
     * 单播通知客户端需更新货币账户或礼物包裹.
     *
     * @param data
     */
    private void onUpdatePackageWallet(final PSCIMessageUnicast data) {
        final PackageWalletUpdateMessage message =
                UnicastMsgParser.parsePackageUpdateMessage(data.getData());
        mainHandler.post(() -> {
            for (IGiftEventCallback iGiftEventCallback : giftCallbackList) {
                iGiftEventCallback
                        .onPackageWalletUpdate(data.getAppId(), data.getChannelId(), message);
            }
        });
    }

    /**
     * 礼物连击结束特效广播
     *
     * @param broadcastData
     */
    private void onGiftComboFinishData(PSCIMessageBroadcast broadcastData) {
        JSONObject data = broadcastData.getData();
        int propsId = data.optInt("props_id", 0);
        int usedChannel = data.optInt("used_channel", mUsedChannel);
        GiftInfo giftInfo = findGiftById(propsId, currentUsedchannel);
        if (giftInfo != null) {
            final GiftComboFinishInfo comboFinishInfo =
                    BroadcastMsgParser.parseGiftComboFinishInfo(data);
            comboFinishInfo.giftInfo = giftInfo;
            mainHandler.post(() -> {
                for (IGiftEventCallback iGiftEventCallback : giftCallbackList) {
                    iGiftEventCallback
                            .onGiftComboFinishInfo(mAppId, comboFinishInfo.usedChannel,
                                    comboFinishInfo);
                }
            });
        } else {
            RLog.error(TAG, "onGiftComboFinishData findGiftInfo == null! propsId = %d",
                    propsId);
        }
    }

    private void onMultiGiftBroadcastData(PSCIMessageBroadcast broadcastData) {
        JSONObject data = broadcastData.getData();
        int propsId = data.optInt("props_id", 0);
        GiftInfo giftInfo = findGiftById(propsId, currentUsedchannel);
        MultiGiftInfo multiGiftInfo = BroadcastMsgParser.parseMultiGiftInfo(data);
        if (giftInfo != null) {
            multiGiftInfo.giftInfo = giftInfo;
            mainHandler.post(() -> {
                for (IGiftEventCallback iGiftEventCallback : giftCallbackList) {
                    iGiftEventCallback
                            .onMultiGiftBroadcastInfo(mAppId, multiGiftInfo.usedChannel,
                                    multiGiftInfo);
                }
            });
        } else {
            RLog.error(TAG, "onMultiGiftBroadcastData multiGiftInfo == null! propsId = %d",
                    propsId);
        }
    }

    /**
     * 判断获取礼物回调数据的类型是否为String
     *
     * @param callback
     * @return
     */
    private static boolean isCallBackTypeString(IGiftRequestCallback callback) {
        if (callback == null) {
            return false;
        }
        Type[] actualTypeArguments = null;
        Type[] interfaces = callback.getClass().getGenericInterfaces();
        Type type = null;
        if (interfaces == null || interfaces.length == 0) {
            Type superclass = callback.getClass().getGenericSuperclass();
            if (superclass instanceof ParameterizedType) {
                actualTypeArguments = ((ParameterizedType) superclass).getActualTypeArguments();
            }
        } else if (interfaces[0] instanceof ParameterizedType) {
            actualTypeArguments = ((ParameterizedType)interfaces[0]).getActualTypeArguments();
        }
        if (actualTypeArguments != null && actualTypeArguments.length > 0) {
            type = actualTypeArguments[0];
        }
        if (type != null &&
                ((type.toString()).equalsIgnoreCase((String.class).toString()) ||
                        type.equals(String.class))) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public void onResponseData(int appId, PSCIMessageResponse responseData) {
        RLog.info(TAG, "onResponseData: appId = %d, cmd = %d, jsonMsg = %s",
                appId,
                responseData.cmd,
                responseData.jsonMsg);
        switch (responseData.cmd) {
            case ProtocolCmd.GetPropsByAppIdResponse:
                //添加处理，该拓展主要为兼容hago的内存优化测试，TODO：稳定后需要整合
                GetPropsResponse response = new GetPropsResponse(responseData.jsonMsg);
                String callbackType = loadGiftCallBackMap.get(response.getSeq());
                RLog.info(TAG, "onResponseData: callbackType = %s, seq = %s ", callbackType,
                        response.getSeq());
                IGiftRequestCallback callback =
                        CallbackMode.getInstance().getCallback(response.getSeq());

                boolean isStringCallback = isCallBackTypeString(callback);
                RLog.info(TAG, "onResponseData: isStringCallback =" + isStringCallback);
                if (callbackType != null && callbackType.equals(GIFT_CALLBACK_TYPE_KEY)) {
                    //先判断类型是否为JSON
                    onGetPropsJsonDataByAppIdResp(response, responseData);
                    RLog.info(TAG, "onResponseData: callbackType = json");
                } else {
                    if (callback != null && isStringCallback) {
                        if (callbackType == null) {
                            // callbackType ==null，且callback是String，说明map获取失败，直接回调错误：-31
                            callback.onFail(ErrorCode.GIFT_CALLBACK_TYPE_ERROR,
                                    "Gift callback data type error");
                        } else {
                            onGetPropsJsonDataByAppIdResp(response, responseData);
                            RLog.info(TAG, "onResponseData: isStringCallback = true");
                        }
                    } else {
                        RLog.info(TAG, "onResponseData: isStringCallback = false");
                        onGetPropsByAppIdResp(new GetPropsByAppIdResponse(responseData.jsonMsg));
                        if (callback == null) {
                            RLog.error(TAG, "onResponseData:GetPropsByAppIdResponse error " +
                                    " callback == null ");
                        }
                    }
                }
                break;
            case ProtocolCmd.ToInfoResponse:
                onToInfoResponse(new ToInfoResponse(responseData.jsonMsg));
                break;
            case ProtocolCmd.UseItemResponse:
            case ProtocolCmd.ConsumeAndUseResponse:
                onUseItemResponse(new UseItemResponse(responseData.jsonMsg));
                break;
            case ProtocolCmd.GetUserPropsResponse:
                onGetUserPropsResponse(new GetUserPropsResponse(responseData.jsonMsg));
                break;
            case ProtocolCmd.RankEntranceResponse:
                onRankEntranceResponse(new RankEntranceResponse(responseData.jsonMsg));
                break;
            case ProtocolCmd.ConsumeAndUseMultipleResponse:
                onSendGiftToMultiUserResponse(
                        new SendGiftToMultiUserResponse(responseData.jsonMsg));
                break;
            case ProtocolCmd.ConsumeUserReceivePropsAmountResponse:
                onGetUserReceivePropsAmountResponse(
                        new GetUserReceivePropsAmountResponse(responseData.jsonMsg));
                break;
            case ProtocolCmd.GetUserCouponStoreResponse:
                onGetUserCouponStoreResponse(
                        new GetUserCouponStoreResponse(responseData.jsonMsg));
                break;

            case ProtocolCmd.GetGiftBagResponse:
                onGetGiftBagResponse(
                        new GetGiftBagResponse(responseData.jsonMsg));
                break;

            default:
                break;
        }
    }

    @Override
    public void onUnicastData(int appId, PSCIMessageUnicast unicastData) {
        if (unicastData.getUri() == ProtocolUnicastUri.GiftBagAddMessageUri) {
            // 礼包发放后，单播通知客户端刷新包裹信息
            onGiftBagAddMessage(unicastData);
        } else if (unicastData.getUri() == ProtocolUnicastUri.GiftBagAcquireMessageUri) {
            // 礼包使用后，单播通知获得的道具信息
            onGiftBagAcquireMessage(unicastData);
        } else if (unicastData.getUri() == ProtocolUnicastUri.URI_UPDATE_WALLET) {
            onUpdatePackageWallet(unicastData);
        } else {
            RLog.error(TAG, "onUnicastData not match any uri!");
        }
    }

    @Override
    public void onBroadcastData(int appId, PSCIMessageBroadcast broadcastData) {
        if (broadcastData.getUri() == ProtocolBroUri.GiftBroadcastUri) {
            // 礼物广播
            onGiftBroadcastData(broadcastData);
        } else if (broadcastData.getUri() == ProtocolBroUri.ComboFinishMessage) {
            // 礼物连击结束特效广播
            onGiftComboFinishData(broadcastData);
        } else if (broadcastData.getUri() == ProtocolBroUri.MultiGIftBroadcastUri) {
            // 多人送礼广播
            onMultiGiftBroadcastData(broadcastData);
        } else {
            RLog.error(TAG, "onBroadcastData not match any uri!");
        }
    }

    @Override
    public void onRequestError(int appId, String seq, int cmd, int srvErrorCode, String message) {
        CallbackMode.getInstance().onCallbackFail(seq, srvErrorCode, message);
    }
}
