/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request;

import android.os.Handler;
import android.os.Looper;
import com.yy.mobile.framework.revenuesdk.baseapi.RetryPolicy;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.SeqUtil;
import com.yy.mobile.framework.revenuesdk.payapi.request.RequestParams;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.DefaultRetryPolicy;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.IDataSender;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequest;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.ProtocolEncoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0012\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\u0006\u0010\r\u001a\u00020\u0004\u0012\u0006\u0010\u000e\u001a\u00020\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010 \u001a\u00020\u0004H\u0016J\b\u0010!\u001a\u00020\u0018H\u0016J\b\u0010\"\u001a\u00020\u0004H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020\u0004H\u0016J\b\u0010%\u001a\u00020\u0004H\u0016J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0018J\b\u0010)\u001a\u00020\u001eH\u0016J\b\u0010*\u001a\u00020\u001eH\u0016J\b\u0010+\u001a\u00020\u0014H\u0016J\u0012\u0010,\u001a\u00020\u001e2\b\u0010-\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010.\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/request/RetryRequestJob;", "Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/DefaultRetryPolicy;", "Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/request/IRequest;", "command", "", "appId", "params", "Lcom/yy/mobile/framework/revenuesdk/payapi/request/RequestParams;", "encoder", "Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/request/ProtocolEncoder;", "iDataSender", "Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/IDataSender;", "retryCount", "intervalMs", "timeOutMs", "retryType", "(IILcom/yy/mobile/framework/revenuesdk/payapi/request/RequestParams;Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/request/ProtocolEncoder;Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/IDataSender;IIII)V", "extParam", "", "isRun", "", "req", "Lcom/yy/mobile/framework/revenuesdk/baseapi/protocolbase/BaseJsonRequest;", "seq", "", "getSeq", "()Ljava/lang/String;", "setSeq", "(Ljava/lang/String;)V", "cancel", "", "getExtParam", "getReqCommand", "getReqSeq", "getRetryCount", "getRetryInterval", "getTimeout", "getTotalRetryCount", "onRequestError", "srvErrorCode", "message", "onRetry", "retryCountExhaust", "run", "setExtParam", "param", "stop", "Companion", "payservice_release"})
public final class RetryRequestJob
extends DefaultRetryPolicy
implements IRequest {
    private BaseJsonRequest req;
    private boolean isRun;
    private Object extParam;
    @NotNull
    private String seq;
    private final int command;
    private final int appId;
    private final RequestParams params;
    private final ProtocolEncoder encoder;
    private final IDataSender iDataSender;
    private int retryCount;
    private int intervalMs;
    private int timeOutMs;
    private int retryType;
    @NotNull
    public static final String TAG = "RetryRequestJob";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getSeq() {
        return this.seq;
    }

    public final void setSeq(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.seq = string;
    }

    public final void onRequestError(int srvErrorCode, @Nullable String message) {
        switch (srvErrorCode) {
            case 408: 
            case 504: 
            case 110001: 
            case 110003: 
            case 200408: 
            case 200504: {
                this.retry();
                break;
            }
            default: {
                IDataSender iDataSender = this.iDataSender;
                if (iDataSender != null) {
                    iDataSender.cancel(this.command, this.seq, srvErrorCode, message);
                }
                this.done();
            }
        }
    }

    @Override
    public void onRetry() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "onRetry command = %d, appId = %d, seq = %s";
        Object[] objectArray = new Object[]{this.command, this.appId, this.seq};
        String string2 = TAG;
        boolean bl = false;
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        String string4 = string3;
        RLog.info((Object)string2, (String)string4);
        IDataSender iDataSender = this.iDataSender;
        if (iDataSender == null) {
            Intrinsics.throwNpe();
        }
        BaseJsonRequest baseJsonRequest = this.req;
        if (baseJsonRequest == null) {
            Intrinsics.throwNpe();
        }
        byte[] byArray = baseJsonRequest.marshall();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"req!!.marshall()");
        iDataSender.sendData(this.seq, byArray);
    }

    public void retryCountExhaust() {
        block0: {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "retryCountExhaust command = %d, appId = %d, seq = %s";
            Object[] objectArray = new Object[]{this.command, this.appId, this.seq};
            String string2 = TAG;
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string3;
            RLog.error((Object)string2, (String)string4, (Object[])new Object[0]);
            IDataSender iDataSender = this.iDataSender;
            if (iDataSender == null) break block0;
            iDataSender.cancel(this.command, this.seq, RetryPolicy.Status.RETRY_COUNT_EXHAUST.getCode(), RetryPolicy.Status.RETRY_COUNT_EXHAUST.getMessage());
        }
    }

    @Override
    public void cancel() {
        block0: {
            super.cancel();
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "cancel command = %d, appId = %d, seq = %s";
            Object[] objectArray = new Object[]{this.command, this.appId, this.seq};
            String string2 = TAG;
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string3;
            RLog.error((Object)string2, (String)string4, (Object[])new Object[0]);
            IDataSender iDataSender = this.iDataSender;
            if (iDataSender == null) break block0;
            iDataSender.cancel(this.command, this.seq, RetryPolicy.Status.RETRY_CANCEL.getCode(), RetryPolicy.Status.RETRY_CANCEL.getMessage());
        }
    }

    @Override
    public boolean run() {
        boolean bl;
        if (this.iDataSender == null || this.encoder == null) {
            return false;
        }
        if (this.isRun) {
            return true;
        }
        this.req = this.encoder.encodeProtocol(this.command, this.appId, this.params);
        boolean bl2 = bl = this.req == null;
        if (bl) {
            return false;
        }
        this.isRun = true;
        this.call();
        return this.isRun;
    }

    @Override
    public void stop() {
        this.cancel();
    }

    @Override
    public int getReqCommand() {
        return this.command;
    }

    @Override
    public void setExtParam(@Nullable Object param) {
        this.extParam = param;
    }

    @Override
    @Nullable
    public Object getExtParam() {
        return this.extParam;
    }

    @Override
    public int getTotalRetryCount() {
        return this.retryCount;
    }

    @Override
    public int getRetryInterval() {
        return this.intervalMs;
    }

    @Override
    public int getTimeout() {
        return this.timeOutMs;
    }

    @Override
    @NotNull
    public String getReqSeq() {
        return this.seq;
    }

    @Override
    public int getRetryCount() {
        return super.getCurrentRetryCount();
    }

    public RetryRequestJob(int command, int appId, @NotNull RequestParams params, @Nullable ProtocolEncoder encoder, @Nullable IDataSender iDataSender, int retryCount, int intervalMs, int timeOutMs, int retryType) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        super(new Handler(Looper.getMainLooper()), timeOutMs, retryCount, intervalMs, retryType);
        this.command = command;
        this.appId = appId;
        this.params = params;
        this.encoder = encoder;
        this.iDataSender = iDataSender;
        this.retryCount = retryCount;
        this.intervalMs = intervalMs;
        this.timeOutMs = timeOutMs;
        this.retryType = retryType;
        this.seq = "";
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/request/RetryRequestJob$Companion;", "", "()V", "TAG", "", "obtain", "Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/request/RetryRequestJob;", "command", "", "appId", "params", "Lcom/yy/mobile/framework/revenuesdk/payapi/request/RequestParams;", "encoder", "Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/request/ProtocolEncoder;", "iDataSender", "Lcom/yy/mobile/framework/revenuesdk/payservice/revenueservice/IDataSender;", "retryCount", "intervalMs", "timeOutMs", "retryType", "payservice_release"})
    public static final class Companion {
        @NotNull
        public final RetryRequestJob obtain(int command, int appId, @NotNull RequestParams params, @NotNull ProtocolEncoder encoder, @NotNull IDataSender iDataSender, int retryCount, int intervalMs, int timeOutMs, int retryType) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
            Intrinsics.checkParameterIsNotNull((Object)iDataSender, (String)"iDataSender");
            params.setSeq(SeqUtil.increaseSeqId());
            RetryRequestJob retryRequestJob = new RetryRequestJob(command, appId, params, encoder, iDataSender, retryCount, intervalMs, timeOutMs, retryType);
            String string = params.getSeq();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            retryRequestJob.setSeq(string);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "obtain seq = %s";
            Object[] objectArray = new Object[]{retryRequestJob.getSeq()};
            String string3 = RetryRequestJob.TAG;
            boolean bl = false;
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            String string5 = string4;
            RLog.error((Object)string3, (String)string5, (Object[])new Object[0]);
            return retryRequestJob;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

