/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payapi.bean.RevenueRecord;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetUserAccountHistoryResponse
implements IBaseJsonResponse {
    public int cmd = 2046;
    public long uid;
    public String seq;
    public int appId;
    public int result;
    public String message;
    public List<RevenueRecord> userAccountHistoryInfos = new ArrayList<RevenueRecord>();
    public boolean hasMore;

    public GetUserAccountHistoryResponse(String jsonMsg) {
        this.parserResponse(jsonMsg);
    }

    public void parserResponse(String jsonMsg) {
        if (null == jsonMsg || "".equals(jsonMsg.trim())) {
            RLog.error((Object)"GetUserAccountHistoryResponse", (String)"parserResponse error, jsonMsg is empty.", (Object[])new Object[0]);
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonMsg);
            int cmd = jsonObject.optInt("cmd");
            if (this.cmd != cmd) {
                throw new Exception(this.cmd + " != " + cmd);
            }
            this.uid = jsonObject.optLong("uid");
            this.seq = jsonObject.optString("seq");
            this.appId = jsonObject.optInt("appId");
            this.result = jsonObject.optInt("result");
            this.message = jsonObject.optString("message");
            this.userAccountHistoryInfos.addAll(this.optHistoryInfo(jsonObject.optJSONArray("userAccountHistoryInfos")));
            this.hasMore = jsonObject.optBoolean("hasMore");
        }
        catch (JSONException e) {
            RLog.error((Object)"GetUserAccountHistoryResponse", (String)"parserResponse error.", (Throwable)e);
        }
        catch (Exception e) {
            RLog.error((Object)"GetUserAccountHistoryResponse", (String)"parserResponse error.", (Throwable)e);
        }
    }

    private List<RevenueRecord> optHistoryInfo(JSONArray array) {
        ArrayList<RevenueRecord> list = new ArrayList<RevenueRecord>();
        if (null == array) {
            return list;
        }
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            JSONObject object = array.optJSONObject(i);
            if (null == object) continue;
            RevenueRecord record = new RevenueRecord();
            record.id = object.optInt("id");
            record.uid = object.optLong("uid");
            record.currencyType = object.optLong("currencyType");
            record.amountChange = object.optLong("amountChange");
            record.amountRemain = object.optLong("amountRemain");
            record.freezedChange = object.optLong("freezedChange");
            record.freezedRemain = object.optLong("freezedRemain");
            record.optType = object.optInt("optType");
            record.optTime = object.optLong("optTime");
            record.optName = object.optString("optName");
            record.description = object.optString("description");
            list.add(record);
        }
        return list;
    }
}

