/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payapi.bean.CouponDiscountInfo;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetChargeCouponDiscountResponse
implements IBaseJsonResponse {
    public int cmd = 2052;
    public long uid;
    public String seq;
    public int appId;
    public int result;
    public String message;
    public int userCouponId;
    public List<CouponDiscountInfo> couponDiscountInfoList = new ArrayList<CouponDiscountInfo>();
    public boolean hasMore;

    public GetChargeCouponDiscountResponse(String jsonMsg) {
        this.parserResponse(jsonMsg);
    }

    public void parserResponse(String jsonMsg) {
        if (null == jsonMsg || "".equals(jsonMsg.trim())) {
            RLog.error((Object)"GetChargeCouponDiscountResponse", (String)"parserResponse error, jsonMsg is empty.", (Object[])new Object[0]);
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonMsg);
            int cmd = jsonObject.optInt("cmd");
            if (this.cmd != cmd) {
                throw new Exception(this.cmd + " != " + cmd);
            }
            this.uid = jsonObject.optLong("uid");
            this.seq = jsonObject.optString("seq");
            this.appId = jsonObject.optInt("appId");
            this.result = jsonObject.optInt("result");
            this.message = jsonObject.optString("message");
            this.userCouponId = jsonObject.optInt("userCouponId");
            this.couponDiscountInfoList.addAll(this.optCouponDiscountInfo(jsonObject.optJSONArray("discountList")));
        }
        catch (JSONException e) {
            RLog.error((Object)"GetChargeCouponDiscountResponse", (String)"parserResponse error.", (Throwable)e);
        }
        catch (Exception e) {
            RLog.error((Object)"GetChargeCouponDiscountResponse", (String)"parserResponse error.", (Throwable)e);
        }
    }

    private List<CouponDiscountInfo> optCouponDiscountInfo(JSONArray array) {
        ArrayList<CouponDiscountInfo> list = new ArrayList<CouponDiscountInfo>();
        if (null == array) {
            return list;
        }
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            JSONObject object = array.optJSONObject(i);
            if (null == object) continue;
            CouponDiscountInfo record = new CouponDiscountInfo();
            record.cid = object.optInt("cid");
            record.couponEnabled = object.optBoolean("couponEnabled");
            record.srcAmount = object.optDouble("srcAmount", 0.0);
            record.discountAmount = object.optDouble("discountAmount", 0.0);
            record.discountProductId = object.optString("discountProductId");
            record.srcCurrencySymbol = object.optString("srcCurrencySymbol");
            list.add(record);
        }
        return list;
    }
}

