/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequestProtocol;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public class ChargeCurrencyRequest
implements IRequestProtocol {
    public long uid;
    public int sid = 0;
    public int appId;
    public int usedChannel = 10002;
    public int currencyType;
    public String seq;
    public String payChannel;
    public String payMethod;
    public double amount;
    public int chargeCurrencyConfigId = 0;
    public boolean needUnicast = true;
    public String returnUrl = "";
    public String expand = "";
    public String clientVersion = "";

    public ChargeCurrencyRequest(int appId, int currencyType, String seq, String payChannel, String payMethod, double amount) {
        this(0, appId, currencyType, seq, payChannel, payMethod, amount);
    }

    public ChargeCurrencyRequest(int uid, int appId, int currencyType, String seq, String payChannel, String payMethod, double amount) {
        this(uid, 0, appId, 10002, currencyType, seq, payChannel, payMethod, amount, 0, true, "", "", "1.0.0", "");
    }

    public ChargeCurrencyRequest(long uid, int sid, int appId, int usedChannel, int currencyType, String seq, String payChannel, String payMethod, double amount, int chargeCurrencyConfigId, boolean needUnicast, String returnUrl, String expand, String clientVersion, String ticket) {
        this.uid = uid;
        this.sid = sid;
        this.appId = appId;
        this.usedChannel = usedChannel;
        this.currencyType = currencyType;
        this.seq = seq;
        this.payChannel = payChannel;
        this.payMethod = payMethod;
        this.amount = amount;
        this.chargeCurrencyConfigId = chargeCurrencyConfigId;
        this.needUnicast = needUnicast;
        this.returnUrl = returnUrl;
        this.expand = expand;
        this.clientVersion = clientVersion;
    }

    @Override
    @NotNull
    public String getProtocol() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", 1022);
            jMsg.put("uid", this.uid);
            jMsg.put("sid", this.sid);
            jMsg.put("appId", this.appId);
            jMsg.put("usedChannel", this.usedChannel);
            jMsg.put("currencyType", this.currencyType);
            jMsg.put("seq", (Object)this.seq);
            jMsg.put("payChannel", (Object)this.payChannel);
            jMsg.put("payMethod", (Object)this.payMethod);
            jMsg.put("amount", this.amount);
            jMsg.put("chargeCurrencyConfigId", this.chargeCurrencyConfigId);
            jMsg.put("needUnicast", this.needUnicast);
            jMsg.put("returnUrl", (Object)this.returnUrl);
            jMsg.put("expand", (Object)this.expand);
            jMsg.put("clientVersion", (Object)this.clientVersion);
            jsonMsg = jMsg.toString();
        }
        catch (JSONException e) {
            RLog.error((Object)"ChargeCurrencyRequest", (String)"constructPSCIMessageRequest", (Throwable)e);
        }
        return jsonMsg;
    }

    public static class ExpandBuilder {
        final int quantity;
        final Double unitPrice;
        final String product_id;
        final String hdid;
        final String srcCurrencySymbol;

        public ExpandBuilder(int quantity, Double unitPrice, String product_id, String hdid, String srcCurrencySymbol) {
            this.quantity = quantity;
            this.unitPrice = unitPrice;
            this.product_id = product_id;
            this.hdid = hdid;
            this.srcCurrencySymbol = srcCurrencySymbol;
        }

        public String toJson() {
            JSONObject expand = new JSONObject();
            try {
                expand.put("quantity", this.quantity);
                expand.put("unitPrice", (Object)this.unitPrice);
                expand.put("product_id", (Object)this.product_id);
                expand.put("hdid", (Object)this.hdid);
                expand.put("srcCurrencySymbol", (Object)this.srcCurrencySymbol);
            }
            catch (JSONException e) {
                RLog.error((Object)"ChargeCurrencyRequest", (String)"ExpandBuilder.toJson", (Throwable)e);
            }
            return expand.toString();
        }
    }
}

