/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.payservice.revenueservice;

import android.os.Handler;
import android.os.Looper;
import com.yy.mobile.framework.revenuesdk.baseapi.RetryPolicy;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;

public abstract class DefaultRetryPolicy
implements RetryPolicy {
    private static final String TAG = "DefaultRetryPolicy";
    private Handler mHander;
    private int mCurrentRetryCount;
    private final int mMaxNumRetries;
    private static final int FINISH = 1;
    private static final int RUNNING = 0;
    private static final int CANCEL = -1;
    private volatile int mStatus = 0;
    private final int mIntervalMs;
    private final int mRetryType;
    public static final int DEFAULT_MAX_RETRIES = 1;
    public static final int DEFAULT_TIME_OUT_MS = 2500;
    public static final int DEFAULT_INTERVAL_MS = 3000;
    public static final int DEFAULT_RETRY_TYPE = 0;
    private int mTimeoutMs;

    public DefaultRetryPolicy() {
        this(new Handler(Looper.getMainLooper()), 2500, 1, 3000, 0);
    }

    public DefaultRetryPolicy(Handler handler, int timeOutMs, int maxNumRetries, int intervalMs, int retryType) {
        this.mHander = handler;
        this.mTimeoutMs = timeOutMs;
        this.mMaxNumRetries = maxNumRetries;
        this.mIntervalMs = intervalMs;
        this.mRetryType = retryType;
    }

    public void retry() {
        RLog.info((Object)TAG, (String)("retry mTimeoutMs=" + this.mTimeoutMs + ", mMaxNumRetries=" + this.mMaxNumRetries + ",mIntervalMs=" + this.mIntervalMs));
        if (this.mStatus != 0) {
            return;
        }
        if (this.hasAttemptRemaining()) {
            if (this.mRetryType == 1) {
                ++this.mCurrentRetryCount;
                if (this.mCurrentRetryCount <= this.mMaxNumRetries / 2) {
                    this.mHander.postDelayed(() -> {
                        RLog.info((Object)TAG, (String)("retry currentRetryCount=" + this.mCurrentRetryCount));
                        this.onRetry();
                    }, (long)this.mIntervalMs);
                } else {
                    this.mHander.postDelayed(() -> {
                        RLog.info((Object)TAG, (String)("retry currentRetryCount=" + this.mCurrentRetryCount));
                        this.onRetry();
                    }, 60000L);
                }
            } else {
                ++this.mCurrentRetryCount;
                this.mHander.postDelayed(() -> {
                    RLog.info((Object)TAG, (String)("retry currentRetryCount=" + this.mCurrentRetryCount));
                    this.onRetry();
                }, (long)this.mIntervalMs);
            }
        } else {
            this.retryCountExhaust();
            RLog.info((Object)TAG, (String)"retryCountExhaust");
        }
    }

    public abstract void onRetry();

    public void call() {
        this.mCurrentRetryCount = 1;
        this.mStatus = 0;
        this.mHander.post(() -> this.onRetry());
    }

    public void cancel() {
        this.mStatus = -1;
        RLog.info((Object)TAG, (String)"cancel");
    }

    public void done() {
        this.mStatus = 1;
        RLog.info((Object)TAG, (String)"done");
    }

    private boolean hasAttemptRemaining() {
        return this.mCurrentRetryCount < this.mMaxNumRetries;
    }

    public int getCurrentRetryCount() {
        return this.mCurrentRetryCount;
    }
}

