/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.payservice;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payapi.PayType;
import com.yy.mobile.framework.revenuesdk.payapi.payservice.DefaultPayMethod;
import com.yy.mobile.framework.revenuesdk.payapi.payservice.H5PayMethod;
import com.yy.mobile.framework.revenuesdk.payapi.payservice.IPayMethod;

enum PayMethodFactory {
    GOOGLE_PLAY("com.yy.mobile.framework.revenue.gppay.PayMethodImpl"),
    WECHAT_PAY("com.yy.mobile.framework.revenue.wxpay.RevenueWechatPayImpl"),
    ALIPAY_PAY("com.yy.mobile.framework.revenue.alipay.RevenueAlipayImpl");

    final String clazz;
    IPayMethod method;

    private PayMethodFactory(String clazz) {
        this.clazz = clazz;
    }

    private IPayMethod getPayMethodImpl() {
        if (null != this.method) {
            return this.method;
        }
        this.initPayMethod();
        return this.method;
    }

    private void initPayMethod() {
        try {
            this.method = (IPayMethod)Class.forName(this.clazz).newInstance();
        }
        catch (Exception e) {
            this.method = new DefaultPayMethod();
            RLog.error((Object)"AppPayServiceImpl", (String)("init PayMethod error.clazz = " + this.clazz), (Throwable)e);
        }
    }

    public static IPayMethod valueOf(PayType type) {
        switch (type) {
            case GOOGLE_PLAY: {
                return GOOGLE_PLAY.getPayMethodImpl();
            }
            case WECHAT_PAY: {
                return WECHAT_PAY.getPayMethodImpl();
            }
            case ALI_PAY: {
                return ALIPAY_PAY.getPayMethodImpl();
            }
            case PAYTM_PAY: {
                return new H5PayMethod();
            }
        }
        return new DefaultPayMethod();
    }
}

