/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.payservice;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.platform.riskcontrol.sdk.core.IVerifyResult;
import com.platform.riskcontrol.sdk.core.RiskImpl;
import com.yy.mobile.framework.revenuesdk.baseapi.IResult;
import com.yy.mobile.framework.revenuesdk.baseapi.IToken;
import com.yy.mobile.framework.revenuesdk.baseapi.PayCallBackBean;
import com.yy.mobile.framework.revenuesdk.baseapi.PurchaseStatus;
import com.yy.mobile.framework.revenuesdk.baseapi.data.IRevenueDataReceiver;
import com.yy.mobile.framework.revenuesdk.baseapi.data.IRevenueDataSender;
import com.yy.mobile.framework.revenuesdk.baseapi.log.CloudLogHelper;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageBroadcast;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageResponse;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageUnicast;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.HiidoReport;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.IReporter;
import com.yy.mobile.framework.revenuesdk.baseapi.router.RouterInfo;
import com.yy.mobile.framework.revenuesdk.baseapi.router.RouterInfoCenter;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.PageIdUtil;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.ThreadPool;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.TraceIdUtil;
import com.yy.mobile.framework.revenuesdk.payapi.IAppPayService;
import com.yy.mobile.framework.revenuesdk.payapi.IAppPayServiceListener;
import com.yy.mobile.framework.revenuesdk.payapi.IPayCallback;
import com.yy.mobile.framework.revenuesdk.payapi.PayType;
import com.yy.mobile.framework.revenuesdk.payapi.PurchaseStatusImpl;
import com.yy.mobile.framework.revenuesdk.payapi.bean.AccountDelayMessage;
import com.yy.mobile.framework.revenuesdk.payapi.bean.ConsumeConfirmMessage;
import com.yy.mobile.framework.revenuesdk.payapi.bean.CurrencyChargeMessage;
import com.yy.mobile.framework.revenuesdk.payapi.bean.ProductInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseStatusInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.SkuDetailInfo;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.CouponDiscountResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.ExchangeResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.HasChargeInActivityResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.MyBalanceResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.PayOrderResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.ProductListResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.RechargeHistoryResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.ReportPurchaseResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.RevenueRecordResult;
import com.yy.mobile.framework.revenuesdk.payapi.callbackresult.UserCouponStoreResult;
import com.yy.mobile.framework.revenuesdk.payapi.payservice.IPayMethod;
import com.yy.mobile.framework.revenuesdk.payapi.reporter.IPayReporter;
import com.yy.mobile.framework.revenuesdk.payapi.request.ChargeCurrencyReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.DoHangPayJobReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.ExchangeCurrencyReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.GetChargeCouponDiscountReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.GetHasChargeInActivityReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.GetUserCouponStoreParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.QueryCurrencyChannelsReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.QueryCurrencyReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.QueryRechargeHistoryReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.QueryUserAccountHistoryReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.ReportPurchaseReqParams;
import com.yy.mobile.framework.revenuesdk.payapi.request.RequestParams;
import com.yy.mobile.framework.revenuesdk.payservice.PayMethodFactory;
import com.yy.mobile.framework.revenuesdk.payservice.reporter.DefaultPayReporter;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.IRevenueService;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueService;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol.GetChargeCurrencyConfigResponse;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequest;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.response.IResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class AppPayServiceImpl
implements IAppPayService,
IRevenueDataReceiver,
IRevenueService.IRevenueServiceListener {
    private static final String TAG = "AppPayServiceImpl";
    int appId;
    int mUsedChannel;
    String mCountryCode = "";
    private String mDefalutServiceName = "";
    private String mDefalutFunctionName = "";
    private RevenueService revenueService;
    private IPayReporter iPayReporter;
    private List<IAppPayServiceListener> listeners = new ArrayList<IAppPayServiceListener>();
    private String mPageId = "";
    private boolean mIsOpenRisk = false;
    private String mClientVer = "";

    public AppPayServiceImpl(int appId, int usedChannel, String country, String clientVer, String serviceName, String functionName, boolean requestReuse, boolean isOpenRisk, IRevenueDataSender iDataSender, IReporter iReporter) {
        this.appId = appId;
        this.mUsedChannel = usedChannel;
        this.mCountryCode = country;
        this.mClientVer = clientVer;
        this.mDefalutServiceName = serviceName;
        this.mDefalutFunctionName = functionName;
        this.revenueService = new RevenueService(appId, iDataSender, this, requestReuse);
        this.iPayReporter = new DefaultPayReporter(iReporter, clientVer, country);
        this.mIsOpenRisk = isOpenRisk;
    }

    @Nullable
    private <T> T getResponseData(Class<T> klass, @NotNull IResponse response) {
        Object result = response.getResponseData();
        if (result != null) {
            return klass.cast(result);
        }
        return null;
    }

    private void onQueryProductList(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        ProductListResult result = this.getResponseData(ProductListResult.class, response);
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        if (iRequest != null) {
            RequestParams req = (RequestParams)iRequest.getExtParam();
            this.doQueryProductListHiidoCommon(reportResponse, iRequest, req);
            if (response.isSuccess() && result != null) {
                RLog.info((Object)TAG, (String)"onQueryProductList success");
                this.onSuccess(req, result, null);
                if (this.iPayReporter != null) {
                    reportResponse.mEventId = "-5";
                    reportResponse.mEventaliae = "\u83b7\u53d6\u914d\u7f6e\u5217\u8868\u6210\u529f";
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg = "queryProductList success!" + response.getMessage();
                    this.iPayReporter.onQueryProductList(reportResponse);
                }
            } else {
                RLog.error((Object)TAG, (String)"onQueryProductList fail code = %d, errMsg = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage()});
                this.onFail(iRequest.getReqSeq(), response.getResponseCode(), response.getMessage(), req.getCallback(), null);
                if (this.iPayReporter != null) {
                    reportResponse.mEventId = "-4";
                    reportResponse.mEventaliae = "\u83b7\u53d6\u914d\u7f6e\u5217\u8868\u5931\u8d25";
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg = "queryProductList fail!" + response.getMessage();
                    this.iPayReporter.onQueryProductList(reportResponse);
                }
            }
        }
    }

    private void onQueryProductListChannels(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        ProductListResult result = this.getResponseData(ProductListResult.class, response);
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        if (iRequest != null) {
            RequestParams req = (RequestParams)iRequest.getExtParam();
            this.doQueryProductListHiidoCommon(reportResponse, iRequest, req);
            if (response.isSuccess() && result != null) {
                RLog.info((Object)TAG, (String)"onQueryProductChannelsList success");
                this.onSuccess(req, result, null);
                if (this.iPayReporter != null) {
                    reportResponse.mEventId = "-5";
                    reportResponse.mEventaliae = "\u83b7\u53d6\u914d\u7f6e\u5217\u8868\u6210\u529f";
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg = "onQueryProductListChannels success!" + response.getMessage();
                    this.iPayReporter.onQueryProductList(reportResponse);
                }
            } else {
                RLog.error((Object)TAG, (String)"onQueryProductChannelsList fail code = %d, errMsg = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage()});
                this.onFail(iRequest.getReqSeq(), response.getResponseCode(), response.getMessage(), req.getCallback(), null);
                if (this.iPayReporter != null) {
                    reportResponse.mEventId = "-4";
                    reportResponse.mEventaliae = "\u83b7\u53d6\u914d\u7f6e\u5217\u8868\u5931\u8d25";
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg = "onQueryProductListChannels fail!" + response.getMessage();
                    this.iPayReporter.onQueryProductList(reportResponse);
                }
            }
        }
    }

    private void doQueryProductListHiidoCommon(HiidoReport.CReportResponse reportResponse, IRequest iRequest, RequestParams req) {
        if (reportResponse != null && iRequest != null && req != null) {
            long delay = System.currentTimeMillis() - req.getRequestTime();
            reportResponse.mDelay = delay + "";
            RouterInfo routerInfo = null;
            Activity context = req.getContext();
            if (context != null) {
                int cmd = iRequest.getReqCommand();
                RLog.info((Object)TAG, (String)("doQueryProductListHiidoReport---getRouterInfo  cmd:" + req.getCmd() + "iRequest.getReqCommand:" + cmd));
                routerInfo = RouterInfoCenter.getRouterInfo((Context)context.getApplicationContext(), (int)cmd);
            } else {
                RLog.error((Object)TAG, (String)"doQueryProductListHiidoReport---context = null:", (Object[])new Object[0]);
            }
            if (routerInfo == null) {
                reportResponse.mServiceName = this.mDefalutServiceName;
                reportResponse.mFunctionName = this.mDefalutFunctionName;
            } else {
                reportResponse.mServiceName = routerInfo.serviceName;
                reportResponse.mFunctionName = routerInfo.functionName;
            }
            reportResponse.mPageId = this.mPageId;
            reportResponse.mConfigTraceId = req.getTraceid();
        }
    }

    private void onGetUserCouponStore(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        UserCouponStoreResult result = this.getResponseData(UserCouponStoreResult.class, response);
        if (iRequest != null) {
            RequestParams req = (RequestParams)iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                RLog.info((Object)TAG, (String)"onGetUserCouponStore success");
                this.onSuccess(req, result, null);
            } else {
                RLog.error((Object)TAG, (String)"onGetUserCouponStore fail code = %d, errMsg = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage()});
                this.onFail(iRequest.getReqSeq(), response.getResponseCode(), response.getMessage(), req.getCallback(), null);
            }
        }
    }

    private void onGetChargeCouponDiscount(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        CouponDiscountResult result = this.getResponseData(CouponDiscountResult.class, response);
        if (iRequest != null) {
            RequestParams req = (RequestParams)iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                RLog.info((Object)TAG, (String)"onGetChargeCouponDiscount success");
                this.onSuccess(req, result, null);
            } else {
                RLog.error((Object)TAG, (String)"onGetChargeCouponDiscount fail code = %d, errMsg = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage()});
                this.onFail(iRequest.getReqSeq(), response.getResponseCode(), response.getMessage(), req.getCallback(), null);
            }
        }
    }

    private void onGetHasChargeInActivity(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        HasChargeInActivityResult result = this.getResponseData(HasChargeInActivityResult.class, response);
        if (iRequest != null) {
            RequestParams req = (RequestParams)iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                RLog.info((Object)TAG, (String)"onGetHasChargeInActivity success");
                this.onSuccess(req, result, null);
            } else {
                RLog.error((Object)TAG, (String)"onGetHasChargeInActivity fail code = %d, errMsg = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage()});
                this.onFail(iRequest.getReqSeq(), response.getResponseCode(), response.getMessage(), req.getCallback(), null);
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private void onOrderProduct(final @NotNull IResponse response) {
        final IRequest iRequest = response.getRequest();
        PayOrderResult result = this.getResponseData(PayOrderResult.class, response);
        if (iRequest != null) {
            final ChargeCurrencyReqParams req = (ChargeCurrencyReqParams)iRequest.getExtParam();
            HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
            long delay = 0L;
            if (req != null) {
                reportResponse.mPaysource = req.getFrom();
                reportResponse.mUid = req.getUid();
                delay = System.currentTimeMillis() - req.getRequestTime();
                reportResponse.mDelay = delay + "";
                RouterInfo routerInfo = null;
                Activity context = req.getContext();
                if (context != null) {
                    int cmd = iRequest.getReqCommand();
                    RLog.info((Object)TAG, (String)("onOrderProduct---getRouterInfo  cmd:" + req.getCmd() + "iRequest.getReqCommand:" + cmd));
                    if (cmd == 0) {
                        cmd = 1022;
                    }
                    routerInfo = RouterInfoCenter.getRouterInfo((Context)context.getApplicationContext(), (int)cmd);
                } else {
                    RLog.error((Object)TAG, (String)"onOrderProduct---context = null:", (Object[])new Object[0]);
                }
                if (routerInfo == null) {
                    reportResponse.mServiceName = this.mDefalutServiceName;
                    reportResponse.mFunctionName = this.mDefalutFunctionName;
                } else {
                    reportResponse.mServiceName = routerInfo.serviceName;
                    reportResponse.mFunctionName = routerInfo.functionName;
                }
            }
            RLog.info((Object)TAG, (String)("onOrderProduct---mDefalutServiceName:" + this.mDefalutServiceName + "---mDefalutFunctionName:" + this.mDefalutFunctionName + "---mRealFunctionName:" + reportResponse.mServiceName + "---mRealFunctionName:" + reportResponse.mFunctionName));
            if (result != null) {
                reportResponse.mOrderId = result.getOrderId();
            }
            if (req != null && result != null) {
                String challengeExpand = this.getChallengeExtension(result.getExpand());
                if (challengeExpand != null && !challengeExpand.equals("")) {
                    long delayInner = delay;
                    RiskImpl.getRiskImpl().showVerifyViewWithInfoString(challengeExpand, (IVerifyResult)new IVerifyResult<String>(){

                        public void onVerifyResult(String verifytoken, int code) {
                            if (code == 0) {
                                IRequest request = AppPayServiceImpl.this.revenueService.obtainRequest(1022, req);
                                request.setExtParam(req);
                                AppPayServiceImpl.this.revenueService.sendRequest(request);
                            } else {
                                int riskFailCode;
                                switch (code) {
                                    case -1: {
                                        riskFailCode = -711;
                                        break;
                                    }
                                    case -2: {
                                        riskFailCode = -712;
                                        break;
                                    }
                                    case -3: {
                                        riskFailCode = -713;
                                        break;
                                    }
                                    case -4: {
                                        riskFailCode = -714;
                                        break;
                                    }
                                    default: {
                                        riskFailCode = -711;
                                    }
                                }
                                RLog.error((Object)AppPayServiceImpl.TAG, (String)"onOrderProduc -- order fail\uff01trigger risk,but verify fail! verify fail code = %d, code = %d, errMsg = %s", (Object[])new Object[]{code, response.getResponseCode(), response.getMessage()});
                                PayCallBackBean backBean = new PayCallBackBean(null, req.getProductId(), null, req.getRequestTime(), null, null, null, null, PurchaseStatus.ORDER_FAIL);
                                AppPayServiceImpl.this.onFail(iRequest.getReqSeq(), riskFailCode, "order fail\uff01trigger risk,but verify fail! verify fail code:" + code, req.getCallback(), backBean);
                            }
                        }
                    });
                } else {
                    this.dealOnOrderInter(response, req, result, iRequest, reportResponse, delay);
                }
            }
        }
    }

    private void dealOnOrderInter(IResponse response, ChargeCurrencyReqParams req, PayOrderResult result, IRequest iRequest, HiidoReport.CReportResponse reportResponse, long delay) {
        if (response.isSuccess() && req != null && result != null) {
            RLog.info((Object)TAG, (String)"onOrderProduct --- order sucess! orderid = %s ,uid = %s , mDelay = %d", (Object[])new Object[]{result.getOrderId(), req.getUid(), delay});
            String payload = result.getPayUrl();
            String chOrderid = this.getChOrderidByPayload(payload);
            PayCallBackBean backBean = new PayCallBackBean(result.getOrderId(), req.getProductId(), null, req.getRequestTime(), chOrderid, payload, null, null, PurchaseStatus.ORDER_SUCCESS);
            if (req.getPayType() == PayType.PAYTM_PAY) {
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    ((IPayCallback)req.getCallback()).onSuccess((Object)result, backBean);
                } else {
                    ThreadPool.getDefault().mainThreadIO().execute(() -> ((IPayCallback)req.getCallback()).onSuccess((Object)result, backBean));
                }
            } else {
                IPayCallback callback;
                if (req.getPayType() == PayType.GOOGLE_PLAY) {
                    PurchaseStatusInfo purchaseStatusInfo = new PurchaseStatusInfo();
                    purchaseStatusInfo.uid = req.getUid();
                    purchaseStatusInfo.status = PurchaseStatus.ORDER_SUCCESS.getCode();
                    purchaseStatusInfo.chorderid = this.getCHOrderId(payload);
                    purchaseStatusInfo.productId = req.getProductId();
                    purchaseStatusInfo.orderId = result.getOrderId();
                    PurchaseStatusImpl.savePurchaseStatus((Activity)req.getContext(), (PurchaseStatusInfo)purchaseStatusInfo);
                }
                boolean isSetAccountId = true;
                String closeRiskEnhance = result.getCloseRiskEnhance();
                if (closeRiskEnhance != null && closeRiskEnhance.equals("true")) {
                    isSetAccountId = false;
                }
                if ((callback = (IPayCallback)req.getCallback()) != null) {
                    callback.onPayStatus(PurchaseStatus.ORDER_SUCCESS, backBean);
                }
                this.requestPay(req.getContext(), req, req.getPayType(), req.getProductId(), payload, isSetAccountId, new PayCallbackProxy(req.getPayType(), result.getOrderId(), req, payload, callback));
            }
            if (this.iPayReporter != null) {
                reportResponse.mEventId = "1";
                reportResponse.mEventaliae = "\u652f\u4ed8\u4e0b\u5355\u6210\u529f";
                reportResponse.mErrCode = response.getResponseCode() + "";
                reportResponse.mErrMsg = "order success!" + response.getMessage();
                this.iPayReporter.onOrderResult(reportResponse);
            }
        } else {
            IPayCallback callback;
            if (req != null && result != null) {
                RLog.error((Object)TAG, (String)"onOrderProduct -- order fail! orderid = %s ,uid = %s , mDelay = %d, code = %d, errMsg = %s", (Object[])new Object[]{result.getOrderId(), req.getUid(), delay, response.getResponseCode(), response.getMessage()});
            } else {
                RLog.error((Object)TAG, (String)"onOrderProduc -- order fail ! code = %d, errMsg = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage()});
            }
            PayCallBackBean backBean = new PayCallBackBean(null, req.getProductId(), null, req.getRequestTime(), null, null, null, null, PurchaseStatus.ORDER_FAIL);
            if (req.getPayType() == PayType.PAYTM_PAY) {
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    ((IPayCallback)req.getCallback()).onFail(response.getResponseCode(), "order fail, fialReason:" + response.getMessage(), null);
                } else {
                    ThreadPool.getDefault().mainThreadIO().execute(() -> ((IPayCallback)req.getCallback()).onFail(response.getResponseCode(), "order fail, fialReason:" + response.getMessage(), backBean));
                }
            }
            if (req != null && (callback = (IPayCallback)req.getCallback()) != null) {
                callback.onPayStatus(PurchaseStatus.ORDER_FAIL, backBean);
            }
            this.onFail(iRequest.getReqSeq(), response.getResponseCode(), "order fial, fialReason:" + response.getMessage(), req.getCallback(), backBean);
            if (this.iPayReporter != null) {
                reportResponse.mEventId = "2";
                reportResponse.mEventaliae = "\u652f\u4ed8\u4e0b\u5355\u5931\u8d25";
                reportResponse.mErrCode = response.getResponseCode() + "";
                reportResponse.mErrMsg = "order fial, fialReason:" + response.getMessage();
                this.iPayReporter.onOrderResult(reportResponse);
                reportResponse.mEventId = "101";
                reportResponse.mEventaliae = "\u8d2d\u4e70\u4e1a\u52a1\u5931\u8d25";
                this.iPayReporter.onPurchaseSummaryResult(reportResponse);
            }
            String logCloud = "";
            logCloud = result != null ? this.combiCloudLogString(response.getResponseCode(), "order fial, fialReason:" + response.getMessage(), req.toString(), result.toString()) : this.combiCloudLogString(response.getResponseCode(), "order fial, fialReason:" + response.getMessage(), req.toString(), "");
            CloudLogHelper.sendLog((String)"onOrderProduct", (String)logCloud);
        }
    }

    private void onQueryUserAccount(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        MyBalanceResult result = this.getResponseData(MyBalanceResult.class, response);
        if (iRequest != null) {
            RequestParams req = (RequestParams)iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                this.onSuccess(req, result, null);
                RLog.info((Object)TAG, (String)"onQueryUserAccount success");
            } else {
                RLog.error((Object)TAG, (String)"onQueryUserAccount fail code = %d, errMsg = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage()});
                this.onFail("", response.getResponseCode(), response.getMessage(), req.getCallback(), null);
            }
        }
    }

    private void onQueryUserAccountHistory(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        RevenueRecordResult result = this.getResponseData(RevenueRecordResult.class, response);
        if (iRequest != null) {
            RequestParams req = (RequestParams)iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                RLog.info((Object)TAG, (String)"onQueryUserAccountHistory success");
                this.onSuccess(req, result, null);
            } else {
                RLog.error((Object)TAG, (String)"onQueryUserAccountHistory fail code = %d, errMsg = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage()});
                this.onFail("", response.getResponseCode(), response.getMessage(), req.getCallback(), null);
            }
        }
    }

    private void onReportPurchase(final @NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        final ReportPurchaseResult result = this.getResponseData(ReportPurchaseResult.class, response);
        if (iRequest != null && result != null) {
            final ReportPurchaseReqParams req = (ReportPurchaseReqParams)iRequest.getExtParam();
            final HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
            long delay = 0L;
            String orderId = "";
            String chorderid = "";
            String payload = "";
            long uid = 0L;
            long purchaseTime = 0L;
            String gpOrderId = "";
            if (req != null) {
                purchaseTime = this.getPurchaseTime(req.getData());
                gpOrderId = this.getGPOrderId(req.getData());
                chorderid = this.getCHOrderId(req.getData());
                payload = this.getPayLoad(req.getData());
                delay = System.currentTimeMillis() - req.getRequestTime();
                reportResponse.mPurchaseTime = purchaseTime + "";
                reportResponse.mGPOrderId = gpOrderId;
                reportResponse.mPaysource = req.getFrom();
                reportResponse.mUid = req.getUid();
                reportResponse.mDelay = delay + "";
                reportResponse.mPayTraceId = req.getTraceid();
                reportResponse.mPageId = this.mPageId;
                orderId = req.getOrderId();
                uid = req.getUid();
                reportResponse.mOrderId = req.getOrderId();
                RouterInfo routerInfo = null;
                Activity context = req.getContext();
                if (context != null) {
                    int cmd = iRequest.getReqCommand();
                    RLog.info((Object)TAG, (String)("onReportPurchase---getRouterInfo  req.getCmd:" + req.getCmd() + "iRequest.getReqCommand:" + cmd));
                    if (cmd == 0) {
                        cmd = 1045;
                    }
                    routerInfo = RouterInfoCenter.getRouterInfo((Context)context.getApplicationContext(), (int)cmd);
                }
                if (routerInfo == null) {
                    reportResponse.mServiceName = this.mDefalutServiceName;
                    reportResponse.mFunctionName = this.mDefalutFunctionName;
                } else {
                    reportResponse.mServiceName = routerInfo.serviceName;
                    reportResponse.mFunctionName = routerInfo.functionName;
                }
                RLog.info((Object)TAG, (String)("onReportPurchase---mDefalutServiceName:" + this.mDefalutServiceName + "---mDefalutFunctionName:" + this.mDefalutFunctionName + "---mRealFunctionName:" + reportResponse.mServiceName + "---mRealFunctionName:" + reportResponse.mFunctionName));
                RLog.info((Object)TAG, (String)"onReportPurchase-reportResult - delay = %s, orderid = %s, uid = %s, purchaseTime = %s, gpOrderId = %s", (Object[])new Object[]{delay, req.getOrderId(), req.getUid(), purchaseTime, gpOrderId});
            }
            final String orderIdReport = orderId;
            final long uidReport = uid;
            final String gpOrderIdReport = gpOrderId;
            final long purchaseTimeReport = purchaseTime;
            String chorderidReport = chorderid;
            String payloadReport = payload;
            if ((response.isSuccess() || response.getResponseCode() == -20) && result != null && req != null) {
                if (req.getPayType() == PayType.GOOGLE_PLAY) {
                    PurchaseStatusInfo purchaseStatusInfo = new PurchaseStatusInfo();
                    purchaseStatusInfo.uid = req.getUid();
                    purchaseStatusInfo.status = PurchaseStatus.REPORT_SUCCESS.getCode();
                    purchaseStatusInfo.productId = req.getProductid();
                    purchaseStatusInfo.chorderid = chorderidReport;
                    purchaseStatusInfo.orderId = orderId;
                    purchaseStatusInfo.purchaseData = result.getPurchaseData();
                    purchaseStatusInfo.purchaseSign = result.getPurchaseSign();
                    PurchaseStatusImpl.savePurchaseStatus((Activity)req.getContext(), (PurchaseStatusInfo)purchaseStatusInfo);
                }
                PayCallBackBean payCallBackBean = new PayCallBackBean(orderId, req.getProductid(), gpOrderId, purchaseTime, chorderidReport, payloadReport, result.getPurchaseData(), result.getPurchaseSign(), PurchaseStatus.REPORT_SUCCESS);
                if (req.getCallback() instanceof IPayCallback) {
                    IPayCallback callback = (IPayCallback)req.getCallback();
                    callback.onPayStatus(PurchaseStatus.REPORT_SUCCESS, payCallBackBean);
                }
                RLog.info((Object)TAG, (String)"onReportPurchase-reportResult: success  orderid= %s ,delay = %s ,uid = %s, purchaseTime = %s, gpOrderId = %s \uff0c SubscriptionType = %s", (Object[])new Object[]{req.getOrderId(), delay, req.getUid(), purchaseTime, gpOrderId, req.getSubscriptionType()});
                if (response.getResponseCode() == -20) {
                    this.onFail("", response.getResponseCode(), "already reported! consumeOrder directly\uff0ccode = -20!", req.getCallback(), payCallBackBean);
                } else {
                    this.onSuccess((RequestParams)req, "Report Purchase Success!", payCallBackBean);
                }
                if (req.getSubscriptionType() == 0) {
                    IPayMethod iPayMethod = req.getPayMethod();
                    final long dohangRequestTime = System.currentTimeMillis();
                    final String hangjogorderid = orderId;
                    iPayMethod.doHangJob(new PurchaseInfo(result.getPurchaseData(), result.getPurchaseSign()), (IResult)new IResult<String>(){

                        public void onSuccess(String resultJob, PayCallBackBean payCallBackBean) {
                            if (req.getPayType() == PayType.GOOGLE_PLAY) {
                                PurchaseStatusImpl.deletePurchaseStatus((Activity)req.getContext(), (String)req.getProductid(), (long)req.getUid(), (String)hangjogorderid);
                            }
                            long delay = System.currentTimeMillis() - dohangRequestTime;
                            reportResponse.mServiceName = AppPayServiceImpl.this.mDefalutServiceName;
                            reportResponse.mFunctionName = AppPayServiceImpl.this.mDefalutFunctionName;
                            reportResponse.mPurchaseTime = purchaseTimeReport + "";
                            reportResponse.mGPOrderId = gpOrderIdReport;
                            reportResponse.mUid = uidReport;
                            reportResponse.mDelay = delay + "";
                            reportResponse.mEventId = "8";
                            reportResponse.mEventaliae = "\u7ee7\u7eed\u5b8c\u6210\u672a\u5b8c\u6210\u7684\u8ba2\u5355\u6210\u529f ";
                            reportResponse.mErrCode = "0";
                            reportResponse.mErrMsg = "dohangJob successdata:" + result.getPurchaseData() + "sign:" + result.getPurchaseSign();
                            AppPayServiceImpl.this.iPayReporter.onDoHangJob(reportResponse);
                            RLog.info((Object)AppPayServiceImpl.TAG, (String)"dohangJob success: delay= %s, orderid= %s, uid= %s, purchaseTime = %s, gpOrderId = %s", (Object[])new Object[]{delay, orderIdReport, uidReport, purchaseTimeReport, gpOrderIdReport});
                            if (req.getPayType() == PayType.GOOGLE_PLAY) {
                                PurchaseStatusImpl.deletePurchaseStatus((Activity)req.getContext(), (String)req.getProductid(), (long)req.getUid(), (String)hangjogorderid);
                            }
                        }

                        public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                            long delay = System.currentTimeMillis() - dohangRequestTime;
                            reportResponse.mServiceName = AppPayServiceImpl.this.mDefalutServiceName;
                            reportResponse.mFunctionName = AppPayServiceImpl.this.mDefalutFunctionName;
                            reportResponse.mPurchaseTime = purchaseTimeReport + "";
                            reportResponse.mGPOrderId = gpOrderIdReport;
                            reportResponse.mUid = uidReport;
                            reportResponse.mDelay = delay + "";
                            reportResponse.mEventId = "9";
                            reportResponse.mEventaliae = "\u7ee7\u7eed\u5b8c\u6210\u672a\u5b8c\u6210\u7684\u8ba2\u5355\u5931\u8d25";
                            reportResponse.mErrCode = code + "";
                            reportResponse.mErrMsg = "dohangJob fail,failReason:" + failReason + "data:" + result.getPurchaseData() + "sign:" + result.getPurchaseSign();
                            AppPayServiceImpl.this.iPayReporter.onDoHangJob(reportResponse);
                            RLog.error((Object)AppPayServiceImpl.TAG, (String)"dohangJob fail code = %d, errMsg = %s, orderid= %s, uid= %s, delay= %s, purchaseTime = %s, gpOrderId = %s", (Object[])new Object[]{code, failReason, orderIdReport, uidReport, delay, purchaseTimeReport, gpOrderIdReport});
                            if (req != null && response != null && result != null) {
                                String logCloud = AppPayServiceImpl.this.combiCloudLogString(code, "dohangJob fail! failReason:" + failReason, req.toString(), "");
                                CloudLogHelper.sendLog((String)"onDoHandJob", (String)logCloud);
                            }
                        }
                    });
                }
                if (this.iPayReporter != null) {
                    reportResponse.mEventId = "6";
                    reportResponse.mEventaliae = "\u51ed\u8bc1\u4e0a\u62a5\u6210\u529f";
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg = response.getResponseCode() == -20 ? "already report success,consumeOrder directly\uff0ccode = -20!:" + response.getMessage() : "purchase report success:" + response.getMessage();
                    this.iPayReporter.onPurchaseReportResult(reportResponse);
                    reportResponse.mEventId = "100";
                    reportResponse.mEventaliae = "\u8d2d\u4e70\u4e1a\u52a1\u6210\u529f";
                    this.iPayReporter.onPurchaseSummaryResult(reportResponse);
                }
            } else {
                RLog.error((Object)TAG, (String)"onReportPurchase fail code = %d, errMsg = %s, orderid= %s, uid= %s, delay= %s, purchaseTime = %s, gpOrderId = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage(), orderId, uidReport, delay, purchaseTime, gpOrderId});
                PayCallBackBean payCallBackBean = null;
                if (result != null) {
                    payCallBackBean = new PayCallBackBean(orderId, req.getProductid(), gpOrderId, purchaseTime, chorderidReport, payload, result.getPurchaseData(), result.getPurchaseSign(), PurchaseStatus.REPORT_FAIL);
                    if (req.getPayType() == PayType.GOOGLE_PLAY) {
                        PurchaseStatusInfo purchaseStatusInfo = new PurchaseStatusInfo();
                        purchaseStatusInfo.uid = req.getUid();
                        purchaseStatusInfo.status = PurchaseStatus.REPORT_FAIL.getCode();
                        purchaseStatusInfo.productId = req.getProductid();
                        purchaseStatusInfo.chorderid = chorderidReport;
                        purchaseStatusInfo.orderId = orderId;
                        purchaseStatusInfo.purchaseData = result.getPurchaseData();
                        purchaseStatusInfo.purchaseSign = result.getPurchaseSign();
                        PurchaseStatusImpl.savePurchaseStatus((Activity)req.getContext(), (PurchaseStatusInfo)purchaseStatusInfo);
                    }
                } else {
                    payCallBackBean = new PayCallBackBean(orderId, req.getProductid(), gpOrderId, purchaseTime, null, payload, null, null, PurchaseStatus.REPORT_FAIL);
                }
                this.onFail("", response.getResponseCode(), "purchase report fail:" + response.getMessage(), req.getCallback(), payCallBackBean);
                if (this.iPayReporter != null) {
                    reportResponse.mEventId = "7";
                    reportResponse.mEventaliae = "\u51ed\u8bc1\u4e0a\u62a5\u5931\u8d25";
                    reportResponse.mErrCode = response.getResponseCode() + "";
                    reportResponse.mErrMsg = "purchase report fail:" + response.getMessage();
                    this.iPayReporter.onPurchaseReportResult(reportResponse);
                    reportResponse.mEventId = "101";
                    reportResponse.mEventaliae = "\u8d2d\u4e70\u4e1a\u52a1\u5931\u8d25";
                    this.iPayReporter.onPurchaseSummaryResult(reportResponse);
                }
                if (req != null && response != null && result != null) {
                    String logCloud = this.combiCloudLogString(response.getResponseCode(), "reportPurchase fail! failReason:" + response.getMessage(), req.toString(), result.toString());
                    CloudLogHelper.sendLog((String)"onReportPurchase", (String)logCloud);
                }
                if (req != null && req.getCallback() instanceof IPayCallback) {
                    IPayCallback callback = (IPayCallback)req.getCallback();
                    callback.onPayStatus(PurchaseStatus.REPORT_FAIL, payCallBackBean);
                }
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void onCurrencyChargeMessage(@NotNull IResponse response) {
        CurrencyChargeMessage result = this.getResponseData(CurrencyChargeMessage.class, response);
        if (result == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.onCurrencyChargeMessage(result);
        } else {
            ThreadPool.getDefault().mainThreadIO().execute(() -> this.onCurrencyChargeMessage(result));
        }
    }

    private void onCurrencyChargeMessage(@NotNull CurrencyChargeMessage result) {
        Iterator<IAppPayServiceListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onCurrencyChargeMessage(result);
        }
    }

    private void onConsumeConfirmMessage(@NotNull IResponse response) {
        ConsumeConfirmMessage result = this.getResponseData(ConsumeConfirmMessage.class, response);
        if (result == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.onConsumeConfirmMessage(result);
        } else {
            ThreadPool.getDefault().mainThreadIO().execute(() -> this.onConsumeConfirmMessage(result));
        }
    }

    private void onAccountDelayMessage(@NotNull IResponse response) {
        AccountDelayMessage result = this.getResponseData(AccountDelayMessage.class, response);
        if (result == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.onAccountDelayMessage(result);
        } else {
            ThreadPool.getDefault().mainThreadIO().execute(() -> this.onAccountDelayMessage(result));
        }
    }

    private void onAccountDelayMessage(@NotNull AccountDelayMessage result) {
        Iterator<IAppPayServiceListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onAccountDelayMessage(result);
        }
    }

    private void onExchangeCurrency(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        ExchangeResult result = this.getResponseData(ExchangeResult.class, response);
        if (iRequest != null) {
            RequestParams req = (RequestParams)iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                this.onSuccess(req, result, null);
                RLog.info((Object)TAG, (String)"onExchangeCurrency success");
            } else {
                RLog.error((Object)TAG, (String)"onExchangeCurrency fail code = %d, errMsg = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage()});
                this.onFail("", response.getResponseCode(), response.getMessage(), req.getCallback(), null);
            }
        }
    }

    private void onQueryRechargeHistory(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        RechargeHistoryResult result = this.getResponseData(RechargeHistoryResult.class, response);
        if (iRequest != null) {
            RequestParams req = (RequestParams)iRequest.getExtParam();
            if (response.isSuccess() && result != null) {
                this.onSuccess(req, result, null);
                RLog.info((Object)TAG, (String)"onQueryRechargeHistory success");
            } else {
                RLog.error((Object)TAG, (String)"onQueryRechargeHistory fail code = %d, errMsg = %s", (Object[])new Object[]{response.getResponseCode(), response.getMessage()});
                this.onFail("", response.getResponseCode(), response.getMessage(), req.getCallback(), null);
            }
        }
    }

    private void onConsumeConfirmMessage(@NotNull ConsumeConfirmMessage result) {
        Iterator<IAppPayServiceListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onConsumeConfirmMessage(result);
        }
    }

    @Override
    public void onRevenueResponse(int command, @NotNull IResponse response) {
        RLog.info((Object)TAG, (String)"onRevenueResponse command = %d", (Object[])new Object[]{command});
        switch (command) {
            case 1021: {
                this.onQueryProductList(response);
                break;
            }
            case 1060: {
                this.onQueryProductListChannels(response);
                break;
            }
            case 1022: {
                this.onOrderProduct(response);
                break;
            }
            case 1005: {
                this.onQueryUserAccount(response);
                break;
            }
            case 1046: {
                this.onQueryUserAccountHistory(response);
                break;
            }
            case 1047: {
                this.onGetUserCouponStore(response);
                break;
            }
            case 1052: {
                this.onGetChargeCouponDiscount(response);
                break;
            }
            case 1026: {
                this.onGetHasChargeInActivity(response);
                break;
            }
            case 1045: {
                this.onReportPurchase(response);
                break;
            }
            case 40423898: {
                this.onCurrencyChargeMessage(response);
                break;
            }
            case 40423235: {
                this.onConsumeConfirmMessage(response);
                break;
            }
            case 40424536: {
                this.onAccountDelayMessage(response);
                break;
            }
            case 1025: {
                this.onExchangeCurrency(response);
                break;
            }
            case 1054: {
                this.onQueryRechargeHistory(response);
                break;
            }
            default: {
                this.onErrorRespone(response);
            }
        }
    }

    private void onErrorRespone(@NotNull IResponse response) {
        IRequest iRequest = response.getRequest();
        RLog.info((Object)TAG, (String)"---onErrorRespone---");
        if (iRequest != null) {
            RLog.info((Object)TAG, (String)("---onErrorRespone---onFail\uff1a" + response.getResponseCode()));
            RequestParams req = (RequestParams)iRequest.getExtParam();
            this.onFail("", response.getResponseCode(), response.getMessage(), req.getCallback(), null);
        }
    }

    public void queryProductList(@NonNull QueryCurrencyReqParams params, IResult<ProductListResult> callback) {
        if (!this.checkNotNull((RequestParams)params, callback)) {
            return;
        }
        params.setCallback(callback);
        params.setRequestTime(System.currentTimeMillis());
        params.setTraceid(TraceIdUtil.newTraceId());
        IRequest req = this.revenueService.obtainRequest(1021, params);
        req.setExtParam(params);
        this.revenueService.sendRequest(req);
    }

    public void queryLocalProductList(@NonNull String fileName, Context context, IResult<ProductListResult> callback) {
        if (callback == null) {
            RLog.error((Object)TAG, (String)"queryLocalProductList: callback is null, return.", (Object[])new Object[0]);
            return;
        }
        if (context == null || fileName.isEmpty()) {
            RLog.error((Object)TAG, (String)"params is illegal", (Object[])new Object[0]);
            callback.onFail(-1, "params is illegal.", null);
            return;
        }
        String result = "";
        try {
            InputStream mAssets = context.getAssets().open(fileName);
            int length = mAssets.available();
            byte[] buffer = new byte[length];
            mAssets.read(buffer);
            mAssets.close();
            result = new String(buffer);
            GetChargeCurrencyConfigResponse response = new GetChargeCurrencyConfigResponse(result);
            ProductListResult productListResult = new ProductListResult(response.currencyType, response.confList);
            callback.onSuccess((Object)productListResult, null);
        }
        catch (IOException e) {
            RLog.error((Object)TAG, (String)"queryLocalProductList: read local file IOException:", (Throwable)e);
            callback.onFail(-1, e.getMessage(), null);
        }
        catch (Exception e) {
            RLog.error((Object)TAG, (String)"queryLocalProductList: read local file error:", (Throwable)e);
            callback.onFail(-1, e.getMessage(), null);
        }
    }

    public void queryProductListChannels(@NonNull QueryCurrencyChannelsReqParams params, IResult<ProductListResult> callback) {
        if (!this.checkNotNull((RequestParams)params, callback)) {
            return;
        }
        params.setCallback(callback);
        params.setRequestTime(System.currentTimeMillis());
        params.setTraceid(TraceIdUtil.newTraceId());
        IRequest req = this.revenueService.obtainRequest(1060, params);
        req.setExtParam(params);
        this.revenueService.sendRequest(req);
    }

    public void GetUserCouponStore(@NonNull GetUserCouponStoreParams params, IResult<UserCouponStoreResult> callback) {
        if (!this.checkNotNull((RequestParams)params, callback)) {
            return;
        }
        params.setCallback(callback);
        IRequest req = this.revenueService.obtainRequest(1047, params);
        req.setExtParam(params);
        this.revenueService.sendRequest(req);
    }

    public void GetChargeCouponDiscount(@NonNull GetChargeCouponDiscountReqParams params, IResult<CouponDiscountResult> callback) {
        if (!this.checkNotNull((RequestParams)params, callback)) {
            return;
        }
        params.setCallback(callback);
        IRequest req = this.revenueService.obtainRequest(1052, params);
        req.setExtParam(params);
        this.revenueService.sendRequest(req);
    }

    public void GetHasChargeInActivity(@NonNull GetHasChargeInActivityReqParams params, IResult<HasChargeInActivityResult> callback) {
        if (!this.checkNotNull((RequestParams)params, callback)) {
            return;
        }
        params.setCallback(callback);
        IRequest req = this.revenueService.obtainRequest(1026, params);
        req.setExtParam(params);
        this.revenueService.sendRequest(req);
    }

    public void payWithProductInfo(@NonNull Activity act, @NonNull ChargeCurrencyReqParams params, @NonNull ProductInfo product, @NonNull PayType payType, IPayCallback<String> callback) {
        this.payWithProductInfo(act, params, product, payType, 0, 0, 0, callback);
    }

    public void payWithProductInfo(final @NonNull Activity act, final @NonNull ChargeCurrencyReqParams params, final @NonNull ProductInfo product, final @NonNull PayType payType, final int retryCount, final int intervalMs, final int timeOutMs, final IPayCallback<String> callback) {
        RLog.info((Object)TAG, (String)"---payWithProductInfo---");
        this.hasHangPayJobAndDoHangPayJob(act, payType, params.getProductId(), params.getUid(), params.getToken(), params.getUsedChannel(), params.getCurrencyType(), params.getSubscriptionType(), params.getTokenCallback(), new IResult<String>(){

            public void onSuccess(String result, PayCallBackBean payCallBackBean) {
                AppPayServiceImpl.this.doOrderRequest(act, params, product, payType, retryCount, intervalMs, timeOutMs, callback);
            }

            public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                AppPayServiceImpl.this.doOrderRequest(act, params, product, payType, retryCount, intervalMs, timeOutMs, callback);
            }
        });
    }

    public void hasHangPayJobAndDoHangPayJob(final Activity act, final PayType payType, final String productId, final Long uid, final String token, final int useChannel, final int currencyType, final int subscriptionType, final IToken tokenCallback, final IResult<String> callback) {
        if (payType == PayType.GOOGLE_PLAY) {
            this.hasHangPayJobs(act, PayType.GOOGLE_PLAY, new IResult<List<PurchaseInfo>>(){

                public void onSuccess(List<PurchaseInfo> result, PayCallBackBean payCallBackBean) {
                    PurchaseInfo purchaseInfo = AppPayServiceImpl.this.getPurchaseInfoByProductId(productId, result);
                    if (purchaseInfo != null) {
                        RLog.info((Object)AppPayServiceImpl.TAG, (String)("\u6709\u672a\u6d88\u8017\u7684\u8ba2\u5355\uff0cpurchaseInfo=" + purchaseInfo));
                        final ReportPurchaseReqParams reportPurchaseReqParams = AppPayServiceImpl.this.getReportRequestParams(act, uid, token, useChannel, currencyType, purchaseInfo, payType, subscriptionType, tokenCallback);
                        ThreadPool.getDefault().mainThreadIO().postDelay(new Runnable(){

                            @Override
                            public void run() {
                                AppPayServiceImpl.this.doHangJob(act, reportPurchaseReqParams, PayType.GOOGLE_PLAY, new IResult<String>(){

                                    public void onSuccess(String result, PayCallBackBean payCallBackBean) {
                                        RLog.info((Object)AppPayServiceImpl.TAG, (String)"doHangJobAndPayProduct onSuccess result=$result");
                                        if (callback != null) {
                                            callback.onSuccess((Object)result, payCallBackBean);
                                        }
                                    }

                                    public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                                        RLog.error((Object)AppPayServiceImpl.TAG, (String)"doHangJobAndPayProduct onFail code=$code,failReason=$failReason", (Object[])new Object[0]);
                                        if (callback != null) {
                                            callback.onFail(code, failReason, payCallBackBean);
                                        }
                                    }
                                });
                            }
                        }, 0L);
                    } else {
                        RLog.info((Object)AppPayServiceImpl.TAG, (String)"\u8be5\u5546\u54c1\u6ca1\u6709\u672a\u6d88\u8017\u7684\u8ba2\u5355");
                        if (callback != null) {
                            callback.onFail(-1, "\u8be5\u5546\u54c1\u6ca1\u6709\u672a\u6d88\u8017\u7684\u8ba2\u5355", payCallBackBean);
                        }
                    }
                }

                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                    RLog.error((Object)AppPayServiceImpl.TAG, (String)"\u6ca1\u6709\u672a\u6d88\u8017\u7684\u8ba2\u5355,=$code, failReason=$failReason", (Object[])new Object[0]);
                    if (callback != null) {
                        callback.onFail(code, failReason, payCallBackBean);
                    }
                }
            });
        } else {
            RLog.info((Object)TAG, (String)"\u8be5\u652f\u4ed8\u65b9\u5f0f\u6ca1\u6709\u5904\u7406\u5361\u5355\u6d41\u7a0b");
            if (callback != null) {
                callback.onFail(-1, "\u8be5\u652f\u4ed8\u65b9\u5f0f\u6ca1\u6709\u5904\u7406\u5361\u5355\u6d41\u7a0b", null);
            }
        }
    }

    private ReportPurchaseReqParams getReportRequestParams(Activity act, Long uid, String token, int useChannel, int currencyType, PurchaseInfo purchaseInfo, PayType payType, int subscriptionType, IToken tokenCallback) {
        ReportPurchaseReqParams params = new ReportPurchaseReqParams();
        params.setUid(uid.longValue());
        params.setToken(token);
        params.setAppId(this.appId);
        params.setSid(0);
        params.setUsedChannel(useChannel);
        params.setCurrencyType(currencyType);
        params.setClientVersion(this.mClientVer);
        params.setPurchaseInfo(purchaseInfo);
        params.setPayType(payType);
        params.setSubscriptionType(subscriptionType);
        params.setTokenCallback(tokenCallback);
        return params;
    }

    private PurchaseInfo getPurchaseInfoByProductId(String productId, List<PurchaseInfo> result) {
        PurchaseInfo purchaseInfo = null;
        for (PurchaseInfo purchase : result) {
            try {
                JSONObject jsonObject = new JSONObject(purchase.data);
                if (jsonObject == null || productId != jsonObject.optString("productId")) continue;
                purchaseInfo = purchase;
                break;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return purchaseInfo;
    }

    public void payWithProductId(@NonNull Activity act, @NonNull ProductInfo info, @NonNull ChargeCurrencyReqParams params, String payload, PayType payType, IPayCallback<String> callback) {
        this.payWithProductId(act, info, params, payload, payType, 0, 0, 0, callback);
    }

    public void payWithProductId(@NonNull Activity act, @NonNull ProductInfo info, @NonNull ChargeCurrencyReqParams params, String payload, PayType payType, int retryCount, int intervalMs, int timeOutMs, IPayCallback<String> callback) {
        this.requestPayWithRetry(act, params, payType, info.productId, payload, retryCount, intervalMs, timeOutMs, callback);
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mPaysource = params.getFrom();
        reportResponse.mUid = params.getUid();
        if (this.iPayReporter != null) {
            reportResponse.mEventId = "0";
            reportResponse.mEventaliae = "\u652f\u4ed8\u8bf7\u6c42";
            reportResponse.mErrCode = "0";
            reportResponse.mErrMsg = "payWithProductId-doOrderRequest(\u53d1\u8d77\u4e0b\u5355\u8bf7\u6c42)";
            this.iPayReporter.onRequestPay(reportResponse);
        }
        RLog.info((Object)TAG, (String)("doOrderRequest(\u4e0b\u5355\u8bf7\u6c42)---reqParams:" + params.getPayType() + " " + params.getSubscriptionType() + " " + params.getCid() + "requestTime:" + params + "--uid:" + params.getUid() + "--productId:" + params.getProductId()));
    }

    public void orderWithProductInfo(@NonNull Activity act, @NonNull ChargeCurrencyReqParams params, @NonNull ProductInfo product, @NonNull PayType payType, IPayCallback<PayOrderResult> callback) {
        this.orderWithProductInfo(act, params, product, payType, 0, 0, 0, callback);
    }

    public void orderWithProductInfo(@NonNull Activity act, @NonNull ChargeCurrencyReqParams params, @NonNull ProductInfo product, @NonNull PayType payType, int retryCount, int intervalMs, int timeOutMs, IPayCallback<PayOrderResult> callback) {
        this.doOrderRequest(act, params, product, payType, retryCount, intervalMs, timeOutMs, callback);
    }

    public String toString() {
        return super.toString();
    }

    private void doOrderRequest(@NonNull Activity act, @NonNull ChargeCurrencyReqParams params, @NonNull ProductInfo product, @NonNull PayType payType, int retryCount, int intervalMs, int timeOutMs, IPayCallback callback) {
        String newToken;
        RLog.info((Object)TAG, (String)"---doOrderRequest---");
        if (!this.checkNotNull((RequestParams)params, (IResult)callback)) {
            return;
        }
        long requestTime = System.currentTimeMillis();
        if (!this.isSupported(act, payType)) {
            PayCallBackBean payCallBackBean = new PayCallBackBean(null, product.productId, null, requestTime, null, null, null, null, PurchaseStatus.ORDER_FAIL);
            callback.onFail(IPayMethod.Status.NOT_SUPPORT.getCode(), IPayMethod.Status.NOT_SUPPORT.getMessage(), payCallBackBean);
            return;
        }
        params.setContext(act);
        params.setCallback((IResult)callback);
        params.setPayChannel(payType.getChannel());
        params.setPayMethod(payType.getMethod());
        params.setSrcAmount(product.srcAmount.doubleValue());
        params.setProductId(product.productId);
        params.setCid(product.cid);
        params.setTraceid(TraceIdUtil.newTraceId());
        ChargeCurrencyReqParams reqParams = ChargeCurrencyReqParams.Companion.clone(params);
        reqParams.setPayChannel(payType.getChannel());
        reqParams.setPayMethod(payType.getMethod());
        reqParams.setSrcAmount(product.srcAmount.doubleValue());
        reqParams.setProductId(product.productId);
        reqParams.setCid(product.cid);
        reqParams.setRetryCount(retryCount);
        reqParams.setIntervalMs(intervalMs);
        reqParams.setTimeOutMs(timeOutMs);
        reqParams.setPayType(payType);
        reqParams.setProductId(params.getProductId());
        reqParams.setFrom(params.getFrom());
        reqParams.setSubscriptionType(params.getSubscriptionType());
        reqParams.setOldProductId(params.getOldProductId());
        reqParams.setProrationMode(params.getProrationMode());
        reqParams.setReturnUrl(params.getReturnUrl());
        reqParams.setExpand(params.getExpand());
        reqParams.setRequestTime(requestTime);
        reqParams.setTokenCallback(params.getTokenCallback());
        reqParams.setTraceid(params.getTraceid());
        reqParams.setFrom(params.getFrom());
        IToken iToken = params.getTokenCallback();
        if (iToken != null && (newToken = iToken.onUpdateToken()) != null) {
            reqParams.setToken(newToken);
            RLog.info((Object)TAG, (String)("doOrderRequest---newToken:" + newToken));
        }
        reqParams.setCid(params.getCid());
        if (payType == PayType.GOOGLE_PLAY && params.getSubscriptionType() != 0) {
            int channel = params.getUsedChannel();
            params.setUsedChannel(channel);
            reqParams.setUsedChannel(channel);
        }
        reqParams.setCurrencyType(params.getCurrencyType());
        reqParams.setCurrencyType(params.getCurrencyType());
        RLog.info((Object)TAG, (String)("doOrderRequest---reqParams:" + reqParams.getPayType() + " " + reqParams.getSubscriptionType() + " " + reqParams.getCid() + "requestTime:" + requestTime + "--uid:" + reqParams.getUid() + "--productId:" + reqParams.getProductId()));
        PayCallBackBean payCallBackBean = new PayCallBackBean(null, reqParams.getProductId(), null, reqParams.getRequestTime(), null, null, null, null, PurchaseStatus.ORDER_START);
        callback.onPayStatus(PurchaseStatus.ORDER_START, payCallBackBean);
        IRequest req = this.revenueService.obtainRequest(1022, params);
        req.setExtParam(reqParams);
        this.revenueService.sendRequest(req);
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mPaysource = params.getFrom();
        reportResponse.mUid = params.getUid();
        reportResponse.mPayTraceId = params.getTraceid();
        reportResponse.mPageId = this.mPageId;
        RouterInfo routerInfo = RouterInfoCenter.getRouterInfo((Context)act.getApplicationContext(), (int)reqParams.getCmd());
        if (routerInfo == null) {
            reportResponse.mServiceName = this.mDefalutServiceName;
            reportResponse.mFunctionName = this.mDefalutFunctionName;
        } else {
            reportResponse.mServiceName = routerInfo.serviceName;
            reportResponse.mFunctionName = routerInfo.functionName;
        }
        RLog.info((Object)TAG, (String)("doOrderRequest---mServiceName:" + reportResponse.mServiceName + "---mFunctionName" + reportResponse.mFunctionName));
        if (this.iPayReporter != null) {
            reportResponse.mEventId = "0";
            reportResponse.mEventaliae = "\u652f\u4ed8\u8bf7\u6c42";
            reportResponse.mErrCode = "0";
            reportResponse.mErrMsg = "doOrderRequest";
            this.iPayReporter.onRequestPay(reportResponse);
        }
    }

    public void queryMyBalance(@NonNull QueryCurrencyReqParams params, IResult<MyBalanceResult> callback) {
        if (!this.checkNotNull((RequestParams)params, callback)) {
            return;
        }
        params.setCallback(callback);
        IRequest req = this.revenueService.obtainRequest(1005, params);
        req.setExtParam(params);
        this.revenueService.sendRequest(req);
    }

    public void queryRevenueRecordByUid(@NonNull QueryUserAccountHistoryReqParams params, IResult<RevenueRecordResult> callback) {
        if (!this.checkNotNull((RequestParams)params, callback)) {
            return;
        }
        params.setCallback(callback);
        IRequest req = this.revenueService.obtainRequest(1046, params);
        req.setExtParam(params);
        this.revenueService.sendRequest(req);
    }

    public void exchangeCurrency(@NonNull ExchangeCurrencyReqParams params, IResult<ExchangeResult> iResult) {
        if (!this.checkNotNull((RequestParams)params, iResult)) {
            return;
        }
        params.setCallback(iResult);
        IRequest req = this.revenueService.obtainRequest(1025, params);
        req.setExtParam(params);
        this.revenueService.sendRequest(req);
    }

    public void queryRechargeHistory(@NonNull QueryRechargeHistoryReqParams params, IResult<RechargeHistoryResult> iResult) {
        if (!this.checkNotNull((RequestParams)params, iResult)) {
            return;
        }
        params.setCallback(iResult);
        IRequest req = this.revenueService.obtainRequest(1054, params);
        req.setExtParam(params);
        this.revenueService.sendRequest(req);
    }

    public boolean isSupported(Activity act, PayType payType) {
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay != null) {
            return pay.isSupported(act);
        }
        return false;
    }

    public boolean hasHangPayJob(Activity act, PayType payType, final IResult<PurchaseInfo> iResult) {
        return this.hasHangPayJobs(act, payType, new IResult<List<PurchaseInfo>>(){

            public void onSuccess(List<PurchaseInfo> result, PayCallBackBean payCallBackBean) {
                iResult.onSuccess((Object)result.get(0), null);
            }

            public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                iResult.onFail(code, failReason, null);
            }
        });
    }

    public boolean hasHangSubscribeJob(Activity act, PayType payType, final IResult<PurchaseInfo> iResult) {
        return this.hasHangSubscribeJobs(act, payType, new IResult<List<PurchaseInfo>>(){

            public void onSuccess(List<PurchaseInfo> result, PayCallBackBean payCallBackBean) {
                iResult.onSuccess((Object)result.get(0), null);
            }

            public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                iResult.onFail(code, failReason, null);
            }
        });
    }

    public boolean hasHangPayJobs(Activity act, PayType payType, final IResult<List<PurchaseInfo>> iResult) {
        if (iResult == null) {
            return false;
        }
        if (!this.isSupported(act, payType)) {
            iResult.onFail(IPayMethod.Status.NOT_SUPPORT.getCode(), IPayMethod.Status.NOT_SUPPORT.getMessage(), null);
            return false;
        }
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay != null) {
            pay.hasHangPayJobs(act, (IResult)new IResult<List<PurchaseInfo>>(){

                public void onSuccess(List<PurchaseInfo> result, PayCallBackBean payCallBackBean) {
                    RLog.info((Object)AppPayServiceImpl.TAG, (String)"hasHangPayJobs result =%s", (Object[])new Object[]{result});
                    iResult.onSuccess(result, payCallBackBean);
                }

                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                    RLog.error((Object)AppPayServiceImpl.TAG, (String)"hasHangPayJobs fail code = %d, failReason = %s", (Object[])new Object[]{code, failReason});
                    iResult.onFail(code, failReason, payCallBackBean);
                }
            });
        }
        return false;
    }

    public boolean hasHangSubscribeJobs(Activity act, PayType payType, final IResult<List<PurchaseInfo>> iResult) {
        if (iResult == null) {
            return false;
        }
        if (!this.isSupported(act, payType)) {
            iResult.onFail(-1, "not support", null);
            return false;
        }
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay != null) {
            final HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
            pay.hasHangSubscribeJobs(act, (IResult)new IResult<List<PurchaseInfo>>(){

                public void onSuccess(List<PurchaseInfo> result, PayCallBackBean payCallBackBean) {
                    RLog.info((Object)AppPayServiceImpl.TAG, (String)"hasHangSubscribeJob result =%s", (Object[])new Object[]{result});
                    iResult.onSuccess(result, payCallBackBean);
                }

                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                    RLog.error((Object)AppPayServiceImpl.TAG, (String)"hasHangSubscribeJob fail code = %d, failReason = %s", (Object[])new Object[]{code, failReason});
                    iResult.onFail(code, failReason, payCallBackBean);
                    reportResponse.mEventId = "101";
                    reportResponse.mErrCode = code + "";
                    reportResponse.mErrMsg = failReason;
                    AppPayServiceImpl.this.iPayReporter.onPurchaseSummaryResult(reportResponse);
                }
            });
        }
        return false;
    }

    public boolean queryHangJobsByLocalCache(final @NonNull Activity act, final PayType payType, final IResult<List<PurchaseStatusInfo>> iResult) {
        PurchaseStatusImpl.readAllPurchaseStatus((Activity)act, (IResult)new IResult<List<PurchaseStatusInfo>>(){

            public void onSuccess(final List<PurchaseStatusInfo> result, PayCallBackBean payCallBackBean) {
                if (result != null && result.size() > 0) {
                    AppPayServiceImpl.this.hasHangPayJobs(act, payType, new IResult<List<PurchaseInfo>>(){

                        public void onSuccess(List<PurchaseInfo> listPurchaseInfo, PayCallBackBean payCallBackBean) {
                            for (PurchaseStatusInfo purchaseStatusInfo : result) {
                                if (purchaseStatusInfo.status != PurchaseStatus.PAY_START.getCode() && purchaseStatusInfo.status != PurchaseStatus.ORDER_SUCCESS.getCode()) continue;
                                for (PurchaseInfo purchaseInfo : listPurchaseInfo) {
                                    String chorderid = AppPayServiceImpl.this.getCHOrderId(purchaseInfo.data);
                                    if (!chorderid.equals(purchaseStatusInfo.chorderid)) continue;
                                    purchaseStatusInfo.purchaseData = purchaseInfo.data;
                                    purchaseStatusInfo.purchaseSign = purchaseInfo.signature;
                                }
                            }
                            iResult.onSuccess((Object)result, null);
                        }

                        public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                            iResult.onFail(-1, "queryHangJobsByLocalCache fail\uff0cresult is null or result.size is 0", payCallBackBean);
                        }
                    });
                } else {
                    iResult.onFail(-1, "queryHangJobsByLocalCache fail\uff0cresult is null or result.size = 0", payCallBackBean);
                }
            }

            public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                iResult.onFail(code, failReason, payCallBackBean);
            }
        });
        return true;
    }

    public boolean doHangJobByLocalCache(final @NonNull Activity act, final ReportPurchaseReqParams params, final IResult<String> iResult) {
        if (params == null) {
            iResult.onFail(-1, "ReportPurchaseReqParams is null", null);
            return false;
        }
        PurchaseStatusImpl.readPurchaseStatus((Activity)act, (String)params.getProductid(), (String)String.valueOf(params.getUid()), (String)params.getOrderId(), (IResult)new IResult<PurchaseStatusInfo>(){

            public void onSuccess(final PurchaseStatusInfo purchaseStatusInfo, PayCallBackBean payCallBackBean) {
                AppPayServiceImpl.this.hasHangPayJobs(act, params.getPayType(), new IResult<List<PurchaseInfo>>(){

                    public void onSuccess(List<PurchaseInfo> listPurchaseInfo, PayCallBackBean payCallBackBean) {
                        for (PurchaseInfo purchaseInfo : listPurchaseInfo) {
                            String productId = AppPayServiceImpl.this.getProductId(purchaseInfo.data);
                            if (!productId.equals(purchaseStatusInfo.productId)) continue;
                            AppPayServiceImpl.this.doHangJob(act, params, params.getPayType(), new IResult<String>(){

                                public void onSuccess(String result, PayCallBackBean payCallBackBean) {
                                    iResult.onSuccess((Object)result, payCallBackBean);
                                }

                                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                                    iResult.onFail(code, failReason, payCallBackBean);
                                }
                            });
                        }
                    }

                    public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                        iResult.onFail(code, failReason, payCallBackBean);
                    }
                });
            }

            public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                iResult.onFail(code, failReason, payCallBackBean);
            }
        });
        return true;
    }

    public boolean doHangJobsByLocalCache(@NonNull Activity act, PayType payType, IResult<List<PurchaseStatusInfo>> iResult) {
        return true;
    }

    public boolean queryHistoryPurchaseBySkuType(@NonNull Activity act, @NonNull PayType payType, String skuType, IResult<List<PurchaseInfo>> iResult) {
        if (iResult == null) {
            return false;
        }
        if (!this.isSupported(act, payType)) {
            iResult.onFail(-1, "not support payType", null);
            return false;
        }
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay != null) {
            pay.queryHistoryPurchaseBySkuType(act, skuType, iResult);
        }
        return false;
    }

    public boolean doHangJob(@NonNull Activity act, @NonNull ReportPurchaseReqParams params, PayType payType, IResult<String> callback) {
        return this.doHangJob(act, params, payType, 0, 0, 0, callback);
    }

    public boolean doHangJob(@NonNull Activity act, @NonNull ReportPurchaseReqParams params, @NonNull PayType payType, int retryCount, int intervalMs, int timeOutMs, IResult<String> callback) {
        RLog.info((Object)TAG, (String)"---doHangJob---");
        if (!this.checkNotNull((RequestParams)params, callback)) {
            return false;
        }
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mPaysource = params.getFrom();
        reportResponse.mUid = params.getUid();
        reportResponse.mOrderId = params.getOrderId();
        if (pay == null || !pay.isSupported(act)) {
            if (callback != null) {
                callback.onFail(-1, "doHangJob fail : not support pay method", null);
                reportResponse.mErrCode = "-1";
                reportResponse.mErrMsg = "doHangJob fail : not support pay method";
                reportResponse.mEventId = "101";
                this.iPayReporter.onPurchaseSummaryResult(reportResponse);
                reportResponse.mEventId = "9";
                reportResponse.mEventaliae = "\u7ee7\u7eed\u5b8c\u6210\u672a\u5b8c\u6210\u7684\u8ba2\u5355\u5931\u8d25";
                this.iPayReporter.onDoHangJob(reportResponse);
                RLog.error((Object)TAG, (String)"doHangJob fail : not support pay method. code = %d, OrderId = %s ,  uid = %s ", (Object[])new Object[]{-1, params.getOrderId(), params.getUid()});
            }
            return false;
        }
        if (params.getPurchaseInfo() == null) {
            callback.onFail(-1, "doHangJob fail: please call hasHangPayJob first", null);
            reportResponse.mErrCode = "-1";
            reportResponse.mErrMsg = "doHangJob fail: please call hasHangPayJob first";
            reportResponse.mEventId = "101";
            this.iPayReporter.onPurchaseSummaryResult(reportResponse);
            reportResponse.mEventId = "9";
            reportResponse.mEventaliae = "\u7ee7\u7eed\u5b8c\u6210\u672a\u5b8c\u6210\u7684\u8ba2\u5355\u5931\u8d25";
            this.iPayReporter.onDoHangJob(reportResponse);
            RLog.error((Object)TAG, (String)"doHangJob fail: please call hasHangPayJob first. code = %d, OrderId = %s ,  uid = %s ", (Object[])new Object[]{-1, params.getOrderId(), params.getUid()});
            return false;
        }
        params.setContext(act);
        params.setRetryCount(retryCount);
        params.setIntervalMs(intervalMs);
        params.setTimeOutMs(timeOutMs);
        params.setPayMethod(pay);
        params.setCallback((IResult)new DoHangJobProxy(params, params.getPurchaseInfo(), payType, callback));
        params.setRequestTime(System.currentTimeMillis());
        this.reportPurchase(params, params.getPurchaseInfo().data, params.getPurchaseInfo().signature);
        return true;
    }

    public void clearHangJob(Activity act, PayType payType, int type, IResult<PurchaseInfo> callback) {
        IPayMethod pay;
        if (callback == null) {
            return;
        }
        if (!this.isSupported(act, payType)) {
            callback.onFail(-1, "not support", null);
        }
        if ((pay = PayMethodFactory.valueOf(payType)) != null) {
            pay.clearHangPayJob(act, type, callback);
        }
    }

    public boolean doHangJobByProductId(final @NotNull Activity act, final @NotNull DoHangPayJobReqParams params, final PayType payType, final int retryCount, final int intervalMs, final int timeOutMs, final IResult<String> callback) {
        RLog.info((Object)TAG, (String)"---doHangJobByProductId---");
        if (callback == null) {
            return false;
        }
        final HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mPaysource = params.getFrom();
        reportResponse.mUid = params.getUid();
        final IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay == null || !pay.isSupported(act)) {
            callback.onFail(IPayMethod.Status.NOT_SUPPORT.getCode(), IPayMethod.Status.NOT_SUPPORT.getMessage(), null);
        } else {
            pay.queryHistoryPurchaseByProductId(params.getProductId(), (IResult)new IResult<PurchaseInfo>(){

                public int hashCode() {
                    return super.hashCode();
                }

                public void onSuccess(PurchaseInfo result, PayCallBackBean payCallBackBean) {
                    params.setContext(act);
                    params.setRetryCount(retryCount);
                    params.setIntervalMs(intervalMs);
                    params.setTimeOutMs(timeOutMs);
                    params.setPayMethod(pay);
                    params.setRequestTime(System.currentTimeMillis());
                    params.setProductid(params.getProductId());
                    params.setCallback((IResult)new DoHangJobProxy((ReportPurchaseReqParams)params, result, payType, (IResult<String>)callback));
                    String data = result.data;
                    try {
                        JSONObject json = new JSONObject(data);
                        json.put("packageName", (Object)params.getPackageName());
                        data = json.toString();
                    }
                    catch (JSONException e) {
                        RLog.error((Object)AppPayServiceImpl.TAG, (String)"doHangJobByProductId fail errMsg = %s", (Object[])new Object[]{e.getMessage()});
                    }
                    AppPayServiceImpl.this.reportPurchase((ReportPurchaseReqParams)params, data, result.signature);
                    reportResponse.mErrCode = "0";
                    reportResponse.mErrMsg = "\u5904\u7406\u5361\u5355\u6210\u529f";
                    reportResponse.mEventId = "102";
                    reportResponse.mEventaliae = "\u5904\u7406\u5361\u5355\u6210\u529f";
                    AppPayServiceImpl.this.iPayReporter.onDoHangJobByProductId(reportResponse);
                }

                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                    callback.onFail(code, failReason, payCallBackBean);
                    reportResponse.mErrCode = code + "";
                    reportResponse.mErrMsg = failReason;
                    reportResponse.mEventId = "103";
                    reportResponse.mEventaliae = "\u5904\u7406\u5361\u5355\u5931\u8d25";
                    AppPayServiceImpl.this.iPayReporter.onDoHangJobByProductId(reportResponse);
                }
            });
        }
        return true;
    }

    public void querySkuDetails(Activity act, PayType payType, List<String> skusList, String skuType, final IResult<List<SkuDetailInfo>> iResult) {
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay == null || !pay.isSupported(act)) {
            iResult.onFail(IPayMethod.Status.NOT_SUPPORT.getCode(), IPayMethod.Status.NOT_SUPPORT.getMessage(), null);
            RLog.info((Object)TAG, (String)"querySkuDetails onFail no support ");
        } else {
            pay.querySkuDetails(act, skusList, skuType, (IResult)new IResult<List<SkuDetailInfo>>(){

                public void onSuccess(List<SkuDetailInfo> result, PayCallBackBean payCallBackBean) {
                    RLog.info((Object)AppPayServiceImpl.TAG, (String)"querySkuDetails onSuccess result = %s", (Object[])new Object[]{result.toString()});
                    iResult.onSuccess(result, payCallBackBean);
                }

                public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                    RLog.info((Object)AppPayServiceImpl.TAG, (String)"querySkuDetails onFail code = %s, failReason = %s", (Object[])new Object[]{code, failReason});
                    iResult.onFail(code, failReason, payCallBackBean);
                }
            });
        }
    }

    public void reportPayEntrancePage(int from) {
        this.mPageId = PageIdUtil.newPageId();
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mEventId = "-10";
        reportResponse.mEventaliae = "\u652f\u4ed8\u5165\u53e3\u9875\u9762";
        reportResponse.mPageId = this.mPageId;
        reportResponse.mPaysource = from;
        reportResponse.mErrCode = "0";
        reportResponse.mErrMsg = "pay-entrance-page\uff08\u652f\u4ed8\u5165\u53e3\u9875\u9762\uff09";
        if (this.iPayReporter != null) {
            this.iPayReporter.onPayEntrancePage(reportResponse);
        }
    }

    public boolean isPayingStatus(PayType payType) {
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        if (pay != null) {
            return pay.isPayingStatus();
        }
        return false;
    }

    public void onWxPayResult(int code, String msg) {
        IPayMethod pay = PayMethodFactory.valueOf(PayType.WECHAT_PAY);
        if (pay != null) {
            pay.onWxPayResult(code, msg);
        }
    }

    public void addPayListener(IAppPayServiceListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removePayListener(IAppPayServiceListener listener) {
        Iterator<IAppPayServiceListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (listener != iterator.next()) continue;
            iterator.remove();
            break;
        }
    }

    public void registerPayReporter(IPayReporter iPayReporter) {
        this.iPayReporter = iPayReporter;
    }

    public void setCountryCode(String countryCode) {
        this.mCountryCode = countryCode;
    }

    public void onResponseData(int appId, PSCIMessageResponse responseData) {
        this.revenueService.onResponseData(appId, responseData);
    }

    public void onUnicastData(int appId, PSCIMessageUnicast unicastData) {
        this.revenueService.onUnicastData(appId, unicastData);
    }

    public void onBroadcastData(int appId, PSCIMessageBroadcast broadcastData) {
    }

    public void onRequestError(int appId, String seq, int cmd, int srvErrorCode, String message) {
        this.revenueService.onRequestError(appId, seq, cmd, srvErrorCode, message);
    }

    public void requestPay(Activity act, PayType payType, String productId, String payload, boolean isSetAccountId, IPayCallback<PurchaseInfo> callback) {
        RLog.info((Object)TAG, (String)("requstPay,payType:" + payType + ",productId:" + productId + ",payload:" + payload));
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        pay.requestPay(act, 0L, productId, payload, isSetAccountId, callback);
    }

    public void requestSubscription(Activity act, PayType payType, String productId, String payload, boolean isSetAccountId, IPayCallback<PurchaseInfo> callback) {
        RLog.info((Object)TAG, (String)("requestSubscription,payType:" + payType + ",productId:" + productId + ",payload:" + payload));
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        pay.requestSubscription(act, 0L, productId, payload, isSetAccountId, callback);
    }

    public void consumeProduct(PayType payType, PurchaseInfo info, IResult<String> result) {
        RLog.info((Object)TAG, (String)("consumeProduct, payType:" + payType + ",info:" + info));
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        pay.doHangJob(info, result);
    }

    private void requestPayWithRetry(Activity act, ChargeCurrencyReqParams params, PayType payType, String productId, String payload, int retryCount, int intervalMs, int timeOutMs, IPayCallback<String> callback) {
        RLog.info((Object)TAG, (String)String.format("---requestPayWithRetry productId = %s, payload = %s---", productId, payload));
        if (!this.checkNotNull((RequestParams)params, (IResult)callback)) {
            return;
        }
        params.setContext(act);
        params.setRetryCount(retryCount);
        params.setIntervalMs(intervalMs);
        params.setTimeOutMs(timeOutMs);
        params.setPayType(payType);
        params.setCallback(callback);
        this.requestPay(act, params, payType, productId, payload, true, new PayCallbackProxy(payType, "", params, payload, callback));
    }

    public AppPayServiceImpl() {
    }

    private void requestPay(Activity act, ChargeCurrencyReqParams params, PayType payType, String productId, String payload, boolean isSetAccountId, IPayCallback callback) {
        IPayMethod pay = PayMethodFactory.valueOf(payType);
        RLog.debug((Object)TAG, (String)String.format("---requestPay SubscriptionType=%s ProductId = %s", params.getSubscriptionType(), params.getProductId()));
        if (params.getPayType() == PayType.GOOGLE_PLAY && params.getSubscriptionType() == 1) {
            pay.requestSubscription(act, params.getUid(), productId, payload, isSetAccountId, callback);
        } else if (params.getPayType() == PayType.GOOGLE_PLAY && params.getSubscriptionType() == 2) {
            pay.updateSubscription(act, params.getUid(), params.getOldProductId(), productId, params.getProrationMode(), payload, isSetAccountId, callback);
        } else {
            pay.requestPay(act, params.getUid(), productId, payload, isSetAccountId, callback);
        }
    }

    private void reportPurchase(@NonNull ChargeCurrencyReqParams params, @NonNull String purchaseData, @NonNull String purchaseSign, @NonNull String orderId, @NonNull IPayCallback callback) {
        String newToken;
        long requestTime = System.currentTimeMillis();
        RLog.info((Object)TAG, (String)String.format("---reportPurchase purchaseData = %s, purchaseSign = %s, requestTime = %s---", purchaseData, purchaseSign, requestTime));
        ReportPurchaseReqParams reqParams = new ReportPurchaseReqParams();
        reqParams.clone((RequestParams)params);
        reqParams.setCurrencyType(params.getCurrencyType());
        reqParams.setData(purchaseData);
        reqParams.setSign(purchaseSign);
        reqParams.setOrderId(orderId);
        reqParams.setFrom(params.getFrom());
        reqParams.setPayMethod(PayMethodFactory.valueOf(params.getPayType()));
        reqParams.setPayType(params.getPayType());
        reqParams.setSubscriptionType(params.getSubscriptionType());
        reqParams.setRetryType(1);
        reqParams.setIntervalMs(5000);
        reqParams.setRetryCount(50);
        reqParams.setRequestTime(requestTime);
        reqParams.setToken(params.getToken());
        reqParams.setTokenCallback(params.getTokenCallback());
        reqParams.setTraceid(params.getTraceid());
        reqParams.setProductid(params.getProductId());
        reqParams.setCallback((IResult)callback);
        IToken iToken = params.getTokenCallback();
        if (iToken != null && (newToken = iToken.onUpdateToken()) != null) {
            reqParams.setToken(newToken);
            RLog.info((Object)TAG, (String)("reportPurchase--1-newToken:" + newToken));
        }
        if (callback != null) {
            String gpOrderId = this.getGPOrderId(purchaseData);
            String chOrderId = this.getCHOrderId(purchaseData);
            String payload = this.getPayLoad(purchaseData);
            PayCallBackBean payCallBackBean = new PayCallBackBean(orderId, reqParams.getProductid(), gpOrderId, reqParams.getRequestTime(), chOrderId, payload, purchaseData, purchaseSign, PurchaseStatus.REPORT_START);
            callback.onPayStatus(PurchaseStatus.REPORT_START, payCallBackBean);
        }
        IRequest req = this.revenueService.obtainRequest(1045, reqParams);
        req.setExtParam(reqParams);
        this.revenueService.sendRequest(req);
    }

    private void reportPurchase(@NonNull ReportPurchaseReqParams params, @NonNull String purchaseData, @NonNull String purchaseSign) {
        String newToken;
        long requestTime = System.currentTimeMillis();
        RLog.info((Object)TAG, (String)String.format("--start-reportPurchase, purchaseData = %s, purchaseSign = %s, requestTime = %s \uff0cuid = %s\uff0coderid = %s", purchaseData, purchaseSign, requestTime, params.getUid(), params.getOrderId()));
        params.setData(purchaseData);
        params.setSign(purchaseSign);
        params.setRetryType(1);
        params.setIntervalMs(5000);
        params.setRetryCount(50);
        params.setRequestTime(requestTime);
        IToken iToken = params.getTokenCallback();
        if (iToken != null && (newToken = iToken.onUpdateToken()) != null) {
            params.setToken(newToken);
            RLog.info((Object)TAG, (String)("reportPurchase--1-newToken:" + newToken));
        }
        IRequest req = this.revenueService.obtainRequest(1045, params);
        req.setExtParam(params);
        this.revenueService.sendRequest(req);
    }

    private boolean checkNotNull(RequestParams params, IResult iResult) {
        return params != null && iResult != null;
    }

    public <T> void onSuccess(RequestParams params, T data, PayCallBackBean payCallBackBean) {
        if (null == params) {
            return;
        }
        IResult callback = params.getCallback();
        if (null == callback) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            callback.onSuccess(data, payCallBackBean);
        } else {
            ThreadPool.getDefault().mainThreadIO().execute(() -> callback.onSuccess(data, payCallBackBean));
        }
    }

    public void onFail(String seq, int code, String message, IResult callback, PayCallBackBean payCallBackBean) {
        if (null == callback) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            callback.onFail(code, message, payCallBackBean);
        } else {
            ThreadPool.getDefault().mainThreadIO().execute(() -> callback.onFail(code, message, payCallBackBean));
        }
    }

    private String getGPOrderId(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                tagObject = json.getString("orderId");
                if (tagObject == null) {
                    tagObject = "";
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getPurchaseTime--PayCallbackProxy data =%s , Exception =%s", data, e.getMessage()), (Object[])new Object[0]);
            }
        }
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser success ---PayCallbackProxy data =%s , orderId =%s", data, tagObject));
        return tagObject;
    }

    private String getProductId(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                tagObject = json.getString("productId");
                if (tagObject == null) {
                    tagObject = "";
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --productId--PayCallbackProxy data =%s , Exception =%s", data, e.getMessage()), (Object[])new Object[0]);
            }
        }
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser success ---PayCallbackProxy data =%s , orderId =%s", data, tagObject));
        return tagObject;
    }

    private String getChOrderidByPayload(String payload) {
        String tagObject = "";
        if (payload != null) {
            try {
                JSONObject json = new JSONObject(payload);
                String payloadString = json.getString("chOrderId");
                if (payloadString == null || payloadString.equals("")) {
                    tagObject = "";
                    RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getChOrderidByPayload =null ", new Object[0]), (Object[])new Object[0]);
                } else {
                    tagObject = payloadString;
                }
                return tagObject;
            }
            catch (JSONException e) {
                e.printStackTrace();
                RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getPayLoad--getChOrderidByPayload data =%s , Exception =%s", payload, e.getMessage()), (Object[])new Object[0]);
            }
        }
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser success ---getChOrderidByPayload data =%s , getPayLoad =%s", payload, tagObject));
        return tagObject;
    }

    private String getCHOrderId(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                String payloadString = json.getString("developerPayload");
                if (payloadString == null || payloadString.equals("")) {
                    tagObject = "";
                } else {
                    JSONObject payloadJson = new JSONObject(payloadString);
                    tagObject = payloadJson.getString("chOrderId");
                    if (tagObject == null) {
                        tagObject = "";
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getCHOrderId--PayCallbackProxy data =%s , Exception =%s", data, e.getMessage()), (Object[])new Object[0]);
            }
        }
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser success ---PayCallbackProxy data =%s , chorderId =%s", data, tagObject));
        return tagObject;
    }

    private String getPayLoad(String data) {
        String tagObject = "";
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                String payloadString = json.getString("developerPayload");
                if (payloadString == null || payloadString.equals("")) {
                    tagObject = "";
                    RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getPayLoad =null ", new Object[0]), (Object[])new Object[0]);
                } else {
                    tagObject = payloadString;
                }
                return tagObject;
            }
            catch (JSONException e) {
                e.printStackTrace();
                RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getPayLoad--PayCallbackProxy data =%s , Exception =%s", data, e.getMessage()), (Object[])new Object[0]);
            }
        }
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser success ---PayCallbackProxy data =%s , getPayLoad =%s", data, tagObject));
        return tagObject;
    }

    private long getPurchaseTime(String data) {
        long tagObject = 0L;
        if (data != null) {
            try {
                JSONObject json = new JSONObject(data);
                tagObject = json.getLong("purchaseTime");
            }
            catch (JSONException e) {
                e.printStackTrace();
                RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getPurchaseTime--PayCallbackProxy data =%s , Exception =%s", data, e.getMessage()), (Object[])new Object[0]);
            }
        }
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser success ---PayCallbackProxy data =%s , purchaseTime =%s", data, tagObject));
        return tagObject;
    }

    private String getChallengeExtension(String expand) {
        String tagObject = "";
        if (expand != null) {
            try {
                JSONObject json = new JSONObject(expand);
                String riskObject = json.getString("riskData");
                if (riskObject != null && !riskObject.equals("")) {
                    JSONObject riskJson = new JSONObject(riskObject);
                    tagObject = riskJson.getString("challengeExtension");
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                RLog.error((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser fail --getChallengeExtension--PayCallbackProxy data =%s , Exception =%s", expand, e.getMessage()), (Object[])new Object[0]);
            }
        }
        RLog.info((Object)TAG, (String)String.format(Locale.ENGLISH, "data parser success ---getChallengeExtension data =%s , purchaseTime =%s", expand, tagObject));
        return tagObject;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    private String combiCloudLogString(int code, String errorMsg, String request, String respone) {
        return "{cdoe:" + code + ",errorMsg:" + errorMsg + ",request:" + request + ",respone:" + respone + "}";
    }

    private class DoHangJobProxy
    implements IResult<String> {
        private IResult<String> iResult;
        private PurchaseInfo mPurchaseInfo;
        private PayType payType;
        private ReportPurchaseReqParams params;

        public DoHangJobProxy(ReportPurchaseReqParams params, PurchaseInfo purchaseInfo, PayType payType, IResult<String> iResult) {
            this.mPurchaseInfo = purchaseInfo;
            this.payType = payType;
            this.iResult = iResult;
            this.params = params;
        }

        public void onSuccess(String result, PayCallBackBean payCallBackBean) {
            this.iResult.onSuccess((Object)result, payCallBackBean);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
            if (code == -20) {
                if (this.params != null && this.params.getSubscriptionType() == 0) {
                    AppPayServiceImpl.this.consumeProduct(PayType.GOOGLE_PLAY, this.mPurchaseInfo, null);
                    this.iResult.onFail(code, "DoHangJobProxy, already reported! consumeOrder directly", null);
                } else {
                    this.iResult.onFail(code, "DoHangJobProxy, already reported!", payCallBackBean);
                }
            } else {
                this.iResult.onFail(code, failReason, payCallBackBean);
            }
        }
    }

    private class PayCallbackProxy
    implements IPayCallback<PurchaseInfo> {
        private IPayCallback iPayCallback;
        private ChargeCurrencyReqParams params;
        private PayType payType;
        private String orderId = "";
        private HiidoReport.CReportResponse reportResponse;
        private long requestTime;
        private String payLoad;

        public PayCallbackProxy(PayType payType, String orderId, ChargeCurrencyReqParams params, String payLoad, IPayCallback iPayCallback) {
            this.payType = payType;
            if (orderId != null) {
                this.orderId = orderId;
            }
            this.requestTime = System.currentTimeMillis();
            this.params = params;
            this.iPayCallback = iPayCallback;
            this.payLoad = payLoad;
            this.reportResponse = new HiidoReport.CReportResponse();
            this.reportResponse.mPaysource = params.getFrom();
            this.reportResponse.mUid = params.getUid();
            this.reportResponse.mOrderId = this.orderId;
            this.reportResponse.mServiceName = AppPayServiceImpl.this.mDefalutServiceName;
            this.reportResponse.mFunctionName = AppPayServiceImpl.this.mDefalutFunctionName;
            this.reportResponse.mPayTraceId = params.getTraceid();
            this.reportResponse.mPageId = AppPayServiceImpl.this.mPageId;
        }

        public void onSuccess(PurchaseInfo result, PayCallBackBean payCallBackBean) {
            long delay = System.currentTimeMillis() - this.requestTime;
            long purchaseTime = 0L;
            String gpOrderId = "";
            if (result != null) {
                if (this.payType == PayType.GOOGLE_PLAY) {
                    if (this.params.getPayType() == PayType.GOOGLE_PLAY) {
                        PurchaseStatusInfo purchaseStatusInfo = new PurchaseStatusInfo();
                        purchaseStatusInfo.uid = this.params.getUid();
                        purchaseStatusInfo.status = PurchaseStatus.PAY_SUCCESS.getCode();
                        purchaseStatusInfo.productId = this.params.getProductId();
                        purchaseStatusInfo.orderId = this.orderId;
                        purchaseStatusInfo.purchaseData = result.data;
                        purchaseStatusInfo.purchaseSign = result.signature;
                        PurchaseStatusImpl.savePurchaseStatus((Activity)this.params.getContext(), (PurchaseStatusInfo)purchaseStatusInfo);
                    }
                    AppPayServiceImpl.this.reportPurchase(this.params, result.data, result.signature, this.orderId, this.iPayCallback);
                    RLog.info((Object)AppPayServiceImpl.TAG, (String)String.format(Locale.ENGLISH, "pay success, start to reportPurchase! ---PayCallbackProxy requestTime =%s , Uid =%s, OrderId =%s", this.requestTime, this.params.getUid(), this.orderId));
                    purchaseTime = AppPayServiceImpl.this.getPurchaseTime(result.data);
                    gpOrderId = AppPayServiceImpl.this.getGPOrderId(result.data);
                    if (payCallBackBean == null) {
                        payCallBackBean = new PayCallBackBean(this.orderId, this.params.getProductId(), gpOrderId, purchaseTime, null, this.payLoad, result.data, result.signature, PurchaseStatus.PAY_SUCCESS);
                    }
                } else {
                    if (payCallBackBean == null) {
                        payCallBackBean = new PayCallBackBean(this.orderId, this.params.getProductId(), "", this.requestTime, null, this.payLoad, null, null, PurchaseStatus.PAY_SUCCESS);
                    }
                    this.iPayCallback.onSuccess((Object)"pay success!", payCallBackBean);
                    RLog.info((Object)AppPayServiceImpl.TAG, (String)String.format(Locale.ENGLISH, "---PayCallbackProxy-pay-onSuccess: requestTime = %s, delay = %s, Uid =%s, OrderId =%s", this.requestTime, delay + "", this.params.getUid(), this.orderId));
                }
            }
            if (this.iPayCallback != null) {
                this.iPayCallback.onPayStatus(PurchaseStatus.PAY_SUCCESS, payCallBackBean);
            }
            if (AppPayServiceImpl.this.iPayReporter != null) {
                this.reportResponse.mGPOrderId = gpOrderId;
                this.reportResponse.mPurchaseTime = purchaseTime + "";
                this.reportResponse.mDelay = delay + "";
                this.reportResponse.mEventId = "4";
                this.reportResponse.mEventaliae = "\u652f\u4ed8\u6210\u529f";
                this.reportResponse.mErrCode = "0";
                this.reportResponse.mErrMsg = "pay success!";
                AppPayServiceImpl.this.iPayReporter.onPayResult(this.reportResponse);
            }
        }

        public void onFail(final int code, final String failReason, PayCallBackBean payCallBackBean) {
            final int payResponeCode = code;
            final String payResponeFailReason = failReason;
            if (this.payType == PayType.GOOGLE_PLAY) {
                final long delay = System.currentTimeMillis() - this.requestTime;
                boolean bl = AppPayServiceImpl.this.hasHangPayJob(this.params.getContext(), this.payType, new IResult<PurchaseInfo>(){

                    public void onSuccess(PurchaseInfo result, PayCallBackBean payCallBackBean) {
                        final String dohangProductId = AppPayServiceImpl.this.getProductId(result.data);
                        RLog.info((Object)AppPayServiceImpl.TAG, (String)String.format(Locale.ENGLISH, "---PayCallbackProxy, pay onFail--hasHangPayJob: requestTime = %s, delay = %s, uid = %s, orderid = %s, dohangProductId = %s", PayCallbackProxy.this.requestTime, delay + "", PayCallbackProxy.this.params.getUid(), PayCallbackProxy.this.orderId, dohangProductId));
                        if (dohangProductId.equals(PayCallbackProxy.this.params.getProductId())) {
                            RLog.info((Object)AppPayServiceImpl.TAG, (String)String.format(Locale.ENGLISH, "---PayCallbackProxy, pay onFail--hasHangPayJob, dohangProductId = productId, start to reportPurchase", new Object[0]));
                            long purchaseTimeHas = AppPayServiceImpl.this.getPurchaseTime(result.data);
                            String gpOrderIdHas = AppPayServiceImpl.this.getGPOrderId(result.data);
                            if (AppPayServiceImpl.this.iPayReporter != null) {
                                ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mGPOrderId = gpOrderIdHas;
                                ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mPurchaseTime = purchaseTimeHas + "";
                                ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mDelay = delay + "";
                                ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mEventId = "5";
                                ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mEventaliae = "\u652f\u4ed8\u5931\u8d25";
                                ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mErrCode = code + "";
                                ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mErrMsg = "pay Fail! but hasHangPayJob, dohangProductId=" + dohangProductId + ",current productId=" + PayCallbackProxy.this.params.getProductId() + ",orderid:" + PayCallbackProxy.this.orderId + ", gpOrderIdHas:" + gpOrderIdHas + ",failReason" + failReason;
                                AppPayServiceImpl.this.iPayReporter.onPayResult(PayCallbackProxy.this.reportResponse);
                            }
                            AppPayServiceImpl.this.reportPurchase(PayCallbackProxy.this.params, result.data, result.signature, PayCallbackProxy.this.orderId, PayCallbackProxy.this.iPayCallback);
                        } else {
                            RLog.info((Object)AppPayServiceImpl.TAG, (String)String.format(Locale.ENGLISH, "---PayCallbackProxy, pay onFail--no hasHangPayJob: requestTime = %s, delay = %s, uid = %s, orderid = %s, dohangProductId = %s", PayCallbackProxy.this.requestTime, delay + "", PayCallbackProxy.this.params.getUid(), PayCallbackProxy.this.orderId, dohangProductId));
                            PayCallbackProxy.this.failCallBackInternal(payResponeCode, payResponeFailReason, payCallBackBean);
                            ThreadPool.getDefault().mainThreadIO().postDelay(new Runnable(){

                                @Override
                                public void run() {
                                    AppPayServiceImpl.this.hasHangPayJob(PayCallbackProxy.this.params.getContext(), PayCallbackProxy.this.payType, new IResult<PurchaseInfo>(){

                                        public void onSuccess(PurchaseInfo result, PayCallBackBean payCallBackBean) {
                                            String dohangProductId2 = AppPayServiceImpl.this.getProductId(result.data);
                                            if (dohangProductId2.equals(PayCallbackProxy.this.params.getProductId())) {
                                                long purchaseTimeHas = AppPayServiceImpl.this.getPurchaseTime(result.data);
                                                String gpOrderIdHas = AppPayServiceImpl.this.getGPOrderId(result.data);
                                                if (AppPayServiceImpl.this.iPayReporter != null) {
                                                    ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mGPOrderId = gpOrderIdHas;
                                                    ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mPurchaseTime = purchaseTimeHas + "";
                                                    ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mDelay = delay + "";
                                                    ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mEventId = "5";
                                                    ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mEventaliae = "\u652f\u4ed8\u5931\u8d25";
                                                    ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mErrCode = code + "";
                                                    ((PayCallbackProxy)PayCallbackProxy.this).reportResponse.mErrMsg = "pay Fail! but hasHangPayJob-- 60s retry!, dohangProductId=" + dohangProductId + ",current productId=" + PayCallbackProxy.this.params.getProductId() + ",orderid:" + PayCallbackProxy.this.orderId + ", gpOrderIdHas:" + gpOrderIdHas + ",failReason" + failReason;
                                                    AppPayServiceImpl.this.iPayReporter.onPayResult(PayCallbackProxy.this.reportResponse);
                                                }
                                                AppPayServiceImpl.this.reportPurchase(PayCallbackProxy.this.params, result.data, result.signature, PayCallbackProxy.this.orderId, PayCallbackProxy.this.iPayCallback);
                                            }
                                        }

                                        public void onFail(int code, String failReason, PayCallBackBean payCallBackBean) {
                                        }
                                    });
                                }
                            }, 60000L);
                        }
                    }

                    public void onFail(int code2, String failReason2, PayCallBackBean payCallBackBean) {
                        PayCallbackProxy.this.failCallBackInternal(payResponeCode, payResponeFailReason, payCallBackBean);
                    }
                });
            } else {
                this.failCallBackInternal(payResponeCode, payResponeFailReason, payCallBackBean);
            }
        }

        public void onPayStart() {
            if (this.iPayCallback != null) {
                String chOrderid = AppPayServiceImpl.this.getChOrderidByPayload(this.payLoad);
                PayCallBackBean payCallBackBean = new PayCallBackBean(this.orderId, this.params.getProductId(), "", this.requestTime, chOrderid, this.payLoad, null, null, PurchaseStatus.PAY_START);
                this.iPayCallback.onPayStatus(PurchaseStatus.PAY_START, payCallBackBean);
                this.iPayCallback.onPayStart();
            }
            if (this.params.getPayType() == PayType.GOOGLE_PLAY) {
                PurchaseStatusInfo purchaseStatusInfo = new PurchaseStatusInfo();
                purchaseStatusInfo.uid = this.params.getUid();
                purchaseStatusInfo.status = PurchaseStatus.PAY_START.getCode();
                purchaseStatusInfo.productId = this.params.getProductId();
                purchaseStatusInfo.orderId = this.orderId;
                PurchaseStatusImpl.savePurchaseStatus((Activity)this.params.getContext(), (PurchaseStatusInfo)purchaseStatusInfo);
            }
            long delay = System.currentTimeMillis() - this.requestTime;
            RLog.info((Object)AppPayServiceImpl.TAG, (String)String.format(Locale.ENGLISH, "---PayCallbackProxy-onPayStart: requestTime = %s, delay = %s, uid = %s, orderid = %s", this.requestTime, delay + "", this.params.getUid(), this.orderId));
            if (AppPayServiceImpl.this.iPayReporter != null) {
                this.reportResponse.mDelay = delay + "";
                this.reportResponse.mEventId = "3";
                this.reportResponse.mEventaliae = "\u652f\u4ed8\u9875\u9762\u88ab\u62c9\u8d77";
                this.reportResponse.mErrCode = "0";
                this.reportResponse.mErrMsg = "start pay---Pull up the payment page";
                AppPayServiceImpl.this.iPayReporter.onPayStart(this.reportResponse);
            }
        }

        public void onPayStatus(PurchaseStatus status, PayCallBackBean callBackBean) {
            this.iPayCallback.onPayStatus(status, callBackBean);
        }

        private void failCallBackInternal(int code, String failReason, PayCallBackBean payCallBackBean) {
            if (payCallBackBean == null) {
                payCallBackBean = new PayCallBackBean(this.orderId, this.params.getProductId(), "", this.requestTime, null, this.payLoad, null, null, PurchaseStatus.PAY_FAIL);
            }
            if (this.iPayCallback != null) {
                if (this.payType == PayType.GOOGLE_PLAY && code == 1) {
                    payCallBackBean = new PayCallBackBean(this.orderId, this.params.getProductId(), "", this.requestTime, null, this.payLoad, null, null, PurchaseStatus.PAY_CANCEL);
                    this.iPayCallback.onPayStatus(PurchaseStatus.PAY_CANCEL, payCallBackBean);
                } else {
                    payCallBackBean = new PayCallBackBean(this.orderId, this.params.getProductId(), "", this.requestTime, null, this.payLoad, null, null, PurchaseStatus.PAY_FAIL);
                    this.iPayCallback.onPayStatus(PurchaseStatus.PAY_FAIL, payCallBackBean);
                }
                this.iPayCallback.onFail(code, "pay fail! failReason:" + failReason, payCallBackBean);
            }
            long delay = System.currentTimeMillis() - this.requestTime;
            RLog.info((Object)AppPayServiceImpl.TAG, (String)String.format(Locale.ENGLISH, "---PayCallbackProxy, pay onFail: requestTime = %s, delay = %s, uid = %s, orderid = %s", this.requestTime, delay + "", this.params.getUid(), this.orderId));
            if (AppPayServiceImpl.this.iPayReporter != null) {
                this.reportResponse.mDelay = delay + "";
                this.reportResponse.mEventId = "5";
                this.reportResponse.mEventaliae = "\u652f\u4ed8\u5931\u8d25";
                this.reportResponse.mErrCode = code + "";
                this.reportResponse.mErrMsg = "pay fail! failReason:" + failReason;
                AppPayServiceImpl.this.iPayReporter.onPayResult(this.reportResponse);
                this.reportResponse.mEventId = "101";
                AppPayServiceImpl.this.iPayReporter.onPurchaseSummaryResult(this.reportResponse);
            }
            if (this.params != null && code != 1) {
                String logCloud = AppPayServiceImpl.this.combiCloudLogString(code, "pay fail! failReason:" + failReason, this.params.toString(), "");
                CloudLogHelper.sendLog((String)"onRequestPay", (String)logCloud);
            }
        }
    }
}

