package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;


import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by ouyangshaocong on 2018/7/19.
 */
public class ReportPurchaseResponse implements IBaseJsonResponse {
    public int cmd = RevenueServerConst.ReportPurchaseResponse;
    public long uid;
    public String seq;
    public int result;
    public String message;
    public String purchaseData;
    public String purchaseSign;
    public String orderId;

    /**
     * 构造函数
     *
     * @param jsonMsg
     */
    public ReportPurchaseResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        if (null == jsonMsg || "".equals(jsonMsg.trim())) {
            RLog.error("ReportPurchaseResponse", "parserResponse error, jsonMsg is empty.");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonMsg);
            int cmd = jsonObject.optInt("cmd");
            if (this.cmd != cmd) {
                throw new Exception(this.cmd + " != " + cmd);
            }
            this.uid = jsonObject.optLong("uid");
            this.seq = jsonObject.optString("seq");
            this.result = jsonObject.optInt("result");
            this.message = jsonObject.optString("message");
            this.purchaseData = jsonObject.optString("purchaseData");
            this.purchaseSign = jsonObject.optString("purchaseSign");
            this.orderId = jsonObject.optString("orderId");
        } catch (JSONException e) {
            RLog.error("ReportPurchaseResponse", "parserResponse error.", e);
        } catch (Exception e) {
            RLog.error("ReportPurchaseResponse", "parserResponse error.", e);
        }
    }
}
