package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;


import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequestProtocol;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by ouyangshaocong on 2018/7/19.
 */
public class ReportPurchaseRequest implements IRequestProtocol {
    public long uid;
    public int sid = 0; //不可为空，频道外传0
    public int appId;
    public int usedChannel = 10002; //暂定IOS：10001、Android：10002
    public int currencyType; //充值货币类型：1-紫水晶,13-钻石
    public String seq;
    // private final String ticket;
    private final String purchaseData;
    private final String purchaseSign;
    public String expand;

    /**
     * 构造函数
     *
     * @param uid
     * @param sid
     * @param appId
     * @param usedChannel
     * @param currencyType
     * @param seq
     * @param ticket
     * @param purchaseData
     * @param purchaseSign
     */
    public ReportPurchaseRequest(long uid, int sid, int appId, int usedChannel, int currencyType, String seq,
                                 String ticket, String purchaseData, String purchaseSign, String expand) {
        this.uid = uid;
        this.sid = sid;
        this.appId = appId;
        this.usedChannel = usedChannel;
        this.currencyType = currencyType;
        this.seq = seq;
        // this.ticket = ticket;
        this.purchaseData = purchaseData;
        this.purchaseSign = purchaseSign;
        this.expand = expand;
    }

    @NotNull
    @Override
    public String getProtocol() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", RevenueServerConst.ReportPurchaseRequest);
            jMsg.put("uid", uid);
            jMsg.put("sid", sid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("currencyType", currencyType);
            jMsg.put("seq", seq);
            // jMsg.put("ticket", ticket);
            jMsg.put("purchaseData", purchaseData);
            jMsg.put("purchaseSign", purchaseSign);
            jMsg.put("expand", expand);
            jsonMsg = jMsg.toString().replaceAll("", "");
        } catch (JSONException e) {
            RLog.error("ReportPurchaseRequest", "constructPSCIMessageRequest", e);
        }
        return jsonMsg;
    }

}
