package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequestProtocol;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public class GetUserCouponStoreRequest implements IRequestProtocol {

    public String seq;
    // public String ticket;
    public long uid;
    public int appId;
    public int goodsType;
    public boolean hasUsed;
    public int page;
    public int pageSize;
    public boolean includeExpire;

    public GetUserCouponStoreRequest(String seq, long uid, int appId, String ticket, int goodsType
            , boolean hasUsed, int page, int pageSize,  boolean includeExpire) {
        this.seq = seq;
        this.uid = uid;
        this.appId = appId;
        // this.ticket = ticket;
        this.goodsType = goodsType;
        this.hasUsed = hasUsed;
        this.page = page;
        this.pageSize = pageSize;
        this.includeExpire = includeExpire;
    }

    @NotNull
    @Override
    public String getProtocol() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", RevenueServerConst.GetUserCouponStoreRequest);
            jMsg.put("seq", seq);
            jMsg.put("uid", uid);
            jMsg.put("appId", appId);
            // jMsg.put("ticket", ticket);
            jMsg.put("goodsType", goodsType);
            jMsg.put("hasUsed", hasUsed);
            jMsg.put("page", page);
            jMsg.put("pageSize", pageSize);
            jMsg.put("includeExpire", includeExpire);
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("GetUserCouponStoreRequest", "constructPSCIMessageRequest error.", e);
        }
        return jsonMsg;
    }
}
