package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;


import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payapi.bean.MyBalanceInfo;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by lhf on 2018/7/23.
 * <p>
 * YY.Inc
 */
public class GetUserAccountResponse implements IBaseJsonResponse {

    public String seq;
    public long uid;
    public int result;
    public String message;
    public long minAmountLimit;
    public Map<Integer, MyBalanceInfo.Account> accountList;
    public Map<Integer, MyBalanceInfo.AccountPeriod> accountPeriodList;

    public GetUserAccountResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        try {
            JSONObject object = new JSONObject(jsonMsg);
            seq = object.optString("seq", "");
            uid = object.optLong("uid", 0);
            result = object.optInt("result", 0);
            message = object.optString("message", "");
            minAmountLimit = object.optLong("minAmountLimit", 0);
            JSONArray accountArray = object.optJSONArray("accountList");
            accountList = new HashMap<>();
            if (accountArray != null && accountArray.length() > 0) {
                for (int i = 0; i < accountArray.length(); ++i) {
                    JSONObject item = accountArray.optJSONObject(i);
                    if (item != null) {
                        MyBalanceInfo.Account account = new MyBalanceInfo.Account();
                        account.currencyType = item.optInt("currencyType", 0);
                        account.amount = item.optLong("amount", 0);
                        account.freezed = item.optLong("freezed", 0);
                        account.accountFrozen = item.optInt("accountFrozen", 0);
                        //account.expireAmount = item.optInt("expireAmount", 0);
                        //account.expireDate = item.optString("expireDate", "");
                        accountList.put(account.currencyType, account);
                    }
                }
            }
            JSONArray accountPeriodArray = object.optJSONArray("accountPeriodList");
            accountPeriodList = new HashMap<>();
            if (accountPeriodArray != null && accountPeriodArray.length() > 0) {
                for (int i = 0; i < accountPeriodArray.length(); ++i) {
                    JSONObject item = accountPeriodArray.optJSONObject(i);
                    if (item != null) {
                        MyBalanceInfo.AccountPeriod accountPeriod = new MyBalanceInfo.AccountPeriod();
                        accountPeriod.currencyType = item.optInt("currencyType", 0);
                        accountPeriod.amount = item.optInt("amount", 0);
                        accountPeriod.startTime = item.optLong("startTime", 0);
                        accountPeriod.endTime = item.optLong("endTime", 0);
                        accountPeriodList.put(accountPeriod.currencyType, accountPeriod);
                    }
                }
            }
        } catch (JSONException e) {
            RLog.error("GetUserAccountResponse", "parserResponse error.", e);
        }
    }
}
