package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequestProtocol;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by lhf on 2018/7/23.
 * <p>
 * YY.Inc
 */
public class GetUserAccountRequest implements IRequestProtocol {
    public String seq;
    public long uid;
    public int appId;
    public int usedChannel;

    public GetUserAccountRequest(String seq, long uid, int appId, int usedChannel) {
        this.seq = seq;
        this.uid = uid;
        this.appId = appId;
        this.usedChannel = usedChannel;
    }

    @NotNull
    @Override
    public String getProtocol() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", RevenueServerConst.GetUserAccountRequest);
            jMsg.put("seq", seq);
            jMsg.put("uid", uid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("returnYb", false);
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("GetUserAccountRequest", "constructPSCIMessageRequest error.", e);
        }
        return jsonMsg;
    }
}
