package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;


import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payapi.bean.RevenueRecord;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by ouyangshaocong on 2018/7/23.
 */
public class GetUserAccountHistoryResponse implements IBaseJsonResponse {
    public int cmd = RevenueServerConst.GetUserAccountHistoryResponse;
    public long uid;
    public String seq;
    public int appId;
    public int result;
    public String message;
    public List<RevenueRecord> userAccountHistoryInfos = new ArrayList<>();
    public boolean hasMore;

    /**
     * 构造函数
     */
    public GetUserAccountHistoryResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        if (null == jsonMsg || "".equals(jsonMsg.trim())) {
            RLog.error("GetUserAccountHistoryResponse", "parserResponse error, jsonMsg is empty.");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonMsg);
            int cmd = jsonObject.optInt("cmd");
            if (this.cmd != cmd) {
                throw new Exception(this.cmd + " != " + cmd);
            }
            this.uid = jsonObject.optLong("uid");
            this.seq = jsonObject.optString("seq");
            this.appId = jsonObject.optInt("appId");
            this.result = jsonObject.optInt("result");
            this.message = jsonObject.optString("message");
            this.userAccountHistoryInfos.addAll(optHistoryInfo(jsonObject.optJSONArray("userAccountHistoryInfos")));
            this.hasMore = jsonObject.optBoolean("hasMore");
        } catch (JSONException e) {
            RLog.error("GetUserAccountHistoryResponse", "parserResponse error.", e);
        } catch (Exception e) {
            RLog.error("GetUserAccountHistoryResponse", "parserResponse error.", e);
        }
    }

    /**
     * 解析流水记录
     *
     * @param array
     * @return
     */
    private List<RevenueRecord> optHistoryInfo(JSONArray array) {
        List<RevenueRecord> list = new ArrayList<>();
        if (null == array) {
            return list;
        }
        int len = array.length();
        JSONObject object;
        RevenueRecord record;
        for (int i = 0; i < len; i++) {
            object = array.optJSONObject(i);
            if (null == object) {
                continue;
            }
            record = new RevenueRecord();
            record.id = object.optInt("id");
            record.uid = object.optLong("uid");
            record.currencyType = object.optLong("currencyType");
            record.amountChange = object.optLong("amountChange");
            record.amountRemain = object.optLong("amountRemain");
            record.freezedChange = object.optLong("freezedChange");
            record.freezedRemain = object.optLong("freezedRemain");
            record.optType = object.optInt("optType");
            record.optTime = object.optLong("optTime");
            record.optName = object.optString("optName");
            record.description = object.optString("description");
            list.add(record);
        }
        return list;
    }
}
