package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequestProtocol;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by ouyangshaocong on 2018/7/23.
 */
public class GetUserAccountHistoryRequest implements IRequestProtocol {
    public long uid;
    public int appId;
    public int usedChannel = 10002; //暂定IOS：10001、Android：10002
    public int currencyType; //充值货币类型：1-紫水晶,13-钻石
    public String seq;
    // public String ticket;
    public long lastId;
    public String expand;

    /**
     * 构造函数
     *
     * @param uid
     * @param appId
     * @param usedChannel
     * @param currencyType
     * @param seq
     * @param ticket
     * @param lastId
     */
    public GetUserAccountHistoryRequest(long uid, int appId, int usedChannel, int currencyType,
                                        String seq, String ticket, long lastId) {
        this(uid, appId, usedChannel, currencyType, seq, ticket, lastId, "");
    }

    /**
     * 构造函数
     *
     * @param uid
     * @param appId
     * @param usedChannel
     * @param currencyType
     * @param seq
     * @param ticket
     * @param lastId
     * @param expand
     */
    public GetUserAccountHistoryRequest(long uid, int appId, int usedChannel, int currencyType,
                                        String seq, String ticket, long lastId, String expand) {
        this.uid = uid;
        this.appId = appId;
        this.usedChannel = usedChannel;
        this.currencyType = currencyType;
        this.seq = seq;
        // this.ticket = ticket;
        this.lastId = lastId;
        this.expand = expand;
    }

    @NotNull
    @Override
    public String getProtocol() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", RevenueServerConst.GetUserAccountHistoryRequest);
            jMsg.put("uid", uid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("currencyType", currencyType);
            jMsg.put("seq", seq);
            // jMsg.put("ticket", ticket);
            jMsg.put("lastId", lastId);
            jMsg.put("expand", expand);
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("GetUserAccountHistoryRequest", "constructPSCIMessageRequest", e);
        }
        return jsonMsg;
    }
}
