package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;

import org.json.JSONException;
import org.json.JSONObject;

public class GetHasChargeInActivityResponse implements IBaseJsonResponse {
    public int cmd = RevenueServerConst.GetHasChargeInActivityResponse;
    public long uid;
    public String seq;
    public int result;
    public String message;

    public int activityId;
    public String startTime;
    public String endTime;
    public boolean hasCharge;
    public String tip;
    public int chargeCount;

    /**
     * 构造函数
     *
     * @param jsonMsg
     */
    public GetHasChargeInActivityResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        if (null == jsonMsg || "".equals(jsonMsg.trim())) {
            RLog.error("GetHasChargeInActivityResponse", "parserResponse error, jsonMsg is empty.");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonMsg);
            int cmd = jsonObject.optInt("cmd");
            if (this.cmd != cmd) {
                throw new Exception(this.cmd + " != " + cmd);
            }
            this.uid = jsonObject.optLong("uid");
            this.seq = jsonObject.optString("seq");
            this.result = jsonObject.optInt("result");
            this.message = jsonObject.optString("message");
            this.activityId = jsonObject.optInt("activityId");
            this.startTime = jsonObject.optString("startTime");
            this.endTime = jsonObject.optString("endTime");
            this.hasCharge = jsonObject.optBoolean("hasCharge");
            this.tip = jsonObject.optString("tip");
            this.chargeCount = jsonObject.optInt("chargeCount");
        } catch (JSONException e) {
            RLog.error("GetHasChargeInActivityResponse", "parserResponse error.", e);
        } catch (Exception e) {
            RLog.error("GetHasChargeInActivityResponse", "parserResponse error.", e);
        }
    }
}
