package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequestProtocol;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by lhf on 2018/7/9.
 * <p>请求充值配置列表
 * YY.Inc
 */
public class GetChargeCurrencyConfigRequest implements IRequestProtocol {

    //    # Request
    //    {
    //            "cmd":1021,
    //            "uid":$uid,
    //            "appId":$appId,                            // hello：15、交友：2
    //            "usedChannel":usedChannel,                //IOS：10001、Android：10002，特殊情况另外考虑
    //            "currencyType":"$currencyType",        // 1-紫水晶,14-钻石
    //            "seq":$seq,                            // seq
    //            "expand":"$expand"                     // 扩展字段，原文附于返回
    //    }

    public long uid;
    public int appId;
    public int usedChannel = 10002;
    public int currencyType;
    public String seq;
    public String expand = "";
    // public String ticket;   // 参数里面不需要传ticket，要在外层传递

    /**
     * 构造函数
     *
     * @param appId
     * @param currencyType
     * @param seq
     */
    public GetChargeCurrencyConfigRequest(int appId, int currencyType, String seq) {
        this(0, appId, currencyType, seq);
    }

    /**
     * 构造函数
     *
     * @param uid
     * @param appId
     * @param currencyType
     * @param seq
     */
    public GetChargeCurrencyConfigRequest(long uid, int appId, int currencyType, String seq) {
        this(uid, appId, 10002, currencyType, seq, "");
    }

    /**
     * 构造函数
     *
     * @param uid
     * @param appId
     * @param usedChannel
     * @param currencyType
     * @param seq
     * @param expand
     */
    public GetChargeCurrencyConfigRequest(long uid, int appId, int usedChannel, int currencyType,
                                          String seq, String expand) {
        this(uid, appId, 10002, currencyType, seq, "", expand);
    }

    /**
     * 构造函数
     *
     * @param uid
     * @param appId
     * @param usedChannel
     * @param currencyType
     * @param seq
     * @param expand
     */
    public GetChargeCurrencyConfigRequest(long uid, int appId, int usedChannel, int currencyType,
                                          String seq, String ticket, String expand) {
        this.uid = uid;
        this.appId = appId;
        this.usedChannel = usedChannel;
        this.currencyType = currencyType;
        this.seq = seq;
        // this.ticket = ticket;
        this.expand = expand;
    }

    @NotNull
    @Override
    public String getProtocol() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", RevenueServerConst.GetChargeCurrencyConfigRequest);
            jMsg.put("uid", uid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("currencyType", currencyType);
            jMsg.put("seq", seq);
            // jMsg.put("ticket", ticket);
            jMsg.put("expand", expand);
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("GetChargeCurrencyConfigRequest", "constructPSCIMessageRequest error.", e);
        }
        return jsonMsg;
    }
}