package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payapi.bean.CurrencyInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.ProductInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PropsInfo;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class GetChargeCurrencyConfigChannelsResponse implements IBaseJsonResponse {
        public int cmd = RevenueServerConst.GetChargeCurrencyConfigByChannelsResponse;
        public long uid;
        public String seq;
        public String expend;
        public int currencyType;
        public List<ProductInfo> confList = new ArrayList<>();

        /**
         * 构造函数
         *
         * @param jsonMsg
         */
        public GetChargeCurrencyConfigChannelsResponse(String jsonMsg) {
            parserResponse(jsonMsg);
        }

        @Override
        public void parserResponse(String jsonMsg) {
            if (null == jsonMsg || "".equals(jsonMsg.trim())) {
                RLog.error("GetChargeCurrencyConfigChannelsResponse",

                        "parserResponse error, jsonMsg is empty.");
                return;
            }
            try {
                JSONObject jsonObject = new JSONObject(jsonMsg);
                int cmd = jsonObject.optInt("cmd");
                if (this.cmd != cmd) {
                    throw new Exception(this.cmd + " != " + cmd);
                }
                this.uid = jsonObject.optLong("uid");
                this.seq = jsonObject.optString("seq");
                this.expend = jsonObject.optString("expand");
                this.currencyType = jsonObject.optInt("currencyType");
                this.confList.addAll(optProductList(jsonObject.optJSONArray("confList")));
            } catch (JSONException e) {
                RLog.error("GetChargeCurrencyConfigChannelsResponse", "parserResponse error.", e);
            } catch (Exception e) {
                RLog.error("GetChargeCurrencyConfigChannelsResponse", "parserResponse error.", e);
            }
        }

        /**
         * 解析product列表
         *
         * @param array
         * @return
         */
        public List<ProductInfo> optProductList(JSONArray array) {
            List<ProductInfo> products = new ArrayList<>();
            if (null == array) {
                return products;
            }
            int len = array.length();
            JSONObject object;
            ProductInfo info;
            for (int i = 0; i < len; i++) {
                object = array.optJSONObject(i);
                if (null == object) {
                    continue;
                }
                info = new ProductInfo();
                info.cid = object.optInt("cid");
                info.offersTips = object.optString("offersTips");
                info.name = object.optString("name");
                info.level = object.optInt("level");
                info.srcAmount = object.optDouble("srcAmount");
                info.srcCurrencySymbol = object.optString("srcCurrencySymbol");
                info.destAmount = object.optLong("destAmount");
                info.offersType = object.optInt("offersType");
                info.offersRate = object.optInt("offersRate");
                info.offers_currency_same = object.optBoolean("offers_currency_same");
                info.offers_currency_name = object.optString("offers_currency_name");
                info.offers_currency_type = object.optInt("offers_currency_type");
                info.hasAct = object.optBoolean("hasAct");
                info.hasCurrencyAct = object.optBoolean("hasCurrencyAct");
                info.hasDestCurrencyAct = object.optBoolean("hasDestCurrencyAct");
                info.spAmount = object.optLong("spAmount");
                info.spSumAmount = object.optLong("spSumAmount");
                info.hasOtherCurrencyAct = object.optBoolean("hasOtherCurrencyAct");
                info.otherCurrenciesSum = object.optInt("otherCurrenciesSum");
                info.otherCurrencies.addAll(optOtherCurrencies(object.optJSONArray("otherCurrencies")));
                info.hasFirstRush = object.optBoolean("hasFirstRush");
                info.firstRushAmount = object.optLong("firstRushAmount");
                info.hasPropsAct = object.optBoolean("hasPropsAct");
                info.propsSum = object.optInt("propsSum");
                info.props.addAll(optProps(object.optJSONArray("props")));
                info.chargeRate = object.optDouble("chargeRate");
                info.productId = object.optString("productId");
                info.expand = object.optString("expand");
                info.currencyCode = object.optString("currencyCode");
                info.otherPrice = object.optString("otherPrice");
                info.payChannel = object.optString("payChannel");
                info.payMethod = object.optString("payMethod");
                info.subChannel = object.optString("subChannel");
                info.payType = object.optString("payType");
                info.usedChannelType = object.optInt("usedChannelType");
                products.add(info);
            }
            return products;
        }

        /**
         * 解析currency数组
         *
         * @param array
         * @return
         */
        private List<CurrencyInfo> optOtherCurrencies(JSONArray array) {
            List<CurrencyInfo> currencies = new ArrayList<>();
            if (null == array) {
                return currencies;
            }
            int len = array.length();
            CurrencyInfo info;
            JSONObject object;
            for (int i = 0; i < len; i++) {
                object = array.optJSONObject(i);
                if (null == object) {
                    continue;
                }
                info = new CurrencyInfo();
                info.offers_currency_type = object.optInt("offers_currency_type");
                info.offers_currency_amount = object.optLong("offers_currency_amount");
                info.offers_currency_name = object.optString("offers_currency_name");
                currencies.add(info);
            }
            return currencies;
        }

        /**
         * 解析道具列表
         *
         * @param array
         * @return
         */
        private List<PropsInfo> optProps(JSONArray array) {
            List<PropsInfo> props = new ArrayList<>();
            if (null == array) {
                return props;
            }
            int len = array.length();
            PropsInfo info;
            JSONObject object;
            for (int i = 0; i < len; i++) {
                object = array.optJSONObject(i);
                if (null == object) {
                    continue;
                }
                info = new PropsInfo();
                info.propid = object.optInt("propid");
                info.count = object.optInt("count");
                info.type = object.optInt("type");
                props.add(info);
            }
            return props;
        }

        @Override
        public String toString() {
            return "GetChargeCurrencyConfigChannelsResponse{" +
                    "cmd=" + cmd +
                    ", uid=" + uid +
                    ", seq='" + seq + '\'' +
                    ", expand='" + expend + '\'' +
                    ", currencyType=" + currencyType +
                    ", confList=" + confList +
                    '}';
        }
    }

