package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequestProtocol;

import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class GetChargeCurrencyConfigChannelsRequest implements IRequestProtocol {

//    # Request
//    {
//            "cmd":1021,
//            "uid":$uid,
//            "appId":$appId,                            // hello：15、交友：2
//            "usedChannelList":$usedChannelList,        //必填，渠道号集合，IOS：10001、Android：10002，特殊情况另外考虑
//            "currencyType":"$currencyType",        // 1-紫水晶,14-钻石
//            "countryCode":$countryCode,            //String国家码，AE\MY\IN
//            "seq":$seq,                            // seq
//            "expand":"$expand"                     // 扩展字段，原文附于返回
//    }

    public long uid;
    public int appId;
    public List<Integer> usedChannelList;
    public int currencyType;
    public String seq;
    public String expand = "";
    // public String ticket = "";

    /**
     * 构造函数
     *
     * @param appId
     * @param currencyType
     * @param seq
     */
    public GetChargeCurrencyConfigChannelsRequest(int appId, int currencyType, String seq) {
        this(0, appId, currencyType, seq);
    }

    /**
     * 构造函数
     *
     * @param uid
     * @param appId
     * @param currencyType
     * @param seq
     */
    public GetChargeCurrencyConfigChannelsRequest(long uid, int appId, int currencyType,
                                                  String seq) {
        this(uid, appId, new ArrayList<Integer>(), currencyType, seq, "", "");
    }

    /**
     * 构造函数
     *
     * @param uid
     * @param appId
     * @param usedChannelList
     * @param currencyType
     * @param seq
     * @param expand
     */
    public GetChargeCurrencyConfigChannelsRequest(long uid, int appId,
                                                  List<Integer> usedChannelList, int currencyType,
                                                  String seq, String ticket, String expand) {
        this.uid = uid;
        this.appId = appId;
        this.usedChannelList = usedChannelList;
        this.currencyType = currencyType;
        this.seq = seq;
        // this.ticket = ticket;
        this.expand = expand;
    }

    @NotNull
    @Override
    public String getProtocol() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();

        JSONArray jsonArray = new JSONArray();

        if (usedChannelList != null) {
            for (Integer item : usedChannelList) {
                jsonArray.put(item);
            }
        }
        try {
            jMsg.put("cmd", RevenueServerConst.GetChargeCurrencyConfigByChannelsRequest);
            jMsg.put("uid", uid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannelList", jsonArray);
            jMsg.put("currencyType", currencyType);
            jMsg.put("seq", seq);
            // jMsg.put("ticket", ticket);
            jMsg.put("expand", expand);
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("GetChargeCurrencyConfigChannelsRequest",
                    "GetChargeCurrencyConfigChannelsRequest error.", e);
        }
        return jsonMsg;
    }
}
