package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.request.IRequestProtocol;

import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

public class GetChargeCouponDiscountRequest implements IRequestProtocol {

    public String seq;
    // public String ticket;
    public long uid;
    public int appId;
    public int currencyType;
    public int usedChannel;
    public int userCouponId;
    public String payChannel;
    public List<Integer> chargeConfigIds;

    /**
     * 构造函数
     */
    public GetChargeCouponDiscountRequest(String seq, String ticket, long uid, int appId,
                                          int currencyType, int usedChannel, int userCouponId,
                                          String payChannel, List<Integer> chargeConfigIds
    ) {
        this.seq = seq;
        // this.ticket = ticket;
        this.uid = uid;
        this.appId = appId;
        this.currencyType = currencyType;
        this.usedChannel = usedChannel;
        this.userCouponId = userCouponId;
        this.payChannel = payChannel;
        this.chargeConfigIds = chargeConfigIds;
    }

    @NotNull
    @Override
    public String getProtocol() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();

        JSONArray jsonArray = new JSONArray();

        if (chargeConfigIds != null) {
            for (Integer item : chargeConfigIds) {
                jsonArray.put(item);
            }
        }
        try {
            jMsg.put("cmd", RevenueServerConst.GetChargeCouponDiscountRequest);
            jMsg.put("uid", uid);
            jMsg.put("appId", appId);
            jMsg.put("currencyType", currencyType);
            jMsg.put("seq", seq);
            // jMsg.put("ticket", ticket);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("userCouponId", userCouponId);
            jMsg.put("payChannel", payChannel);
            jMsg.put("chargeConfigIds", jsonArray);
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("GetChargeCouponDiscountRequest",
                    "GetChargeCouponDiscountRequest error.", e);
        }
        return jsonMsg;
    }
}
