package com.yy.mobile.framework.revenuesdk.payservice.revenueservice.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.payservice.revenueservice.RevenueServerConst;

import org.json.JSONException;
import org.json.JSONObject;

public class ErrorResponse implements IBaseJsonResponse {
    public int cmd;
    public int appid;
    public long uid;
    public String seq;
    public int result;

    /**
     * 构造函数
     *
     * @param jsonMsg
     */
    public ErrorResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        if (null == jsonMsg || "".equals(jsonMsg.trim())) {
            RLog.error("ErrorResponse", "parserResponse error, jsonMsg is empty.");
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonMsg);
            this.cmd = jsonObject.optInt("cmd");
            this.appid = jsonObject.optInt("appid");
            this.uid = jsonObject.optLong("uid");
            this.seq = jsonObject.optString("seq");
            RLog.info("ErrorResponse", "jsonObject", jsonObject);
        } catch (JSONException e) {
            RLog.error("ErrorResponse", "parserResponse error.", e);
        } catch (Exception e) {
            RLog.error("ErrorResponse", "parserResponse error.", e);
        }
    }
}

